#!/usr/bin/perl -s

use File::Path;

#if (! defined $TMPDIR) {
#	$TMPDIR = "$MBGD_tmp";
#}

if (! $OUTNAME) {
	$OUTNAME = "tmphom_$$";
	if ($TMPDIR) {
		$OUTNAME = "$TMPDIR/$OUTNAME";
	}
}

$blastout="$OUTNAME.mqblast";
$listfile="$OUTNAME.mdpin";
$outfile="$OUTNAME.mdpout";
$restfile="$OUTNAME.mdprest";
$resultfile="$OUTNAME.out";

$motdbfile = "/scratch/rpsblast/cdd/Cdd";
if (! defined $NAMELEN) {
	$NAMELEN = 22;	# the length of MD5 value; for check
}

$retainTmp = 1; # temporal
$retainTmp = 0 if ($deleteTmp);

$qseqfile=$ARGV[0];
$resultfile=$ARGV[1] if ($#ARGV >= 1);

die "Usage: $0 qseqfile\n" if (! $qseqfile);
die "$0: $qseqfile: file not found\n" if (! -f $qseqfile);

$ENV{'PATH'} .= ":/dbb/project/MBGD/package/mqblast";

if ($TMPDIR && ! -d $TMPDIR) {
	mkpath($TMPDIR);
}

if ($RETRY) {
	die "You must specify MQBLAST_TMPDIR\n" if (! $MQBLAST_TMPDIR);
	die "directory not exist: $MQBLAST_TMPDIR\n" if (! -d $MQBLAST_TMPDIR);
	$OTHEROPT .= "-ADD -TMPDIR='$MQBLAST_TMPDIR' ";
}
if ($retainTmp) {
	$OTHEROPT .= "-retainTmp ";
}


system("mqblast -OUTFILE='$blastout' " .
	"-mode=qsub -CopyAll -CopyDB=0 -PROCNUM=16 " .
	"-BLKSIZ=200 -BLASTOPT='-e 1' " .
	"-CHECK -CHECK_NAMELEN1=$NAMELEN " .
	"-PROGNAME='rpsblast' " .
	$OTHEROPT .
	"$motdbfile $qseqfile");

system("convrps.pl $blastout > $resultfile");

unlink($blastout);
