#!/usr/bin/perl -s

require "MBGD_common.pl";

$EVALCUT = 0.05 if (! $EVALCUT);
$fileCdd = $main::FILE_cdd_id;
if ($main::FILE) {
    $fileCdd = $main::FILE;
}
$cddfile = "$main::CMD_gzip -dc $fileCdd|";
$program = 'rpsblast';

open(F, $cddfile) || die "Can't open $cddfile\n";
while(<F>){
	chomp;
	my ($cddid,$motid,$motname,@descr) = split;
	my $motlen= pop @descr;
	my $descr = join(' ', @descr);
	if ($motid =~ /^pfam/) {
		$motlib = 'Pfam';
	} elsif ($motid =~ /^smart/) {
		$motlib = 'Smart';
	} elsif ($motid =~ /^COG/) {
		$motlib = 'COG';
	} elsif ($motid =~ /^KOG/) {
		$motlib = 'KOG';
	} elsif ($motid =~ /^LOAD/) {
		$motlib = 'Load';
	} elsif ($motid =~ /^cd/) {
		$motlib = 'cd';
	}
	$Cdd{$cddid} = {
		motid=>$motid,
		motlib=>$motlib,
		program=>$program,
		motname=>$motname,
		descr=>$descr,
	};
	if ($motifout) {
#		print join("\t", $motlib,$motid,$motname,$program,$descr),"\n";
		print join("\t", $motlib,$motid,$motname,$program,$motlen,$descr
),"\n";
	}
}
close(F);

exit if ($motifout);

while(<>){
	chomp;
	next if (/^#/);
	($name,$motname0,$ident,$alilen,$mismatch,$gapopen,
		$from1,$to1,$from2,$to2,$eval,$score) = split;
	next if ($eval > $EVALCUT);
	($dmy1,$dmy2,$cddid) = split(/\|/,$motname0);
	$motid = $Cdd{$cddid}->{motid};
	$motlib = $Cdd{$cddid}->{motlib};
	$motname = $Cdd{$cddid}->{motname};
	$descr = $Cdd{$cddid}->{descr};
	if ($output eq 'work') {
		($sp,$name) = split(/:/, $name);
		print join("\t",
			$sp,$name,$from1,$to1,$motlib,$motid,
			$motname,$program,$from2,$to2,$score,$eval,$descr),"\n";
	} else {
		print join("\t",
			$name,$from1,$to1,$motlib,$motid,
			$program,$from2,$to2,$score,$eval),"\n";
	}
}
