#!/usr/bin/perl -s
use File::Copy;
use File::Basename;
use File::Path;
use FileHandle;
use POSIX "sys_wait_h";
use Time::HiRes;


if (! $main::PID) {
    $main::PID = $$;
}

$MX = 5000 if (! $MX || $MX < 1000);          # $B#12s$N(B dp2 $B$G=hM}$9$kG[Ns%Z%"$N>e8B(B
$MXJOB = 10  if (! $MXJOB || $MXJOB < 1);     # PBS $B$K:GBg(B $MXJOB $BJB9TEjF~$9$k(B

$main::CMD_qsub    = '/usr/pbs/bin/qsub'  if (! $main::CMD_qsub);
if ($main::QUEUE_nqs !~ /^\s*$/) {
    $main::CMD_qsub .= " -q $main::QUEUE_nqs ";
}
$main::CMD_qstat   = '/usr/pbs/bin/qstat' if (! $main::CMD_qstat);
$main::DIR_nqs_pub = "/scratch"           if (! $main::DIR_nqs_pub);
$main::STA_QSTAT_RUNNING  = 1;
$main::STA_QSTAT_FINISHED = 0;


$UserName = getpwuid($<);
$HOME=($ENV{HOME} ? $ENV{HOME} : "/home/$UserName");
$MBGDHOME = ($ENV{MBGD_HOME} ? $ENV{MBGD_HOME} : "/db5/project/MBGD");
if (! $EXECDIR) {
    if (-d "$main::DIR_nqs_pub") {
        $EXECDIR = $main::DIR_nqs_pub;
    } else {
        $EXECDIR = "/tmp";
    }
    $EXECDIR .= "/$UserName/dp2tmp.$main::PID";
}

$PAMFILE = "$MBGDHOME/etc/allpamout.jtt";
$CMD_dp2 = "$MBGDHOME/binaries/dp2";
$DPOPT   = "-L -l -P0 -G -s";
$CURRDIR=$ENV{PWD};

###############################################################################
if (@ARGV < 2) {
	die "Usage: $0 inputlist seqfile\n";
}
$INPUTLIST  = $ARGV[0];
$SEQFILE    = $ARGV[1];
$OUTPUTFILE = $ARGV[2];
if (! $OUTPUTFILE) {
	$OUTPUTFILE="dp2all.out";
}

$INPUTLIST_BASE  = basename($INPUTLIST);
$SEQFILE_BASE    = basename($SEQFILE);
$OUTPUTFILE_BASE = basename($OUTPUTFILE);

mkpath($EXECDIR, 0, 0750) || die("ERROR :: mkpath($EXECDIR).");

#
if ($CopyAll) {
	copy($INPUTLIST, "$EXECDIR/$INPUTLIST_BASE") || die("Can not copy $INPUTLIST to $EXECDIR/$INPUTLIST_BASE");
	copy($SEQFILE, "$EXECDIR/$SEQFILE_BASE") || die("Can not copy $SEQFILE to $EXECDIR/$SEQFILE_BASE");
} else {
	if ($INPUTLIST =~ /^\//) {
		symlink($INPUTLIST, "$EXECDIR/$INPUTLIST_BASE") || die("Can not symlink $INPUTLIST $EXECDIR/$INPUTLIST_BASE");
	} else {
		symlink("$CURRDIR/$INPUTLIST", "$EXECDIR/$INPUTLIST_BASE") || die("Csn not symlink $CURRDIR/$INPUTLIST $EXECDIR/$INPUTLIST_BASE");
	}
	if ($SEQFILE =~ /^\//) {
		symlink($SEQFILE, "$EXECDIR/$SEQFILE_BASE") || die("Csn not symlink $SEQFILE $EXECDIR/$SEQFILE_BASE");
	} else {
		symlink("$CURRDIR/$SEQFILE", "$EXECDIR/$SEQFILE_BASE") || die("Csn not symlink $CURRDIR/$SEQFILE $EXECDIR/$SEQFILE_BASE");
	}
}
$INPUTLIST = $INPUTLIST_BASE;
$SEQFILE = $SEQFILE_BASE;

chdir $EXECDIR;
print STDERR "CWD :: $EXECDIR\n";

#
copy($PAMFILE, "$EXECDIR/allpamout") || die("Can not copy $PAMFILE to $EXECDIR/allpamout");

# dp2 $B$G<B9T(B
execDp2("$EXECDIR/$INPUTLIST_BASE", "$SEQFILE", "$OUTPUTFILE_BASE");

#
if (-f $OUTPUTFILE_BASE) {
	if ($OUTPUTFILE =~ /^\//) {
		# absolute path
		copy($OUTPUTFILE_BASE, "$OUTPUTFILE");
	} else {
		# relative path
		copy($OUTPUTFILE_BASE, "$CURRDIR/$OUTPUTFILE");
	}
}
if (! $retainTmp) {
	chdir "/";
	sleep(1);
#	rmtree($EXECDIR);
}

###############################################################################
sub getFilenameLst {
    my($idx) = shift;
    return sprintf("$main::EXECDIR/$main::INPUTLIST_BASE.%d", $idx);
}

###############################################################################
sub getFilenameOut {
    my($idx) = shift;
    return sprintf("$main::EXECDIR/$main::OUTPUTFILE_BASE.%d", $idx);
}

###############################################################################
sub waitJobs {
    my($maxJob) = shift;
    my($refHashJobId) = shift;
    my($stat_ref);

    my@listJobId = keys(%{$refHashJobId});
    for(;;) {
        if ($main::mode eq 'qsub') {
            $stat_ref = getQstat();
        }
        foreach my$jobid (@listJobId) {
            if ($main::mode eq 'qsub') {

                if (!exists($stat_ref->{"$jobid"})) {
                    unlink($refHashJobId->{"$jobid"});
                    delete($refHashJobId->{"$jobid"});
                }
                elsif ($stat_ref->{"$jobid"} =~ /^Eqw$/) {
                    my($cmd) = "$CMD_qmod -cj $jobid";
                    print STDERR "WARNING :: $cmd\n";
                    system("$cmd");
                }
            }
            else {
                my($ret) = waitpid($jobid, POSIX::WNOHANG);
                if ($ret == $jobid) {
#                    unlink($refHashJobId->{"$jobid"});
                    delete($refHashJobId->{"$jobid"});
                }
            }
        }

        @listJobId = keys(%{$refHashJobId});
        if (scalar(@listJobId) <= $maxJob) {
            # $BJBNs<B9T$N>e8B0J2<$G$"$k(B
            last;
        }
        sleep 10;
    }
}

###############################################################################
sub divideListFile {
    my($fileList) = shift;
    my($maxList) = shift;

    #
    my($fhr) = new FileHandle("$fileList") || die("Can not open $fileList($!)");
    my($fhw) = undef();
    my($nDiv) = 0;            # $B%U%!%$%kJ,3d?t(B
    my($nList) = 0;           # $B=PNO$7$?%j%9%H$N?t(B
    while($_ = $fhr->getline()) {
        if (($maxList <= $nList) ||    # $B=PNO$7$?%j%9%H$N?t$,!"J,3d>e8B$KC#$7$?(B
            !defined($fhw)) {          # $B=PNO%U%!%$%k$,L$(Bopen
            if (defined($fhw)) {
                $fhw->close();
            }
            $nDiv++;
            $nList = 0;
            my($fileDiv) = getFilenameLst($nDiv);
            $fhw = new FileHandle(">$fileDiv");
            if (! $fhw) {
                print STDERR "Can not open $fileDiv($!)\n";

                # $BJ,3d$G$-$?%U%!%$%k?t$rJV$9(B
                return ($nDiv - 1);
            }
        }

        $fhw->print($_);
        $nList++;
    }
    $fhw->close();
    $fhr->close();

    return $nDiv;
}

###############################################################################
sub mergeResultFiles {
    my($fileOut) = shift;
    my($maxJob) = shift;

    # $BJ,3d<B9T$7$?7k2L$r0l$D$N%U%!%$%k$K$^$H$a$k(B
    new FileHandle(">$fileOut");
    for(my$idx = 1; $idx <= $maxJob; $idx++) {
        my$fileOutIdx = getFilenameOut($idx);
        if (-e $fileOutIdx) {
            system("/bin/cat $fileOutIdx >> $fileOut");
            unlink("$fileOutIdx");
        }

        my$fileLst = getFilenameLst($idx);
        unlink("$fileLst"); # $BJ,3d$7$?%j%9%H%U%!%$%k$r:o=|(B
    }
}

sub execDp2 {
    my($fileList) = shift;
    my($fileSeq) = shift;
    my($fileOut) = shift;
    my($fh);

    # $B%j%9%H%U%!%$%k$rJ,3d!J>e8B!'(B$MX $BG[Ns%Z%"!K(B
    my($maxJobFile) = divideListFile($fileList, $main::MX);
    if ($maxJobFile <= 0) {
        # $BJ,3d$5$l$J$+$C$?!#6u$N7k2L%U%!%$%k$r:n@.$7$F=*N;$9$k!#(B
        new FileHandle(">$fileOut");
        return;
    }

    #
    my($nRetry) = 0;
    my($refHashJobId) = {};
    for(my$idx = 1; $idx <= $maxJobFile; $idx++) {
        my($fileDivList) = getFilenameLst($idx);
        my($fileDivOut)  = getFilenameOut($idx);

        my($fileTmpDivOut) = "/tmp/dp2_out_$idx.$UserName.$$";
        my($cmd) = "$main::CMD_dp2 -N $fileDivList $fileSeq $main::DPOPT > $fileTmpDivOut" . "\n"
                 . "/bin/mv $fileTmpDivOut $fileDivOut" . "\n"
                 . "";

        my($fileJob) = sprintf("$EXECDIR/execdp2.%d", $idx);
        $fh = new FileHandle(">$fileJob");
        if (! $fh) {
            print STDERR "Can not open $fileJob($!)\n";

            $nRetry++;
            if ($maxRetry < $nRetry) {
                # $B%j%H%i%$$7$F$_$?$,2~A1$;$:(B
                # die $B$;$:!"<B9T$7$?(B JOB $B7k2L$@$1$G$b=PNO$9$k(B
                last;
            }
            sleep($nRetry * 60);    # $B$7$P$i$/BT$C$F:F<B9T(B
            redo;
        }

        $fh->print("#\$ -N dp2.$idx\n");
        $fh->print("#\$ -o $fileJob.stdout\n");
        $fh->print("#\$ -e $fileJob.stderr\n");
        $fh->print("#\$ -S /bin/bash\n");
        $fh->print("export PAMFILE=$EXECDIR/allpamout", "\n");
        $fh->print("cd $main::EXECDIR", "\n");
        $fh->print("$cmd", "\n");
        $fh->close();

        #
        chmod(0755, $fileJob);
        print STDERR "system :: $fileJob\n";
if ($main::mode eq 'qsub') {
        my($fileJobId) = sprintf("$main::EXECDIR/jobid%d.$main::PID", $idx);
        system("$main::CMD_qsub $fileJob > $fileJobId");
        Time::HiRes::sleep(0.25);

        $fh = new FileHandle($fileJobId);
        if (! $fh) {
            print STDERR "Can not open $fileJobId($!)\n";

            $nRetry++;
            if ($maxRetry < $nRetry) {
                # $B%j%H%i%$$7$F$_$?$,2~A1$;$:(B
                # die $B$;$:!"<B9T$7$?(B JOB $B7k2L$@$1$G$b=PNO$9$k(B
                last;
            }
            sleep($nRetry * 60);    # $B$7$P$i$/BT$C$F:F<B9T(B
            redo;
        }

        $jobid = $fh->getline();
        $fh->close();
        ($jobid) = ($jobid =~ /(\d+)/);
        if (! $jobid) {
            print STDERR "Can not get JOB-ID(NQS)\n";

            $nRetry++;
            if ($maxRetry < $nRetry) {
                # $B%j%H%i%$$7$F$_$?$,2~A1$;$:(B
                # die $B$;$:!"<B9T$7$?(B JOB $B7k2L$@$1$G$b=PNO$9$k(B
                last;
            }
            sleep($nRetry * 60);    # $B$7$P$i$/BT$C$F:F<B9T(B
            redo;
        }
} else {
        if ($jobid = fork()) {
            # $B?F(B
        }
        elsif (defined($jobid)) {
            # $B;R(B
            my($sta) = system("$fileJob");
            unlink("$fileJob");
            exit($sta >> 8);
        }
        else {
            $nRetry++;
            if ($maxRetry < $nRetry) {
                # $B%j%H%i%$$7$F$_$?$,2~A1$;$:(B
                # die $B$;$:!"<B9T$7$?(B JOB $B7k2L$@$1$G$b=PNO$9$k(B
                last;
            }
            sleep($nRetry * 60);    # $B$7$P$i$/BT$C$F:F<B9T(B
            redo;
        }
}
        print STDERR "JobID=$jobid\n";
        $refHashJobId->{"$jobid"} = $fileJob;         # $B<B9T$7$?(B JOB ID $B$rJ]B8(B

        waitJobs($main::MXJOB - 1, $refHashJobId);    # $BJBNs<B9T2DG=$K$J$k$^$GBT$D(B

        $nRetry = 0;
    }

    # $B<B9T$7$?A4$F$N(B JOB $B$,=*N;$9$k$N$rBT$D(B
    waitJobs(0, $refHashJobId);

    # $BJ,3d<B9T$7$?7k2L$r0l$D$N%U%!%$%k$K$^$H$a$k(B
    mergeResultFiles($fileOut, $maxJobFile);
}

###############################################################################
#
sub getQstat {
    my($sta_ref) = {};

    my($cmd) = "$main::CMD_qstat";
    my(@stat) = `$cmd`;
    my($id);
    foreach my$line (@stat) {
        $line =~ s#^\s*##;
        $line =~ s#[\r\n]*$##;
        my(@qstat_list) = split(/\s+/, $line);
        my($job_id)  = $qstat_list[0];
        my($job_sta) = $qstat_list[4];

        if ($job_id !~ /^\d+$/) {
            print "DBG :: SKIP :: JOBID=$jobid\n" if ($main::DEBUG);
            next;
        }

        $sta_ref->{"$job_id"} = $job_sta;
    }
    return $sta_ref;
}

1;
