#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "db.h"
#include "matrix.h"

#ifdef REGEXP
#include <regexpr.h>
#endif

#define MAXENTNAME 200
#define MAXSEQNUM 800
#define MAXSEQLEN 6000
#define LINELEN 60
#define MAXTITLEN 80
#define TITBUFSIZ 2500
#define MAXWORD 10
#define EXPSIZ 1000

#define Toupper(x) (isupper(x) ? (x) : (toupper(x)))

char filename[80] = "stdin";
char entname[MAXSEQNUM][MAXENTNAME];
char seq[MAXSEQNUM][MAXSEQLEN];
int seqpos[MAXSEQNUM];
char titlebuf[TITBUFSIZ];
char align_title[TITBUFSIZ];
int cnt[MAXCHR];
char cons[MAXSEQLEN];
char propcons[MAXSEQLEN];
int maxseqlen;
int seqnum;
int rate = 80;
int proprate = 80;
int linelen = LINELEN;
int fontsize = 0;	/* for postscript */
char boldfontname[100] = "Helvetica-Bold";
char fontname[100] = "Helvetica";
char titlefont[100] = "Helvetica";
int psflag;
int htmlflag, htmlheader;
int out_seqpos;
int nocons_flag;
int regexp_flag;
int noheader;
int landscape;
int maxmismatch;
int titlen;
char *word[MAXWORD];
char expbuf[MAXWORD][EXPSIZ];
char *color[MAXWORD];
int wordnum;

int coloramino;
char *coltable1[27] = {
	"lightblue","blue","green","blue","blue","orange","lightblue",
	"red","yellow","white","red","yellow","yellow","purple",
	"white","brown","purple","red","cyan","cyan","white",
	"yellow","orange","black","orange","blue","black"
};
char *coltable2[27] = {
	"red","blue","green","blue","blue","orange","blue",
	"red","yellow","white","red","yellow","yellow","gray",
	"white","brown","purple","red","cyan","purple","white",
	"yellow","orange","black","orange","blue","black"
};
char **aminocol = coltable2;
char *coltable_nt[27] = {
	"white","black","blue","black","black","black","cyan",
	"black","black","black","black","black","black","black",
	"black","black","black","black","black","yellow","yellow",
	"black","black","black","black","black","black"
};
char *coltable3[MAXWORD] = {
	"red", "blue", "green", "yellow", "purple",
	"cyan", "magenta", "violet", "orange", "black"
};
int normal_esc(), bold_esc(), normal_html(), bold_html(), halfbold_html();
int (*normal)() = normal_esc;
int (*halfbold)() = bold_esc;
int (*bold)() = bold_esc;

int red_esc(), yellow_esc(), green_esc(), blue_esc(), magenta_esc(), cyan_esc();
int redrev_esc(), yellowrev_esc(), greenrev_esc(), bluerev_esc(), magentarev_esc(), cyanrev_esc();
int (*coltable_aa_esc[27])() = {
	cyan_esc, blue_esc, green_esc, blue_esc, blue_esc, yellow_esc,
	cyan_esc, red_esc, yellow_esc, normal_esc, red_esc, yellow_esc,
	yellow_esc, magenta_esc, normal_esc, magenta_esc, magenta_esc,
	red_esc, magenta_esc, magenta_esc, normal_esc, yellow_esc,
	yellow_esc, normal_esc, yellow_esc, blue_esc, normal_esc
};
int (*coltablerev_aa_esc[27])() = {
	cyanrev_esc, bluerev_esc, greenrev_esc, bluerev_esc, bluerev_esc, yellowrev_esc,
	cyanrev_esc, redrev_esc, yellowrev_esc, normal_esc, redrev_esc, yellowrev_esc,
	yellowrev_esc, magentarev_esc, normal_esc, magentarev_esc, magentarev_esc,
	redrev_esc, magentarev_esc, magentarev_esc, normal_esc, yellowrev_esc,
	yellowrev_esc, normal_esc, yellowrev_esc, bluerev_esc, normal_esc
};

int (*coltable_nt_esc[27])() = {
	cyan_esc, normal_esc, red_esc, normal_esc, normal_esc, normal_esc,
	blue_esc, normal_esc, normal_esc, normal_esc, normal_esc, normal_esc,
	normal_esc, normal_esc, normal_esc, normal_esc, normal_esc,
	normal_esc, normal_esc, yellow_esc, yellow_esc, normal_esc,
	normal_esc, normal_esc, normal_esc, normal_esc, normal_esc
};
int (*coltablerev_nt_esc[27])() = {
	cyanrev_esc, normal_esc, redrev_esc, normal_esc, normal_esc, normal_esc,
	bluerev_esc, normal_esc, normal_esc, normal_esc, normal_esc, normal_esc,
	normal_esc, normal_esc, normal_esc, normal_esc, normal_esc,
	normal_esc, normal_esc, yellowrev_esc, yellowrev_esc, normal_esc,
	normal_esc, normal_esc, normal_esc, normal_esc, normal_esc
};

int red_html(), yellow_html(), green_html(), blue_html(), magenta_html(), cyan_html(),orange_html(), brown_html(), white_html();
int redrev_html(), yellowrev_html(), greenrev_html(), bluerev_html(), magentarev_html(), cyanrev_html(),orangerev_html(), brownrev_html(), whiterev_html();
int (*coltable_aa_html[27])() = {
	white_html, blue_html, green_html, blue_html, blue_html, orange_html,
	white_html, red_html, yellow_html, normal_html, red_html, yellow_html,
	yellow_html, magenta_html, normal_html, brown_html, magenta_html,
	red_html, cyan_html, cyan_html, normal_html, yellow_html,
	orange_html, normal_html, orange_html, blue_html, normal_html
};
int (*coltablerev_aa_html[27])() = {
	whiterev_html, bluerev_html, greenrev_html, bluerev_html, bluerev_html, orangerev_html,
	whiterev_html, redrev_html, yellowrev_html, normal_html, redrev_html, yellowrev_html,
	yellowrev_html, magentarev_html, normal_html, brownrev_html, magentarev_html,
	redrev_html, cyanrev_html, cyanrev_html, normal_html, yellowrev_html,
	orangerev_html, normal_html, orangerev_html, bluerev_html, normal_html
};

int (*coltable_nt_html[27])() = {
	cyan_html, normal_html, red_html, normal_html, normal_html, normal_html,
	blue_html, normal_html, normal_html, normal_html, normal_html, normal_html,
	normal_html, normal_html, normal_html, normal_html, normal_html,
	normal_html, normal_html, yellow_html, yellow_html, normal_html,
	normal_html, normal_html, normal_html, normal_html, normal_html
};
int (*coltablerev_nt_html[27])() = {
	cyanrev_html, normal_html, redrev_html, normal_html, normal_html, normal_html,
	bluerev_html, normal_html, normal_html, normal_html, normal_html, normal_html,
	normal_html, normal_html, normal_html, normal_html, normal_html,
	normal_html, normal_html, yellowrev_html, yellowrev_html, normal_html,
	normal_html, normal_html, normal_html, normal_html, normal_html
};

int (**coltable_esc)() = coltable_aa_esc;
int (**coltablerev_esc)() = coltablerev_aa_esc;
int (**coltable_html)() = coltable_aa_html;
int (**coltablerev_html)() = coltablerev_aa_html;

int (**coltable)() = coltable_aa_esc;
int (**coltablerev)() = coltablerev_aa_esc;


/*
#define PROPNUM 9
#define PROPNUM 5
*/
/*
#define PROPNUM 12
*/
#define PROPNUM 11
struct Property {
	char *name;
	char code;
	char *amino;
} property[PROPNUM] = {
/* by Taylor
	{"pos_charged", '+', "KHR"},
	{"neg_charged", '-', "DE"},
/*-----*/ /*
	{"charged", 'c', "KHRDE"},
	{"aromatic", 'r', "FYW"},
	{"aliphatic", 'l', "ILV"},
	{"tiny", 't', "AGSC"},
	{"polar-small", 's', "TSDN"},
/*-----*/ /*
	{"hydrophobic", 'h', "ILVMFYWHKT"},
	{"polar", 'p', "DENQKRHST"},
	{"small", 's', "AGSTNDVP"}
*/
/*-----*/

/* omit less-specific propaties
	{"small", '0', "AGSTNDCP"},
*/
	{"hydrophobic", 'h', "ILVMFYW"},
	{"charged", 'c', "KHRDE"},
	{"small-polar", 'p', "NQST"},
	{"pos_charged", '+', "KHR"},
	{"aromatic", 'r', "FYW"},
	{"aliphatic", 'l', "ILV"},
	{"acid_amide", 'a', "NQDE"},
	{"tiny", 't', "AGSC"},
/*	{"sulfer", 's', "MC"}, */
	{"hydroxyl", 'o', "TS"},
	{"amide", 'n', "NQ"},
	{"neg_charged", '-', "DE"},
};
int propnum;
int propcnt[PROPNUM];
char consbg[20] = "red";
char consfg[20] = "white";

main(argc, argv)
	int argc;
	char **argv;
{
	int i, j, k;
	int seqlen;
	DB *db;
	int tlen;

	get_args(argc, argv);
	if ((db = dbopen(filename)) == NULL) {
		fprintf(stderr, "Can't open %s\n", filename);
		exit(1);
	}
	while (getseqtitle(db, entname[seqnum], titlebuf,
			seq[seqnum], sizeof(seq)) > 0) {
	/*
	while (getseq(db, entname[seqnum], seq[seqnum], sizeof(seq)) > 0) {
				*/
/*
			printf("***%s, %s\n", entname[seqnum], titlebuf);
*/
		if (titlen) {
			if (titlen + strlen(entname[seqnum]) > MAXENTNAME) {
				tlen = MAXENTNAME - strlen(entname[seqnum]) - 1;
			} else {
				tlen = titlen - strlen(entname[seqnum]) - 1;
			}
			strncat(entname[seqnum], titlebuf, tlen);
			entname[seqnum][strlen(entname[seqnum])] = '\0';
		}
		seqlen = strlen(seq[seqnum]);
		if (seqlen > maxseqlen) maxseqlen = seqlen;
		seqnum++;
	}
	dbclose(db);
	get_consensus();
	if (htmlheader) {
		printf("<HTML><BODY><PRE>\n");
	}
	if (psflag) {
		postscript();
	} else {
		print_align();
	}
	if (htmlheader) {
		printf("</PRE></BODY></HTML>\n");
	}
}
get_args(argc, argv)
	int argc;
	char **argv;
{
	int i;
	char *p;
	int titfontflag;
	for (i = 1; i < argc; i++) {
		if (*argv[i] == '-') {
			argv[i]++;
			if (strcmp("nocons", argv[i]) == 0) {
				nocons_flag  = 1;
			} else if (strcmp("fn", argv[i]) == 0) {
				if (++i > argc) break;
				strcpy(fontname, argv[i]);
				if (! titfontflag) {
					strcpy(titlefont, fontname);
				}
			} else if (strcmp("tfn", argv[i]) == 0) {
				if (++i > argc) break;
				strcpy(titlefont, argv[i]);
				titfontflag = 1;
			} else if (strcmp("fs", argv[i]) == 0) {
				if (++i > argc) break;
				fontsize = atoi(argv[i]);
			} else if (strcmp("noheader", argv[i]) == 0) {
				noheader = 1;
			} else if (strcmp("landscape", argv[i]) == 0) {
				landscape = 1;
			} else if (strcmp("consfg", argv[i]) == 0) {
				if (++i > argc) break;
				strcpy(consfg, argv[i]);
			} else if (strcmp("consbg", argv[i]) == 0) {
				if (++i > argc) break;
				strcpy(consbg, argv[i]);
			} else if (*argv[i]) {
				switch (*argv[i]) {
				case 'r':
					rate = proprate = atoi(++argv[i]);
					break;
				case 'p':
					psflag = 1;
					break;
				case 'c':
					if (*(argv[i]+1)=='2') {
						coloramino = 2;
					} else {
						coloramino = 1;
					}
					break;
				case 'l':
					linelen = atoi(++argv[i]);
					break;
				case 'T':
					strcpy(align_title, ++argv[i]);
					break;
				case 't':
					titlen = atoi(++argv[i]);
					if (titlen == 0) titlen = 30;
					break;
				case 'm':
					maxmismatch = atoi(++argv[i]);
					break;
				case 'R':
#ifdef REGEXPR
					regexp_flag = 1;
#endif
					break;
				case 'w':
					word[wordnum] = ++argv[i];
					if ((p = strchr(argv[i], '=')) != NULL) {
						*p = '\0';
						p++;
						color[wordnum] = p;
					}
					if (++wordnum >= MAXWORD) {
						fprintf(stderr, "Too many words\n");
						exit(1);
					}
					break;
				case 'P':
					propnum = PROPNUM;
					break;
				case 'n':
					out_seqpos = 1;
					break;
				case 'N':
					coltable_html = coltable_nt_html;
					coltablerev_html = coltablerev_nt_html;
					coltable_esc = coltable_nt_esc;
					coltablerev_esc = coltablerev_nt_esc;
					break;
				case 'h':
					htmlheader = 1;
				case 'H':
					htmlflag = 1;
					bold = bold_html;
					halfbold = halfbold_html;
					normal = normal_html;
					coltable = coltable_html;
					coltablerev = coltablerev_html;
					break;
				}
			}
		} else {
			strcpy(filename, argv[i]);
		}
	}
#ifdef REGEXP
	if (regexp_flag) {
		char *p;
		for (i = 0; i < wordnum; i++) {
			for (p = word[i]; *p; p++) {
				*p = Toupper(*p);
			}
			compile(word[i], expbuf[i], &expbuf[i][EXPSIZ]);
		}
	}
#endif
}
get_consensus()
{
	char tr[256];
	char amino[30];
	int amnum;
	int i, j, k;
	int prop;
	strcpy(amino, AMINO);
	make_char2num(amino, tr);
	amnum = strlen(amino);
	for (j = 0; j < maxseqlen; j++) {
		for (i = 0; i < amnum; i++) {
			cnt[i] = 0;
			for (prop = 0; prop < propnum; prop++) {
				propcnt[prop] = 0;
			}
		}
		for (i = 0; i < seqnum; i++) {
			if (isalpha(seq[i][j])) {
				cnt[tr[seq[i][j]]]++;
			}
			for (prop = 0; prop < propnum; prop++) {
				if (has_prop(seq[i][j], &property[prop])) {
					propcnt[prop]++;
				}
			}
		}
		for (i = 0; i < amnum; i++) {
			if (cnt[i] >= ceil((double)seqnum * rate / 100)) {
				cons[j] = amino[i];
				break;
			} else {
				cons[j] = 0;
			}
			for (prop = 0; prop < propnum; prop++) {
				if (propcnt[prop] >=
				    ceil((double)seqnum * proprate / 100)) {
					propcons[j] = property[prop].code;
				}
			}
		}
	}
}
has_prop(amino, property)
	char amino;
	struct Property *property;
{
	char *a;
	for (a = property->amino; *a; a++) {
		if (amino == *a) {
			return 1;
		}
	}
	return 0;
}
prop_check(amino, propcode)
	char amino, propcode;
{
	int i;
	char *a;
	for (i = 0; i < PROPNUM; i++) {
		if (propcode == property[i].code) {
			for (a = property[i].amino; *a; a++) {
				if (amino == *a) return i;
			}
		}
	}
	return -1;
}

int normalflag = 1;

print_align()
{
	int i, j, k;
	char format[50];
	int wordflag[MAXSEQNUM], matchnum;

	for (k = 0; k < maxseqlen; k+= linelen) {
		for (i = 0; i < seqnum; i++) {
			if (titlen) {
				sprintf(format, "%%-%ds  ", titlen);
			} else {
				strcpy(format, "%-15s  ");
			}
			printf(format, entname[i]);
			if (wordflag[i]) bold();
			if (out_seqpos) {
				printf("%4d ", seqpos[i]+1);
			}
			for (j = k; j < k + linelen; j++) {
				if (j >= maxseqlen) break;
				if (isalpha(seq[i][j])) {
					if (wordnum) {
						if ((matchnum = wordmatch(word,&seq[i][j])) >= 0) {
							bold();
							wordflag[i] = matchlen(matchnum,&seq[i][j]);
						}
					} else {
						if (coloramino) {
							if (seq[i][j] == cons[j]) {
								/* bold(); */
								(*coltablerev[todigit(seq[i][j])])();
							} else if (propnum) {
							    if (prop_check(seq[i][j], propcons[j]) >= 0) {
								(*coltable[todigit(seq[i][j])])();
							    } else {
								normal();
							    }
							} else if (coloramino==2) {
								(*coltable[todigit(seq[i][j])])();
							} else {
								normal();
							}
						} else {
							if (seq[i][j] == cons[j]) {
								bold();
							} else if (prop_check(seq[i][j], propcons[j]) >= 0) {
								halfbold();
							}
						}
					}
					putchar(seq[i][j]);
					if (out_seqpos) {
						seqpos[i]++;
					}
					if (wordnum) {
						if (wordflag[i]) {
							if (--wordflag[i] == 0) {
								normal();
							}
						}
					} else { /* seq[i][j] == cons[j] */
						normal();
					}
				} else {
					normal();
					putchar('-');
				}
			}
			normal();
			putchar('\n');
		}
		if (! nocons_flag) {
			printf(format, "Consensus:");
			if (out_seqpos) {
				printf("     ");
			}
			for (j = k; j < k + linelen; j++) {
				if (cons[j])	putchar(cons[j]);
				else		putchar(' ');
			}
			putchar('\n');
		}
		putchar('\n');
	}
}
#define TITSIZ 8
postscript()
{
	int i, j, k, l;
	int height, width;
	int linenum;
	int titlen = 22;
	int xmargin = 30, ymargin = 30;
	int pagewidth = 595, pageheight = 798;
/*
	int pagewidth = 595, pageheight = 838;
	int pagewidth = 595, pageheight = 798;
*/
	int xtrans, ytrans;
	int wordflag[MAXSEQNUM], matchnum[MAXSEQNUM], match;
	int linewidth = 1;
	int fillflag;
	int pagenum = 1;
	int ln;
	double xfine = 0.0, yfine = 0.2;

	if (landscape) {
		int tmp;
		tmp = pageheight;
		pageheight = pagewidth;
		pagewidth = tmp;
		xtrans = xmargin, ytrans = ymargin;
	} else {
		xtrans = xmargin, ytrans = pageheight - ymargin;
	}
	if (! fontsize) {
		fontsize = (pagewidth - xmargin * 2) / (linelen + titlen) - 1;
	} else {
		linelen = (int) ((double) (pagewidth - xmargin * 2) /
			(fontsize+1) - TITSIZ);
	}
	height = fontsize + 1, width = fontsize + 1;
	linenum = (pageheight - ymargin * 2) / width;
	if (! noheader) {
		printf("%%!PS-Adove-1.0\n");
		printf("%%%%Title Alignment\n");
		printf("%%%%EndComments\n");
		printf("%%%%BoundingBox: 0 0 %d %d\n", pagewidth, pageheight);
		if (landscape)
			printf("%%%%Orientation: Landscape\n");
		printf("%%%%Page %d\n", pagenum);

		printf("/box {newpath moveto 0 %d rlineto %d 0 rlineto ",
				height, width);
		printf("  0 %d rlineto %d 0 rlineto closepath fill} def\n",
				-height, -width);

		printf("/linebox {newpath moveto 0 %d rlineto %d 0 rlineto ",
				height, width);
		printf("  0 %d rlineto %d 0 rlineto closepath ",
				-height, -width);
		printf("  %d setlinewidth stroke} def\n", linewidth);

		printf("/leftline {newpath moveto 0 %d rlineto ", height);
		printf(" closepath %d setlinewidth stroke} def\n", linewidth);
		printf("/rightline {newpath moveto %d 0 rmoveto 0 %d rlineto ",
			height, height);
		printf(" closepath %d setlinewidth stroke} def\n", linewidth);
		printf("/topline {newpath moveto 0 %d rmoveto %d 0 rlineto ",
			width, width);
		printf(" closepath %d setlinewidth stroke} def\n", linewidth);
		printf("/bottomline {newpath moveto %d 0 rlineto ", width);
		printf(" closepath %d setlinewidth stroke} def\n", linewidth);

		printf("/red {1 0 0 setrgbcolor} def\n");
		printf("/green {0 1 0 setrgbcolor} def\n");
		printf("/blue {0 0 1 setrgbcolor} def\n");
		printf("/black {0 0 0 setrgbcolor} def\n");
		printf("/yellow {1 1 0 setrgbcolor} def\n");
		printf("/magenta {1 0 1 setrgbcolor} def\n");
		printf("/purple {0.8 0.3 1.0 setrgbcolor} def\n");
		printf("/orange {1 0.6 0 setrgbcolor} def\n");
		printf("/cyan {0 1 1 setrgbcolor} def\n");
		printf("/lightblue {0.8 0.9 1 setrgbcolor} def\n");
		printf("/brown {0.7 0.2 0.2 setrgbcolor} def\n");
		printf("/white {1 1 1 setrgbcolor} def\n");
		printf("/gray {0.8 0.8 0.8 setrgbcolor} def\n");
		printf("/inch {72 mul} def\n");
		printf("/alishow {dup stringwidth pop %d sub -0.5 mul 0 rmoveto show} def\n", width);
		printf("%%EndProlog\n");
/*
		printf("%d %d translate\n", xtrans, ytrans);
*/
	}
/*
	printf("newpath\n");
	if (*align_title) {
		printf("0 0 moveto\n");
		printf("/%s findfont %d scalefont setfont\n", titlefont, fontsize + 2);
		printf("(%s) show\n", align_title);
		printf("%d %d translate\n", 0, - (height + 2) * 2);
	}
*/
	if (! noheader) {
		printf("%d %d translate\n", xtrans, ytrans);
	}
	page_setup(pagenum);
	if (*align_title) {
		printf("%d %d translate\n", 0, - (height + 2) * 2);
	}
	ln = 0;
	for (k = 0; k < maxseqlen; k+= linelen) {
		for (i = 0; i < seqnum; i++) {
			printf("0 %d moveto\n", - ln * height);
			printf("black\n");
			printf("/%s findfont %d scalefont setfont\n", titlefont, fontsize);
			printf("(%-15s  ) show\n", entname[i]);
			for (j = k, l = 0; j < k + linelen; j++, l++) {
				if (j >= maxseqlen) break;
			/* write box */
				fillflag = 1;
				if (wordnum) {
					if ((match = wordmatch(word, &seq[i][j])) >= 0) {
						matchnum[i] = match;
						wordflag[i] = matchlen(matchnum[i], &seq[i][j]);
					}
					if (wordflag[i]) {
						printf("%s\n", coltable3[matchnum[i]]);
					} else {
						fillflag = 0;
						/* printf("white\n"); */
					}
				} else if (isalpha(seq[i][j])
				     && seq[i][j] == cons[j]) {
					if (coloramino) {
						printf("%s\n",
					    	  aminocol[todigit(seq[i][j])]);
					} else {
						printf("%s\n",consbg);
					}
				} else {
					/* printf("white\n"); */
					fillflag = 0;
				}
				if (fillflag) {
				   printf("%d %d box\n",
					(int) ((xfine + l + TITSIZ) * width),
					- (int) ((yfine + ln) * height));
				}
			/* Property check (linebox) */
				if (isalpha(seq[i][j]) && propcons[j]
						&& seq[i][j] != cons[j]) {
					if (prop_check(seq[i][j], propcons[j]) >= 0) {
						if (coloramino) {
							printf("black\n");
/*
						printf("%s\n",
					    	  aminocol[todigit(seq[i][j])]);
*/
						} else {
							printf("%s\n",consbg);
						}
						print_lines(i, j,
						(int) ((xfine + l + TITSIZ) * width),
						- (int)((yfine + ln) * height));
/*
						printf("%d %d linebox\n",
						(int) ((xfine + l + TITSIZ) * width),
						- (int)((yfine + ln) * height));
*/
					}
				}
			/* put amino acid code */
				printf("%d %d moveto\n",
					(l + TITSIZ) * width, - ln * height);
				if (wordnum) {
					if (wordflag[i]) {
						printf("%s\n",consfg);
						wordflag[i]--;
						printf("/%s findfont\n", boldfontname);
					} else {
						printf("/%s findfont\n", fontname);
						printf("black\n");
					}
				} else if (seq[i][j] == cons[j] && ! wordnum)  {
					printf("%s\n",consfg);
					printf("/%s findfont\n", boldfontname);
				} else {
					printf("/%s findfont\n", fontname);
					if (coloramino && isalpha(seq[i][j])) {
						printf("%s\n",
					    	  aminocol[todigit(seq[i][j])]);
					} else {
						printf("black\n");
					}
				}
				printf("%d scalefont setfont\n", fontsize);
				if (isalpha(seq[i][j])) {
					printf("(%c) alishow\n", seq[i][j]);
				} else {
					printf("(-) alishow\n");
				}
			}
			putchar('\n');
			if (++ln % linenum == 0) {
				endpage(pagenum);
				if (! noheader) {
					printf("%d %d translate\n", xtrans, ytrans);
				}
				page_setup(++pagenum);
				if (*align_title) {
					printf("%d %d translate\n", 0, - (height + 2) * 2);
				}
				ln = 0;
			}
		}
		printf("/%s findfont\n", fontname);
		printf("%d scalefont setfont\n", fontsize);
		printf("0 %d moveto\n", - ln * height);
		printf("black\n");
		if (! nocons_flag) {
			printf("(Consensus:       ) show\n");
			for (j = k, l = 0; j < k + linelen; j++, l++) {
				printf("%d %d moveto\n",
					(l + TITSIZ) * width, - ln * height);
				if (cons[j])	printf("(%c) alishow\n", cons[j]);
				else if (propcons[j])	printf("(%c) alishow\n", propcons[j]);
				else		printf("( ) alishow\n");
			}
			putchar('\n');
		}
		putchar('\n');
		if ((ln += 2) % linenum == 0) {
			endpage(pagenum);
			if (! noheader) {
				printf("%d %d translate\n", xtrans, ytrans);
			}
			page_setup(++pagenum);
			if (*align_title) {
				printf("%d %d translate\n", 0, - (height + 2) * 2);
			}
			ln = 0;
		}
	}
/*
	printf("closepath\n");
	printf("showpage\n");
*/
	endpage(pagenum);
}
page_setup(pagenum)
	int pagenum;
{
	printf("%%Page: %d\n", pagenum);
	if (landscape)
		printf("90 rotate\n");
	printf("newpath\n");
	if (*align_title) {
		printf("0 0 moveto\n");
		printf("/%s findfont %d scalefont setfont\n", titlefont, fontsize + 2);
		printf("(%s) show\n", align_title);
	}
}
endpage(pagenum)
	int pagenum;
{
	printf("closepath\n");
	printf("showpage\n");
	printf("%%%%Trailer\n");
	printf("%%%%Pages: %d\n", pagenum);
}

wordmatch(word, str)
	char **word;
	char *str;
{
	int i;
	for (i = 0; i < wordnum; i++) {
		if (regexp_flag) {
#ifdef REGEXP
			if (advance(str, expbuf[i])) {
				return i;
			}
#endif
		} else if (maxmismatch) {
			if (wordmismatch(word[i], str, maxmismatch)) {
				return i;
			}
		} else {
			if (strncasecmp(word[i], str, strlen(word[i])) == 0) {
				return i;
			}
		}
	}
	return -1;
}

wordmismatch(word, str, maxmismatch)
	char *word;
	char *str;
	int maxmismatch;
{
	int mismatchnum = 0;
	while (*word) {
		if (! *str) return 0;
		if (Toupper(*word) != Toupper(*str)) {
			if (++mismatchnum > maxmismatch) {
				return 0;
			}
		}
		word++; str++;
	}
	return 1;
}

matchlen(matchnum, strpos)
	int matchnum;
	char *strpos;
{
	if (regexp_flag) {
#ifdef REGEXP
		return (int) (loc2 - strpos);
#endif
	} else {
		return strlen(word[matchnum]);
	}
}

print_lines(i, j, posx, posy)
	int i, j;
{
	if (i == 0 || prop_check(seq[i-1][j],propcons[j]) < 0) {
		printf("%d %d topline\n", posx, posy);
	}
	if (i == seqnum - 1|| prop_check(seq[i+1][j],propcons[j]) < 0) {
		printf("%d %d bottomline\n", posx, posy);
	}
	if (j == 0 || prop_check(seq[i][j-1],propcons[j-1]) < 0) {
		printf("%d %d leftline\n", posx, posy);
	}
	if (j == maxseqlen - 1 || prop_check(seq[i][j+1],propcons[j+1]) < 0) {
		printf("%d %d rightline\n", posx, posy);
	}
}


print_str()
{
}

bold_html()
{
	if (! normalflag) {
		printf("</FONT>");
	}
	printf("<FONT COLOR=#ff0000>");
	normalflag = 0;
}
halfbold_html()
{
	if (! normalflag) {
		printf("</FONT>");
	}
	printf("<FONT COLOR=#ff8800>");
	normalflag = 0;
}
normal_html()
{
	if (! normalflag) {
		printf("</FONT>");
	}
	normalflag = 1;
}
red_html() { if (!normalflag) printf("</FONT>"); printf("<FONT COLOR=#ff0000>"); normalflag = 0; }
green_html() { if (!normalflag) printf("</FONT>"); printf("<FONT COLOR=#00ff00>"); normalflag = 0; }
blue_html() { if (!normalflag) printf("</FONT>"); printf("<FONT COLOR=#0000ff>"); normalflag = 0; }
magenta_html() { if (!normalflag) printf("</FONT>"); printf("<FONT COLOR=#ff00ff>"); normalflag = 0; }
cyan_html() { if (!normalflag) printf("</FONT>"); printf("<FONT COLOR=#00ffff>"); normalflag = 0; }
yellow_html() { if (!normalflag) printf("</FONT>"); printf("<FONT COLOR=#ffff00>"); normalflag = 0; }
white_html() { if (!normalflag) printf("</FONT>"); printf("<FONT COLOR=#ffffff>"); normalflag = 0; }
orange_html() { if (!normalflag) printf("</FONT>"); printf("<FONT COLOR=#ff8800>"); normalflag = 0; }
brown_html() { if (!normalflag) printf("</FONT>"); printf("<FONT COLOR=#aa6600>"); normalflag = 0; }

redrev_html() { red_html(); }
greenrev_html() { green_html(); }
yellowrev_html() { yellow_html(); }
bluerev_html() { blue_html(); }
magentarev_html() { magenta_html(); }
cyanrev_html() { cyan_html(); }
orangerev_html() { orange_html(); }
brownrev_html() { brown_html(); }
whiterev_html() { white_html(); }


bold_esc()
{
	printf("[1m");
	normalflag = 0;
}
uline_esc()
{
	printf("[4m");
	normalflag = 0;
}
normal_esc()
{
	if (normalflag != 1) {
		printf("[0m");
	}
	normalflag = 1;
}

red_esc() { printf("[31m"); normalflag = 0; }
green_esc() { printf("[32m"); normalflag = 0; }
yellow_esc() { printf("[33m"); normalflag = 0; }
blue_esc() { printf("[34m"); normalflag = 0; }
magenta_esc() { printf("[35m"); normalflag = 0; }
cyan_esc() { printf("[36m"); normalflag = 0; }

redrev_esc() { printf("[41m"); normalflag = 0; }
greenrev_esc() { printf("[42m"); normalflag = 0; }
yellowrev_esc() { printf("[43m"); normalflag = 0; }
bluerev_esc() { printf("[44m"); normalflag = 0; }
magentarev_esc() { printf("[45m"); normalflag = 0; }
cyanrev_esc() { printf("[46m"); normalflag = 0; }

ps_bold()
{
}

todigit(c)
	char c;
{
	if (islower(c)) return c - 'a';
	else if (isupper(c)) return c - 'A';
	else return 26;
}
set_aminocol()
{
}
