#!/usr/local/bin/perl

##
## Routine for argument checking
##
package ArgCheck;

sub new {
	my($class, $template, $opt) = @_;
	my($this) = {};
	bless $this, $class;
	$this->{check} = {};
	$this->add($template) if ($template);
	$this->{DEBUG} = 1 if ($opt->{'DEBUG'});
	return $this;
}
sub add {
	my($this, $template, $default) = @_;
	if (ref $template eq 'HASH') {
	    foreach $k (%{$template}) {
		$this->set_action($k, $template->{$k});
	    }
	} elsif (ref $template eq 'ARRAY') {
		foreach $k (@{$template}) {
			if ($default) {
				$this->set_action($k, $default);
			} else {
				$this->{check}->{$k} = sub { 1; };
			}
		}
	} else {
		warn "template specification is invalid\n";
	}
}
sub set_action {
	my($this, $key, $value) = @_;
	my $ref = ref $value;
	if ($ref eq 'CODE') {
		$this->{check}->{$key} = $value;
	} elsif ($ref eq 'Regexp') {
		$this->{check}->{$key} = sub {"$_[0]" =~ $value};
	} elsif ($ref eq 'HASH') {
		# set default value;
		$this->{default}->{$key} = $value->{default};
		$this->set_action( $key, $value->{check} );
	} else {
		$this->{check}->{$key} = sub { 1; };
	}
}

sub check {
	my($this, $args) = @_;
	my($valid) = {};
	$this->set_default($valid);
	foreach $k (keys %{$args}) {
		if (ref $args->{$k} eq 'ARRAY') {
			my @valid_array = ();
			foreach $v (@{$args->{$k}}) {
				if (&{$this->{check}->{$k}}($v)) {
					push(@valid_array, $v);
			warn "$k: Valid parameter $v\n" if ($this->{DEBUG});
				} else {
			warn "$k: Invalid parameter $v\n" if ($this->{DEBUG});
				}
			}
			$valid->{$k} = \@valid_array;
		} elsif (defined $this->{check}->{$k} &&
			&{$this->{check}->{$k}}($args->{$k})) {
			### OK
			$valid->{$k} = $args->{$k};
			if (! $args->{$k} && $this->{default}->{$k}) {
print STDERR "default>>>>$k,$this->{default}->{$k}\n";
				$valid->{$k} = $this->{default}->{$k};
			}
			warn "$k: Valid parameter\n" if ($this->{DEBUG});
		} else {
			warn "$k: Invalid parameter $args->{$k}\n" if ($this->{DEBUG});
		}
	}
	return $valid;
}
sub set_default {
	my($this, $param) = @_;
	foreach $k (keys %{$this->{default}}) {
		$param->{$k} = $this->{default}->{$k};
	}
}

package main;
if ($0 eq __FILE__) {
	$Template = {
		aho => qr/^\d+$/,
		baka => 1,
		manuke => qr/^(true|false)/,
		aho2 => sub {$_[0] > -10 && $_[0] < 10;}
	};
	$Template2 = [
		baka2, manuke2,
	];
	$Args = {
		aho => -1,
		aho2 => -1,
		baka => 'hello',
		manuke => 'false',
		baka2 => 'bye',
		manuke2 => '0000',
		aho3 => 1.1
	};
	$arg = ArgCheck->new($Template, 'DEBUG');
	$arg->add($Template2);
	$valid = $arg->check($Args);
	print "Valid parameters:\n";
	foreach $k (keys %$valid) {
		print "$k $valid->{$k}\n";
	}
}
1;
