#!/usr/local/bin/perl -s

package KeggGeneCatalog;
###############################################################################
# Kegg Gene Catalog
#
#

###############################################################################
#
BEGIN {
    $catalogFile = "$ENV{'BIOROOT'}/etc/all_species.tab";
}

###############################################################################
#
sub new
{
    my($type) = shift;

    $self = {};
    bless($self);

    $self->readKeggGeneCatalog($catalogFile);

    return($self);
}

###############################################################################
#
sub readKeggGeneCatalog
{
    my($self) = shift();
    my($filename) = @_;
    local(*FH);

    # KEGGTAB 
    $self->{'KEGGGENECATALOG'} = {};

    open(FH, "$filename") || die "Can not open $filename($!)";
    while(<FH>) {
        if (/^\s*#*$/) {
            next;
        }

        ($abbr, $name, $fullname, $kegg, $category, $fastaCode, $complete, $completedYear) = split(/\t/);

        $self->{'KEGGGENECATALOG'}->{$abbr} = {};
        $self->{'KEGGGENECATALOG'}->{$abbr}->{'ABBR'}         = $abbr;
        $self->{'KEGGGENECATALOG'}->{$abbr}->{'NAME'}         = $name;
        $self->{'KEGGGENECATALOG'}->{$abbr}->{'FULLNAME'}     = $fullname;
        $self->{'KEGGGENECATALOG'}->{$abbr}->{'KEGG'}         = $kegg;
        $self->{'KEGGGENECATALOG'}->{$abbr}->{'CATEGORY'}     = $category;
        $self->{'KEGGGENECATALOG'}->{$abbr}->{'FASTACODE'}    = $fastaCode;
        $self->{'KEGGGENECATALOG'}->{$abbr}->{'COMPLETE'}     = $complete;
        $self->{'KEGGGENECATALOG'}->{$abbr}->{'COMPLETEYEAR'} = $completedYear;
    }
    close(FH);
}

###############################################################################
#
sub getName
{
    my($self) = shift();
    my($spec) = @_;

    return($self->{'KEGGGENECATALOG'}->{$spec}->{'NAME'});
}

###############################################################################
#
sub getFullname
{
    my($self) = shift();
    my($spec) = @_;

    return($self->{'KEGGGENECATALOG'}->{$spec}->{'FULLNAME'});
}

###############################################################################
#
sub getKegg
{
    my($self) = shift();
    my($spec) = @_;

    return($self->{'KEGGGENECATALOG'}->{$spec}->{'KEGG'});
}

###############################################################################
#
sub getCategory
{
    my($self) = shift();
    my($spec) = @_;

    return($self->{'KEGGGENECATALOG'}->{$spec}->{'CATEGORY'});
}

###############################################################################
#
sub getFastaCode
{
    my($self) = shift();
    my($spec) = @_;

    return($self->{'KEGGGENECATALOG'}->{$spec}->{'FASTACODE'});
}

###############################################################################
#
sub getComplete
{
    my($self) = shift();
    my($spec) = @_;

    return($self->{'KEGGGENECATALOG'}->{$spec}->{'COMPLETE'});
}

###############################################################################
#
sub getCompleteYear
{
    my($self) = shift();
    my($spec) = @_;

    return($self->{'KEGGGENECATALOG'}->{$spec}->{'COMPLETEYEAR'});
}

###############################################################################
# ޥɤȤƼ¹Ԥ줿
if ($0 eq __FILE__) {

    package main;

    my($obj);
    $obj = new KeggGeneCatalog;

    while(<STDIN>) {
        chomp();
        if (/^$/) {
            last;
        }

        print $obj->getName($_), "\n";
        print $obj->getFullname($_), "\n";
    }
}

###############################################################################
1;#
###############################################################################
