package MBGD::Config;
use Exporter ();
@ISA = (Exporter);
@EXPORT = qw(%Config);
@EXPORT_OK = qw(config_sh config_vars);

#$] == 5.00503
#  or die "Perl lib version (5.00503) doesn't match executable version ($])";

# This file was taken and modified from Config.pm in the standard Perl library

##
## This file was produced by running the Configure script. It holds all the
## definitions figured out by Configure. Should you modify one of these values,
## do not forget to propagate your changes by running "Configure -der". You may
## instead choose to run each of the .SH files by yourself, or "Configure -S".
##
#
## Package name      : perl5
## Source directory  : .
## Configuration time: Wed Jan 31 21:29:54 JST 2001
## Configured by     : uchiyama
## Target system     : irix64 ori 6.5 10181058 ip27 
#
## Configure command line arguments.
## Variables propagated from previous config.sh file.

my $_Config = <<'_EOF_';
mbgddir=$ENV{MBGD_HOME} || "/dbb/project/MBGD"
datadir="$mbgddir/data"
flatdata_dir="$datadir/flat"
csvdir="$datadir/csv"
seqdir="$mbgddir/seq"
schema_dir="$mbgddir/schema"
default_dbs=$ENV{MBGD_DBS} || "dbi:mysql:database=mbgd"
#kegg_dir="/bio/db/ideas"
#kegg_genome_dir="$kegg_dir/genome"
#kegg_genome_file="$kegg_genome_dir/genome"
#kegg_genome_fasta_dir="/bio/db/fasta/genome"
#kegg_genes_dir="$kegg_dir/genes"
allowed_N_ratio="0.005"
_EOF_

sub FETCH { 
    # check for cached value (which may be undef so we use exists not defined)
	my($this,$key) = @_;
	return $this->{$key} if (exists $this->{$key});
	foreach my $line (split(/\n/, $_Config)) {
		next if ($line =~ /^#/);
		($var, $val) = split(/=/, $line, 2);
		eval qq{\$$var = $val};
		$this->{$var} = ${$var};
	}
	return $this->{$key};
}
 
my $prevpos = 0;

sub FIRSTKEY {
    $prevpos = 0;
    # my($key) = $_Config =~ m/^(.*?)=/;
    substr($_Config, 0, index($_Config, '=') );
    # $key;
}

sub NEXTKEY {
    # Find out how the current key's quoted so we can skip to its end.
    my $quote = substr($_Config, index($_Config, "=", $prevpos)+1, 1);
    my $pos = index($_Config, qq($quote\n), $prevpos) + 2;
    my $len = index($_Config, "=", $pos) - $pos;
    $prevpos = $pos;
    $len > 0 ? substr($_Config, $pos, $len) : undef;
}

sub EXISTS { 
    # exists($_[0]->{$_[1]})  or  $_Config =~ m/^$_[1]=/m;
    exists($_[0]->{$_[1]}) or
    index($_Config, "\n$_[1]='") != -1 or
    substr($_Config, 0, length($_[1])+2) eq "$_[1]='" or
    index($_Config, "\n$_[1]=\"") != -1 or
    substr($_Config, 0, length($_[1])+2) eq "$_[1]=\"";
}

sub STORE  { die "\%MBGD::Config::Config is read-only\n" }
sub DELETE { &STORE }
sub CLEAR  { &STORE }

sub TIEHASH { bless {} }

# avoid Config..Exporter..UNIVERSAL search for DESTROY then AUTOLOAD
sub DESTROY { }

tie %Config, 'MBGD::Config';

1;
