#!/bin/perl

package MBGD::SQL_mysql;
use MBGD::SQL;
@ISA = qw {MBGD::SQL};

use DBI;
use MBGD::DB;

sub drop_table {
	my($this, $tablename) = @_;
	my(@SQL, $sql);

	push(@SQL, "drop table $tablename");
	@SQL;
}
sub copy_table {
	my($this, $table, $newtable, $opt) = @_;
	my($field) = '*';
	my $sql = "create table $newtable $opt->{table_opt} " .
		"select $field from $table";
	if ($opt->{condition}) {
		$sql .= " where $opt->{condition}";
	}
	$sql;
}

sub get_idval {
	my($this) = @_;
	return 'select last_insert_id()';
}

sub table_options {
	my($this, $options_ref) = @_;
    my($tab_opt) = '';
    my($key);

    foreach my$key (keys(%{$options_ref})) {
        my($key_lc) = lc($key);
        if ($key eq $key_lc) {
            next;
        }

        if (!exists($options_ref->{"$key_lc"}) && ($options_ref->{"$key"} ne '')) {
            $options_ref->{"$key_lc"} = $options_ref->{"$key"};
        }
    }

###	return "type = InnoDB\n";
    $key = lc('type');
    if ($options_ref->{"$key"} ne '') {
        $tab_opt .= ' ' if ($tab_opt ne '');
        $tab_opt .= join('=', $key, $options_ref->{"$key"});
    }

    $key = lc('auto_increment');
    if (0 < $options_ref->{"$key"}) {
        $tab_opt .= ' ' if ($tab_opt ne '');
        $tab_opt .= join('=', $key, $options_ref->{"$key"});
    }

	return $tab_opt;
}

sub merge_table_options {
	my($this, $opt) = @_;
	return $opt->{'merge_table'};
}

sub type_convert_2 {
	my($this, $attrinfo) = @_;
	my ($type, $option) = $this->SUPER::type_convert_2($attrinfo);

	if ($attrinfo->{type} eq 'ID') {
		$type = 'int';
		$option .= ' auto_increment';
	}
	return ($type, $option);
}

1;
