#!/usr/local/bin/perl

package MBGD::Sequence;

use MBGD::Object;

@ISA = qw {MBGD::Object};

use Digest::MD5;
use FileHandle;

#sub new {
#	my($class, @args) = @_;
#	my($this) = {};
#	bless $this, $class;
#	if (ref($args[0])) {
#		# assuming $args[0] is a variable-value hash reference
#		$this->setValues($args[0]);
#	} else {
#		# assuming @args = (sequence, title)
#		$this->setseq(@args);
#	}
#	$this;
#}

sub setValues {
        my($this, $values) = @_;
	$this->SUPER::setValues($values);
	if ($values->{seq}) {
		$this->{chksum} = &setseq($values->{seq});
		$this->{length} = length($values->{seq});
	}
}
sub setseq {
	my($seq) = @_;
	my($d);
	$d = Digest::MD5->new;
	$d->add($seq);
	return $d->b64digest;
}
sub get_subseq {
	my($this, $db, $id, $from, $to, $dir) = @_;
	my($len) = $to - $from + 1;
	my @a = $this->find($db, "id=$id", {fields=>"substring(seq, $from, $len) seq"});
	my $seq = $a[0]->{seq};
	if ($dir < 0) {
		return &complement($seq);
	}
	return $seq;
}

sub complement {
	my( $org_seq ) = @_;
	my( $new_seq ) = $org_seq;

	$new_seq =~ tr/ACGTURYMKWSBDHVNXacgturymkwsbdhvnx/TGCAAYRKMWSVHDBNXtgcaayrkmwsvhdbnx/;
	$new_seq =  reverse $new_seq;
	return $new_seq;
}

sub composition {
	my($this) = @_;
	my(%Count);
	foreach $s (split(//, $this->{seq})) {
		$Count{$s}++;
	}
	return %Count;
}

sub print_fasta {
	my($this, $comment, $opt) = @_;
	my $LINELEN = 60;
	my $fh;
	if ($opt->{fh}) {
		$fh = $opt->{fh};
	} else {
		$fh = FileHandle->new(">&STDOUT");
	}
	$comment = $this->{comment} if (! $comment);
	if ($comment) {
		print $fh ">", $comment;
		print $fh " chksum:",  $this->{chksum} if (! $opt->{no_chksum});
		print $fh "\n";
	}
	for (my $i = 0; $i < $this->{length}; $i+=$LINELEN) {
		print $fh substr($this->{seq}, $i, $LINELEN), "\n";
	}
}
1;
