#!/usr/bin/perl -s
use strict;
use DirHandle;
use FileHandle;

###############################################################################
# TIGRFAMs ROLE NAMES $B%G!<%?$NFI$_9~$_(B
# http://cmr.tigr.org/tigr-scripts/CMR/shared/EvidenceList.cgi?ev_type=TIGRFAM&order_type=role
# $B%G!<%?9=C[(B
#     $B3F%(%s%H%j!<(B
#     $ent = {};
#     $ent->{'ID'}
#     $ent->{'NAME_MAIN'}
#     $ent->{'NAME_SUB1'}
#
#     ID $B$+$i%(%s%H%j!<$r<hF@$9$k(B
#     $ref->{'ID'}->{"$id"} = $ent;
#
#     main role $B$NG[Ns!J(BID:$B>:=g!K(B
#     $ref->{'MAIN_NAMES'} = [ $nameMain1, $nameMain2, ..., $nameManinN ];
#
#     main role $B$r9=@.$9$k(B sub1 role $B$N%(%s%H%j!<(B
#     $ref->{'TREE'}->{"$nameMain"} = [ $ent1, $ent2, ..., $entN ];
#
sub parseTigrfamsRoleNames {
    my($filename) = shift;

    #
    my($ref) = {};
    $ref->{'ID'} = {};
    $ref->{'MAIN_NAMES'} = [];
    $ref->{'TREE'} = {};

    #
    my($fh) = new FileHandle("$filename") or return $ref;
    while(my$line = $fh->getline()) {
        $line =~ s#[\r\n]*$##;

        my($d, $id, $type, $name) = split(/\t/, $line);
        if (! exists($ref->{'ID'}->{"$id"})) {
            $ref->{'ID'}->{"$id"} = {};
        }
        my($ent) = $ref->{'ID'}->{"$id"};
        $ent->{'ID'} = $id;
        if ($type =~ /^mainrole/i) {
            $ent->{'NAME_MAIN'} = $name;
        }
        elsif ($type =~ /^sub1role/i) {
            $ent->{'NAME_SUB1'} = $name;
        }
        else {
        }

    }
    $fh->close();

    # ID $B$N=g$KJB$YBX$((B
    foreach my$id (sort({$a <=> $b} keys(%{$ref->{'ID'}}))) {
        my($ent) = $ref->{'ID'}->{"$id"};
        my($nameMain) = $ent->{'NAME_MAIN'};

        if (! exists($ref->{'TREE'}->{"$nameMain"})) {
            $ref->{'TREE'}->{"$nameMain"} = [];
            push(@{$ref->{'MAIN_NAMES'}}, $nameMain);
        }
        push(@{$ref->{'TREE'}->{"$nameMain"}}, $ent);
    }

    return $ref;
}

###############################################################################
# tigr $B$N(B Web $B$G$O!"(Bmainrole $B$O!"%"%k%U%!%Y%C%H=g$GI=<((B
#                   sub1role $B$O!"!)(B
sub printTigrfamsRoleNames {
    my($ref) = shift;
    my($dbname) = 'TIGRFAMs';

    my(@mainNames) = @{$ref->{'MAIN_NAMES'}};       # ID $B$N=g(B
    @mainNames = sort(@mainNames);                  # $BL>>N=g(B

    my($idxMain) = 0;
    foreach my$nameMain (@mainNames) {
        my($levMain) = $idxMain + 1;
        print join("\t", $dbname, $levMain, $nameMain), "\n";

        my($idxSub1) = 0;
        foreach my$ent (@{$ref->{'TREE'}->{"$nameMain"}}) {
            my($lev) = join('.', $levMain, $idxSub1 + 1);
            my($name) = join(' ; ', $nameMain, $ent->{'NAME_SUB1'});
            print join("\t", $dbname, $lev, $name), "\n";

            $idxSub1++;
        }
        $idxMain++;
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my$ref = parseTigrfamsRoleNames($ARGV[0]);
    printTigrfamsRoleNames($ref);
}

###############################################################################
1;#
###############################################################################
