#!/usr/bin/perl


use Property::Base;

package Property::Preference;
@ISA = qw{ Property::Base };

sub setArgs {
	my($this, $Args, $opt) = @_;
	my $params = $this->getParams;
	foreach $key (keys %{$params}) {
		if ( $opt->{overwrite} ) {
			## set the current argument by pref value
			$Args->{$key} = $params->{$key};
		} elsif ( defined $Args->{$key} ) {
			## set pref value from the current argument
			$this->setValue($key, $Args->{$key});
		} elsif ( $this->{Param}->{$key}->{type} eq 'checkbox' ) {
			## set pref value from the current argument
			$this->setValue($key, $Args->{$key});
		} else {
			## set the current argument by pref value
			$Args->{$key} = $params->{$key};
		}
	}
}

######################################
1;
######################################
##
## user parameters for malign
##
######################################
package Property::Preference;
__DATA__
#name: table_color
#fullname: Color of genes
#description:
#step: clusttab.disp
#options: off,funccat,neighbors
#default: off
#//
name: showname
fullname: Display cluster members as
description:
step: clusttab.disp
options: orfid[ORFIDs],gene[gene names],count[count of members]
default: orfid
//
name: outputnum
fullname: Maximum optputs / page
description:
step: clusttab.disp
default: 25
//
name: motif
fullname: Add motifs
description:
step: clusttab.addinfo
type: checkbox
default: off
//
name: motifcutoff
fullname: Motif cutoff
description:
step: clusttab.addinfo
default: 50
//
name: funccat_type
fullname: Function category type
description:
step: clusttab.disp
default: mbgd
//
