#!/usr/bin/perl -s
package RECOG::Cache::mysql;
###############################################################################
# .ANLN>N>NN
#     RECOG::Cache::mysql.pm
# .AN3N5NMNW
#     .AN;NXNDNjN$N5N$NlN$N?N%NGN%N#N%NlN%N/N%NHN%NjN2N<N$NKN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NrN:NnN@N.N$N9N$NkN!N#
#     .AN$N^N$N?N;NXNDNjN$N5N$NlN$N?IDN$NKNBNPN1N~N$N9N$NkN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NrN%N*N!N<N%NWN%NsN$N7NFNbNMNFN$NrN<NhNFN@N$N9N$NkN!N#
# .AN@NbNLN@
#     .AN;NXNDNjN$N5N$NlN$N?N%NGN%N#N%NlN%N/N%NHN%NjN2N<N$NK, ".index" N$NHN$N$N$N&NLN>N>NNN$NNN%NUN%N!N%N$N%NkN$NrN:NnN@N.N$N7N!N"
#     mysql.AN$NNN%NFN!N<N%NVN%NkNLN>N$NHIDN$NNNBNPN1N~N4NXN7N8N$NrN4NINMN}N$N9N$NkN!N#(N%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%Nk)
#     .AN%N-N%NcN%NCN%N7N%NeN:NnN@N.N!N"NFNIN$N_N9N~N$N_N!N"N:NoN=N|N$NrN9NTN$N&N%NaN%N=N%NCN%NIN$NKN$NhN$NjN!N"N%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$Nr
#     .ANAN`N:NnN$N9N$NkN!N#
# .AN%NQN%NCN%N1N!N<N%N8NJNQN?NtN0NlNMNw
#     IndexFileName
#
# .AN%NaN%NsN%NPN!N<NJNQN?NtN0NlNMNw
#     'DirName'    .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%Nk(N%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%Nk)N:NnN@N.N%NGN%N#N%NlN%N/N%NHN%NjNLN>
#     'Modified'   .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NNNDNIN2NC/N:NoN=N|N$N,N9NTN$NoN$NlN$N?N>NlN9NgN$NKN?N?N$NKN$NJN$Nk
#     'Index'      .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N$NHIDN$NNNBNPN1N~NINUN$N1N$NrN9NTN$N&N%NON%NCN%N7N%Ne
#     'IndexCount' .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N$NNN?Nt
#
# .AN%NaN%N=N%NCN%NIN0NlNMNw
#     new()
#     _init()
#     DESTROY
#     readIndex()
#     updateIndex()
#     create()
#     write()
#     close()
#     exists()
#     getline()
#     getlines()
#     purge()
#
# .ANHNwN9NM
#
###############################################################################
use strict;
#our(@Cache::mysql::ISA);                                   # require 5.6.0;
use FileHandle;

use File::Basename;
#use File::Path;
use POSIX "sys_wait_h";
use RECOG;
use RECOG::Cache;
use MBGD::DB;
use RECOG::DomClustCommon;
@RECOG::Cache::mysql::ISA = ( 'Cache' );   # require 5.6.0;      # .AN7NQN>N5N$N9N$NkN>NlN9NgN!N"N9NTNFN,N$NN # N$NrN:NoN=N|N$N9N$Nk

#@PerlModuleTemplate::ISA = ('BaseName');    # .AN7NQN>N5N$N9N$NkN>NlN9NgN!N"N9NTNFN,N$NN # N$NrN:NoN=N|N$N9N$Nk

# .AN%NQN%NCN%N1N!N<N%N8NJNQN?NtN$NNNDNjN5NA
use constant DefaultIndexFname  => "cache.idx";  # .AN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkNLN>
use constant DefaultFnamePrefix => 'cache';   # .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N$NNN%NWN%NlN%NUN%N#N%N/N%N9

###############################################################################
# .ANLN>N>NN
#     new()
# .AN3N5NMNW
#     .AN%N3N%NsN%N9N%NHN%NiN%N/N%N?
# .AN0NzN?Nt
#     $that  : .AN%N/N%NiN%N9NLN>(N$NbN$N7N$N/N$NON%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9)
#     @args : .AN=NiN4N|N%NQN%NiN%NaN!N<N%N?: N4NXN?Nt_init()N$NrN;N2N>NH
# .ANLNaNCNM
#     .AN?N7N5N,N%N$N%NsN%N9N%N?N%NsN%N9N$NXN$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .AN@NbNLN@
#
# .ANHNwN9NM
#
sub new {
    my $that = shift;
    my @args  = @_;
    
    # $that .AN$N,N%NjN%NUN%N!N%NlN%NsN%N9N$NJN$NiN!N"N%NQN%NCN%N1N!N<N%N8NLN>N$NrN<NhNFN@N$N9N$NkN!N#
    my $class = ref($that) || $that;

    my $self  = {};

    bless($self, $class);
    $self->_init(@args);
##    _init($self, @args);

    return $self;
}

###############################################################################
# .ANLN>N>NN
#     _init()
# .AN3N5NMNW
#     .AN=NiN4N|N=NhNMN}
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
#     %args : .AN%N3N%NsN%N9N%NHN%NiN%N/N%N?N8NFN$NSN=NPN$N7N;N~N$NNN0NzN?Nt
#     $args{'space'}   : .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$N*N$NhN$NSN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN:NnN@N.NMNQ
#                        .AN%NGN%N#N%NlN%N/N%NHN%NjNLN>(N%NGN%NUN%N)N%NkN%NHN!N'"/tmp")
#     $args{'prefix'}  : .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N%NWN%NlN%NUN%N#N%N/N%N9(N%N*N%NWN%N7N%NgN%Ns)
# .ANLNaNCNM
#     .AN$NJN$N7
# .AN@NbNLN@
#     
# .ANHNwN9NM
#
sub _init {
    my $self  = shift;
    my %args  = @_;

    # .AN0NJN2N<N$NKN=NiN4N|N=NhNMN}

    # .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN:NnN@N.N%NGN%N#N%NlN%N/N%NHN%NjN$NrN%NaN%NsN%NPNJNQN?NtN$NKNJN]NBN8N$N9N$NkN!N#
    my $dir = (defined $args{'space'} ? $args{'space'} : '/tmp');
    $self->{'DirName'} = $dir;

    # domclust$B=PNO%U%!%$%k$N(Bprefix$B$r%a%s%PJQ?t$KEPO?$9$k!#(B
    if(exists $args{'prefix'}) {
        $self->{'FnamePrefix'} = $args{'prefix'};
    }
    else {
        $self->{'FnamePrefix'} = DefaultFnamePrefix;
    }
	
    if(-e $dir && -d $dir) {
    }
    # $B;XDj$5$l$?%G%#%l%/%H%j$=$N$b$N$,$J$$>l9g!"%(%i!<%a%C%;!<%8$r=PNO$7$F(B
    # $B%W%m%0%i%`$r=*N;$9$k!#(B
    else {
        die sprintf("***** %s : invalid directory name [%s] ******",
					ref $self, $dir);
    }

}

###############################################################################
# .ANLN>N>NN
#     DESTROY()
# .AN3N5NMNW
#     .AN%NGN%N9N%NHN%NiN%N/N%N?
# .AN0NzN?Nt
#     $self  : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .ANLNaNCNM
#     .AN$NJN$N7
# .AN@NbNLN@
#     .AN%NaN%NbN%NjN>NeN$NNN%N-N%NcN%NCN%N7N%NeN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$N,NJNQN9N9N$N5N$NlN$NFN$N$N$NkN>NlN9NgN!N"N$N=N$NlN$Nr
#     .AN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$NKN=NPNNNON$N9N$NkN!N#
# .ANHNwN9NM
#     .ANDNLN>NoN$NNNJNQN?NtN$NNN;NHNMNQN$NdN%NUN%N!N%N$N%NkN%NON%NsN%NIN%NkN$NNN;NHNMNQN$N@N$N1N$NNN>NlN9NgN$NON%NGN%N9N%NHN%NiN%N/N%N?N$NrNMNQN0NU
#     .AN$N7N$NJN$N/N$NFN$NbNEN,N@NZN$NKNGNKN4N~N!N"N%N/N%NmN!N<N%N:N$N5N$NlN$NkN!N#
#     .AN:NnN@N.N$N7N$N?N0NlN;N~N%NUN%N!N%N$N%NkN$NrN:NoN=N|N$N7N$N?N$N$N;N~N$NJN$NIN$NKNDNjN5NAN$N9N$NkN!N#
#
sub DESTROY {
    my $self = shift;

    # $B<+?H$N%/%i%9$NGK4~<jB3$-(B
    # $B%9!<%Q!<%/%i%9$N%$%s%9%?%s%9JQ?t$rMxMQ$7$F$$$J$$>l9g$O!"(B
    # $B%9!<%Q!<%/%i%9$N(B DESTROY() $B8F$S=P$7$N8e$G$b$h$$(B

    # $B%G%9%H%i%/%?$rDj5A$9$k>l9g$O?F%/%i%9$,$J$/$F$bF~$l$?J}$,$h$$(B
    $self->SUPER::DESTROY;
}

#
sub parseCmdOpts {
    my $self = shift;
    my $cmd = shift;

    my($ref) = {};
    foreach my$opt (split(/\s+/, $cmd)) {
        next if ($opt =~ /^\-tabout/i);
        next if ($opt =~ /^\-t\//i);

        if ($opt =~ /^\-(.+)/) {
            # $B?tCM%*%W%7%g%s$N7eB7$(!'(B -C60 $B$b(B -C60.0 $B$bF1$8%*%W%7%g%s(B
            if ($opt =~ /\-EVAL=([\d\.]+)/i) {
                $opt = sprintf("-EVAL=%.5f", $1);
            }
            elsif ($opt =~ /\-([^\=]+)=([\d\.]+)/) {
                $opt = sprintf("-%s=%.3f", $1, $2);
            }
            elsif ($opt =~ /\-([A-Z]+)([\d\.]+)/i) {
                $opt = sprintf("-%s%.3f", $1, $2);
            }
            $ref->{"$opt"} = 1;
        }
    }

    return $ref;
}

#
sub isSameCmdOpts {
    my $self = shift;
    my $cmd_a_ref = shift;
    my $cmd_b_ref = shift;

    my(@cmd_a_keys) = sort(keys(%{$cmd_a_ref}));
    my(@cmd_b_keys) = sort(keys(%{$cmd_b_ref}));

    if (scalar(@cmd_a_keys) != scalar(@cmd_b_keys)) {
        return; # FALSE
    }

    foreach my$k (@cmd_a_keys) {
        if (!exists($cmd_b_ref->{"$k"})) {
            return; # FALSE
        }
    }

    return 1; # TRUE
}

#
sub getCmdForDump {
    my($self) = shift;
    my($cmd) = shift;

    my($cmd_dump) = main::getCmdForDump($cmd);

    return $cmd_dump;
}

#
sub canUseSameCmdOptsForDump {
    my $self = shift;
    my $cmd_a_ref = shift;
    my $cmd_b_ref = shift;

    #
    my(@cmd_a_keys) = sort(keys(%{$cmd_a_ref}));
    my(@cmd_b_keys) = sort(keys(%{$cmd_b_ref}));

    #
    if (scalar(@cmd_a_keys) != scalar(@cmd_b_keys)) {
        return; # FALSE
    }

    foreach my$k (@cmd_a_keys) {
        if (!exists($cmd_b_ref->{"$k"})) {
            return; # FALSE
        }
    }

    if (exists($cmd_a_ref->{'S'})) {
        # CUTOFF :: score
        if ($cmd_a_ref->{'c'} < $cmd_b_ref->{'c'}) {
            # $cmd_b_ref $B$N(B CUTOFF(score) $B$,Bg$-$$$?$a!"(B$cmd_b_ref $B$N(B dump $B$OMxMQIT2D(B
            return; # FALSE
        }
    }
    else {
        # CUTOFF :: pam
        if ($cmd_b_ref->{'c'} < $cmd_a_ref->{'c'}) {
            # $cmd_b_ref $B$N(B CUTOFF(pam) $B$,>.$5$$$?$a!"(B$cmd_b_ref $B$N(B dump $B$OMxMQIT2D(B
            return; # FALSE
        }
    }

    return 1; # TRUE
}

#
sub getClusterIdByCmdstr {
    my $self = shift;
    my $db = shift;
    my $cmdstr = shift;

    #
    my($cmdstr_ref) = $self->parseCmdOpts($cmdstr);

    #
    my $sql = "select * from $main::TBL_DOMINDEX";
    my $st = $db->execute($sql);
    while(my$ref = $st->fetchrow_hashref()) {
        my($cmd_ref) = $self->parseCmdOpts($ref->{'cmd'});
        my($staCmdCmp) = $self->isSameCmdOpts($cmdstr_ref, $cmd_ref);
        if ($staCmdCmp) {
            return $ref->{'clusterID'};
        }
    }

    return;
}

#
sub getDumpClusterIdByCmdstr {
    my $self = shift;
    my $db = shift;
    my $cmdstr = shift;

    #
    my($cmd_dump) = $self->getCmdForDump($cmdstr);
    my($cmdstr_ref) = $self->parseCmdOpts($cmd_dump);

    #
    my $sql = "select * from $main::TBL_DOMINDEX";
    my $st = $db->execute($sql);
    while(my$ref = $st->fetchrow_hashref()) {
        my($cmd_dump) = $self->getCmdForDump($ref->{'cmd'});
        my($cmd_ref) = $self->parseCmdOpts($cmd_dump);
        my($staCmdCmp) = $self->canUseSameCmdOptsForDump($cmdstr_ref, $cmd_ref);
        if ($staCmdCmp) {
            my($fileDump) = "$ENV{'MBGD_HOME'}/MBGD.tmp/clustdump_" . $ref->{'clusterID'};
            if (-e $fileDump) {
                # dump $B7k2L%F!<%V%k$"$j(B
                return $fileDump;
            }
        }
    }

    return;
}

#
sub getDumpClusterIdByTabid {
    my $self = shift;
    my $db = shift;
    my $tabid = shift;

    my($sql) = "select * from $main::TBL_DOMINDEX where clusterID=\'$tabid\'";
    my($sth) = $db->execute($sql);
    if ($sth->rows() == 0) {
        return;
    }
    my($ref) = $sth->fetchrow_hashref();
    my($cmdstr) = $ref->{'cmd'};

    #
    my($id) = $self->getDumpClusterIdByCmdstr($db, $cmdstr);

    return $id;
}

#
#
# domclust$B5/F0%3%^%s%I$h$j!"%f%K!<%/$J(BID$B$r@8@.$7(Bcluster_tables_idx$B%F!<%V%k$r:n@.$9$k(B
# $B;XDj$5$l$?@8J*<o$N0dEA;R?t$r%+%&%s%H$7!"%F!<%V%k$XEPO?$9$k(B
sub createIndex {
    my $self = shift;
	my $db = shift;
    my $cmd = shift;
    my $tabid = shift;
	my @species = @_;
    my($ret_status);	#return status = 0 (entry is newly created) or 1 (found in a table)

    # $B%$%s%G%C%/%9%F!<%V%k$,L5$$>l9g$O:n@.$9$k!#(B
    if(!$db->exist_table($main::TBL_DOMINDEX)) {
        my $sql = "create table if not exists $main::TBL_DOMINDEX ("
                . "clusterID varchar(50) not null,"
                . "status    int(11) not null,"
                . "cmd       mediumtext not null,"
                . "name      mediumtext,"
                . "counter   int(11) not null,"
                . "ngene     int(30) not null,"
                . "ncluster  int(30),"
                . "warning   mediumtext,"
                . "cdate     timestamp,"
                . "primary key(clusterID))";
#            unique(cmd))";
        print STDERR "SQL :: $sql\n";
        $db->execute($sql);
    }

    # $BF1$8(B Command $B$,L5$$$+$r3NG'$9$k!#(B
    my($res) = $self->getClusterIdByCmdstr($db, $cmd);
    if(!$res) {

        my($fname, $fullname);
        if ($tabid =~ /^\d+\_\d+$/) {
            # $tabid $B$r:FMxMQ$9$k!#(B
            ($fname, $fullname) = $self->getCacheFname($tabid);
        }
        else {
            # uniq$B$J(B ID $B$r?75,:n@.$9$k!#(B
            ($fname, $fullname) = $self->newCacheFname();
        }

        if (-e $fullname) {
            unlink("$fullname");
        }

        $self->{'CacheID'}       = $cmd;
        $self->{'CacheFile'}     = $fullname;
        $self->{'Index'}{$cmd}{'file'} = $fname;
        my $clustid = '';
        if($fname=~/(\d+_\d+)/) {
            $clustid = $1;
        }
		# gene$B%F!<%V%k$K%"%/%;%9$7!"0dEA;R?t$r%+%&%s%H$9$k(B
		my $genedb = MBGD::DB->new($ENV{'MYSQL_DB'});
		my $sps = "\'" . join("\',\'", @species) . "\'";
		my $sql = "select count(*) from gene where sp in ($sps)";
		my $st = $genedb->execute($sql);
		my $ngene = $st->fetch()->[0];

        # uniq$B$J(BID$B$r(Bmysql$B$KEPO?$9$k!#(B
#	my($pid) = 0;
	my($pid) = $$;	## set current process_id when creation 
        $sql = "insert into $main::TBL_DOMINDEX ("
             . "clusterID,status,cmd,counter,ngene,cdate"
             . ") values ("
             . "\'$clustid\', $pid, \'$cmd\', 1, $ngene, current_timestamp()"
             . ")";
        $db->execute($sql);
	$ret_status = 0;
    }
    else {
        # $B$9$G$K$"$C$?>l9g!"<!$X!#(B
		my $cid = $res;
#        print STDERR "cache ID already exists(mysql) : $cid\n";
		$self->createCacheFilePath($cid);
	$ret_status = 1;
    }
    return $ret_status;
}

sub createCacheFilePath {
	my $self = shift;
	my $id = shift;

	my $fname = sprintf("%s_%s",
						$self->{'FnamePrefix'},
						$id);   
	my $path = $self->{'DirName'};
	my $fullname = join("/", $path, $fname);

	$self->{'CacheID'}     = $id;
	$self->{'CacheFile'}   = $fullname;
	$self->{'Index'}{$id}{'file'} = $fname;
}

# $B%3%^%s%I(BID$B$+$i(BindexID$B$r<hF@$9$k(B
# $B3:Ev$,L5$1$l$P(Bundef$B$rJV$9(B
sub getTabId {
    my $self = shift;
	my $db = shift;
    my $id   = shift;
    my $index;

    my $sql = "select clusterID from $main::TBL_DOMINDEX where cmd=\'$id\'";
    if(!$db->exist_table($main::TBL_DOMINDEX)) {
		die "Tabel $main::TBL_DOMINDEX is not undefined : $sql";
    }

    my($res) = $self->getClusterIdByCmdstr($db, $id);
	if (!$res) {  # $B3:EvL5$7$N>l9g(B
        return;
	}

    return $res;
}


# $B%/%i%9%?%j%s%0%*%W%7%g%s$r$b$H$K!"(Bdump $B7k2L%F!<%V%k(B ID $B$rJV$9(B
sub getDumpTabId {
    my $self = shift;
	my $db = shift;
    my $cmd = shift;
    my $index;

    my $sql = "select clusterID from $main::TBL_DOMINDEX where cmd=\'$cmd\'";
    if(!$db->exist_table($main::TBL_DOMINDEX)) {
		die "Tabel $main::TBL_DOMINDEX is not undefined : $sql";
    }

    my($res) = $self->getDumpClusterIdByCmdstr($db, $cmd);
	if (!$res) {  # $B3:EvL5$7$N>l9g(B
        return;
	}

    return $res;
}

#
# indexID$B$+$i(Bstatus$B$r<hF@$9$k(B
#
sub getStatus {
    my $self = shift;
	my $db = shift;
    my $cid   = shift;

    my $sql = "select status from $main::TBL_DOMINDEX where clusterID=\'$cid\'";
    if(!$db->exist_table($main::TBL_DOMINDEX)) {
        die "Tabel $main::TBL_DOMINDEX is not undefined.";
    } else {
        my $st = $db->execute($sql);
        my $res = $st->fetch();

		if(!$res) {  # $B3:EvL5$7$N>l9g(B
            return;
		}
        elsif(scalar(@$res) > 1) { # $BJ#?t$N%R%C%H$,$"$C$?>l9g(B
            die "       Duplicate Table ID. : $cid";
        } elsif(scalar(@$res)==1) { # $B#1$D$"$C$?>l9g(B
            return $res->[0];
        } else {
            die "Can not Table ID."; # $BA[Dj30(B
        }
    }

}

#
# domclust$B$N<B9T7k2L=PNO@h%U%!%$%k$r:n@.$7!"%U%!%$%k%O%s%I%k$r@8@.$9$k(B
sub createDCOutfile {
    my $self = shift;
	my $db = shift;
    my $cid = shift;

    # $id$B$,;XDj$5$l$F$$$J$$>l9g!"%(%i!<%a%C%;!<%8$r=PNO$7$F%W%m%0%i%`$r=*N;$9$k!#(B
    unless(defined $cid) {
        die "cache ID not specified : $cid";
    }

    # $id$B$N%9%F!<%?%9$,%^%$%J%9$G$"$C$?>l9g!"$^$?$O(B
    # $B%9%F!<%?%9$,L$Dj5A$G$"$C$?>l9g!"%(%i!<%a%C%;!<%8$r=PNO$7$F%W%m%0%i%`$r=*N;$9$k!#(B
    if(!defined $self->getStatus($db,$cid)) {
        die "ClusterID $cid is invalid value.";
    }
	elsif($self->getStatus($db,$cid) < 0) {
		die "Domclust Error : ClusterID $cid";
	}
    else {
        my $fullname = $self->{'CacheFile'};
        my $fh = new FileHandle("> $fullname") || die "open failure($!): $fullname";
        $self->{'CacheHandle'} = $fh;
#        $self->updateStartStatus($cid);
    }
}

#
# domclust$B$N<B9T7k2L(B(Tree)$B=PNO@h%U%!%$%k$r%3%T!<$9$k(B
sub createDCTreeOutfile {
    my $self = shift;
    my $db = shift;
    my $cid = shift;
    my $fileSrc = shift;

    my($fhr) = FileHandle->new("$fileSrc") || die("Can not open $fileSrc($!)");
    my($filename) = $self->{'CacheFile'} . '.tree';

    my($fhw) = new FileHandle("> $filename") || die "open failure($!): $filename";
    while(my$line = $fhr->getline()) {
        $fhw->print($line);
    }
    $fhw->close();
    $fhr->close();

    return;
}

#
# $B%9%F!<%?%9%U%i%0$rJQ99$9$k(B
# Running(status=pid)
sub updateStartStatus {
    my($self) = shift;
	my($db) = shift;
    my($cid) = shift;
	my $res;

    if($db->exist_table($main::TBL_DOMINDEX)) {
        my $sql = "update $main::TBL_DOMINDEX set status=1 where clusterID=\'$cid\'";
        $db->execute($sql);
		$res = 1;
    } else {
        print STDERR "Table $main::TBL_DOMINDEX is not exists.\n";
        $res = 0;
    }

	return $res;
}

sub updateRunningStatus {
	my($self) = shift;
	my($db) = shift;
	my($cid) = shift;
	my($pd) = shift;

	my $res;
	if($db->exist_table($main::TBL_DOMINDEX)) {
        my $sql = "update $main::TBL_DOMINDEX set status=$pd where clusterID=\'$cid\'";
        $db->execute($sql);
        $res = 1;
    } else {
        print STDERR "Table $main::TBL_DOMINDEX is not exists.\n";
        $res = 0;
    }

    return $res;
}

###############################################################################
# .ANLN>N>NN
#     readIndex()
# .AN3N5NMNW
#     .AN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$NNNFNbNMNFNAN4N$NFN$NrNFNIN$N_N9N~N$N_N!N"N%NaN%NsN%NPNJNQN?Nt'Index'N$NKNCNMN$NrNJN]N;N}N$N9N$NkN!N#
# .AN0NzN?Nt
#     $self  : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .ANLNaNCNM
#     .AN$NJN$N7
# .AN@NbNLN@
#     .AN%NaN%NsN%NPNJNQN?Nt'Index'N$NKN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>(NCNM)N$NHN%NGN!N<N%N?N$NNID(N<N1NJNLNLN>N!N'N%N-N!N<)N$NN
#     .ANBNPN1N~N4NXN7N8N$NrN<N(N$N9N%NON%NCN%N7N%Ne(N%NjN%NUN%N!N%NlN%NsN%N9)N$NrN%N;N%NCN%NHN$N9N$NkN!N#
# .ANHNwN9NM
#     
#
sub readIndex {
    my $self = shift;

    my $idxfname = $self->{'IndexFile'};
    my $idxfh = new FileHandle($idxfname) || die "open failure($!): $idxfname";

    # .AN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$N+N$NiN#N1N9NTN$N:N$NDNFNIN$N_N!N"IDN$NHN%NUN%N!N%N$N%NkNLN>N$NrN<NhNFN@N$N9N$Nk
    while(my $line = $idxfh->getline) {
	$line =~ s/[\r\n]+$//;
	my($id, $fname, @info) = split /\t/, $line;
	$self->{'Index'}{$id}{'file'} = $fname;
	$self->{'Index'}{$id}{'info'} = eval join("\t", @info);
    }
    # 
    $idxfh->close;
}

###############################################################################
# .ANLN>N>NN
#     addIndex()
# .AN3N5NMNW
#     .AN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$NKN?N7N$N7N$N$N%NlN%N3N!N<N%NIN$NrNDNIN2NCN$N9N$NkN!N#
# .AN0NzN?Nt
#     $self    : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
###     $id      : .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NrNAN*NBNrN$N9N$NkN$N?N$NaN$NNN<N1NJNLN;NR
###     $fname   : .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>
#     $info    : .ANINUN2NCN>NpNJNs(N%NON%NCN%N7N%NeN!N"N%NjN%N9N%NHN$NNN%NjN%NUN%N!N%NlN%NsN%N9N$NbN2ND)
# .ANLNaNCNM
#     .AN$NJN$N7
# .AN@NbNLN@
#     .AN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$NrNDNIN2NCN=NqN$N-N9N~N$N_N%NbN!N<N%NIN$NGN%N*N!N<N%NWN%NsN$N7N!N"N%NlN%N3N!N<N%NIN$NrNDNIN2NCN$N9N$NkN!N#
# .ANHNwN9NM
#     
#
sub addIndex {
    my $self    = shift;
    my $info    = shift;

    my $id    = $self->{'CacheID'};
    my $fname = $self->{'Index'}{$id}{'file'};

    # .AN%NfN%NKN!N<N%N/N$NJIDN$NrN?N6N$NkN$N?N$NaN$NNN@N)N8NfN>NpNJNsN$NrN@NhN$N:N=NPNNNO

    $self->{'Index'}{$id}{'info'} = $info;
print STDERR "addIndex>>>$id, $fname\n";

#    # mysql.AN$NKNENPNON?N$NbN9NTN$NJN$N&N!N#
    my $specs = join(",", @{$info->{'species'}});
    my $tabid = basename($fname);
    my $cfile = $self->{'DirName'} . "/" . $fname;
    my $cmd_db = "$main::PROG_DOMCLUST2SQL -dbname=$main::DOMCLUST_DB -tabid=$tabid -spec=\'$specs\' -cmd=\'$id\' $cfile";
    print STDERR "DBG (addIndex) :: CMD :: $cmd_db\n";
#    system($cmd_db)==0 or die"$cmd_db::($!)";
    my($pid_db) = fork();
    if ($pid_db) {
    }
    elsif (defined($pid_db)) {
	close(STDERR);
        exec($cmd_db);
        exit(0);
    }

    #
    my($tfile) = $self->{'DirName'} . "/" . $fname . '.tree';
    my($clust_tabid) = ($tabid =~ /(\d+_\d+)/);
    my $cmd_tree = "$main::PROG_DOMCLUST_TREE2MYSQL -DBNAME=$main::DOMCLUST_DB -TABID=$clust_tabid $tfile";
    print STDERR "DBG :: CMD :: $cmd_tree\n";
#    system($cmd_tree)==0 or die"$cmd_db::($!)";
    my($pid_tree) = fork();
    if ($pid_tree) {
    }
    elsif (defined($pid_tree)) {
        exec($cmd_tree);
        exit(0);
    }

    # wait both process
    waitpid($pid_db, 0);
    waitpid($pid_tree, 0);
    print STDERR "DBG :: Done.(domclust2mysql / tree2mysql) :: " . scalar(time) . "\n";

    return;
}

###############################################################################
# .ANLN>N>NN
#     updateIndex()
# .AN3N5NMNW
#     .AN%NaN%NsN%NPNJNQN?Nt'Index'N$NNNFNbNMNFN$N,NJNQN9N9N$N5N$NlN$N?N>NlN9NgN!N"N$N=N$NNNFNbNMNFN$NrN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$NK
#     .ANHN?N1NGN$N5N$N;N$NkN!N#
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .ANLNaNCNM
#     .AN$NJN$N7
# .AN@NbNLN@
#     .AN%NaN%NsN%NPNJNQN?Nt'Modified'N$NNNCNMN$N,N?N?N$NNN>NlN9NgN!N"N%NaN%NsN%NPNJNQN?Nt'Index'N$NNNCNMN$NrN%N$N%NsN%NGN%NCN%N/N%N9
#     .AN%NUN%N!N%N$N%NkN$NKN=NPNNNO(N>NeN=NqN$N-)N$N9N$NkN!N#
# .ANHNwN9NM
#     
#
sub updateIndex {
    my $self = shift;

    # .AN%N$N%NsN%NGN%NCN%N/N%N9N$NKNJNQN9N9N$N,N$NJN$N1N$NlN$NPN!N"N2N?N$NbN$N;N$N:N$NKN=N*NNN;N!N#
    return unless($self->{'Modified'});

    my $rc;
    my $idxfname = $self->{'IndexFile'};
    my $idxfh = new FileHandle("> $idxfname") || die "open failure($!): $idxfname";

    # ID.AN$NHN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N$NNNBNPN1N~NIN=N$NrN=NPNNNO
    foreach my $id (sort keys %{$self->{'Index'}})  {
	unless($rc = print $idxfh join("\t",
				       $id,
				       $self->{'Index'}{$id}{'file'},
				       refSerialize($self->{'Index'}{$id}{'info'}),
				       ) . "\n") {
	    die "write error($!) : $idxfname";
	}
    }
    $idxfh->close;
    $self->{'Modified'} = undef;
}

###############################################################################
# .ANLN>N>NN
#     create()
# .AN3N5NMNW
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NrN:NnN@N.N$N9N$NkN!N#
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N$NrN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$NKNENPNON?N$N9N$NkN$NKN$NON!N"addIndex()N$Nr
#     .AN%N3N!N<N%NkN$N9N$NkN$N3N$NHN!N#
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
#     $id   : .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N$NKNBNPN1N~N$N9N$NkN<N1NJNLN;NR
#             .AN"N(N3N0NINtN$N+N$NiN$NON!N"N$N3N$NNN<N1NJNLN;NRN$NGN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NrN<N1NJNLN$N9N$NkN!N#
# .ANLNaNCNM
#     .AN$NJN$N7
# .AN@NbNLN@
#     .AN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$NNN@NhNFN,N%NlN%N3N!N<N%NIN$N+N$NiN!N"N$N+N$NiN2NaN5NnN$NKN:NnN@N.N$N7N$N?N%N-N%NcN%NCN%N7N%Ne
#     .AN%NUN%N!N%N$N%NkN?NtN$NrNFN@N$NFN!N"N%NfN%NKN!N<N%N/N$NJN?N7N5N,N%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N$NrN@N8N@N.N$N9N$NkN!N#
###     .AN$N=N$NNN%NUN%N!N%N$N%NkN$NrN=NqN$N-N9N~N$N_N%N*N!N<N%NWN%NsN$N7N!N"N%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$NKN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%Nk
###     .ANLN>N$NNNDNIN2NCN$NrN9NTN$N&N!N#
# .ANHNwN9NM
#
sub create {
    my $self  = shift;
    my $id    = shift;

    # $id.AN$N,N;NXNDNjN$N5N$NlN$NFN$N$N$NJN$N$N>NlN9NgN!N"N$N"N$NkN$N$N$NON4N{N$NKN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$NKNENPNON?N$N5N$NlN$NF
    # .AN$N$N$NkN>NlN9NgN!N"N%N(N%NiN!N<N%NaN%NCN%N;N!N<N%N8N$NrN=NPNNNON$N7N$NFN%NWN%NmN%N0N%NiN%N`N$NrN=N*NNN;N$N9N$NkN!N#
    unless(defined $id) {
		die "cache ID not specified : $id";
    }

    if(exists $self->{'Index'}{$id}) {
		die "cache ID already exists : $id";
    }

    # .AN?N7N5N,N%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>(N%NfN%NKN!N<N%N/N$NJN$NbN$NN)N$NrN@N8N@N.N$N9N$NkN!N#
    # .AN"N(N%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN@NhNFN,N$NKN$N"N$NkN%NlN%N3N!N<N%NIN$N+N$NiN%NfN%NKN!N<N%N/NHNVN9NfN$NrN@N8N@N.
    my($fname, $fullname) = $self->newCacheFname();
    my $cnt = 0;
    while(-e $fullname) {
		($fname, $fullname) = $self->newCacheFname();
		$cnt++;
		if($cnt > 10) {
			die "***** cache file generate retry over $cnt *****";
		}
    }

    # .AN%N-N%NcN%N7N%NeN%NUN%N!N%N$N%NkN$NrN=NqN$N-N9N~N$N_N%NbN!N<N%NIN$NGN%N*N!N<N%NWN%NsN$N9N$NkN!N#
    my $fh = new FileHandle("> $fullname") || die "open failure($!): $fullname";

    # .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N$NrN%NaN%NsN%NPNJNQN?NtN$NKNJN]NBN8N$N9N$NkN!N#
    $self->{'CacheID'}     = $id;
    $self->{'CacheFile'}   = $fullname;
    $self->{'CacheHandle'} = $fh;
    $self->{'Index'}{$id}{'file'} = $fname;

}

###############################################################################
# .ANLN>N>NN
#     write()
# .AN3N5NMNW
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NKN%NGN!N<N%N?N$NrN=NPNNNON$N9N$Nk
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
#     $rec  : .AN=NPNNNON%NGN!N<N%N?
# .ANLNaNCNM
#     .AN$NJN$N7
# .AN@NbNLN@
#     
# .ANHNwN9NM
#
sub write {
    my $self = shift;
    my @rec  = @_;

    my $fh = $self->{'CacheHandle'};
#print STDERR "write: handle=$fh; $rec[0..3]\n";
    my $rc = print $fh @rec;
    unless($rc) {
		die "write failure($!) : [$rc] : " . $self->{'CacheFile'};
    }
}

###############################################################################
# .ANLN>N>NN
#     close()
# .AN3N5NMNW
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NrN%N/N%NmN!N<N%N:N$N9N$Nk
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .ANLNaNCNM
#     .AN$NJN$N7
# .AN@NbNLN@
#     
# .ANHNwN9NM
#
sub close {
    my $self  = shift;

    if(my $fh = $self->{'CacheHandle'}) {
	$fh->close;
    }
}

###############################################################################
# .ANLN>N>NN
#     open()
# .AN3N5NMNW
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NrN%N*N!N<N%NWN%NsN$N9N$NkN!N#
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
#     $id   : .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN<N1NJNLN;NR
# .ANLNaNCNM
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NNN%N*N!N<N%NWN%NsN$NKN@N.N8Ny : 1
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$N,NBN8N:N_N$N7N$NJN$N$     : 0
# .AN@NbNLN@
#     
# .ANHNwN9NM
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$N,NBN8N:N_N$N7N!N"N$N+N$NDmysqlN$NKN%NGN!N<N%N?N$N,NLN5N$N$N>NlN9NgN$NON%NWN%NmN%N0N%NiN%N`N$NrN=N*NNN;
#
sub open {
    my $self = shift;
    my $id   = shift;

    my $rc   = 0;
    # .AN;NXNDNjN$N5N$NlN$N?IDN$NKNBNPN1N~N$N9N$NkN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$N,NBN8N:N_N$N9N$NlN$NPN!N"N$N=N$NNN%NUN%N!N%N$N%NkN$Nr
    # .AN%N*N!N<N%NWN%NsN$N9N$NkN!N#
    if(exists $self->{'Index'}{$id}) {
        my $fname = join("/", $self->{'DirName'}, $self->{'Index'}{$id}{'file'});
        my $id = basename($fname);
        my $cmd = "$main::PROG_DOMCLUST_RESULT -dbname=$main::DOMCLUST_DB -tabid=$id";
        print STDERR "DBG :: CMD :: $cmd\n";
        my $fh = new FileHandle("$cmd |") || die "open failure($!) : $cmd";
        $self->{'CacheHandle'} = $fh;
        $rc = 1;
    }
    return $rc;
}

###############################################################################
# .ANLN>N>NN
#     exists()
# .AN3N5NMNW
#     .AN;NXNDNjN$N5N$NlN$N?IDN$NKNBNPN1N~N$N9N$NkN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$N,NBN8N:N_N$N9N$NkN$N+NDN4N$NYN$Nk
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
#     $id   : .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN<N1NJNLN;NR
# .ANLNaNCNM
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$N,NBN8N:N_N$N9N$NlN$NPN?N?N$NrN!N"N$NJN$N1N$NlN$NPN5N6N$NrNJNVN$N9N!N#
# .AN@NbNLN@
#     
# .ANHNwN9NM
#
sub exists {
    my $self  = shift;
    my $id    = shift;

    exists $self->{'Index'}{$id};
}

###############################################################################
# .ANLN>N>NN
#     getlines()
# .AN3N5NMNW
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NNNFNbNMNFNAN4N$NFN$NrN$N^N$NHN$NaN$NFN<NhNFN@N$N9N$NkN!N#
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
#     $fm   : .AN<NhNFN@N$N7N$N?N$N$N%NlN%N3N!N<N%NIN$NNN3N+N;NONHNVN9Nf(N%N*N%NWN%N7N%NgN%Ns)
#     $to   : .AN<NhNFN@N$N7N$N?N$N$N%NlN%N3N!N<N%NIN$NNN=N*NNN;NHNVN9Nf(N%N*N%NWN%N7N%NgN%Ns)
# .ANLNaNCNM
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NNNFNbNMNFN$NrNJN]N;N}N$N9N$NkN%NjN%N9N%NHN!NJN#N1NMNWNANGN#N1N%NlN%N3N!N<N%NIN!NK
# .AN@NbNLN@
#     $fm.AN$N,N;NXNDNjN$N5N$NlN$NFN$N$N$NJN$N1N$NlN$NPN!N"NAN4N$NFN$NNN%NlN%N3N!N<N%NIN$NrNJNVN$N9N!N#
#     $fm.AN$N,N;NXNDNjN$N5N$NlN$NFN$N$N$NlN$NPN!N"N;NXNDNjN$N5N$NlN$N?NHNVN9NfN$N^N$NGN$NNN%NlN%N3N!N<N%NIN$NrNFNIN$N_NHNtN$NPN$N7N!N"
#     $to.AN$N^N$NGN$NNN%NlN%N3N!N<N%NIN$NrNJNVN$N9N!
# .ANHNwN9NM
#
sub getlines {
    my $self  = shift;
    my $fm    = shift;
    my $to    = shift;

    my @rec;

    # .AN%NUN%N!N%N$N%NkN%NON%NsN%NIN%NkN$NrN<NhNFN@N$N7N!N"N%NUN%N!N%N$N%NkN$NNN@NhNFN,N$NKN%N]N%N8N%N7N%NgN%NsN$NrN0N\NFN0N$N9N$NkN!N#
    my $fh = $self->{'CacheHandle'};

    # $fm .AN$N,N;NXNDNjN$N5N$NlN$NFN$N$N$NkN>NlN9NgN!N"N$N=N$N3N$N^N$NGN$NNN%NlN%N3N!N<N%NIN$NrNFNIN$N_NHNtN$NPN$N7
    # $to .AN$N^N$NGN$NNN%NlN%N3N!N<N%NIN$NrNFNIN$N_N9N~N$N`
    if(defined $fm) {
       my $num = 0;
       while(my $line = $fh->getline) {
           $num++;
           if($fm <= $num) {
               push(@rec, $line);
               last if($num == $to);
           }
       }
    }
    # $fm .AN$N,N;NXNDNjN$N5N$NlN$NFN$N$N$NJN$N1N$NlN$NPN!N"NAN4N%NlN%N3N!N<N%NIN$NrNFNIN$N_N9N~N$N`N!N#
    else {
       @rec = $fh->getlines;
    }

    # .ANFNIN$N_N9N~N$NsN$N@N%NlN%N3N!N<N%NIN$NrNJNVN$N9N!N#
    return @rec;
}

###############################################################################
# .ANLN>N>NN
#     getline()
# .AN3N5NMNW
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NNNFNbNMNFN$NrN#N1N%NlN%N3N!N<N%NIN$N:N$NDN<NhNFN@N$N9N$NkN!N#
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .ANLNaNCNM
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NNNFNbNMNF(N#N1N%NlN%N3N!N<N%NIN!NK
# .AN@NbNLN@
#     
# .ANHNwN9NM
#
sub getline {
    my $self  = shift;

    my $fh = $self->{'CacheHandle'};
    my $rec = $fh->getline;
    $rec;
}

###############################################################################
# .ANLN>N>NN
#     purge()
# .AN3N5NMNW
#     .AN;NXNDNjN$N5N$NlN$N?N%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NrN:NoN=N|N$N9N$NkN!N#
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .ANLNaNCNM
#     .AN$NJN$N7
# .AN@NbNLN@
#     .AN;NXNDNjN$N5N$NlN$N?N<N1NJNLN;NRN$NKN3N:NENvN$N9N$NkN>NpNJNsN$NrN%N$N%NsN%NGN%NCN%N/N%N9N$N+N$NiN:NoN=N|N$N7N!N"N$N=N$NNN8NeN%N-N%NcN%NCN%N7N%Ne
#     .AN%NUN%N!N%N$N%NkN$NrN:NoN=N|N$N9N$NkN!N#
# .ANHNwN9NM
#     
#
sub purge {
    my $self  = shift;
    my $id    = shift;

    # .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N$NrNFN@N$NkN!N#
    my $fname = join("/", $self->{'DirName'}, $self->{'Index'}{$id});

    # .AN%N$N%NsN%NGN%NCN%N/N%N9N$N+N$NiN3N:NENvN>NpNJNsN$NrN:NoN=N|N$N9N$NkN!N#
    delete $self->{'Index'}{$id};
    $self->{'Modified'}    = 1;   # .AN%NGN%N9N%NHN%NiN%N/N%N?N$NGN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$NKNHN?N1NG
    
    # .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NrN:NoN=N|N$N9N$NkN!N#
    unlink $fname if(-e $fname);
}

###############################################################################
# .ANLN>N>NN
#     newCacheFname()
# .AN3N5NMNW
#     .AN%NfN%NKN!N<N%N/N$NJN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N$NrN@N8N@N.N$N9N$Nk
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .ANLNaNCNM
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>(1) N"N(N%NQN%N9N$NJN$N7
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>(2) N"N(N%NQN%N9N$N"N$Nj
# .AN@NbNLN@
#     
# .ANHNwN9NM
#     
sub newCacheFname {
    my $self = shift;

    # .AN?N7N5N,N%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>(N%NfN%NKN!N<N%N/N$NJN$NbN$NN)N$NrN@N8N@N.N$N9N$NkN!N#
    my($fname, $fullname) = $self->getCacheFname(createUID());

    return($fname, $fullname);
}

###############################################################################
# .ANLN>N>NN
#     getCacheFname()
# .AN3N5NMNW
#     .AN;NXNDNjN$N5N$NlN$N?N%NfN%NKN!N<N%N/NJN8N;NzNNNsN$NrNMNQN$N$N$NFN!N"N%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N$NrN@N8N@N.N$N9N$Nk
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .ANLNaNCNM
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>(1) N"N(N%NQN%N9N$NJN$N7
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>(2) N"N(N%NQN%N9N$N"N$Nj
# .AN@NbNLN@
#     
# .ANHNwN9NM
#     
sub getCacheFname {
    my $self = shift;
    my $uid  = shift;

    # .ANMN?N$N(N$NiN$NlN$N?(N%NfN%NKN!N<N%N/N$NJ)NJN8N;NzNNNsN$NrNMNQN$N$N$NFN!N"NLN?NLN>N%NkN!N<N%NkN$NKN=N>N$NCN$N?N%NUN%N!N%N$N%NkNLN>N$NrN@N8N@N.N$N9N$NkN!N#
    my $path  = $self->{'DirName'};
    my $fname = sprintf("%s_%s",
			$self->{'FnamePrefix'},   # .AN%NUN%N!N%N$N%NkNLN>N%NWN%NlN%NUN%N#N%N/N%N9
			$uid);                    # .AN%NfN%NKN!N<N%N/N$NJID
    my $fullname = join("/", $path, $fname);

    return($fname, $fullname);
}

###############################################################################
# .ANLN>N>NN
#     createUID()
# .AN3N5NMNW
#     .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkNLN>N$NKNMNQN$N$N$NkN%NfN%NKN!N<N%N/N$NJIDN$NrN@N8N@N.N$N9N$Nk
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .ANLNaNCNM
#     .AN%NfN%NKN!N<N%N/N$NJID
# .AN@NbNLN@
#     
# .ANHNwN9NM
#     .AN%N?N%N$N%N`N%N9N%N?N%NsN%NWN$NHN%NWN%NmN%N;N%N9IDN$NHN$NrNANHN$N_N9NgN$NoN$N;N$NFN%NfN%NKN!N<N%N/N$NJID(NJN8N;NzNNNs)N@N8N@N.N$N9N$NkN!N#
# 
sub createUID {
    my($uid) = sprintf("%d_%05d", time, $$);

    return $uid;
}

###############################################################################
# .ANLN>N>NN
#     refSerialize()
# .AN3N5NMNW
#     .AN%NON%NCN%N7N%NeN$NdN%NjN%N9N%NHN$NNN%NjN%NUN%N!N%NlN%NsN%N9N$NrNJN8N;NzNNNsN$NKNEN8N3N+N$N9N$NkN!N#
# .AN0NzN?Nt
#     $var : .AN%NON%NCN%N7N%NeN$NbN$N7N$N/N$NON%NjN%N9N%NHN$NNN%NjN%NUN%N!N%NlN%NsN%N9
# .ANLNaNCNM
#     .ANEN8N3N+N8NeN$NNNJN8N;NzNNNs
# .AN@NbNLN@
#     
# .ANHNwN9NM
#     
sub refSerialize {
    my $str;
#
#  1. .AN0NzN?NtN$NNN?NtN$NrNDN4N$NYN!N"N0NzN?NtN$N,N$NJN$N/N$NJN$NkN$N^N$NGN0NJN2N<N$NNN=NhNMN}N$NrN7N+N$NjNJNVN$N9N!N#
    while(scalar(@_)) {
#     1).AN0NzN?NtN$NrN#N1N$NDN<NhN$NjN=NPN$N9N!N#N<NhN$NjN=NPN$N7N$N?NCNMN$N,NLN$NDNjN5NANCNMN$NGN$NJN$N1N$NlN$NPN!N"N7NkN2NLNJN8N;NzNNNsN$NK
#       ", ".AN$NrNDNIN2NCN$N9N$NkN!N#
#     .AN"N(N7NkN2NLNJN8N;NzNNNs: NLNaN$NjNCNMN$NHN$N7N$NFNJNVN$N9NJN8N;NzNNNs
        my $var = shift @_;
        $str .= ', ' if(defined($str));
#
#     2)1).AN$NGN<NhN$NjN=NPN$N7N$N?NCNMN$N,N%NjN%N9N%NHN$NXN$NNN%NjN%NUN%N!N%NlN%NsN%N9N$NJN$NiN$NPN!N"N%NjN%NUN%N!N%NlN%NsN%N9N$NrNEN8N3N+N$N7N$N?
#       .AN%NjN%N9N%NHN$NrN0NzN?NtN$NHN$N7N$NFNKN\N4NXN?NtN$NrN:NFN5N"NEN*N$NKN8NFN$NSN=NPN$N9N!N#
#       .AN$N=N$NNN7NkN2NLN<NuN$N1N<NhN$NCN$N?NJN8N;NzNNNsN$NNNAN0N8NeN$NK"[", "]"N$NrNDNIN2NCN$N7N$N?NJN8N;NzNNNsN$NrN7NkN2NLNJN8N;NzNNNs
#       .AN$NKNDNIN2NCN$N9N$NkN!N#
        # array ref
        if(ref $var eq 'ARRAY') {
            $str .= '[' . refSerialize(@$var) . ']';
        }
#
#     3)1).AN$NGN<NhN$NjN=NPN$N7N$N?NCNMN$N,N%NON%NCN%N7N%NeN$NXN$NNN%NjN%NUN%N!N%NlN%NsN%N9N$NJN$NiN$NPN!N"N%N-N!N<N$NHNCNMN$NrN=NgN<N!
#       .AN<NhN$NjN=NPN$N7N!N"N$N=N$NlN$NiN$Nr"=>"N$NGN7NkN9NgN$N7N$N?NJN8N;NzNNNsN$NrN@N8N@N.N$N9N$NkN!N#
#       .AN$N3N$NNN;N~N%NON%NCN%N7N%NeN$NNNCNMN<N+NBNNN$N,N%NjN%NUN%N!N%NlN%NsN%N9N$NKN$NJN$NCN$NFN$N$N$NkN>NlN9NgN$NrN9NMNNN8N$N7N$NFN!N"NCNMN$Nr
#       .AN0NzN?NtN$NHN$N7N$NFNKN\N4NXN?NtN$NrN:NFN5N"NEN*N$NKN8NFN$NSN=NPN$N7N!N"NLNaN$NjNCNMN$NrNJN8N;NzNNNsN$NKN%N;N%NCN%NHN$N9N$NkN!N#
#       .AN$N3N$N3N$NGNFN@N$N?N!N"N%N-N!N<N!N?NCNMN$NNNANHN9NgN$N;NKNhN$NKNFN@N$N?NJN8N;NzNNNs(NJN#N?Nt)N$N=N$NlN$N>N$NlN$Nr","N$NGN7NkN9NgN$N7N!N"
#       .AN$N5N$NiN$NKNAN0N8NeN$NK"{", "}"N$NrNINUNMN?N$N7N$NFN7NkN2NLNJN8N;NzNNNsN$NKNDNIN2NCN$N9N$NkN!N#
        # hash ref
        elsif(ref $var eq 'HASH') {
            my @substr;
            foreach my $k (sort keys  %$var) {
                my $v = $var->{$k};
                push(@substr, "'$k'=>" . refSerialize($v));
            }
            $str .= '{' . join(', ', @substr) . '}';
        }
#
#     4).AN>NeN5N-N0NJN3N0N$NNN>NlN9NgN!N"N<NuN$N1N<NhN$NCN$N?NCNMN$NNNAN0N8NeN$NK"'"(N%N7N%NsN%N0N%NkN%N/N%N*N!N<N%NH)N$NrNINUN2NCN$N7N$N?
#       .ANJN8N;NzNNNsN$NrN:NnN@N.N$N7N!N"N7NkN2NLNJN8N;NzNNNsN$NKNDNIN2NCN$N9N$NkN!N#
        # not ref
        else {
            $str .= "'" . $var . "'";
        }
    }
#
#  2. .AN7NkN2NLNJN8N;NzNNNsN$NrN%NjN%N?N!N<N%NsN$N9N$NkN!N#
    return($str);
}

###############################################################################
# .ANLN>N>NN
#     getAddInfo()
# .AN3N5NMNW
#     .AN%N$N%NsN%NGN%NCN%N/N%N9N%NUN%N!N%N$N%NkN$NKN$N"N$NkNINUN2NCN>NpNJNsN$NrN<NhNFN@N$N9N$NkN!N#
# .AN0NzN?Nt
#     $self : .AN%N$N%NsN%N9N%N?N%NsN%N9N$NNN%NjN%NUN%N!N%NlN%NsN%N9
#     $id   : .AN%N-N%NcN%NCN%N7N%NeN%NUN%N!N%N$N%NkN$NNN<N1NJNLN;NR
# .ANLNaNCNM
#     .ANINUN2NCN>NpNJNs(N%NjN%NUN%N!N%NlN%NsN%N9N!N'NENPNON?N;N~N$NNN%N?N%N$N%NWN$NKN0NMNBN8)
# .AN@NbNLN@
#     
# .ANHNwN9NM
#     
sub getAddInfo {
    my $self = shift;
    my $id   = shift;

    return $self->{'Index'}{$id}{'info'};
}

###############################################################################
#
sub setUseDomclustDump {
    my $self  = shift;
    my $sta  = shift;

    $self->{'USE_DOMCLUST_DUMP'} = $sta;

    return;
}

###############################################################################
#
sub getUseDomclustDump {
    my $self  = shift;

    return $self->{'USE_DOMCLUST_DUMP'};
}

###############################################################################
1;#
###############################################################################
