#!/usr/local/bin/perl -s
package RECOG::DomClust;
###############################################################################
# ̾
#     DomClust.pm
# 
#     ץdomclust¹Ԥ̤ɸϤ˽Ϥ롣
# 
#     Ϳ줿ϥե̾ץ˽äơdomclust ¹Ԥ롣
# ѥåѿ
#     $ProgFileName
#     
# Сѿ
#     'ProgramFileName'
#     'SimFile'
#     'GeneFile'
#     'FileHandle'
#     'Option'
#     'InGroup'
#     'OutGroup'
#     'Species'
#     
# ᥽åɰ
#     new()
#     _init()
#     setSimilarityFile()
#     setGeneFile()
#     setOutFile()
#     setOption()
#     editStatement()
#     exec()
#     getEachLine()
#     getAllLines()
#     setProgFname()
#     setInGroup()
#     setOutGroup()
#     setSpecies()
# 
#
###############################################################################
use strict;
#our(@ISA);                                   # require 5.6.0;
use FileHandle;
# ѥåѿ
use constant ProgFileName => "domclust";     # domclust ¹ԥե̾
use RECOG;
use RECOG::DomClustCommon;
use RECOG::RecogCommon;
require 'MBGD_commonPath.pl';
use FileHandle;

###############################################################################
# ̾
#     new()
# 
#     󥹥ȥ饯
# 
#     $that  : 饹̾(⤷ϥ󥹥󥹤Υե)
#     @args  : ѥ᡼
# 
#     󥹥󥹤ؤΥե
# 
#
# 
#
sub new {
    my $that = shift;
    my @args = @_;
    my $self = {};

    # $that ե󥹤ʤ顢ѥå̾롣
    my $class = ref($that) || $that;

    bless($self, $class);
    $self->_init(@args);

    return $self;
}

###############################################################################
# ̾
#     _init()
# 
#     
# 
#     $self  : 󥹥󥹤ؤΥե
#     %param : ưѥ᡼
# 
#     ʤ
# 
#     ¹ԥץ̾ѿ˥åȤ롣
# 
#
sub _init {
    my $self  = shift;
    my %param = @_;

    $self->setProgFname(ProgFileName);

    # ʲ˽

#    return;
}

###############################################################################
# ̾
#     DESTROY()
# 
#     ǥȥ饯
# 
#     $self  : 󥹥󥹤ؤΥե
# 
#     ʤ
# 
#     ե롣
# 
#     ̾ѿλѤեϥɥλѤξϥǥȥ饯Ѱ
#     ʤƤŬڤ˴롣
#     եʤɤ롣
#
sub DESTROY {
    my $self = shift;

    # ȤΥ饹˴³
    # ѡ饹Υ󥹥ѿѤƤʤϡ
    # ѡ饹 DESTROY() ƤӽФθǤ褤
    my ($tmpname,$tmpprog,$tmperr) = $self->getTmpfileName();
    if(-e $tmpname) {
        unlink($tmpname);
    }
    if(-e "$tmpname.tree") {
        unlink("$tmpname.tree");
    }
	if(-e $tmpprog) {
		unlink($tmpprog);
	}
	if(-e $tmperr) {
		unlink($tmperr);
	}

    # ǥȥ饯Ͽƥ饹ʤƤ줿褤
    $self->SUPER::DESTROY;
}

###############################################################################
# ̾
#     createTmpfileName()
# 
#     ե̾롣
# 
#     $self  : 󥹥󥹤ؤΥե
# 
#     $tmpname : ե̾
# 
#
# 
#
sub createTmpfileName {
    my $self = shift;
	my $id   = shift;
	my $pref = shift;

#    my @ti = localtime(time);
#    my $nen = $ti[5] + 1900;
#    my $tuki = $ti[4] + 1;
#    my $tmpname = $main::DOMCLUST_TMP_DIR . "/" . $pref . "_" . "$nen$tuki$ti[3]$ti[2]$ti[1]$ti[0]" . "_" . $$;

	my $tmpname = $main::DOMCLUST_TMP_DIR . "/" . $pref . "_" . $id;

    return $tmpname;
}

###############################################################################
# ̾
#     getTmpfileName()
# 
#     ե̾롣
# 
#     $self  : 󥹥󥹤ؤΥե
# 
#     $tmpname : ե̾
# 
#     ѿ'Tmpfile'˥ե뤬̵硢createTmpfileName
#     ե֤
# 
sub getTmpfileName {
    my $self = shift;
	my $clusterID = shift;

    my $tmpname = $self->{'Tmpfile'};
    if(!$tmpname) {
      $tmpname = $self->createTmpfileName($clusterID,$main::PREF_DOMCLUST_RESULT);
    }

	my $tmperr = $self->{'TmpErrorfile'};
	if(!$tmperr) {
		$tmperr = $self->createTmpfileName($clusterID,$main::PREF_DOMCLUST_ERROR);
	}

	my $tmpprog = $self->{'TmpProgfile'};
	if(!$tmpprog) {
		$tmpprog = $self->createTmpfileName($clusterID,$main::PREF_DOMCLUST_PROG);
	}

    return ($tmpname,$tmpprog,$tmperr);
}


###############################################################################
# ̾
#     setSimilarityFile()
# 
#     domclustϥե̾(similarity_file)ꤹ롣
# 
#     $self  : 󥹥󥹤ؤΥե
#     $fname : similarity_file̾
# 
#     ʤ
# 
#     similarity_file̾Τѿ'SimFile'˥åȤ롣
# 
#
sub setSimilarityFile {
    my $self  = shift;
    my $fname = shift;
    $self->{'SimFile'} = $fname;

    unless(-e $fname && -f $fname) {
	printf(STDERR "similarity file not exists : %s\n", $fname);
    }
}

###############################################################################
# ̾
#     setGeneFile()
# 
#     domclustϥե̾(gene_file)ꤹ롣
# 
#     $self  : 󥹥󥹤ؤΥե
#     $fname : gene_file̾
# 
#     ʤ
# 
#     gene_file̾Τѿ'GeneFile'˥åȤ롣
# 
#
sub setGeneFile {
    my $self  = shift;
    my $fname = shift;
    $self->{'GeneFile'} = $fname;

    unless(-e $fname && -f $fname) {
	printf(STDERR "gene file not exists : %s\n", $fname);
    }
}

###############################################################################
# ̾
#     setOutFile()
# 
#     domclustνϥե̾ꤹ롣
# 
#     $self  : 󥹥󥹤ؤΥե
#     $fname : ϥե̾
# 
#     ʤ
# 
#     ϥե̾Τѿ'OutFile'˥åȤ롣
# 
#
sub setOutFile {
    my $self  = shift;
    my $fname = shift;

    $self->{'OutFile'}  = $fname;
}

###############################################################################
# ̾
#     setOptionSelect()
# 
#     select ưץѿ'OptionSelect'ꤹ롣
# 
#     $self : 󥹥󥹤ؤΥե
# 
#     ʤ
# 
#     ưѥ᡼Υǥեͤ䴰롣
# 
#
sub setOptionSelect {
    my $self = shift;
    my $parm_ref = shift;

	$self->{'OptionSelect'} = $parm_ref;

    return;
}

###############################################################################
# ̾
#     setOption()
# 
#     domclustưץѿ'Option'ꤹ롣
# 
#     $self : 󥹥󥹤ؤΥե
# 
#     ʤ
# 
#     ưѥ᡼Υǥեͤ䴰롣
# 
#
sub setOption {
    my $self = shift;
    my %parm = @_;

    # ץåʤ顢ѿ'Option'ꤹ롣
    while(my($name, $value) = each %parm) {
#	if($name eq '-S'	|| 
#	   $name eq '-d'	||
#	   $name eq '-c'	||
#	   $name eq '-m'	||
#	   $name eq '-mr'	||
#	   $name eq '-C'	||
#	   $name eq '-V'	||
#	   $name eq '-n'	||
#	   $name eq '-ne'	||
#	   $name eq '-p'	||
#	   $name eq '-H'	||
#	   $name eq '-ai'	||
#	   $name eq '-ao'	||
#	   $name eq '-t'	||
#	   $name eq '-R'	||
#	   $name eq '-o'	||
#	   $name eq '-O'	) {
##	   $name eq '-o'	) {
#	    $self->{'Option'}{$name} = $value;
#	}
#	else {
#	    printf(STDERR "***** domclust invalid option : %s %s *****\n",
#		   $name, $value);
#	}
	$self->{'Option'}{$name} = $value;
    }
#    return;
}

###############################################################################
# ̾
#     exec()
# 
#     domclustư롣
# 
#     $self : 󥹥󥹤ؤΥե
#     $cmnd : domclust¹ԥơȥ(ץ)
# 
#     ʤ
# 
#     domclustưϥեϥɥ˥ѥפǷ礹롣
# 
#
sub exec {
    my $self = shift;
	my $clusterID = shift;
    my $cmnd = shift;
	my $res;

    $cmnd = $self->editStatement() unless(defined $cmnd);

    my $pid = sprintf("%6d",$$);
    my $remip = $ENV{'REMOTE_ADDR'}; 
    my $fhd;

    # execλ֤פäƽϤե
    my $exec_logfile = $main::DOMCLUST_EXE_LOGFILE;

    if(-e $exec_logfile) {
        $fhd = FileHandle->new(">>$exec_logfile");
        if (!$fhd) {
            DomClustCommon::printErrMsgExit($DomClustCommon::ERRNO_FILE_ACCESS, $clusterID);
        }
        my $date = scalar(localtime);
        my $cmd = sprintf("$cmnd > %s", $self->{'OutFile'});
        print $fhd "pid=$pid\t$date\t$remip\tSTART\tcommand=\"$cmnd\"\n";
    }
    else {
        $fhd = FileHandle->new(">/dev/null");
        if (!$fhd) {
            DomClustCommon::printErrMsgExit($DomClustCommon::ERRNO_FILE_ACCESS, $clusterID);
        }
    }

	my ($tmpname, $tmpprog, $tmperr) = $self->getTmpfileName($clusterID);
    my $fh;
    if(exists $self->{'OutFile'}) {
		main::execDomClust($clusterID, $cmnd, $self->{'OutFile'}, $tmperr, $tmpprog);
		$res = 1;
		if(-e $exec_logfile) {
			my $date = scalar(localtime);
			print $fhd "pid=$pid\t$date\t$remip\tEND\n";
		}
        $fh = new FileHandle($self->{'OutFile'});
        if (!$fh) {
            DomClustCommon::printErrMsgExit($DomClustCommon::ERRNO_FILE_ACCESS, $clusterID);
        }
		$self->{'TmpErrorfile'} = $tmperr;
        $self->{'TmpProgfile'}  = $tmpprog;
    }
    else {
		main::execDomClust($clusterID, $cmnd, $tmpname, $tmperr, $tmpprog);
		$res = 1;
        if(-e $exec_logfile) {
          my $date = scalar(localtime);
		  print $fhd "pid=$pid\t$date\t$remip\tEND\n";
        }
	    $fh = new FileHandle("$tmpname");
        if (!$fh) {
            DomClustCommon::printErrMsgExit($DomClustCommon::ERRNO_FILE_ACCESS, $clusterID);
        }
        $self->{'Tmpfile'} = $tmpname;
		$self->{'TmpErrorfile'} = $tmperr;
		$self->{'TmpProgfile'}  = $tmpprog;
    }
    $self->{'FileHandle'} = $fh;
    
    $fhd->close();

    return $res;
}

###############################################################################
# ̾
#     editStatement()
# 
#     domclust¹Ԥ륳ޥɥ饤󥹥ơȥȤԽ롣
# 
#     $self : 󥹥󥹤ؤΥե
# 
#     DomClust¹ԥޥɥ饤󥹥ơȥ
# 
#     
# 
#
sub editStatement {
    my $self = shift;

    #
    my(@opt_keys) = (
#        '-c',
        '-m',
        '-mr',
        '-C',
        '-V',
        '-n',
        '-ne',
        '-p',
        '-H',
        '-HO',
        '-t',
        '-ai',
        '-ao',
#        '-Ohorizweight',
    );

    #
    my(%default_value) = (
#        '-c'  => 60,
#        '-ci'  => 80,
#        '-mr' => 0.95,
        '-n'  => 1,
        '-ne' => 1,
        '-p'  => 0.5,
        '-V'  => 0.6,
        '-C'  => 80,
        '-ao' => 0.8,
        '-ai' => 0.95,
#        '-Ohorizweight' => 0,
    );

    #
    my($k);
    my($opt) = '';

    #
    my $refSelectOpt = $self->{'OptionSelect'};
    if (exists($self->{'Option'}{'-S'})) {
        $opt .= ' ' if ($opt ne '');
        $opt .= '-S ';
        $opt .= "-c" . $refSelectOpt->{'-SCORE'};
    }
    elsif (exists($self->{'Option'}{'-d'})) {
        $opt .= ' ' if ($opt ne '');
        $opt .= '-d ';
        if (exists($refSelectOpt->{'-di'})) {
            if ($refSelectOpt->{'-IDENT'} ne '') {
                $opt .= "-c" . $refSelectOpt->{'-IDENT'};
            }
            else {
                $opt .= "-c" . 80;
            }
        }
        else {
            if ($refSelectOpt->{'-PAM'} ne '') {
                $opt .= "-c" . $refSelectOpt->{'-PAM'};
            }
        }
    }

    #
    $k = '-ci';
    if (exists($self->{'Option'}{$k})) {
        $opt .= ' ' if ($opt ne '');
        $opt .= $k . $self->{'Option'}{$k};
    }

    #
    $k = '-O';
    if (exists($self->{'Option'}{$k})) {
        $opt .= ' ' if ($opt ne '');
        $opt .= $k . $self->{'Option'}{$k};
    }

    #
    $k = '-Ohorizweight';
    if (exists($self->{'Option'}{$k})) {
        $opt .= ' ' if ($opt ne '');
        $opt .= $k . '=' . $self->{'Option'}{$k};
    }
    else {
        $opt .= ' ' if ($opt ne '');
        $opt .= $k . '=0';
    }

    #
    foreach my $k (@opt_keys) {
        my($v) = $self->{'Option'}{$k};
        if (!defined($v)) {
            if (!exists($default_value{"$k"})) {
                next;
            }
            $v = $default_value{"$k"};
        }

        #
        $opt .= ' ' if ($opt ne '');
        $opt .= $k;
        if ($v ne '') {
            $opt .= "$v";
        }
    }

    #
    my(@meta_spec_list) = RECOG::RecogCommon::getSpeciesByType($main::DBNAME_MBGD,
                                                               'metagenome');
    my(@sp_meta);
    foreach my$m (@meta_spec_list) {
        if ($self->{'SPECS'} =~ /$m/i) {
            push(@sp_meta, $m);
        }
    }
    my($opt_meta) = join(',', @sp_meta);
    if ($opt_meta) {
        $opt .= " -Ometa=$opt_meta";
    }

    #
    $k = '-OtaxMapSpec';
    if (exists($self->{'Option'}{$k})) {
        $opt .= ' ' if ($opt ne '');
        my($file_taxmap) = "$ENV{'MBGD_HOME'}/database/tax.map";
        if ($self->{'Option'}{$k}) {
            $opt .= $k . '=' . $self->{'Option'}{$k};
            $opt .= " -t$file_taxmap";
        }
        elsif ($opt_meta) {
            $opt .= $k . '=' . $opt_meta;
            $opt .= " -t$file_taxmap";
        }
        else {
        }
    }

    #
    my($cmnd);
    $cmnd = sprintf("%s %s", $self->{'ProgramFileName'}, $opt);
    $cmnd .= sprintf(" %s", $self->{'SimFile'})  if ($self->{'SimFile'});
    $cmnd .= sprintf(" %s", $self->{'GeneFile'}) if ($self->{'GeneFile'});
    $cmnd .= " ";
	$cmnd .= " -v ";  # domclust οĽɽץ

    return $cmnd;
}

###############################################################################
# ̾
#     getEachLine()
# 
#     domclustμ¹Է̤򣱹Ԥļ롣
# 
#     $self : 󥹥󥹤ؤΥե
# 
#     domclust¹Է(ʬ)
# 
#     ѿ'FileHandle'ϥեϥɥgetline᥽å
#     򥳡뤹롣
# 
#
sub getEachLine {
    my $self = shift;

    my $fh = $self->{'FileHandle'};
    my $line = $fh->getline;
    return $line;
}

###############################################################################
# ̾
#     getAllLines()
# 
#     domclustμ¹Է̤ɤ߹ࡣ
# 
#     $self : 󥹥󥹤ؤΥե
# 
#     domclust¹Է()
# 
#     ѿ'FileHandle'ϥեϥɥgetlines᥽å
#     ˤƤη̤ɤ߹ࡣꥹȤ¸ΥꥹȤ꥿
#     롣
# 
#
sub getAllLines {
    my $self = shift;

    my $fh = $self->{'FileHandle'};
    my @lines = $fh->getlines;
    return @lines;
}

###############################################################################
# ̾
#     setProgFname()
# 
#     domclust¹ԥե̾ѿ˥åȤ롣
# 
#     $self : 󥹥󥹤ؤΥե
#     $prog : domclust¹ԥե̾
# 
#     ʤ
# 
#     ѿ'ProgramFileName'Ϳ줿ե̾򥻥åȤ롣
# 
#
sub setProgFname {
    my $self  = shift;
    my $prog  = shift;

    $self->{'ProgramFileName'} = $prog;
}

###############################################################################
# ̾
#     setInGroup()
# 
#     domclust¹ԻIn Groupǻꤷʪѿ˥åȤ롣
# 
#     $self    : 󥹥󥹤ؤΥե
#     @species : ʪΥꥹ
# 
#     ʤ
# 
#     ѿ'InGroup'Ϳ줿ʪ̾򥻥åȤ롣
# 
#
sub setInGroup {
  my $self = shift;
  my @species = @_;

  $self->{'InGroup'} = \@species;
}

###############################################################################
# ̾
#     setOutGroup()
# 
#     domclust¹ԻOut Groupǻꤷʪѿ˥åȤ롣
# 
#     $self    : 󥹥󥹤ؤΥե
#     @species : ʪΥꥹ
# 
#     ʤ
# 
#     ѿ'OutGroup'Ϳ줿ʪ̾򥻥åȤ롣
# 
#
sub setOutGroup {
  my $self = shift;
  my @species = @_;

  $self->{'OutGroup'} = \@species;
}

###############################################################################
# ̾
#     setSpecies()
# 
#     domclust¹Ի˻ꤷʪѿ˥åȤ롣
# 
#     $self    : 󥹥󥹤ؤΥե
#     @species : ʪΥꥹ
# 
#     ʤ
# 
#     ѿ'Species'Ϳ줿ʪ̾򥻥åȤ롣
# 
#
###############################################################################
sub setSpecies {
  my $self = shift;
  my @species = @_;

  $self->{'Species'} = \@species;
}

1;#
###############################################################################
