package RECOG_PROJECTS::Schema::GeneProperty;

use strict;
use warnings;

use base 'DBIx::Class';

__PACKAGE__->load_components(
  "ResultSetManager",
#  "UTF8Columns",
  "InflateColumn::DateTime",
  "Core",
  "Core",
);
__PACKAGE__->table("gene_property");
__PACKAGE__->add_columns(
  "id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "gene_property_def_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "sp",
  { data_type => "VARCHAR", default_value => undef, is_nullable => 0, size => 5 },
  "locus_tag",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 0,
    size => 24,
  },
  "value",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 0,
    size => 40,
  },
);
__PACKAGE__->set_primary_key("id");
__PACKAGE__->add_unique_constraint(
  "gene_property_uniq",
  ["gene_property_def_id", "sp", "locus_tag", "value"],
);


# Created by DBIx::Class::Schema::Loader v0.04005 @ 2009-03-25 13:54:37
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:KkKcJhY8PBsE2zMQ97t28g

__PACKAGE__->belongs_to (
    gene_property_def => 'RECOG_PROJECTS::Schema::GenePropertyDef', {
        'foreign.id' => 'self.gene_property_def_id'
    }
);

# You can replace this text with custom content, and it will be preserved on regeneration
1;
