package RECOG_PROJECTS::Schema::Project;

use strict;
use warnings;

use base 'DBIx::Class';

__PACKAGE__->load_components(
  "ResultSetManager",
#  "UTF8Columns",
  "InflateColumn::DateTime",
  "Core",
  "Core",
);
__PACKAGE__->table("project");
__PACKAGE__->add_columns(
  "id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "udate",
  {
    data_type => "TIMESTAMP",
    default_value => "CURRENT_TIMESTAMP",
    is_nullable => 0,
    size => 14,
  },
  "proj_name",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 0,
    size => 100,
  },
  "proj_descr",
  {
    data_type => "TEXT",
    default_value => undef,
    is_nullable => 0,
    size => 65535,
  },
);
__PACKAGE__->set_primary_key("id");
__PACKAGE__->add_unique_constraint("project_uniq_name", ["proj_name"]);


# Created by DBIx::Class::Schema::Loader v0.04005 @ 2009-03-25 13:54:37
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:vQ7XvVb8BVvWZwWKdPJPFA

__PACKAGE__->has_many (
    project_member => 'RECOG_PROJECTS::Schema::ProjectMember', {
        'foreign.project_id' => 'self.id'
    }
);

# You can replace this text with custom content, and it will be preserved on regeneration
1;
