#!/usr/local/bin/perl -s
###############################################################################
#
###############################################################################
require "libMBGDaxes.pl";
require "MBGD_Conf.pl";

use MBGD::Taxonomy;
use MBGD::WWW;
use MbgdUserGenomeCommon;

###############################################################################
#
sub printHtmlElimOrg {
    my($tax) = shift;

    my(@RANKS) = ('species', 'genus','family','order','class','phylum');

    my(%ElimOrg, @ElimOrgArray);
    my(@deforg);
    if (!$tax) {
        @deforg = MBGD_SpecTableGetDefaultSpecies();
    }
    else {
        @deforg = $tax->get_default_spec();
    }

    my($default_orgs) = '"' . join('","', @deforg) . '"';
    foreach my $rank (@RANKS) {
	    my @orglist = $tax->get_species({'one_strain'=>$rank});
	    foreach my$o (@orglist) {
		    $ElimOrg{$o}++;
	    }
    }
    foreach my $org ($tax->get_all_spec()) {
	    my $num = scalar(@RANKS) - $ElimOrg{$org};
	    if ($ElimOrg{$org} < @RANKS) {
		    push(@ElimOrgArray, qq{"$org:$ElimOrg{$org}"});
	    }
    }
    $ElimOrgList = join(',', @ElimOrgArray);

    print <<END_SCRIPT;
<script defer="defer">
function elimNonDefault(document) {
    var document = this.document;

    var orglist = new Array( $ElimOrgList );
    var orglist2 = new Array( orglist.length );

    if (parent != self) {
        document = parent.tax_head.document;
    }
    var rank = document.specForm.rank.selectedIndex;
    var n = orglist.length;
    for (var i = 0; i < n; i++) {
        var tmpArray = orglist[ i ].split(":");
        orglist2[ tmpArray[0] ] = tmpArray[1];
    }

    if (parent != self) {
        document = parent.tax_body.document;
    }
    var n = document.specForm.species.length;
    var opts = document.specForm.species;
    for (var i = 0; i < n; i++) {
        if (orglist2[ opts[i].value ] < rank) {
            opts[i].checked = false;
        }
    }

    return;
}
</script>
END_SCRIPT

    return;
}

###############################################################################
#
sub printHtmlSelectByTaxonomy {
    my($uid) = shift;
    my(%Args) = @_;
    my($action) = $Args{'action'};


    my($URL_pairwise) = "/htbin/cluster";
    my(%COL);
    $COL{'2'} = '#ff0000';
    $COL{'1'} = '#ff00ff';
    $COL{''}  = '#009000';
    $COL{'0'} = '#009000';

    my(%COLOR);
    $COLOR{'Archaea'}    = '#fffff0';
    $COLOR{'Eubacteria'} = '#fff0ff';
    $COLOR{'Bacteria'}   = '#fff0ff';
    $COLOR{'Eukaryota'}  = '#f0ffff';
    $COLOR{'Eukaryotae'} = '#f0ffff';


    my($cntStart) = 0;
    my($cntEnd) = 0;

    # $BA*Br$5$l$F$$$k@8J*<o$N$_$rI=<(BP>]$K$9$k$?$a(B
    # $BA*Br$5$l$F$$$k@8J*<o$r(B Hash $B$K3JG<$9$k(B
    if (defined $Args{species}) {
	    foreach $sp (split(/,/, $Args{'species'})) {
            $spHash{"$sp"} = 1;
        }
    } else {
	my($WWW) = MBGD::WWW->new;
    	my($hom) = $WWW->uInfo->loadHomolParams;
        foreach $sp (split(/\|/, $hom->getValue('species') )) {
            $spHash{"$sp"} = 1;
        }
    }

    my(%isGenome, %IsSpecies);
    $IsGenome{'genome'} = 1;
    $IsSpecies{'species'} = 1;

    #
    my($dirUgDb) = MbgdUserGenomeCommon::getDirUserGenomeDatabase($uid);
    $fileUgTax = "$dirUgDb/tax";
    if ((-e $dirUgDb) && (! -e $fileUgTax)) {
        # UserGenome $B$r4^$s$@(B tax $B%U%!%$%k$r:n@.$9$k(B
        $taxonfile = $dirUgDb;
        MbgdUserGenomeCommon::createFileTaxon($uid);
    }
    $tax = MBGD::Taxonomy->new($taxonfile);


    print "<STYLE>
.button { font-type: sans-serif; font-size: 100% }
</STYLE>\n";

    print "<H3>Please choose a taxonomy group to conduct pairwise genome comparisons</H3>\n";

    #
    my(@out);
    $tax->print_tab(\@out);

    print <<EOB;
<script>
function narrowsSpec(list) {
    var win = self.opener;
    if (win == null) {
        win = self;
    }
    var opt = '&show_summary=pairwise&map_type=pairwise';
    win.location.href='${URL_pairwise}?pairwise_spec=' + list + opt;
    if (self.opener != null) {
        self.close();
    }
    return false;
}

</script>
EOB

    # $B%/%i%9%?%j%s%0BP>]$NA4$F$N(B SPEC
    my(%selSpecHashAll) = ();
    my($idxSelSpecAll) = 1;
    while ($_ = shift @out) {
        s#[\r\n]*$##;

        next if (/^\s*#/);

        ($lev, $specname, $list, $rank, $div, $status, $url) = split(/\t/);
        next if ($IsSpecies{$rank});

        # $BI=<(BP>]$N(B SPEC $B$N$_$rCj=P(B
        %selSpecHash = ();
        $idxSelSpec = 1;
        @list = split(/,/, $list);
        foreach $sp (@list) {
            next if (! $spHash{"$sp"});       # $B%/%i%9%?%j%s%0BP>]30$N(B SPEC

            $selSpecHash{"$sp"} = $idxSelSpec++;

            if (! $selSpecHashAll{"$sp"}) {
                $selSpecHashAll{"$sp"} = $idxSelSpecAll++;
            }

        }
        if (scalar(keys(%selSpecHash)) <= 1) {
            # $BI=<(BP>]$N@8J*<o$r4^$s$G$$$J$$(B
            # $B$b$7$/$O(B
            # $B#1@8J*<o$N$_$G$"$k(B
            next;
        }

        # $BI=<(BP>]$N@8J*<o$r(B tax $B%U%!%$%k$N=P8==g$GJB$YBX$((B
        $list = join(',', sort {$selSpecHash{"$a"} <=> $selSpecHash{"$b"}} keys(%selSpecHash));

        if ($lev == 1) {
            print "</TD></TABLE>\n" if ($prevlev ne '');
            print "<TABLE><TD>\n";
            $prevlev = 1; $prevwlev = 1; undef(@Wlev);
	        if ($specname eq 'Eukaryota') {
		        $eukflag = 1;
            } else {
	            $eukflag = 0;
            }
        }
        if ($lev > $prevlev) {
            $wlev = $prevwlev+1;
            $Wlev[$lev] = $wlev;
        }
        elsif ($lev == $prevlev) {
            $wlev = $prevwlev;
        }
        else {
            $wlev = $Wlev[$lev];
            for ($l = $prevlev; $l < $lev; $l--) {
                pop(@Wlev);
            }
        }

        if ($wlev < $prevwlev) {
            print "</UL>" x ($prevwlev - $wlev), "\n";
        }
        else {
            print "<UL>" x ($wlev - $prevwlev), "\n";
        }

        print "<li>" if (! $IsGenome{$rank});

        if ($IsGenome{$rank}) {
                $cntStart++;
        }

        $specname0 = $specname; $specname0 =~ s/ /+/g;
        if ($IsGenome{$rank}) {
        } elsif ($url) {
            print "<A HREF=\"${url}\">\n";
        } else {
            print "<A HREF=\"\" onclick=\"narrowsSpec('$list'); return false;\">\n";
        }

        @list = split(/,/, $list);
	$numsp = @list;
        if (! $IsGenome{$rank}) {
            print "<FONT color=\"$COL{'2'}\"><i>"     if ($IsGenome{$rank});
#            print "<b>$specname</b> ($list)";
            print "<b>$specname</b> ($numsp)";
            print "</i></FONT>"                       if ($IsGenome{$rank});
            print "</A>";
        }
        print "\n";
        if ($div) {
            if (! $IsGenome{$rank}) {
                $cntSpec  = scalar(split(",", $list));
                $cntEnd   = $cntStart + $cntSpec;
            }
        }
        if (! $IsGenome{$rank}) {
            print "<br>\n";
        }
        $prevlev = $lev;
        $prevwlev = $wlev;
    }
    close(TAXON);
    print "</UL>" x $prevwlev;

    # $BI=<(BP>]$NA4@8J*<o$r(B Tax $B%U%!%$%k$N=P8==g$GJB$YBX$((B
    @allspec = sort {$selSpecHashAll{"$a"} <=> $selSpecHashAll{"$b"}}
		keys(%selSpecHashAll);
##    $list = join(',', @allspec);
    $spnum = @allspec;
    print "<LI>";
    print "<A HREF=\"\" onclick=\"narrowsSpec('$list'); return false;\">\n";
    print "<b>All Selected Species</b> ($spnum)";
    print "</A>";
    print "</LI>";

    print "</TD></TABLE>\n";

    print "<P>\n";
}

###############################################################################
#
sub print_html_organism_selection_taxonomy {
    my($tax) = shift;
    my($mode) = shift;
    my($opt_ref) = shift;

    if ($opt_ref->{'species'}) {
        %spHash = ();
        my(@spec_list) = split(',', $opt_ref->{'species'});
        foreach my$spec (@spec_list) {
            $spHash{"$spec"} = 1;
        }
    }

    #
    my(%isGenome, %isSpecies);
    if ($mode eq 'mbgd') {
        $isGenome{'genome'} = 1;
    }
    else {
        $isGenome{'species'} = 1;
    }
    $isSpecies{'species'} = 1;

    #
    my$TAXURL   = "http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi";
    my$CMAPURL  = "/htbin/MBGD_whole_html.pl";
    my$LMAPURL  = "/htbin/MBGD_whole_linear_html.pl";

    #
    my(%color) = (  'Archaea'    => '#fffff0',
                    'Eubacteria' => '#fff0ff',
                    'Bacteria'   => '#fff0ff',
                    'Eukaryota'  => '#f0ffff',
                    'Eukaryotae' => '#f0ffff',
                 );
    my(%col);
    $col{'2'} = '#ff0000';
    $col{'1'} = '#ff00ff';
    $col{''}  = '#009000';
    $col{'0'} = '#009000';

    my($cntStart) = 0;
    my($cntEnd) = 0;

    #
    printHtmlElimOrg($tax);

    #
    print <<EOB;
<script>
function hide_self(id) {
    var doc = document;
    var elm = doc.getElementById(id);
    elm.style.display ='none';
}
</script>
EOB

    my(@out);
    $tax->print_tab(\@out);

    while (my$line= shift(@out)) {
       next if ($line =~ /^\s*#/);
        $line =~ s#[\r\n]*$##;

        my($lev, $specname, $list, $rank, $div, $status, $url) = split(/\t/, $line);
##        next if (($mode eq 'mbgd') && $isSpecies{"$rank"});

        if ($lev == 1 || $color{$specname}) {
            print "</TD></tr></TABLE>\n" if ($prevlev ne '');
            print "<TABLE width=\"100%\" border><tr><TD bgcolor=\"$color{$specname}\">\n";
            $prevlev = 1;
            $prevwlev = 1;
            undef(@Wlev);
            if ($specname eq 'Eukaryota') {
                $eukflag = 1;
            }
            else {
                $eukflag = 0;
            }
	}

        if ($lev > $prevlev) {
            $wlev = $prevwlev+1;
            $Wlev[$lev] = $wlev;
        }
        elsif ($lev == $prevlev) {
            $wlev = $prevwlev;
        }
        else {
            $wlev = $Wlev[$lev];
            for ($l = $prevlev; $l < $lev; $l--) {
                pop(@Wlev);
            }
        }

        if ($wlev < $prevwlev) {
            print "</UL>" x ($prevwlev - $wlev), "\n";
        }
        else {
            print "<UL>" x ($wlev - $prevwlev), "\n";
        }

        if (! $isGenome{$rank}) {
            print "<li id=\"tax_$specname\">";
        }

        if (($mode eq 'mbgd') && $isGenome{$rank}) {
            print "<span id=\"species_$list\"><br>\n";
            print "<a name=\"$list\"></a>";
            print "<INPUT TYPE=\"checkbox\" NAME=\"species\" VALUE=\"$list\"";
            print " id=\"species_chkbox_$list\" ";
            print " onClick=\"click_species('$list');\" ";
            print " CHECKED" if ($spHash{"$list"});
            print ">\n";
            $cntStart++;
        }

        $specname0 = $specname;
        $specname0 =~ s/ /+/g;
        if ($isGenome{$rank} && (($mode eq 'mbgd') || ($status == 2))) {
            if (! MbgdUserGenomeCommon::isUserGenome($list)) {
                if ($eukflag) {
                    print "<A HREF=\"${LMAPURL}";
                }
                else {
                    print "<A HREF=\"${CMAPURL}";
                }
                print "?spec=${list}&seqtype=chromosome&seqname=1\" target=\"_top\">\n";
            }
        }
        elsif ($url) {
            print "<A HREF=\"${url}\" target=\"_top\">\n";
        }
        else {
            print "<A HREF=\"${TAXURL}?name=$specname0\" target=\"_top\">\n";
        }

        if ($mode eq 'mbgd') {
            @list = split(/,/, $list);
            print "<FONT color=\"$col{'2'}\"><i>"     if ($isGenome{$rank});
            print "<b>$specname</b>";
            print "</i></FONT>"                       if ($isGenome{$rank});
            print "</A>" if (! MbgdUserGenomeCommon::isUserGenome($list));
            if ($isGenome{$rank}) {
                print "</span>";
            }
        }
        else {
            print "<FONT color=\"$col{$status}\"><i>" if ($isGenome{$rank});
            print "<b>$specname</b>";
            print " [$lev]"                           if (! $isGenome{$rank});
            print "</i></FONT>"                       if ($isGenome{$rank});
            print "</A>";
        }
        print "\n";
        if (($mode eq 'mbgd') && $div) {
            if (! $isGenome{$rank}) {
                $cntSpec  = scalar(split(",", $list));
                $cntEnd   = $cntStart + $cntSpec;
                print "<FONT SIZE=\"-1\">";
                print "<INPUT TYPE=\"button\" VALUE=\"ON\" Class=\"button\" onClick=\"selectAll(document,$cntStart,$cntEnd,true)\">\n";
                print "<INPUT TYPE=\"button\" VALUE=\"OFF\" Class=\"button\" onClick=\"selectAll(document,$cntStart,$cntEnd,false)\">\n";
                print "</FONT>";
            }
        }

        $prevlev = $lev;
        $prevwlev = $wlev;
    }
    print "</UL>" x $prevwlev;

    print "</TD></tr></TABLE>\n";


    return;
}

###############################################################################
1;#
###############################################################################
