#!/usr/local/bin/perl


package Sequence::CodonTable;

@amino = (A, R, N, D, C, Q, E, G, H, I, L, K, M, F, P, S, T, W, Y, V);

sub new {
	my($class, $id) = @_;
	my($this) = {};
	bless $this, $class;
	$this->{id} = $id;
	$this;
}

sub trans {
	my($this, $cod, $id) = @_;
	$id = $this->{id} if (! $id);
	return $trans[$id]->{$cod};
}

sub revtrans {
	my($this, $aa, $id) = @_;
	$id = $this->{id} if (! $id);
	if (! $revtrans[$id]) {
		$revtrans[$id] = $this->create_revtrans($id);
	}
	return $revtrans[$id]->{$aa};
}

sub create_revtrans {
	my($this, $id) = @_;
	my($revtrans);
	$id = $this->{id} if (! $id);
	foreach $cod (keys %{$trans[$id]}) {
		push(@{$revtrans->{$trans[$id]->{$cod}}}, $cod);
	}
	$revtrans;
}

sub start {
	my($this, $cod, $id) = @_;
	$id = $this->{id} if (! $id);
	return $start[$id]->{$cod};
}

$name[1] = 'The Standard Code (transl_table=1)';
$trans[1] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'I',
'ATC' => 'I',
'CTA' => 'L',
'CTC' => 'L',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'L',
'GTG' => 'V',
'AAA' => 'K',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'L',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => '*',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => 'R',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => 'R',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => '*',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => '*',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[1] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => '-',
'ATC' => '-',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => 'M',
'GTG' => '-',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => '-',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => '-',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => 'M',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
$name[2] = 'The Vertebrate Mitochondrial Code (transl_table=2)';
$trans[2] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'M',
'ATC' => 'I',
'CTA' => 'L',
'CTC' => 'L',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'L',
'GTG' => 'V',
'AAA' => 'K',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'L',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => 'W',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => '*',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => '*',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => '*',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => '*',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[2] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => 'M',
'ATC' => 'M',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => '-',
'GTG' => 'M',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => 'M',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => '-',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => '-',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
$name[3] = 'The Yeast Mitochondrial Code (transl_table=3)';
$trans[3] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'M',
'ATC' => 'I',
'CTA' => 'T',
'CTC' => 'T',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'T',
'GTG' => 'V',
'AAA' => 'K',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'T',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => 'W',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => 'R',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => 'R',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => '*',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => '*',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[3] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => '-',
'ATC' => '-',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => '-',
'GTG' => '-',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => '-',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => '-',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => '-',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
$name[4] = 'The Mold, Protozoan, and Coelenterate Mitochondrial Code and the Mycoplasma/Spiroplasma Code (transl_table=4)';
$trans[4] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'I',
'ATC' => 'I',
'CTA' => 'L',
'CTC' => 'L',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'L',
'GTG' => 'V',
'AAA' => 'K',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'L',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => 'W',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => 'R',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => 'R',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => '*',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => '*',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[4] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => 'M',
'ATC' => 'M',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => 'M',
'GTG' => 'M',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => 'M',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => 'M',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => 'M',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
$name[5] = 'The Invertebrate Mitochondrial Code (transl_table=5)';
$trans[5] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'M',
'ATC' => 'I',
'CTA' => 'L',
'CTC' => 'L',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'L',
'GTG' => 'V',
'AAA' => 'K',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'L',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => 'W',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => 'S',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => 'S',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => '*',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => '*',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[5] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => 'M',
'ATC' => 'M',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => '-',
'GTG' => 'M',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => 'M',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => '-',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => 'M',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
$name[6] = 'The Ciliate, Dasycladacean and Hexamita Nuclear Code (transl_table=6)';
$trans[6] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'I',
'ATC' => 'I',
'CTA' => 'L',
'CTC' => 'L',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'L',
'GTG' => 'V',
'AAA' => 'K',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'L',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => '*',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => 'R',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => 'R',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => 'Q',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => 'Q',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[6] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => '-',
'ATC' => '-',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => '-',
'GTG' => '-',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => '-',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => '-',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => '-',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
$name[9] = 'The Echinoderm Mitochondrial Code (transl_table=9)';
$trans[9] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'I',
'ATC' => 'I',
'CTA' => 'L',
'CTC' => 'L',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'L',
'GTG' => 'V',
'AAA' => 'N',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'L',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => 'W',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => 'S',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => 'S',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => '*',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => '*',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[9] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => '-',
'ATC' => '-',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => '-',
'GTG' => '-',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => '-',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => '-',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => '-',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
$name[10] = 'The Euplotid Nuclear Code (transl_table=10)';
$trans[10] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'I',
'ATC' => 'I',
'CTA' => 'L',
'CTC' => 'L',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'L',
'GTG' => 'V',
'AAA' => 'K',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'L',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => 'C',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => 'R',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => 'R',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => '*',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => '*',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[10] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => '-',
'ATC' => '-',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => '-',
'GTG' => '-',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => '-',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => '-',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => '-',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
$name[11] = 'The Bacterial "Code" (transl_table=11)';
$trans[11] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'I',
'ATC' => 'I',
'CTA' => 'L',
'CTC' => 'L',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'L',
'GTG' => 'V',
'AAA' => 'K',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'L',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => '*',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => 'R',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => 'R',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => '*',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => '*',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[11] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => 'M',
'ATC' => 'M',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => 'M',
'GTG' => 'M',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => 'M',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => '-',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => 'M',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
$name[12] = 'The Alternative Yeast Nuclear Code (transl_table=12)';
$trans[12] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'I',
'ATC' => 'I',
'CTA' => 'L',
'CTC' => 'L',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'S',
'GTG' => 'V',
'AAA' => 'K',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'L',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => '*',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => 'R',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => 'R',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => '*',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => '*',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[12] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => '-',
'ATC' => '-',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => 'M',
'GTG' => '-',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => '-',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => '-',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => '-',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
$name[13] = 'The Ascidian Mitochondrial Code (transl_table=13)';
$trans[13] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'M',
'ATC' => 'I',
'CTA' => 'L',
'CTC' => 'L',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'L',
'GTG' => 'V',
'AAA' => 'K',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'L',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => 'W',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => 'G',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => 'G',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => '*',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => '*',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[13] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => '-',
'ATC' => '-',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => '-',
'GTG' => '-',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => '-',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => '-',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => '-',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
$name[14] = 'The Flatworm Mitochondrial Code (transl_table=14)';
$trans[14] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'I',
'ATC' => 'I',
'CTA' => 'L',
'CTC' => 'L',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'L',
'GTG' => 'V',
'AAA' => 'N',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'L',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => 'W',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => 'S',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => 'S',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => 'Y',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => '*',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[14] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => '-',
'ATC' => '-',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => '-',
'GTG' => '-',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => '-',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => '-',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => '-',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
$name[15] = 'Blepharisma Nuclear Code (transl_table=15)';
$trans[15] = {
'GGT' => 'G',
'TAT' => 'Y',
'ATA' => 'I',
'ATC' => 'I',
'CTA' => 'L',
'CTC' => 'L',
'GTA' => 'V',
'ATG' => 'M',
'GTC' => 'V',
'CTG' => 'L',
'GTG' => 'V',
'AAA' => 'K',
'AAC' => 'N',
'CAA' => 'Q',
'CAC' => 'H',
'GAA' => 'E',
'AAG' => 'K',
'ATT' => 'I',
'GAC' => 'D',
'CTT' => 'L',
'CAG' => 'Q',
'GAG' => 'E',
'GTT' => 'V',
'AAT' => 'N',
'TCA' => 'S',
'CAT' => 'H',
'TCC' => 'S',
'GAT' => 'D',
'TGA' => '*',
'TGC' => 'C',
'TCG' => 'S',
'TGG' => 'W',
'TCT' => 'S',
'TGT' => 'C',
'ACA' => 'T',
'CCA' => 'P',
'ACC' => 'T',
'CCC' => 'P',
'TTA' => 'L',
'AGA' => 'R',
'CGA' => 'R',
'TTC' => 'F',
'ACG' => 'T',
'AGC' => 'S',
'GCA' => 'A',
'CGC' => 'R',
'CCG' => 'P',
'GCC' => 'A',
'TTG' => 'L',
'AGG' => 'R',
'GGA' => 'G',
'CGG' => 'R',
'GCG' => 'A',
'GGC' => 'G',
'GGG' => 'G',
'TAA' => '*',
'TAC' => 'Y',
'ACT' => 'T',
'CCT' => 'P',
'TTT' => 'F',
'TAG' => 'Q',
'AGT' => 'S',
'CGT' => 'R',
'GCT' => 'A',
};
$start[15] = {
'GGT' => '-',
'TAT' => '-',
'ATA' => '-',
'ATC' => '-',
'CTA' => '-',
'CTC' => '-',
'GTA' => '-',
'ATG' => 'M',
'GTC' => '-',
'CTG' => '-',
'GTG' => '-',
'AAA' => '-',
'AAC' => '-',
'CAA' => '-',
'CAC' => '-',
'GAA' => '-',
'AAG' => '-',
'ATT' => '-',
'GAC' => '-',
'CTT' => '-',
'CAG' => '-',
'GAG' => '-',
'GTT' => '-',
'AAT' => '-',
'TCA' => '-',
'CAT' => '-',
'TCC' => '-',
'GAT' => '-',
'TGA' => '-',
'TGC' => '-',
'TCG' => '-',
'TGG' => '-',
'TCT' => '-',
'TGT' => '-',
'ACA' => '-',
'CCA' => '-',
'ACC' => '-',
'CCC' => '-',
'TTA' => '-',
'AGA' => '-',
'CGA' => '-',
'TTC' => '-',
'ACG' => '-',
'AGC' => '-',
'GCA' => '-',
'CGC' => '-',
'CCG' => '-',
'GCC' => '-',
'TTG' => '-',
'AGG' => '-',
'GGA' => '-',
'CGG' => '-',
'GCG' => '-',
'GGC' => '-',
'GGG' => '-',
'TAA' => '-',
'TAC' => '-',
'ACT' => '-',
'CCT' => '-',
'TTT' => '-',
'TAG' => '-',
'AGT' => '-',
'CGT' => '-',
'GCT' => '-',
};
