#!/usr/bin/perl -s
use strict;

package UserScriptParams;

###############################################################################
sub new {
    my($class) = shift;
    my($self) = {};

    bless($self, $class);
    $self->_init();

    return $self;
}

###############################################################################
#
sub _init {
    my($self) = shift;

    $self->clear();

    return;
}

###############################################################################
#
sub clear {
    my($self) = shift;

    $self->{'DESCRIPTION'} = '';
    $self->{'KEY_LIST'} = [];
    $self->{'PARAM_LIST'} = [];
    $self->{'PARAM_HASH'} = {};

    return;
}

###############################################################################
#
sub set_description {
    my($self) = shift;
    my($descr) = shift;

    $self->{'DESCRIPTION'} = $descr;

    return;
}

###############################################################################
#
sub get_description {
    my($self) = shift;

    return $self->{'DESCRIPTION'};
}

###############################################################################
#
sub add_param {
    my($self) = shift;
    my($key) = shift;
    my($default) = shift;
    my($require) = shift;
    my($explain) = shift;
    my($example) = shift;

    #
    my($param) = {};
    $param->{'KEY'}     = $key;
    $param->{'DEFAULT'} = $default;
    $param->{'REQUIRE'} = $require;
    $param->{'EXPLAIN'} = $explain;
    $param->{'EXAMPLE'} = $example;

    #
    if (exists($self->{'PARAM_HASH'}->{"$key"})) {
        print STDERR "ERROR :: Already exists. KEY='$key'\n";
        return;
    }
    push(@{$self->{'KEY_LIST'}}, $key);
    push(@{$self->{'PARAM_LIST'}}, $param);
    $self->{'PARAM_HASH'}->{"$key"} = $param;

    return;
}

###############################################################################
#
sub get_key_list {
    my($self) = shift;

    return @{$self->{'KEY_LIST'}};
}

###############################################################################
#
sub get_param_attr {
    my($self) = shift;
    my($key) = shift;
    my($attr) = shift;

    #
    my($param) = $self->{'PARAM_HASH'}->{"$key"};

    return $param->{"$attr"};
}

###############################################################################
#
sub get_default {
    my($self) = shift;
    my($key) = shift;

    my($attr) = 'DEFAULT';

    return $self->get_param_attr($key, $attr);
}

###############################################################################
#
sub get_example {
    my($self) = shift;
    my($key) = shift;

    my($attr) = 'EXAMPLE';

    return $self->get_param_attr($key, $attr);
}

###############################################################################
#
sub string_options {
    my($self) = shift;

    #
    my($str_opt) = '';
    my($descr) = '';
    foreach my$param (@{$self->{'PARAM_LIST'}}) {
        if ($param->{'REQUIRE'} !~ /^T$/i) {
           $str_opt .= "[";
        }
        $str_opt .= '-' . $param->{'KEY'};
        if ($param->{'EXAMPLE'} !~ /^\s*$/) {
           $str_opt .= "='" . $param->{'EXAMPLE'} . "'";
        }
        if ($param->{'REQUIRE'} !~ /^T$/i) {
           $str_opt .= "]";
        }
        $str_opt .= " ";

        #
        $descr .= "    " .  $param->{'KEY'} .  " : " . $param->{'EXPLAIN'};
        if ($param->{'DEFAULT'} !~ /^\s*$/) {
           $descr .= ' [default : ' . $param->{'DEFAULT'} . ']';
        }
        $descr .= "\n";
    }
    $str_opt .= "\n";

    #
    $str_opt .= $self->{'DESCRIPTION'} . "\n";
    $str_opt .= $descr;

    return $str_opt;
}

###############################################################################
#
sub string_usage {
    my($self) = shift;

    my($str_usage) = "Usage :: $0 ";
    $str_usage .= $self->string_options();

    return $str_usage;
}

###############################################################################
#
sub print_usage {
    my($self) = shift;

    print $self->string_usage();

    return;
}

###############################################################################
#
sub string_params {
    my($self) = shift;

    my($str_params) = '';
    foreach my$param (@{$self->{'PARAM_LIST'}}) {
        $str_params .= $param->{'KEY'};
        if ($param->{'EXAMPLE'} !~ /^\s*$/) {
           $str_params .= "=" . $param->{'EXAMPLE'};
        }
        if ($param->{'DEFAULT'} !~ /^\s*$/) {
           $str_params .= " [DEFAULT:" . $param->{'DEFAULT'} . "]";
        }
        $str_params .= "\n";
    }

    return $str_params;
}

###############################################################################
1;#
###############################################################################
