#!/usr/local/bin/perl -s

use DBI;
use MBGD;
require 'MBGD_Conf.pl';

$COLOR_SELECTED = 2;
$COLOR_ORTHOLOG = 1;
$COLOR_PARALOG = 5;

sub plot {
	foreach $d (@data) {
		($x, $y, $col) = @{$d};
		if ($col ne '') {
			pgsci($col);
		}
		pgline(2, $x, $y);
	}
	pgsci(1);
}

sub print_gene {
	local($ypos1) = $miny + ($maxy - $miny ) * .07;
	local($ypos2) = $miny + ($maxy - $miny ) * .05;
	local($ytxtpos1) = $miny + ($maxy - $miny ) * .08;
	local($ytxtpos2) = $miny + ($maxy - $miny ) * .03;
	local($xpos1) = $minx + ($maxx - $minx ) * .07;
	local($xpos2) = $minx + ($maxx - $minx ) * .05;
	local($xtxtpos1) = $minx + ($maxx - $minx ) * .09;
	local($xtxtpos2) = $minx + ($maxx - $minx ) * .04;
	pgsci(1);
	pgslw(1);
	pgsch(0.65);
	pgsah(1,60,0.2);
	for ($i = 0; $i < $Gn1; $i++) {
		($from,$to,$dir,$color,$gname) = split(/:/, $GENE1->[$i]);
		next if ($to < $minx); next if ($from > $maxx);
		pgsci($color);
		if ($dir > 0) {
			pgarro($from,$ypos1,$to,$ypos1);
			if ($gnameout && $from > $minx && $to < $maxx ) {
				pgptxt(($to+$from)/2,$ytxtpos1,0.0,0.5,$gname);
			}
		} else {
			pgarro($to,$ypos2,$from,$ypos2);
			if ($gnameout && $from > $minx && $to < $maxx ) {
				pgptxt(($to+$from)/2,$ytxtpos2,0.0,0.5,$gname);
			}
		}
	}
	for ($i = 0; $i < $Gn2; $i++) {
		($from,$to,$dir,$color,$gname) = split(/:/, $GENE2->[$i]);
		next if ($to < $miny); next if ($from > $maxy);
		pgsci($color);
		if ($dir > 0) {
			pgarro($xpos1,$from,$xpos1,$to);
			if ($gnameout && $from > $miny && $to < $maxy ) {
				pgptxt($xtxtpos1,($to+$from)/2,90.0,0.5,$gname);
			}
		} else {
			pgarro($xpos2,$to,$xpos2,$from);
			if ($gnameout && $from > $miny && $to < $maxy ) {
				pgptxt($xtxtpos2,($to+$from)/2,90.0,0.5,$gname);
			}
		}
	}
	pgslw(1);
	pgsch(1);
}
sub print_rep {
	local($ypos) = $miny + ($maxy - $miny) * .003;
	local($xpos) = $minx + ($maxx - $minx ) * .003;
#	local($ypos) = $miny + ($maxy - $miny) * .06;
#	local($xpos) = $minx + ($maxx - $minx ) * .06;

#	pgsci(4);
	pgsci(2);
	pgslw(5);
#	pgsch(1);
#	pgsah(2,80,0.8);
	for ($i = 0; $i < $Rp1; $i++) {
		($from,$to) = split(/:/, $REP1[$i]);
		next if ($to < $minx); next if ($from > $maxx);
		pgmove($from,$ypos);
		pgdraw($to,$ypos);
	}
	for ($i = 0; $i < $Rp2; $i++) {
		($from,$to) = split(/:/, $REP2[$i]);
		next if ($to < $miny); next if ($from > $maxy);
		pgmove($xpos, $from);
		pgdraw($xpos, $to);
	}
	pgslw(1);
}

sub plotout {
	pgenv($minx, $maxx, $miny, $maxy, 1, 0);
	pglabel($XLAB, $YLAB, $TITLE);
	print "$minx,$maxx,$miny,$maxy\n";
	&plot;
	&print_gene;
	&print_rep;
}

sub read_chromosome {
	my($sp, $seq) = @_;
	$seq = 'chromosome' if (! $seq);
	my $sth = $db->prepare("select d.length from chromosome c, dnaseq d ".
			"where c.seq=d.id and sp='$sp' and name='$seq'");
	$sth->execute;
	($length) = $sth->fetchrow_array;
	return $length;
}
sub readgene {
	my($tab, $sp) = @_;
	my $color = 1;
	my ($Gn, $GENE, $Gnames);
	my($sql);
	$Gnames = {};
	$sql = "select g.name,from1,to1,dir,funccat,seqno from $tab g, chromosome c where g.sp=c.sp and g.sp='$sp' and g.chrid=c.id";
	my $sth = $db->prepare($sql);
	$sth->execute;
	while (my($name,$from,$to,$dir,$funccat,$seqno) = $sth->fetchrow_array) {
#		$GENE->[$Gn] = "$from:$to:$dir:$color:$name";
		$GENE->[$Gn] = "$from:$to:$dir:$funccat:$name:$seqno";
		$name =~ tr/a-z/A-Z/;
		$Gnames->{$name} = $Gn;
		$Gn++;
	}
	return ($GENE, $Gnames, $Gn);
}

sub read_data {
	my($sp1,$sp2) = @_;
#	my $sth = $db->prepare("select name1,from1,to1,name2,from2,to2,score " .
#		"from homology where sp1='$sp1' and sp2='$sp2'");
#	$sth->execute;
#print STDERR "OK\n";
#	while (($name1,$from1,$to1,$name2,$from2,$to2,$score)
#			= $sth->fetchrow_array) {

	open(F, "$DIR_www/bin/select.pl -SPEC=$sp1,$sp2 -noparacheck|")
		|| die "Can't open $DIR_www/bin/select.pl\n";
	while (<F>) {
		($name1,$name2,$from1,$to1,$from2,$to2,$pam,$score) = split;
		($sp01,$name1) = split(/:/,$name1);
		($sp02,$name2) = split(/:/,$name2);
		if ($sp01 ne $sp1) {
			$tmp = $name1; $name1 = $name2; $name2 = $tmp;
			$tmp = $from1; $from1 = $from2; $from2 = $tmp;
			$tmp = $to1; $to1 = $to2; $to2 = $tmp;
		}
		$name1 =~ tr/a-z/A-Z/; $name2 =~ tr/a-z/A-Z/;
		($gfrom1,$gto1,$dir1) = split(/:/,$GENE1->[$Gnames1->{$name1}]);
		($gfrom2,$gto2,$dir2) = split(/:/,$GENE2->[$Gnames2->{$name2}]);
#if ($gfrom1 < 1000 && $gfrom2 < 1000){
#print STDERR "*****$name1,$gfrom1,$gto1\n";
#}
#if ($gfrom2 < 1000 && $gto2 < 1000){
#print STDERR "*****$name2,$gfrom2,$gto2n";
#}

		if ($dir1 < 0) {
			$from1 = $gto1 - ($from1-1) * 3;
			$to1 = $gto1 - $to1 * 3;
		} else {
			$from1 = $gfrom1 + ($from1-1) * 3;
			$to1 = $gfrom1 + $to1 * 3;
		}
		next if ($to1 < $minx || $from1 > $maxx);

		if ($dir2 < 0) {
			$from2 = $gto2 - ($from2-1) * 3;
			$to2 = $gto2 - $to2 * 3;
		} else {
			$from2 = $gfrom2 + ($from2-1) * 3;
			$to2 = $gfrom2 + $to2 * 3;
		}
		next if ($to2 < $miny || $from2 > $maxy);

		if ($clusttab) {
			my $clid;
			if (($clid=$clusttab->{$sp1}->{$name1}) &&
				$clusttab->{$sp1}->{$name1}
					== $clusttab->{$sp2}->{$name2}) {
				$col = $COLOR_ORTHOLOG;
				if ($selected && $selected->{$clid}) {
					$col = $COLOR_SELECTED;
				} else {
					$col = $COLOR_ORTHOLOG;
				}
#			} elsif ($clusttab->{$sp1}->{$name1} &&
#					! $clusttab->{$sp2}->{$name2}) {
#				$col = 5;
#			} elsif (! $clusttab->{$sp1}->{$name1} &&
#					$clusttab->{$sp2}->{$name2}) {
#				$col = 3;
			} else {
				$col = $COLOR_PARALOG;
			}
		} else {
			$col = $COLOR_ORTHOLOG;
		}
		push(@data, [[$from1, $to1], [$from2, $to2], $col]);
	}
}
sub read_clusttab {
	my($sp1,$sp2,$tabid,$opt) = @_;
	my($clusttab) = {};
	my($selected) = {};

    my($dbname) = $DBNAME_TMP;
    ($dbname) = ($ENV{'MYSQL_DBTMP'} =~ /\:?([^\:]+)$/) if ($ENV{'MYSQL_DBTMP'});
	my $sql = "select sp,name,clustid from $dbname.cluster_$tabid where sp in ('$sp1','$sp2')";
	my $sth = $db->prepare($sql);
	$sth->execute;
	while (my ($sp,$name,$clustid) = $sth->fetchrow_array) {
		$clusttab->{$sp}->{$name} = $clustid;
	}

	if ($opt->{phylopat}) {
		$opt->{mismatch} = 0 if (! $opt->{mismatch});
		$sql = "select clustid from ${DBNAME_TMP}.clusttab_$tabid";
		$sql .= " where mismatch(phylopat, '$opt->{phylopat}', $opt->{mismatch})";
#print STDERR ">>SQL>$sql\n";
		$sth = $db->prepare($sql); $sth->execute;
		while (my ($clustid) = $sth->fetchrow_array) {
			$selected->{$clustid} = 1;
		}
	}

#	my $sth = $db->prepare("select sp,name,clustid " .
#		"from mbgd_tmp.cluster_$tabid");
#	$sth->execute;
#	while (my ($sp,$name,$clustid) = $sth->fetchrow_array) {
#		$clustsiz{$clustid}->{$sp} = 1;
#	}

	($clusttab, $selected);
}
sub legend {
	pgsci(1);
	pgsci($COLOR_ORTHOLOG);
	pgmtxt(R,1,1,1,"orthologous");
#	pgsci(5);
#	pgmtxt(R,2,1,1,"duplicated in $sp1");
#	pgsci(3);
#	pgmtxt(R,3,1,1,"duplicated in $sp2");
	pgsci(4);
	pgsci($COLOR_PARALOG);
	pgmtxt(R,2,1,1,"paralogous");
	pgsci($COLOR_SELECTED);
	pgmtxt(R,3,1,1,"selected orthologs");
#	pgmtxt(R,5,1,1,"highly repetitive");
#	pgsci(1);
}

1;

