#!/usr/local/bin/perl
use MBGD;
use FileHandle;
use MBGD::FuncCat;
use MBGD::FunctionCategory;
require "MBGD_Conf.pl";
$UNKNOWN = 100;

###############################################################################
#
sub get_func_category {
	my($ent) = @_;
    my($filename);
	my($sp, $orf) = split(/:/, $ent);
	my($orfname);

    #
	$filename = "$main::DIR_database/class/$sp.class";
	if (! $FuncCategory{$sp}) {
		if (! open(FuncCategory, "$filename")) {
			$FuncCategory{$sp} = {};
		} else {
			while (<FuncCategory>) {
				($cl, $orfname) = split;
				$FuncCategory{$sp}->{$orfname} = $cl;
			}
			close(FuncCategory);
		}
	}
	return $FuncCategory{$sp}->{$orf};
}

###############################################################################
#
sub get_func_color {
	my($sp, $class) = @_;
	my($cid) = &get_func_color_id($sp,$class);
	&get_func_color_from_id($cid);
}

###############################################################################
#
sub get_func_color_from_id {
	my($cid) = @_;
	&create_color if (! @COLOR);
#	return ("ffffff") if ($cid == $UNKNOWN);	## function unassigned;
	return ("ffffcf") if ($cid == $UNKNOWN);	## function unassigned;
	return ($COLOR[$cid-1]);
}

###############################################################################
#
sub get_func_color_id {
	my($sp, $class) = @_;
	my(@class) = split(/\./,$class);
	my($colnum);
	my($cl, $cl2, $cl3);

	$cl = "$class[0]";
	$cl2 = "$class[0].$class[1]" if ($class[1]);
	$cl3 = "$class[0].$class[1].$class[2]" if ($class[1] && $class[2]);

	if (! %ColorTab) {
		%ColorTab = &create_colortab;
	}
	if ($cl3 && $ColorTab{$sp,$cl3}) {
		$colnum = $ColorTab{$sp,$cl3};
	} elsif ($cl2 && $ColorTab{$sp,$cl2}) {
		$colnum = $ColorTab{$sp,$cl2};
	} elsif ($cl && $ColorTab{$sp,$cl}) {
		$colnum = $ColorTab{$sp,$cl};
	} else {
		$colnum = $UNKNOWN;
	}
	return $colnum;
}

###############################################################################
#
sub create_colortab {
	my(%ColorTab);
	my($i, $name, $category, $s, $c, $c0, $cat);
        my($filename);
        local(*COLORTAB);

        $filename = "$main::DIR_database/class/colortab.category";
	open(COLORTAB, "$filename") || die "Can't open $filename";
	LOOP:while (<COLORTAB>) {
		chop;
		($name, $color, $category) = split(/\t/);
		push(@COLOR, $color);
		++$i;
		foreach $cat (split(/ /, $category)) {
			($s,$c0) = split(/:/, $cat);
			foreach $c (split(/,/, $c0)) {
				$ColorTab{$s,$c} = $i;
			}
		}
	}
	close(COLORTAB);
	return %ColorTab;
}

###############################################################################
#
sub create_color {
        my($filename);
        local(*COLORTAB);

        $filename = "$main::DIR_database/class/colortab.category";
	open(COLORTAB, "$filename") || die "Can't open $filename";
	while (<COLORTAB>) {
		($name, $color, $category) = split(/\t/);
		push(@COLOR, $color);
	}
	close(COLORTAB);
}
sub create_color_hash {
        my($filename);
        local(*COLORTAB);

        $filename = "$main::DIR_database/class/colortab.category";
	open(COLORTAB, "$filename") || die "Can't open $filename";
	while (<COLORTAB>) {
		my($name, $color, $category) = split(/\t/);
		$Colors{$name} = $color;
		push(@Names, $name);
	}
	close(COLORTAB);
	(\%Colors, \@Names);
}

###############################################################################
#
###sub create_color {
###	my($r,$g,$b,$R,$G,$B);
###	push(@COLOR, '');
###	foreach $r (3,4,2) {
###		foreach $g (2..4) {
###			foreach $b (2..4) {
###				$R = sprintf("%02x", int(255 * $r/4));
###				$G = sprintf("%02x", int(255 * $g/4));
###				$B = sprintf("%02x", int(255 * $b/4));
###				push(@COLOR, "#$R$G$B");
###			}
###		}
###	}
###}

###############################################################################
#
sub print_rev_colortab {
        my($filename);
        local(*COLORTAB);

        $filename = "$main::DIR_database/class/colortab.category";
	open(COLORTAB, "$filename") || die "Can't open $filename";
	while (<COLORTAB>) {
		($name, $color, $category) = split(/\t/);
		push(@COLOR, $color);
		++$i;
		foreach $cat (split(/ /, $category)) {
			($s,$c0) = split(/:/, $cat);
			foreach $c (split(/,/, $c0)) {
				$ColorTab{$s,$i} = $c;
			}
		}
	}
}

###############################################################################
#
sub get_class_info {
    my($org, $num) = @_;
    my($classInfo);
    my $fname;
    local(*FILE, $_);

    #
    $fname = "$DIR_database/class/$org.cl";
    open(FILE, "< $fname") || return('');
    while(<FILE>) {
	if(/^\s*$num[\s\t]+(\S.+)$/) {
	    $classInfo = $1;
	    $classInfo =~ s|//|;|g;
	    last;
	}
    }
    close(FILE);

    return($classInfo);
}

###############################################################################
#
sub getColortabCategory {
    my($ref) = shift;
    my($sp) = shift;
    my($level) = shift;

    my(@lev) = split(/\./, $level);
    my($lev1) = $lev[0];
    my($lev2) = $lev1 . $lev[1];
    my($lev3) = $lev2 . $lev[2];

    foreach my$l ($lev3, $lev2, $lev1) {
        if ($ref->{'splev2func'}->{"$sp"}->{"$l"}) {
            return $ref->{'splev2func'}->{"$sp"}->{"$l"};
        }
    }
    return {};
}

###############################################################################
#
sub parseColortabCategory {
    my($filename) = shift;
    my($fh);
    my($line);

    #
    my($ref) = {};
    $ref->{'name2func'} = {};
    $ref->{'splev2func'} = {};

    #
    $fh = new FileHandle("$filename") || die("Can not open $filename($!)");
    while($line = $fh->getline()) {
        next if ($line =~ /^\s*$/);
        next if ($line =~ /^\s*#/);

        $line =~ s#[\r\n]*$##;

        my($funcName, $color, $spLevList) = split(/\t/, $line);
        $funcName =~ s#^\s*##; $funcName =~ s#\s*$##;

        #
        my($entFunction) = {};
        $entFunction->{'FUNC_NAME'} = $funcName;
        $entFunction->{'COLOR'} = $color;
        $entFunction->{'SPEC'} = {};

        # FunctionName $B$+$i(B Function $B$r<hF@2DG=$H$9$k(B
        $ref->{'name2func'}->{"$funcName"} = $entFunction;

        #
        foreach my$spLev (split(/\s/, $spLevList)) {
            my($sp, $levList) = split(/:/, $spLev);
            foreach my$lev (split(/,/, $levList)) {
                $entFunction->{'SPEC'}->{"$sp"}->{"$lev"} = 1;

                # SP + Level $B$+$i(B Function $B$r<hF@2DG=$H$9$k(B
                $ref->{'splev2func'}->{"$sp"}->{"$lev"} = $entFunction;
            }
        }
    }
    $fh->close();

    return $ref;
}

###############################################################################
#
sub getFunction {
    my($dbname) = shift;
    my($funcDbname) = shift;

    my($db) = new MBGD::DB($dbname);
    my($tab) = "function";
    my($opt) = {};
    $opt->{'columns'} = "*";
    $opt->{'where'} = "dbname='$funcDbname'";
    my($res) = $db->select_fetch($tab, $opt);
    foreach my$ent (@{$res->{'INFO'}}) {
        my($funcId)   = $ent->{'fid'};
        my($funcName) = $ent->{'funcname'};
        $ref->{'id2name'}->{"$funcId"}   = $funcName;
        $ref->{'name2id'}->{"$funcName"} = $funcId;
    }

    return $ref;
}

###############################################################################
#
sub get_color_rank {
    my($cntColor_ref) = shift;

    my(@rank_color) = sort {$cntColor_ref->{$b}<=>$cntColor_ref->{$a}} keys(%{$cntColor_ref});

    return @rank_color;
}

###############################################################################
#
sub print_cluster_func {
    my($dbFunc) = shift;
    my($cntColor_ref) = shift;
    my($cluster_id) = shift;
    my($subcluster_id) = shift;
    my($opt) = shift;

    # $B5!G=$N=E$_IU$1$GJB$SBX$((B
    my(@rank_color) = get_color_rank($cntColor_ref);
    my($is_best) = 1;
    foreach my$c (@rank_color) {
        next if (($cntColor_ref->{$c} == 0) && ($is_best == 0));

        print $cluster_id,         "\t";
        print $subcluster_id,      "\t" if ($opt->{'SUBCLUST'});
        print $dbFunc,             "\t";
        print $c,                  "\t";
        print $cntColor_ref->{$c}, "\t";
        print $is_best,            "\n";
        $is_best = 0;
    }

    return;
}

###############################################################################
#
sub cluster_func {
    my($refFuncCategory) = shift;
    my(@spname_list) = @_;

    my(%n_para);
    foreach my$spname (@spname_list) {
        my($sp, $name) = split(/\:/, $spname);
        $n_para{"$sp"}++;
    }

    #
    my($colorDefault) = $refFuncCategory->getDefaultColorLevel();

    #
    my($cntColor_ref) = {};
    foreach my$spname (@spname_list) {
        my($sp, $name) = split(/\:/, $spname);

        my($n_para) = $n_para{"$sp"};
        my($refFuncList) = $refFuncCategory->getFunctionListBySporf($spname);
        my($nFuncList)   = $refFuncCategory->countFunctionListBySporf($spname);
        foreach my$refFunc (@{$refFuncList}) {
            my($colid) = $refFunc->{'LEVEL'};

            next if (!$colid);
            next if ($colid eq $colorDefault);

            # $B$R$H$D$N(B Gene $B$KJ#?t$N5!G=$,3d$jEv$F$i$l$F$$$k>l9g!"=E$_$E$1$rEyJ,$9$k(B
            $cntColor_ref->{"$colid"} += (1 / $nFuncList / $n_para);
        }
    }

    return $cntColor_ref;
}

###############################################################################
#
sub cluster_func_dbtype {
    my($dbFunc) = shift;
    my($file_in) = shift;
    my($ext) = shift;
    my($opt) = shift;

    $file_in = '-' if (!$file_in);
    my($Hclnum) = 2;
    if (0 < $opt->{'Hclnum'}) {
        $Hclnum = $opt->{'Hclnum'};
    }
    my($is_orig) = 1;
    if ($ext =~ /^all$/i) {
        $is_orig = 0;
    }

    $main::DIR_database = "$ENV{'MBGD_HOME'}/database.work" if ($main::UPD);
    my($refFuncCategory) = MBGD::FunctionCategory->new($dbFunc, "$main::DIR_database/function", $is_orig);
    my($colorDefault) = $refFuncCategory->getDefaultColorLevel();

    #
    my($prev_clustid);
    my($cntColorAll_ref);
    my(@species);
    my($fh) = FileHandle->new("$file_in") || die("Can not open $file_in($!)");
    while ($_ = $fh->getline()) {
        if (/^#/) {
            if (/SPEC=(\S+)/) {
                my($specstr) = $1;
                @species = split(/,/, $specstr);
            }
            next;
        }

        s#[\r\n]*$##;

        my(@data) = split(/\t/, $_, -1);

        my($cluster_id)    = shift(@data);
        my($subcluster_id) = shift(@data) if ($opt->{'SUBCLUST'});
        my($homcluster_id) = shift(@data);
        my($num_spec)      = shift(@data);
        my(@names)         = @data;

        if ($prev_clustid != $cluster_id) {
            print_cluster_func($dbFunc, $cntColorAll_ref, $prev_clustid, '', $opt);

            $cntColorAll_ref = {};
            $cntColorAll_ref->{"$colorDefault"} = 0;
        }

        #
        my($cntColor_ref) = {};
        $cntColor_ref->{"$colorDefault"} = 0;

        #
        my($idx_spec) = 0;
        my(@spname_list);
        foreach my$nm (@names) {
            my($sp0) = $species[$idx_spec++];
            my(@ent_list) = split(/ /, $nm);
            foreach my$ent (@ent_list) {
                $ent =~ s/\(\d+\)//; # $B%I%a%$%s>pJs$r:o=|(B
                if ($ent !~ /\:/) {
                    $ent = "$sp0:$ent";
                }
                push(@spname_list, $ent);
            }
        }
        my($cntColor_ref) = cluster_func($refFuncCategory, @spname_list);
        print_cluster_func($dbFunc, $cntColor_ref, $cluster_id, $subcluster_id, $opt);

        #
        foreach my$k (keys(%{$cntColor_ref})) {
            my($v) = $cntColor_ref->{"$k"};
            $cntColorAll_ref->{"$k"} += $v;
        }

        #
        $prev_clustid = $cluster_id;
    }
    $fh->close();

    #
    print_cluster_func($dbFunc, $cntColorAll_ref, $prev_clustid, '', $opt);

    return;
}

###############################################################################
1;
###############################################################################
