#!/usr/bin/perl -s

use MBGD::Contig;
require 'libMBGDImg.pl';
require 'libMBGDaxes.pl';

sub get_gene_from_map {
	my($PositionX, $PositionY, $Organism, $Chromosome) = @_;
	$Chromosome = 1 if (! $Chromosome);
	my($Point) = &get_pos_from_map($PositionX, $PositionY, $Organism, $Chromosome);
	my($gene_num) = 0;
	my(@chr) = MBGD::Chromosome->find("sp='$Organism' and seqno=$Chromosome");
	$chrid = $chr[0]->{id};
	my(@genes) = MBGD::Gene->find("sp='$Organism' and chrid=$chrid",
				{order=>"from1"});
#	my(@genes) = MBGD::Gene->get($Organism, {order=>"from1"});
	foreach $g (@genes) {
		$gene_num++;
		if ($g->{to1} > $Point) {
			return ($g, $gene_num);
		}
	}
	return ($genes[$#genes], $genenum);
}
sub get_pos_from_map {
	my($PositionX, $PositionY, $Organism, $Chromosome, $db) = @_;
	my($Point);	## output

	if (! $db) {
		$db = MBGD::DB->new();
	}

    my($sp_euk_ref) = MBGD_SpecBySuperkingdom('Eukaryota');

	my($seqNo) = ($Chromosome ? $Chromosome : 1);
    if (exists($sp_euk_ref->{"$Organism"})) {
        $seqNo = &get_seqno_in_linear($PositionY);
	}
	my($opt) = {keys => "sp:seqno", with_length=>1};
	my($infoChr) = MBGD::Chromosome->get($db, ["$Organism:$seqNo"], $opt);
	my($ChrID) = $infoChr->{'id'};
	my($Length) = $infoChr->{'length'};
	my($Type) = $infoChr->{'type'};

        if (exists($sp_euk_ref->{"$Organism"})) {
            ($ChrID, $Point, $Length) = &get_pos_in_linear(
				$PositionX, $PositionY, $Organism);
        } elsif ($Type =~ /linear/i) {
		## linear genome
            $Point = &get_pos_in_whole_linear($PositionX, $PositionY, $Length);
            $RegStart = $Point - int( $RegWidth / 2 );
            if($RegStart < 1) {
                $RegStart = 1;
                $Point    = $RegStart + int($RegWidth / 2);
            }
            elsif($RegStart > $Length - $RegWidth) {
                $RegStart = $Length - $RegWidth;
                $Point    = $Length - int($RegWidth / 2);
            }
        } else {
		## circular genome
            $Point    = &get_pos_in_whole( $PositionX, $PositionY, $Length );
        }
	$Point;
}

###############################################################################
sub get_pos_in_whole {
    my( $pos_x, $pos_y, $width, $map_scale ) = @_;
    my( $center_x, $center_y, $radius_min, $radius_max ) =
         ( @MBGD_WHOLE_IMG_CENTER,
           $MBGD_WHOLE_IMG_INNER_R, $MBGD_WHOLE_IMG_OUTER_R );
    my( $radius, $diff_x, $diff_y, $angle );

    $map_scale = 1 if (! $map_scale);
    $center_x *= $map_scale; $center_y *= $map_scale;
    $radius_min *= $map_scale; $radius_max *= $map_scale;

    if( $center_y == $pos_y ) {
        $radius  = $pos_x - $center_x;
        if( $radius > 0 ) {
            $pos = int( $width / 4 );
        }
        else {
            $pos = int( $width * 3 / 4 );
            $radius *= -1;
        }
    }
    else {
        $diff_x = $center_y - $pos_y;
        $diff_y = $pos_x - $center_x;
        $radius = sqrt( $diff_x ** 2 + $diff_y ** 2 );

        if( $diff_y >= 0 ) {
            #  = atan2( 1, 1 ) * 4
            $pos = int(atan2($diff_y, $diff_x) * $width / (atan2(1, 1) * 8));
        }
        else {
            #  = atan2( 1, 1 ) * 4
            $pos = int((atan2($diff_y, $diff_x)+(atan2(1, 1)*8))*$width/(atan2(1, 1)*8));
        }
    }

    return $pos;
}

###############################################################################
#
sub get_pos_in_whole_linear {
    my($pos_x, $pos_y, $width, $map_scale) = @_;
    my($center_x, $center_y, $radius_min, $radius_max) =
         (@MBGD_WHOLE_IMG_CENTER,
          $MBGD_WHOLE_IMG_INNER_R, $MBGD_WHOLE_IMG_OUTER_R);
    my($radius, $diff_x, $diff_y, $angle);
    $map_scale = 1 if (! $map_scale);
    $center_x *= $map_scale; $center_y *= $map_scale;
    $radius_min *= $map_scale; $radius_max *= $map_scale;

    if($center_y == $pos_y) {
        $radius  = $pos_x - $center_x;
        if($radius > 0) {
            $pos = int($width / 4);
            $angle = atan2(1, 1) / 2;      #  / 2
        }
        else {
            $pos = int($width * 3 / 4);
            $radius *= -1;
            $angle = atan2(1, 1) * 3 / 4;  #  * 3 / 4
        }
    }
    else {
        $diff_x = $center_y - $pos_y;
        $diff_y = $pos_x - $center_x;
        $radius = sqrt($diff_x ** 2 + $diff_y ** 2);

        if($diff_y >= 0) {
            #  = atan2(1, 1) * 4
            $pos = int(atan2($diff_y, $diff_x) * $width / (atan2(1, 1) * 8));
            $angle = atan2($diff_y, $diff_x);
        }
        else {
            #  = atan2(1, 1 ) * 4
            $pos = int((atan2($diff_y, $diff_x)+(atan2(1, 1)*8))*$width/(atan2(1, 1)*8));
            $angle = atan2($diff_y, $diff_x) + atan2(1, 1) * 8;
        }
    }

    $pos = $width * $angle * 360 / ($MBGD_WHOLE_IMG_LINEAR_ARC * atan2(1, 1) * 8);
}

###############################################################################
#
sub get_pos_in_region {
    local( $pos_x, $pos_y, $from, $to ) = @_;
    local( $img_width, $img_height ) = @MBGD_REGION_IMG_SIZE;
    local( $click_point );

    $click_point = ( $to - $from + 1) * $pos_x /( $img_width ) + $from;

    int( $click_point );
}

###############################################################################
###sub _get_pos_in_linear {
###    my($pos_x, $seqLen, $width) = @_;
###    if($pos_x <= 150) {
###        $pos = 1;
###    } else {
###        $seqEnd = int(($seqLen / $width) * (600 - 150)) + 150;
###        if($pos_x > $seqEnd) {
###            $pos = $seqLen;
###        }
###        else {
###            $pos = (($pos_x - 150) / (600 - 150)) * $width;
###        }
###    }
###    return($pos);
###}
###
###############################################################################
# Get a base position of the clicked point on the linear genome
# input : clicked position (x, y), display width, organism name
# return: chromosome id, base position
sub get_pos_in_linear {
    my($pos_x, $pos_y, $org, $map_scale) = @_;
    my($seqNo);
    my($chrid);
    my($seqLen);

    $map_scale = 1 if (! $map_scale);
    my($posx_min, $posx_max) = (150, 600);
    $posx_max *= $map_scale;
    $pos_y /= $map_scale;

    $seqNo = &get_seqno_in_linear($pos_y);

    #
    my($seqMaxLen);
    my($opt) = {};
    $opt->{'keys'} = "sp";
    $opt->{'with_length'} = 1;
    my(@info_chr_list) = MBGD::Chromosome->get($db, ["$org"], $opt);
    foreach my$ref (@info_chr_list) {
        if ($seqMaxLen < $ref->{'length'}) {
            $seqMaxLen = $ref->{'length'};
        }
    }

    my($opt) = {};
    $opt->{'keys'} = "sp:seqno";
    $opt->{'with_length'} = 1;
    my($infoChr) = MBGD::Chromosome->get($db, ["$org:$seqNo"], $opt);
    $chrid = $infoChr->{'id'};
    $seqLen = $infoChr->{'length'};
    if($pos_x <= $posx_min) {
        $pos = 1;
    } else {
        $seqEnd = int(($seqLen / $seqMaxLen) * ($posx_max - $posx_min)) + $posx_min;
        if($pos_x > $seqEnd) {
            $pos = $seqLen;
        }
        else {
            $pos = (($pos_x - $posx_min) / ($posx_max - $posx_min)) * $seqMaxLen;
        }
    }
    return($chrid, $pos, $seqLen);
}
sub get_seqno_in_linear {
    my($pos_y) = @_;
    my($seqNo);

    if($pos_y <= 70) {
        $seqNo = 1;
    } else {
        $seqNo = int(($pos_y - 40) / 50) + 1;
    }
    $seqNo;
}
###############################################################################
$libMBGDImgMap::cgi_gene_info = 'MBGD_gene_info_frame.pl';
sub create_clickable_map
{
    my( $Organism, $chrid, $contigid, $Point, $RegWidth, $Dir, %opt ) = @_;
    my( @drawCmnds );
    my( @ImageMap, $ImageMap );
    my( $x1, $y1, $x2, $y2, $color, $gene, $font, $comment );
    my( $genename, $orfname, $work_gene, $work_orf );

    @drawCmnds = &MBGDImg_Layout( $Organism,
                                  $chrid,
                                  $contigid,
                                  $Point,
                                  $RegWidth,
				  {Reverse=>$Dir} );
    @drawCmnds = grep( /^\s*(string|rect)\s/, @drawCmnds );

    while ( scalar( @drawCmnds )) {
	$_ = shift( @drawCmnds );
	next if( /^\s*string\s+\S+\s+[\-\d\s]+$/ );

	if (/^\s*rect\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\S+)\s+(\S+)\s+(\S+)\s*$/) {
	    $x1    = $1;
	    $y1    = $2;
	    $x2    = $3;
	    $y2    = $4;
	    $color = $5;
	    $orfname  = $6;
	    $genename = $7;
	    $status = 1;


	} elsif( /^\s*string\s+(\S+)\s+(\d+)\s+(\d+)\s+\"(.+)\"\s+(\S+)\s+(\S.+)\s*$/ ) # " #
	{
	    $font    = $1;
	    $x1      = $2;
	    $y1      = $3;
	    $genename    = $4;
	    $color   = $5;
	    $orfname = $6;

	    eval "\$x2 = \$x1 + length(\$genename) * $font->width";
	    eval "\$y2 = \$y1 + $font->height";
	    $status = 1;

	} else {
	    $status = 0;
	}

	if ($status) {
            $work_orf    = $orfname;
            $work_orf    =~ s/\'/\\\'/g;
            $work_gene = $genename;
            $work_gene =~ s/\'/\\\'/g;
	    if($genename ne $orfname) {
		$work_orf = "$work_orf($work_gene)";
	    }
        my($cgi_path) = "${Path_htbin}$libMBGDImgMap::cgi_gene_info?name=$Organism:$orfname";
        if ($opt{'tabid'}) {
            $cgi_path .= "&tabid=$opt{'tabid'}";
        }
	    push(@ImageMap, "<AREA SHAPE=\"RECT\" COORDS=\"$x1,$y1,$x2,$y2\" HREF=\"$cgi_path\" onMouseOver=\"window.status='$work_orf';return true\" TARGET=\"_top\">");
	}
    }
    $ImageMap = join( "\n", @ImageMap );

    return $ImageMap;
}
###############################################################################
1;
