#!/usr/local/bin/perl

#require 'libMBGDFuncCat.pl';
require "MBGD_Conf.pl";

###############################################################################
#
sub get_prosite_category {
	my($orf) = @_;
	my(%Cnt, $max, $maxclass, $c, $stat);
	$pros = &get_prosite_motif($orf);
	foreach $p (@{$pros}) {
##		print "$orf $p->{'from'} $p->{'prosacc'}\n";
		$prosclass = &get_category_of_prosid($p->{'prosacc'});
##		print $prosclass, " ",
##			&get_prosclass_name($prosclass),"\n";
		$stat = &get_prosite_stat($p->{'prosacc'});
		if ($stat) {
			$Cnt{$prosclass} += 1.0/$stat;
		} else {
		}
	}
	foreach $c (sort keys %Cnt) {
		if ($max < $Cnt{$c}) {
			$max = $Cnt{$c};
			$maxclass = $c;
		}
	}
	if ($maxclass eq '') {
		$maxclass = $UNKNOWN;
	}
	$maxclass;
}

###############################################################################
#
sub get_prosite_color {
	my($colorid) = @_;
	return('ffffff') if ($colorid == $UNKNOWN);
	if (! @PROSCOLOR) {
		&create_pros_color;
	}

	return ($PROSCOLOR[$colorid]);
}

###############################################################################
#
sub get_prosite_stat {
	my($prosid) = @_;
	my($prosstat,$id);
	if (! %ProsStat) {
		open(PROSSTAT, "$main::DIR_mbgdhome/etc/prosite.stat");
		while (<PROSSTAT>){
			($id, $prosstat) = split;
			$ProsStat{$id} = $prosstat;
		}
		close(PROSSTAT);
	}
	$ProsStat{$prosid};
}

###############################################################################
#
sub get_prosite_motif {
	my($orfid) = @_;
	my($sp, $orf, $PROSITEFILE);

	($sp, $orf) = split(/:/, $orfid);

	if (! defined $Prosite{$sp}) {
		$Prosite{$sp} = &create_prositetab($sp);
	}
	$Prosite{$sp}->{$orf};
}

###############################################################################
#
sub create_prositetab {
	my($sp) = @_;
	my($orfname, $from, $to, $prosname, $prosacc, $sp0);
	my($PROSFD);
	my($PROSITEFILE) = "$main::DIR_database/motif/$sp.pr";
	my($Prosite);

	$PROSFD = "PROSITE_$sp";
	open($PROSFD, $PROSITEFILE) || die "Can not open $PROSITEFILE";
	while (<$PROSFD>) {
		($sp0,$orfname,$from,$to,$prosname,$prosacc) = split(/:/);
		push(@{$Prosite->{$orfname}},
		    {'from'=>$from, 'to'=>$to, 'prosacc'=>$prosacc});
##	print $Prosite->{$orfname}->[0]->{'prosacc'}," $orfname****\n";
	}
	close($PROSFD);

	return $Prosite;
}

###############################################################################
#
sub get_category_of_prosid {
	my($pros) = @_;
	## ProsClass and ProsClassName are global variable !
	if (! $ProsClass) {
		($ProsClass, $ProsClassName) = &create_prosite_category;
	}
	$ProsClass->{$pros};
}

###############################################################################
#
sub create_prosite_category{
	my($classid, $prosdoc, $prosid, @classname, @prosids);
	my($prosid);
	my($PROSITECLASS) = "$main::DIR_mbgdhome/etc/prosite.class";
	my($ProsClass, $ProsClassName);

	open(PROCLASS, $PROSITECLASS) || die "File($PROSITECLASS) open error.";
	while (<PROCLASS>) {
		if (/^### /) {
			($dmy, $classid, @classname) = split;
			$classname = join(' ', @classname);
			$ProsClassName->{$classid} = $classname;
		} else {
			($classid, $prosdoc, @prosids) = split;
			foreach $prosid (@prosids) {
				$ProsClass->{$prosid} = $classid;
			}
		}
	}
	close(PROCLASS);
	($ProsClass, $ProsClassName);
}

###############################################################################
#
sub get_prosite_category_members {
	my($qclassid) = @_;
	my($classid, $prosdoc, $prosid, @classname, @prosids);
	my($prosid, $flag);
	my($PROSITECLASS) = "$main::DIR_mbgdhome/etc/prosite.class";
	my($ProsMembers);
        local(*PROCLASS);

	open(PROCLASS, $PROSITECLASS) || die "File($PROSITECLASS) open error.";
	while (<PROCLASS>) {
		if (! /^### /) {
			my(@prosids);
			($classid, $prosdoc, @prosids) = split;
			if ($qclassid eq $classid) {
				push(@{$ProsMembers}, @prosids);
			}
		}
	}
	close(PROCLASS);
	$ProsMembers;
}

###############################################################################
#
sub get_prosite_titles {
	my($PROSITETIT) = "$main::DIR_mbgdhome/etc/prosite.tit";
	my($TIT);
	open(PROSTIT, $PROSITETIT) || die "File($PROSITETIT) open error.";
	while (<PROSTIT>) {
		($name, @title) = split;
		$TIT->{$name} = join(' ', @title);
	}
	$TIT;
}

###############################################################################
#
sub get_prosclass_name {
	my($prosclass) = @_;
	$ProsClassName->{$prosclass};
}

###############################################################################
#
sub create_pros_color {
     my($r,$g,$b,$R,$G,$B);
     push(@PROSCOLOR, '');
     foreach $r (3,4,2) {
	     foreach $g (2..4) {
		     foreach $b (2..4) {
			     next if ($r == 4 && $g == 4 && $b == 4);
			     $R = sprintf("%02x", int(255 * $r/4));
			     $G = sprintf("%02x", int(255 * $g/4));
			     $B = sprintf("%02x", int(255 * $b/4));
			     push(@PROSCOLOR, "#$R$G$B");
		     }
	     }
     }
}

###############################################################################
1;
###############################################################################
