#!/usr/bin/perl -s

###############################################################################
use IO::Dir;
use IO::File;
use MBGD;
use Roman;             # ޿򥢥ӥѴ⥸塼
#require "libMBGDConv.pl";
require "MBGD_Conf.pl";

use MBGD::Taxonomy;	# temporary

###############################################################################
# MBGD饤֥
###############################################################################
package MBGDaxes;
#$DEBUG = 1;

###############################################################################
#
sub main::MBGD_DbAccessError {
    my($sth, $sql) = @_;

    if ($sth) {
	print STDERR "DB access error(", $sth->err, ")\n";
	print STDERR "Msg :: ", $sth->errstr, "\n";
    }
    print STDERR "Sql :: [", $sql, "]\n";
}

###############################################################################
# MBGD_TaxonomyTree : MBGD ϿƤʪ˴ؤ taxonomy tree 
# input : 
# return: 
#
# taxonomy.taxonomy ơ֥ι hierarchy ϡʸȤƳǼƤ
# Τᡢorder by Ƥ⡢ʬˤϤʤʤ
# ǡselect ̤Ȥˡץ hierarchy Ϥ¤ؤ
#
sub main::MBGD_TaxonomyTree {
    my($dbname);
    my($db);
    my($tab, $opt);
    my($res);

    $dbname = $ENV{'MYSQL_DB'};
    $db = MBGD::DB->new($dbname);

    $tab        = "genome g, taxonomy.taxonomy t";
    $opt = {};
    $opt->{'columns'} = "g.sp sp, t.hierarchy hierarchy, t.name name, t.taxorder taxorder";
    $opt->{'where'}   = "g.taxid=t.taxid and t.class = 'scientific name'";

    $res = $db->select_fetch($tab, $opt);

    # hierarchy  sort
    my($refSorted);
    @{$refSorted} = sort sortTaxonTree @{$res->{'INFO'}};

    return $refSorted;
}

###############################################################################
# MBGD_TaxonomyTree  sort ɾؿ
#   $a, $b ϡΥե
#   ˤϡʪ̾, Fullname, hierarchy, taxorder ǼƤ
#   hierarchy ¤ؤ
sub sortTaxonTree {

    if ($a->{'hierarchy'} eq $b->{'hierarchy'}) {
        # hierarchy Ʊʤ taxorder 
        return ($a->{'taxorder'} <=> $b->{'taxorder'});
    }

    # hierarchy ϡ '.' ǳʬƤ
    my(@aHi) = split(/\./, $a->{'hierarchy'});
    my(@bHi) = split(/\./, $b->{'hierarchy'});
    my($i);
    for($i = 0; ; $i++) {
        if ($aHi[$i] == $bHi[$i]) {
            # $i γؤޤǤƱ hierarchy
            next;
        }

        return ($aHi[$i] <=> $bHi[$i]);
    }
}

###############################################################################
# MBGD_GetAllGeneInReg : ꤵ줿꡼ΰҤ
# input : ʪID꡼󳫻ϡλ
# return: ҥꥹ
sub main::MBGD_GetAllGeneInReg {
    my($chrid, $contigid, $start, $end, $options) = @_;

    my($dbname) = $ENV{'MYSQL_DB'};
    my($db) = MBGD::DB->new($dbname);

    my($tab, $opt);
    $tab = "gene";
    $opt->{'columns'}  = "name, gene, from1, to1, dir, type, location";
    $opt->{'where'}    = "1 ";
    $opt->{'where'}   .= " and chrid=$chrid " if ($chrid);
    $opt->{'where'}   .= " and contigid=$contigid " if ($contigid);
    $opt->{'where'}   .= " and from1 <= $end and to1 >= $start";
    $opt->{'order'} = "from1";

    my($res) = $db->select_fetch($tab, $opt);

    return $res;
}

###############################################################################
# protmotif ơ֥ gene ơ֥Ȥ join Ʒ̤Ƥ
# protmotif ơ֥ gene ơ֥򤽤Τޤ join 
# 빽֤롣
# ǡprotmotif ơ֥ʤ߰ơ֥ơ֥
# gene ơ֥ join ˾̤뤳ȤȤ롣
###############################################################################
# MBGD_SearchGeneByMotif : ꤷդ˥ޥå Gene 򸡺
# input : motif-lib, motif-id
# return: ID
sub main::MBGD_SearchGeneByMotif {
    my($refMotlib, $sp, $motid, $cutoff, $start, $limit, $count) = @_;
    my($refRes);

    $refRes = {};
    $refRes->{'MAXROWS'} = 0;
    $refRes->{'ROWS'}    = 0;
    $refRes->{'INFO'}    = [];

    my($db);
    my($sth);
    my($sql, $colms, $tables, $whereCond, $orderCond);
    my($whereCondGene);
    my($rows);
    my(@dat);
    my($i);

    $db = MBGD::DB->new($ENV{'MYSQL_DB'});

    $colms      = "sp, name, from1, to1, score, eval, program";
    $tables     = "protmotif";
    $whereCond = "";
    foreach $motlib (@{$refMotlib}) {
        my($lib, $prog) = split(/:/, $motlib);
        $whereCond .= " or " if ($whereCond ne '');
	if ($prog) {
	        $whereCond .= "(motlib='$lib' and program='$prog')";
	} else {
	        $whereCond .= "motlib='$lib'";
	}
    }
    $whereCond  = "($whereCond) and motid='$motid'";
    if (ref($sp) eq 'ARRAY') {
        $whereCond  = "$whereCond and sp in ('". join("','", @{$sp}). "')";
    } elsif ($sp && $sp !~ /^all$/i) {
        $whereCond  = "$whereCond and sp='$sp'";
    }
    if ($cutoff) {
        $whereCond  = "$whereCond and (program = 'regexp' or eval < $cutoff)";
    }
    $orderCond  = "";

    if ($count) {
	my %Count;
    	my $sql = "select sp,count(*) from $tables where $whereCond group by sp";
        my $sth = $db->execute("$sql");
	while (my ($sp,$count) = $sth->fetchrow) {
		$Count{$sp} = $count;
	}
	return \%Count;
    }

    $sql = "create temporary table tmp_protmotif";
    $sql = "$sql select $colms from $tables";
    $sql = "$sql where $whereCond";
    print STDERR "SQL :: $sql\n" if ($DEBUG);
print STDERR "$sql\n";
    $sth = $db->execute("$sql");
    if (not $sth) {
        &MBGD_DbAccessError($sth, $sql);
        return undef();
    }

    #join the temporary table and the gene table;

    $colms      = "p.sp sp, p.name name, p.from1 from1, p.to1 to1, p.score score, p.eval eval, p.program program, g.descr descr";
    $tables     = "tmp_protmotif p, gene g";
    $whereCond  = "p.sp=g.sp and p.name=g.name";
    $orderCond  = "p.eval,p.score desc";
#    $orderCond  = "p.sp, p.name";
#    $orderCond  = "p.sp, p.name, p.name";

    # count hit records
    $sql = "select count(*) from $tables";
    $sql = "$sql where $whereCond";
    print STDERR "SQL :: $sql\n" if ($DEBUG);
    $sth = $db->execute("$sql");
    if (not $sth) {
        &MBGD_DbAccessError($sth, $sql);
        return undef();
    }
    $refRes->{'MAXROWS'} = $sth->fetchrow_array;

    $sql = "select $colms from $tables";
    $sql = "$sql where $whereCond";
    $sql = "$sql order by $orderCond";
$start = 0 if (! $start);
    if (0 < $limit) {
        $sql = "$sql limit $start,$limit";
    }
    print STDERR "SQL :: $sql\n" if ($DEBUG);
    $sth = $db->execute("$sql");
    if (not $sth) {
        &MBGD_DbAccessError($sth, $sql);
        return undef();
    }

    $rows = $sth->rows;
    $refRes->{'ROWS'} = $rows;
    for($i = 0; $i < $rows; $i++) {
        @dat = $sth->fetchrow_array;
        push(@{$refRes->{'INFO'}}, [@dat]);
    }

    $sth->finish;

    return $refRes;
}

###############################################################################
# MBGD_GetSeqID : ꤷҤޤॷ󥹤ID
# input : ʪ(ORF)̾
# return: ID
sub main::MBGD_GetSeqID {
    my($org, $orf) = @_;
    my $result;
    my($key, $value);
    my($cmd);
    my(@list);

    # ORF ̾ ɥᥤֹ椬ޤޤƤϡ
    $orf =~ s#\(\d+\)##;

    my($dbname);
    my($db);
    my($tab, $opt);
    my($res);

    # ֹ椬 '' ̵Ѵơ֥
    my(%trans) = ( 'chromosome' => 1,
                   'CHROMOSOME' => 1);

    $dbname = $ENV{'MYSQL_DB'};
    $db = MBGD::DB->new($dbname);

    # ֹ
    $tab = "gene g, chromosome c";
    $opt->{'columns'} = "c.name name, c.type type, c.seqno seqno";
    $opt->{'where'}  = "g.sp='$org' and g.name='$orf' and g.chrid=c.id";

    $res = $db->select_fetch($tab, $opt);
    my($ent) = @{$res->{'INFO'}};
    my($chrName) = $ent->{'name'};
    my($type)    = $ent->{'type'};
    my($chrNo)   = $ent->{'seqno'};

    return($type, $chrNo, $chrName);
}

###############################################################################
# MBGD_GetSeqLen : ()Ĺ
# input : ʪID(⤷Υ)name
# return: Ĺ
sub main::MBGD_GetSeqLen {
    my($org, $type, $no) = @_;

    my($dbname) = $ENV{'MYSQL_DB'};
    my($db) = MBGD::DB->new($dbname);

    my($tab, $opt);
    $tab = "chromosome c, $main::DBNAME_ACCUM.dnaseq d";
    $opt->{'columns'} = "d.length len";
    $opt->{'where'} = "c.sp='$org' and c.seq=d.id and c.type='$type'";
    if ($no ne '') {
        $opt->{'where'} .= " and c.seqno=$no";
    }
    $opt->{'order'}  = "c.seqno";
    $opt->{'limit'}  = "0, 1";

    # SQL ¹
    my($res) = $db->select_fetch($tab, $opt);
    my($ent) = @{$res->{'INFO'}};

    return $ent->{'len'};
}

###############################################################################
# MBGD_GetGeneInfo : ꤷҤξܺپ
# input : ʪ(ORF)̾
# return: Ҿƥ
sub main::MBGD_GetGeneInfo {
    my($org, $orf) = @_;
    my($result);
    my(%info);
    my($key, $value);
    my(@list);
    my($dbname);
    my($db);
    my($tab, $opt);
    my($res);

    # ORF ̾ ɥᥤֹ椬ޤޤƤϡ
    $orf =~ s#\(\d+\)##;

    $info{'ORF'} = $orf;

    $dbname = $ENV{'MYSQL_DB'};
    $db = MBGD::DB->new($dbname);

    $tab = "gene";
    $opt->{'columns'} = "*";
    $opt->{'where'}   = "sp='$org' and (name='$orf' or gene='$orf')";

    $res = $db->select_fetch($tab, $opt);
    my($ent) = @{$res->{'INFO'}};
    $info{'GeneName'} = $ent->{'gene'};
    if ($ent->{'dir'} < 0) {
       $info{'PositionFrom'} = $ent->{'to1'};
       $info{'PositionTo'}   = $ent->{'from1'};
    } else {
       $info{'PositionFrom'} = $ent->{'from1'};
       $info{'PositionTo'}   = $ent->{'to1'};
    }
    $info{'Product'} = $ent->{'descr'};

    $info{'Position'} = "$info{'PositionFrom'}-$info{'PositionTo'}";

    foreach $key (keys(%info)) {
        $result .= sprintf("%s:%s\n", $key, $info{"$key"});
    }

    return $result;
}

###############################################################################
# MBGD_GetGeneInfomation : ꤷҤξܺپ
# input : ʪ(ORF)̾
# return: Ҿƥ
sub main::MBGD_GetGeneInformation {
    my($org, $orf) = @_;
    my %info;
    my($key, $value);
    my(@list);
    my($dbname);
    my($db);
    my($tab, $opt);
    my($res);

    $dbname = $ENV{'MYSQL_DB'};
    $db = MBGD::DB->new($dbname);

    $tab = "genome ge, gene g, chromosome c";
    $opt->{'columns'} = "ge.abbrev abbrev, ge.orgname orgname, ge.strain strain, ge.taxid taxid, g.sp sp, g.name name, g.gene gene, g.from1 from1, g.to1 to1, g.dir dir, g.descr descr, c.type chrtype, c.seqno chrno";
    $opt->{'where'} = "ge.sp=g.sp and g.sp='$org' and g.name='$orf' and c.id=g.chrid";

    #
    $res = $db->select_fetch($tab, $opt);
    my($ent) = @{$res->{'INFO'}};

    $info{'ORF'}             = $orf;
    $info{'Orgname'}         = $ent->{'orgname'};
    $info{'Abbrev'}          = $ent->{'abbrev'};
    $info{'Strain'}          = $ent->{'strain'};
    $info{'Taxid'}           = $ent->{'taxid'};
    $info{'GeneName'}        = $ent->{'gene'};
    $info{'PositionFrom'}    = $ent->{'from1'};
    $info{'PositionTo'}      = $ent->{'to1'};
    $info{'Product'}         = $ent->{'descr'};
    $info{'Position'}        = "$info{'PositionFrom'}-$info{'PositionTo'}";
    $info{'ChromosomeType'}  = $ent->{'chrtype'};
    $info{'ChromosomeNo'}    = $ent->{'chrno'};

    return(%info);
}

###############################################################################
#
sub main::MBGD_GetNumGenes {
    my($sp) = @_;
    my($dbname);
    my($db);
    my($tab, $opt);
    my($res);

    $dbname = $ENV{'MYSQL_DB'};
    $db = MBGD::DB->new($dbname);

    $tab = "gene";
    $opt->{'columns'} = "chrid, count(chrid) n";
    $opt->{'where'} = "sp='$sp' and type='CDS'";
    $opt->{'group'} = "chrid";

    $res = $db->select_fetch($tab, $opt);

    my($ent);
    my(%Count);
    foreach $ent (@{$res->{'INFO'}}) {
        my($chrid) = $ent->{'chrid'};
        my($count) = $ent->{'n'};

        $Count{"$chrid"} = $count;
    }

    return \%Count;
}

###############################################################################
#
sub main::MBGD_GetGeneByOrder {
    my($sp, $order) = @_;
    my($dbname);
    my($db);
    my($tab, $opt);
    my($res);

    $dbname = $ENV{'MYSQL_DB'};
    $db = MBGD::DB->new($dbname);

    $order--; $order = 0 if ($order < 0);

    $tab = "gene";
    $opt->{'columns'} = "*";
    $opt->{'where'} = "sp='$sp' and type='CDS'";
    $opt->{'order'} = "chrid, from1";
    $opt->{'limit'} = "$order, 1";

    $res = $db->select_fetch($tab, $opt);
    my($ent) = @{$res->{'INFO'}};

    return ($ent->{'name'}, $ent->{'chrid'}, $ent->{'from1'}, $ent->{'to1'});
}

###############################################################################
# MBGD_GetChromosomeInfo : ꤷΤξܺپ
# input : ʪΥסֹ
# return: Ҿƥ
sub main::MBGD_GetChromosomeInfo {
    my($spec, $type, $name) = @_;
    my($dbname);
    my($db);
    my($tab, $opt);
    my($res);

    $dbname = $ENV{'MYSQL_DB'};
    $db = MBGD::DB->new($dbname);

    $tab = "genome g, chromosome c";
    $opt->{'columns'} = "g.sp, g.abbrev, g.orgname, c.name, c.type, c.shape";
    $opt->{'where'} = "g.sp=c.sp and g.sp='$spec'";
    $opt->{'order'} = "c.type, c.name";

    $res = $db->select_fetch($tab, $opt);
    $rows = $sth->rows;
    $refRes->{'MAXROWS'} = $rows;
    $refRes->{'ROWS'} = $rows;
    for($i = 0; $i < $rows; $i++) {
        ($sp, @dat) = $sth->fetchrow_array;
        $refRes->{'INFO'}->{"$sp"} = [$sp, @dat];
    }

    $sth->finish;

    return $refRes;
}

###############################################################################
# MBGD_GetStdOrgName : ʪ̾Τ
# input : ʪά
# return: ʪ̾
sub main::MBGD_GetStdOrgName {
    my($org) = @_;

    my(%info) = &main::MBGD_GetGenomeInfo($org);

    return "$info{'orgname'}\n";
}

###############################################################################
# MBGD_GetStdSeqID : IDɽ̾Τ
# input : ʪάΡIDά
# return: ID̾
sub main::MBGD_GetStdSeqID {
    my($org, $seq, $num) = @_;
    my($stdSeq);
    my($chformosome);
    my(%type);
    my(%type_disp);

    $type{'CHR'}        = "chromosome";
    $type{'CHROMOSOME'} = "chromosome";
    $type{'PLAS'}       = "plasmid";
    $type{'PLASMID'}    = "plasmid";
    $type_disp{'CHR'}        = "Chromosome";
    $type_disp{'CHROMOSOME'} = "Chromosome";
    $type_disp{'PLAS'}       = "Plasmid";
    $type_disp{'PLASMID'}    = "Plasmid";

    # ξ
    $chromosome = &main::MBGD_GetChromosomeList($org, $seq);

    $stdSeq = '';
    if (defined(@{$chromosome->{$type{$seq}}})) {
        if (${$chromosome->{$type{$seq}}}[$num - 1]->{'name'} ne '') {
            # ɽ̾ΤꤵƤ硢̾κ
            $stdSeq = "$type_disp{$seq} ${$chromosome->{$type{$seq}}}[$num - 1]->{'name'}";
        }
    }

    return("$stdSeq\n");
}

###############################################################################
# ۥ(BLAST)η̤򸡺롣
# input : ʪNEAREST(ȥåץβޤǤᤤȸʤ)
#         åȥեѥ᡼
#         ѥ᡼λˡ
#           ʪ      -> "SPEC:ʪά(1),ʪά(2),,,
#           ꡼ORF -> "QORF:ORF
#           NEAREST     -> "NEAREST:float"   (ȥåץβ%ޤ)
#           Ǿ  -> "SCORE:integer"
#           ǾΨ  -> "OVLP:float"      (ñ%)
#           ǾP-value -> "PVAL:float"
#           ǾIdenty  -> "IDENT:integer"   (ñ%)
# return: ORFΥڥΥꥹ֤(ϥƥ)
##sub main::MBGD_GetBlastRes {
##    my(@Params) = @_;
##    my($Orgs, $stdOrgs);	# ʪάΡ̾
##    my($args, $argCnt, $param);
##    my($stdOrgs, $nearest, $score, $ovlp, $pval, $ident);
##    my($result);
##
##    # ꡼ѥåȤ
##    $args  = "";
##    while(scalar(@Params)) {
##        $param = shift(@Params);
##    if(length($param) == 0) {
##        next;
##    }
##    elsif($param =~ /^SPEC:/) {
##        $Orgs = $param;
##
##        # ʪζڤʸѴ
##        $Orgs =~ s/,$//;
##        $Orgs =~ s/,/|/g;
##
##        # ʪάΤ̾ΤѴ
##        $param = &main::Conv_OrgAbbrevToStd($Orgs);
##
##        print STDERR "$Orgs\n"  if($main::DEBUG);
##        print STDERR "$param\n" if($main::DEBUG);
##    }
##    elsif($param =~ /^QORF:/) {
##        local($Orf) = $param;
##        $param = &main::Conv_OrgAbbrevToStd($Orf);
##
##        print STDERR "$Orf\n"   if($main::DEBUG);
##        print STDERR "$param\n" if($main::DEBUG);
##    }
##
##    if($main::DEBUG) {
##        printf(STDERR "len = %d, param = %s\n", length($param), $param);
##    }
##
##    $args .= pack('C a*', length($param), $param);
##    $argCnt++;
##    }
##
##    &main::Sock_SendPacket($SocketFH,
##                           pack('n n n n', $CMND_PACKET_TYPE,
##                                $GetBlastRes,
##                                $argCnt,
##                                length($args)),
##                           $args);
##    $result = &main::Sock_RecvData($SocketFH);
##
##    # ʪ̾ΤάΤѴ
##    $result = &main::Conv_OrgStdToAbbrev($result);
##
##    return($result);
##}

###############################################################################
# ꤵ줿ʪΥΥ˴ؤ֤
# input : ʪ(̾)
# return: Υ(Ϣ)
sub main::MBGD_GetGenomeInfo {
    my($org) = @_;

    my($dbname) = $ENV{'MYSQL_DB'};
    my($db) = MBGD::DB->new($dbname);
    my($sta) = $db->sta_connect();
    if ($sta) {
        return main::MBGD_GetGenomeInfoMysql($db, $org);
    }

    return main::MBGD_GetGenomeInfoFile($org);
}

###############################################################################
#
sub main::MBGD_GetGenomeInfoMysql {
    my($db) = shift;
    my($org) = shift;
    my($spInfo);

    my($tab, $opt);
    $tab = "genome";
    $opt->{'columns'} = "*";
    $opt->{'where'} = "sp='$org'";

    my($res);
    my($ent);
    $res = $db->select_fetch($tab, $opt);
    ($ent) = @{$res->{'INFO'}};

    my($key);
    my(%info);
    foreach $key (keys(%{$ent})) {
        $info{"$key"} = $ent->{"$key"};
    }

    return(%info);
}

###############################################################################
#
sub main::MBGD_GetGenomeInfoFile {
    my($org) = shift;

    my($ref) = main::MBGD_read_tab_genome();

    return %{$ref->{"$org"}};
}

###############################################################################
#
$main::CACHE_tab_genome = undef();
sub main::MBGD_read_tab_genome {
    my($filename) = shift;

    if ($main::CACHE_tab_genome) {
        return $main::CACHE_tab_genome;
    }

    my($ref) = $main::CACHE_tab_genome = main::MBGD_read_tab_genome_user();

    if (!$filename) {
        $filename = "$ENV{'MBGD_HOME'}/etc/"
                  . $main::NAME_PUBLIC_SERVER
                  . '/tab_genome.txt';
    }
    my($fh) = IO::File->new("$filename", 'r');
    if (!$fh) {
        return $ref;
    }

    #
    my(@key_list) = ('id', 'udate',
                     'ver', 'status',
                     'spid', 'sp', 'abbrev', 'orgname', 'strain',
                     'taxid', 'tax_family', 'tax_genus', 'tax_species',
                     'specweight',
                     'source',
                     'institution', 'wwwlink',
                     'medid', 'journal',
                     'date_release',
                     'date_modify',
                     'mbgd_update',
        );

    #
    while (my$line=$fh->getline()) {
        $line =~ s#[\r\n]*$##;
        my(@d) = split(/\t/, $line);
        my($sp) = $d[5];
        $ref->{"$sp"} = {};
        foreach my$key (@key_list) {
            $ref->{"$sp"}->{"$key"} = shift(@d);
        }
    }
    $fh->close();

    return $ref;
}

###############################################################################
#
sub main::MBGD_read_tab_genome_user {
    my($ref) = {};

    my($dir) = "$ENV{'RECOG_HOME'}/species";
    my($dh) = IO::Dir->new("$dir");
    if (!$dh) {
die("Can not open $dir :: $!");
        return $ref;
    }
    while (my$file=$dh->read()) {
        next if ($file !~ /^gu\d+$/);

        my($genome_ref) = {};
        my($filename) = "$dir/$file/gm/genome.txt";
        my($fh) = IO::File->new("$filename", 'r');
        if (!$fh) {
            print STDERR "Can not open $filename($!)\n";
            next;
        }
        while (my$line=$fh->getline()) {
            $line =~ s#[\r\n]*$##;
            my($k, $v) = split(/\t/, $line);
            $genome_ref->{"$k"} = $v;
print STDERR "LOG :: read $file :: $k - $v\n";
        }
        $fh->close();
        my($sp) = $genome_ref->{'sp'};
        $ref->{"$sp"} = $genome_ref;
    }

    return $ref;
}

###############################################################################
#
sub main::MBGD_GetSpecShortName {
    my($sp) = @_;
    my(%genomeInfo);

    %genomeInfo = &main::MBGD_GetGenomeInfo($sp);

    return $genomeInfo{'abbrev'};
}

###############################################################################
# ꤵ줿ʪ ORF ֤
# input : ʪ(̾)
# return: ORF 
sub main::MBGD_GetOrfNum {
    my($org) = @_;
    my($dbname);
    my($db);
    my($tab, $opt);

    $dbname = $ENV{'MYSQL_DB'};
    $db = MBGD::DB->new($dbname);

    $tab = "gene";
    $opt->{'columns'} = "count(*) n";
    $opt->{'where'} = "type='cds' and sp='$org'";

    my($res);
    $res = $db->select_fetch($tab, $opt);
    my($ent) = @{$res->{'INFO'}};

    return $ent->{'n'};
}

###############################################################################
sub main::MBGD_SpecBySuperkingdom {
	my($superkingdom) = shift;
	my($taxfile) = shift;


    my($tax) = MBGD::Taxonomy->new($taxfile);
    my(@sp_list) = $tax->get_species({
                                        match_rank => 'superkingdom',
                                        match_name => $superkingdom,
                                        one_strain => 'species'});
    #
    my($sp_hash) = {};
    foreach my$sp (@sp_list) {
        $sp_hash->{"$sp"} = 1;
    }

    return $sp_hash;
}

###############################################################################
###
##sub main::MBGD_SpecTableGetAllSpec {
##    my(@specList);
##    my($infoTaxon);
##    my($ent);
##
##    # MBGD Ͽʪ˴ؤ taxonomy tree μ
##    $infoTaxon = &main::MBGD_TaxonomyTree();
##
##    foreach $ent (@{$infoTaxon}) {
##        next if ($ent->{'sp'} =~ /^\s*$/);
##        push(@specList, $ent->{'sp'});
##    }
##
##    return @specList;
##}
sub main::MBGD_GetAllGenomes {
	my($dbname) = @_;

    #
    my($db) = MBGD::DB->new($dbname);
    my($sta) = $db->sta_connect();
    if ($sta) {
        return main::MBGD_GetAllGenomesMysql($db, $org);
    }

    return main::MBGD_GetAllGenomesFile();
}
sub main::MBGD_GetAllGenomesMysql {
	my($db) = shift;

	my @genomes = MBGD::Genome->find($db);
	my @spnames;
	foreach $g (@genomes) {
		push(@spnames, $g->{sp});
	}
	return @spnames;
}
sub main::MBGD_GetAllGenomesFile {

    my($ref) = main::MBGD_read_tab_genome();
    my(@spnames) = keys(%{$ref});

    return @spnames;
}
sub main::MBGD_SpecTableGetAllSpec {
	my($taxfile) = @_;
	$tax = MBGD::Taxonomy->new($taxfile);
	$tax->get_all_spec;
}

###############################################################################
#
sub main::MBGD_SpecTableGetDefaultSpecies {
	my($taxfile) = @_;
	$tax = MBGD::Taxonomy->new($taxfile);
	$tax->get_default_spec();
}

###############################################################################
#
sub main::MBGD_SpecTableIsDefaultSpecies {
	my($speclist, $taxfile) = @_;
	$tax = MBGD::Taxonomy->new($taxfile);
	my(@spDefaultList) = $tax->get_default_spec();
    my(%spDefaultHash);
    foreach my$sp (@spDefaultList) {
        $sp = lc($sp);
        $spDefaultHash{"$sp"} = 1;
    }

    my(@speclist) = split(/[\,\|]/, $speclist);
    if (scalar(@spDefaultList) != scalar(@speclist)) {
        return 0;
    }
    foreach my$sp (@speclist) {
        $sp = lc($sp);
        if (!exists($spDefaultHash{"$sp"})) {
            return 0;
        }
    }

    return 1;
}
# ߴΤ˻ĤƤ롣ʺͽ
sub main::MBGD_SpecTableGetSelectedSpecies {
	my($taxfile) = @_;
    printf(STDERR "WARNING :: Please use 'MBGD_SpecTableGetDefaultSpecies()' :: %s %s %s\n", caller());
	main::MBGD_SpecTableGetDefaultSpecies($taxfile);
}
sub main::MBGD_SpecTableGetDefaultSpecies_OBSOLETE {
    my(@specList);
    my($infoTaxon);
    my($ent);
    my($preName1, $preName2);

    # MBGD Ͽʪ˴ؤ taxonomy tree μ
    $infoTaxon = &main::MBGD_TaxonomyTree();

    $preName1 = '';
    $preName2 = '';
    foreach $ent (@{$infoTaxon}) {
        my($sp)        = $ent->{'sp'};
        my($hierarchy) = $ent->{'hierarchy'};
        my($name)      = $ent->{'name'};
        my($name1, $name2) = split(/\s+/, $name);

        if (($preName1 eq $name1) && ($preName2 eq $name2)) {
	  ## assuming the same species (matches both genus and species name)
            next;
        }
        else {
            push(@specList, $sp);
            $preName1 = $name1;
            $preName2 = $name2;
        }
    }

    return @specList;
}

###############################################################################
#
sub main::getSpeciesForAddspec {
    my($selopt) = shift;
    my(@splist);

    my(%species_hash);

    #
    my(@default_spec_list) = main::MBGD_SpecTableGetDefaultSpecies();
    foreach my$sp (@default_spec_list) {
        $species_hash{"$sp"} = 1;
    }

    #
    if (exists($selopt->{'hgenes'}) && scalar(@{$selopt->{'hgenes'}}) != 0) {
        #
        foreach my$g (@{$selopt->{'hgenes'}}) {
            my($sp, $name) = split(/\:/, $g);
            $species_hash{"$sp"} = 1;
        }
    }

    if (exists($selopt->{'genes'}) && scalar(@{$selopt->{'genes'}}) != 0) {
        #
        foreach my$g (@{$selopt->{'genes'}}) {
            my($sp, $name) = split(/\:/, $g);
            $species_hash{"$sp"} = 1;
        }
    }

    #
    if (exists($selopt->{'refspec'}) && exists($selopt->{'ref_gene'})) {
        #
        my($sp) = $selopt->{'refspec'};
        $species_hash{"$sp"} = 1;
    }

    #
    my(@all_spec_list) = main::MBGD_SpecTableGetAllSpec();
    foreach my$sp (@all_spec_list) {
        if (exists($species_hash{"$sp"})) {
            push(@splist, $sp);
        }
    }

    my($species) = join(',', @splist);
    return $species;
}

###############################################################################
# ʪʬ
# 'Eubacteria' °ʪ
# 㡧$baseSpec = 'Eubacteria' ȤƼ¹Ԥ
# 'Archaea' °ʪ
# 'Eukaryotae' °ʪ
#
# Ʊʪstrain㤤
# 㡧$baseSpec = 'Escherichia coli' ȤƼ¹Ԥ
#
sub main::MBGD_GetSpecListBySpec {
    my($baseSpec) = @_;

    # MySQL  DB Ȥä
    my($dbname);
    my($db);
    my($tab, $opt);

    if (length($baseSpec) == 3) {
        # ʸ ---> 'eco' Ϥ줿Ƚ
        my(%info);
        %info = &main::MBGD_GetGenomeInfo($baseSpec);
        ($baseSpec) = ($info{'orgname'} =~ /^(\S+\s+\S+)/);
    }
    $baseSpec = lc($baseSpec);

    $dbname = $ENV{'MYSQL_DB'};
    $db = MBGD::DB->new($dbname);

    # baseSpec  hierarchy 
    $tab = "genome g, taxonomy.taxonomy t, taxonomy.taxonomy w";
    $opt->{'columns'} = "g.sp sp, t.hierarchy hierarchy, t.name name, t.taxorder taxorder";
    $opt->{'where'}   = "g.taxid=t.taxid and t.class='scientific name' and w.lname='$baseSpec' and t.hierarchy like concat(w.hierarchy,'%')";

    $res = $db->select_fetch($tab, $opt);

    # hierarchy  sort
    my($refSorted);
    @{$refSorted} = sort sortTaxonTree @{$res->{'INFO'}};

    return $refSorted;
}

###############################################################################
# SP:ORF  MD5 бμ
sub main::MBGD_InfoSporfMd5 {
    my($dbname);
    my($db);
    my($dbForProteinseq);

    $dbname = $ENV{'MYSQL_DB'};
    $db = MBGD::DB->new($dbname);

    my($tab, $opt);
    $dbForProteinseq = $main::DBNAME_ACCUM;
#    $tab = "gene g, $dbForProteinseq.proteinseq ps";
    $tab = "$dbForProteinseq.gene g, $dbForProteinseq.proteinseq ps";
    $opt->{'columns'} = "concat(g.sp, ':', g.name) spname, ps.chksum chksum";
    $opt->{'where'}   = "g.aaseq=ps.id";

    my($res);
    $res = $db->select_fetch($tab, $opt);
    my($ent);
    foreach $ent (@{$res->{'INFO'}}) {
        my($sporf) = $ent->{'spname'};
        my($md5)   = $ent->{'chksum'};

        # SP:ORF  MD5 Ǥ褦ˤ
        $refRes->{'SPORF2MD5'}->{"$sporf"} = $md5;

        # MD5  SP:ORF Ǥ褦ˤ
        push(@{$refRes->{'MD52SPORF'}->{"$md5"}}, $sporf);
    }

    return $refRes;
}

###############################################################################
1;#
###############################################################################
