#!/usr/bin/perl -w
use strict;
use File::Basename;
use Getopt::Std;
my $PROGRAM = basename $0;
my $USAGE=
"Usage: $PROGRAM
";

my %OPT;
getopts('', \%OPT);

### Main ###
if (@ARGV == 0) {
    print STDERR $USAGE;
    exit 1;
}
my ($CLUSTER) = @ARGV;

system "cat $CLUSTER | cut.sh 1 | sort | uniq | ignore_clusters.pl cluster.to_ignore > $CLUSTER.to_check";

system "cat $CLUSTER.to_check | sge_script.pl -R -i $CLUSTER -o $CLUSTER.alignment 'dom_align'";
system "cat $CLUSTER.to_check | sge_script.pl -R -i $CLUSTER -o $CLUSTER.tree 'dom_tree_score'";
