#!/usr/bin/perl -w
use strict;
use File::Basename;
use Getopt::Std;
my $PROGRAM = basename $0;
my $USAGE=
"Usage: $PROGRAM [OPTION] CLUSTER_FILE
-e GAP_EXT
-o GAP_OPEN

Create boundaries

Intermediate output files:
CLUSTER_FILE.link(|_eval|_eval.score.jobs|_eval.score.jobs.check)
CLUSTER_FILE.create_test(|.jobs|.jobs.check|.score.jobs|.score.jobs.check|.summary)

Final output files:
CLUSTER_FILE.create(|.log)
";

my %OPT;
getopts('t:e:o:', \%OPT);

### Settings ###
my $OPTION = "";
if (defined $OPT{e}) {
    $OPTION .= " -e $OPT{e}";
}
if (defined $OPT{o}) {
    $OPTION .= " -o $OPT{o}";
}

my $SCORE = "dom_score_c";
# $SCORE .= " -r"; # align by region
$SCORE .= $OPTION;

my $CREATE_BOUNDARY = "dom_create_boundary";
# $CREATE_BOUNDARY .= " -r"; # align by region
$CREATE_BOUNDARY .= $OPTION;

### Main ###
if (@ARGV == 0) {
    print STDERR $USAGE;
    exit 1;
}
my ($CLUSTER) = @ARGV;

my $GET_CLUSTER = "cat $CLUSTER.link | ignore_clusters.pl cluster.to_ignore";

### prepare ###
if (! -f "$CLUSTER.link") {
    system "cat $CLUSTER | dom_network -l > $CLUSTER.link";
}

### create boundary ###
if (! -f "$CLUSTER.create") {
    system "$GET_CLUSTER | sge_script.pl -i $CLUSTER -o $CLUSTER.link_eval -p score '$SCORE'";
    system "$GET_CLUSTER | select_links.pl ${CLUSTER}_test.to_move | sge_boundary.pl -i ${CLUSTER}_test -o $CLUSTER.create_test '$CREATE_BOUNDARY'";
    system "$GET_CLUSTER | sge_script.pl -i $CLUSTER.create_test -o $CLUSTER.create_test -p score '$SCORE'";
    system "$GET_CLUSTER | summarize_score.pl -i $CLUSTER.link_eval/score. -o $CLUSTER.create_test/score. > $CLUSTER.create_test.summary";
    system "cat $CLUSTER.create_test.summary | sort -k4,4gr | select_positive.pl -f 4 | modify_stepwise -m c -i $CLUSTER -o $CLUSTER.create_test > $CLUSTER.create 2> $CLUSTER.create.log";
}
