#!/usr/bin/perl -w
use strict;
use File::Basename;
use Getopt::Std;
my $PROGRAM = basename $0;
my $USAGE=
"Usage: $PROGRAM [-N JOB_NAME] [-q QUEUE] [-l RESOURCE] COMMAND LINE
";

use DomRefine::Read;

### Settings ###
my %OPT;
getopts('N:q:l:', \%OPT);

@ARGV == 0 and die $USAGE;

my $JOB_NAME = $OPT{N} || $PROGRAM;

my $QUEUE_OPTION = "";
if ($ENV{DOMREFINE_QUEUE}) {
    $QUEUE_OPTION = "-q $ENV{DOMREFINE_QUEUE}";
}
if ($OPT{q}) {
    $QUEUE_OPTION = "-q $OPT{q}";
}
if ($OPT{l}) {
    $QUEUE_OPTION = " -l $OPT{l}";
}

my $TMP_SCRIPT = "$ENV{DOMREFINE_QSUB_TMP}/$ENV{HOSTNAME}.$$.$PROGRAM.$JOB_NAME.sh";
open(SCRIPT, ">$TMP_SCRIPT") || die;
print SCRIPT '#$ -S /bin/sh', "\n";
print SCRIPT "@ARGV\n";
close(SCRIPT);

### Main ###
system "qsub $QUEUE_OPTION -V -N $JOB_NAME -e $ENV{DOMREFINE_QSUB_TMP} -o $ENV{DOMREFINE_QSUB_TMP} $ENV{DOMREFINE_QSUB_OPT} $TMP_SCRIPT";
