/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.CoreGeneCreater;
import cgdp.recog.align.CoreGeneTargetCondition;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.color.geneinfo.GeneColorCondition;
import cgdp.recog.color.geneinfo.GeneColorConditionFactory;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.info.gene.GeneInfoRegister;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CoreGenePropertyCreater
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenePropertyCreater.class);
    private Component parent;
    private MediatorImpl mediator;
    private GeneInfoTitle geneInfoTitle;
    private List organismList;
    private CoreGeneCreater coreGeneCreater;

    public CoreGenePropertyCreater(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, GeneInfoTitle geneInfoTitle, CoreGeneTargetCondition coreGeneTargetCondition, List list, GenomeAlign genomeAlign) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.geneInfoTitle = geneInfoTitle;
        this.organismList = list;
        this.coreGeneCreater = new CoreGeneCreater(geneInfoTitle, coreGeneTargetCondition, list, genomeAlign, clusterTbl);
    }

    public CoreGenePropertyCreater(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, GeneInfoTitle geneInfoTitle, CoreGeneTargetCondition coreGeneTargetCondition, List list, List list2) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.geneInfoTitle = geneInfoTitle;
        this.organismList = list;
        this.coreGeneCreater = new CoreGeneCreater(geneInfoTitle, coreGeneTargetCondition, list, list2, clusterTbl);
    }

    public void execute(ProgressImpl progressImpl) {
        this.coreGeneCreater.execute(progressImpl);
        if (this.coreGeneCreater.isCancel()) {
            this.setCancel(true);
            return;
        }
        if (this.coreGeneCreater.isError()) {
            this.setError(true);
            this.setErrorMessages(this.coreGeneCreater.getErrorMessages());
            return;
        }
        progressImpl.nextProc();
        progressImpl.setTotal(2);
        progressImpl.setCount(-1);
        progressImpl.increment();
        Set set = this.coreGeneCreater.getTargetOrganismCodeSet();
        Map map = this.coreGeneCreater.getOrganismCodeGeneInfoListMap();
        progressImpl.increment();
        try {
            this.geneInfoTitle.addAllOrganismCode(set);
            ArrayList<GeneInfoTitle> arrayList = new ArrayList<GeneInfoTitle>();
            arrayList.add(GeneInfoTitle.TITLE_ORGANISM_CODE);
            arrayList.add(GeneInfoTitle.TITLE_LOCUSTAG_SERVER);
            arrayList.add(this.geneInfoTitle);
            GeneInfoRegister.saveGeneInfo(this.geneInfoTitle.getLocationName(), arrayList, map);
        }
        catch (Exception exception) {
            String string = "Fail to save core gene's property.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
        progressImpl.increment();
    }

    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        List list = OrganismUtil.getOrganismCodeList(this.organismList);
        GeneColorCondition geneColorCondition = GeneColorConditionFactory.createEnumGeneColorCondition(new HashSet(list), this.geneInfoTitle, 2);
        this.mediator.showGeneInfoColorDialog(this.parent, null, geneColorCondition);
    }

    public static GeneInfoTitle createCoreGeneGeneInfoTitle(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.valueOf(0));
        arrayList.add(String.valueOf(1));
        GeneInfoTitle geneInfoTitle = GeneInfoTitle.createGeneInfoTitle(string, string, 3, "Global");
        geneInfoTitle.setEditable(true);
        geneInfoTitle.setElementList(arrayList);
        return geneInfoTitle;
    }
}

