/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignPreviewPanel;
import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.util.AbstractApplyDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class GlobalAlignPrintDialog
extends AbstractApplyDialog
implements ChangeListener {
    private static GlobalAlignPrintDialog GLOBAL_ALIGN_PRINT_DIALOG;
    private static final String TITLE = "Genome Comparison Viewer Preview";
    private MediatorImpl mediator;
    private GlobalAlignViewModel globalAlignViewModel;
    private JRadioButton zoomAutoButton;
    private JRadioButton zoomSpecButton;
    private JSpinner zoomSpinner;
    private JButton pageSettingButton;
    private GlobalAlignPreviewPanel globalAlignPreviewPanel;

    private GlobalAlignPrintDialog(Frame frame, MediatorImpl mediatorImpl, GlobalAlignViewModel globalAlignViewModel) {
        super(frame);
        this.mediator = mediatorImpl;
        this.globalAlignViewModel = globalAlignViewModel;
        this.createComponents();
    }

    static void createInstance(Frame frame, MediatorImpl mediatorImpl, GlobalAlignViewModel globalAlignViewModel) {
        GLOBAL_ALIGN_PRINT_DIALOG = new GlobalAlignPrintDialog(frame, mediatorImpl, globalAlignViewModel);
    }

    static GlobalAlignPrintDialog getInstance() {
        return GLOBAL_ALIGN_PRINT_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        JLabel jLabel = new JLabel("Page setting");
        this.pageSettingButton = new JButton("Show");
        this.pageSettingButton.addActionListener(this);
        this.globalAlignPreviewPanel = new GlobalAlignPreviewPanel(this.globalAlignViewModel, this.mediator.getPageFormat());
        JPanel jPanel = new JPanel();
        jPanel.add(this.globalAlignPreviewPanel);
        jPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createZoomPanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(15, 10, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.pageSettingButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(15, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(2, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 0, new Insets(15, 0, 10, 0), 0, 0));
        this.updateValue();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void updateValue() {
        this.zoomAutoButton.setSelected(this.globalAlignViewModel.isPrintZoomAuto());
        this.zoomSpecButton.setSelected(!this.globalAlignViewModel.isPrintZoomAuto());
        this.globalAlignPreviewPanel.updateValue(this.globalAlignViewModel, this.mediator.getPageFormat());
        this.setEnabledZoom();
    }

    private void setEnabledZoom() {
        this.zoomSpinner.setEnabled(this.zoomSpecButton.isSelected());
    }

    private JPanel createZoomPanel() {
        JLabel jLabel = new JLabel("Zoom");
        this.zoomAutoButton = new JRadioButton("Auto");
        this.zoomAutoButton.addActionListener(this);
        this.zoomSpecButton = new JRadioButton("Specification(%)");
        this.zoomSpecButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.zoomAutoButton);
        buttonGroup.add(this.zoomSpecButton);
        this.zoomAutoButton.setSelected(true);
        this.zoomSpinner = new JSpinner(new SpinnerNumberModel(10.0, 0.05, 10.0, 0.05));
        this.zoomSpinner.setValue(new Double(1.0));
        this.zoomSpinner.addChangeListener(this);
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.zoomSpinner, "0%");
        this.zoomSpinner.setEditor(numberEditor);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.zoomAutoButton, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        jPanel.add((Component)this.zoomSpecButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        jPanel.add((Component)this.zoomSpinner, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void updatePreview() {
        this.globalAlignPreviewPanel.updateValue(this.isZoomAuto(), this.getZoomScale(), this.mediator.getPageFormat());
    }

    private boolean isZoomAuto() {
        return this.zoomAutoButton.isSelected();
    }

    private double getZoomScale() {
        return (Double)this.zoomSpinner.getValue();
    }

    protected boolean check() {
        return true;
    }

    protected boolean apply() {
        this.globalAlignViewModel.setPrintZoomAuto(this.isZoomAuto());
        this.globalAlignViewModel.setPrintZoomSpecValue(this.getZoomScale());
        this.mediator.printGlobalAlign(this.globalAlignViewModel);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.pageSettingButton) {
            this.mediator.pageSetup();
            this.updatePreview();
        } else if (actionEvent.getSource() == this.zoomAutoButton) {
            this.setEnabledZoom();
            this.updatePreview();
        } else if (actionEvent.getSource() == this.zoomSpecButton) {
            this.setEnabledZoom();
            this.updatePreview();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.zoomSpinner) {
            this.updatePreview();
        }
    }
}

