/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.align;

import cgdp.recog.align.GlobalAlignViewModel;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismNamePanel;
import cgdp.recog.organism.OrganismSelectPanel;
import cgdp.recog.organism.OrganismViewModel;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.SliderTextPanel;
import cgdp.recog.util.TabPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;

public class GlobalAlignViewOptionPanel
extends TabPanel
implements ActionListener {
    private MediatorImpl mediator;
    private GlobalAlignViewModel globalAlignViewModel;
    private OrganismSelectPanel organismSelectPanel;
    private OrganismNamePanel organismNamePanel;
    private JCheckBox coreCheckBox;
    private JCheckBox nonCoreCheckBox;
    private JCheckBox rnaCheckBox;
    private JCheckBox coreUniversalCheckBox;
    private JCheckBox coreOneToOneCheckBox;
    private JCheckBox coreLineCheckBox;
    private JCheckBox nonCoreUniversalCheckBox;
    private JCheckBox nonCoreUniqueCheckBox;
    private JCheckBox nonCoreOneToOneCheckBox;
    private JCheckBox nonCoreLineCheckBox;
    private JCheckBox locusTagShowCheckBox;
    private SliderTextPanel labelRowPanel;

    GlobalAlignViewOptionPanel(Component component, MediatorImpl mediatorImpl, GlobalAlignViewModel globalAlignViewModel) {
        super(component);
        this.mediator = mediatorImpl;
        this.globalAlignViewModel = globalAlignViewModel;
        this.createComponents();
    }

    private void createComponents() {
        this.organismSelectPanel = new OrganismSelectPanel(this.globalAlignViewModel.getGlobalAlign().getOrganismList(), this.globalAlignViewModel.getOrganismViewModel().getViewOrganismList(), null, true);
        this.organismNamePanel = new OrganismNamePanel(2);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.organismSelectPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.createDisplayPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.organismNamePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.createLabelPanel(), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
        this.updateValue();
    }

    private JPanel createDisplayPanel() {
        this.coreCheckBox = new JCheckBox("Core genes");
        this.coreCheckBox.addActionListener(this);
        this.coreLineCheckBox = new JCheckBox("Line:");
        this.coreLineCheckBox.addActionListener(this);
        this.coreUniversalCheckBox = new JCheckBox("Universal Only");
        this.coreOneToOneCheckBox = new JCheckBox("1vs1 Only");
        this.nonCoreCheckBox = new JCheckBox("Non-Core genes");
        this.nonCoreCheckBox.addActionListener(this);
        this.nonCoreLineCheckBox = new JCheckBox("Line:");
        this.nonCoreLineCheckBox.addActionListener(this);
        this.nonCoreUniversalCheckBox = new JCheckBox("Universal Only");
        this.nonCoreUniqueCheckBox = new JCheckBox("Unique Only");
        this.nonCoreUniqueCheckBox.addActionListener(this);
        this.nonCoreOneToOneCheckBox = new JCheckBox("1vs1 Only");
        JLabel jLabel = new JLabel("(");
        JLabel jLabel2 = new JLabel(")");
        this.rnaCheckBox = new JCheckBox("RNA");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.nonCoreCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 20, 2, 0), 0, 0));
        jPanel.add((Component)this.nonCoreUniqueCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Display elements"));
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)this.coreCheckBox, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.coreLineCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 20, 2, 2), 0, 0));
        jPanel2.add((Component)this.coreUniversalCheckBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.coreOneToOneCheckBox, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.nonCoreLineCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 20, 2, 2), 0, 0));
        jPanel2.add((Component)this.nonCoreUniversalCheckBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.nonCoreOneToOneCheckBox, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel2.add((Component)this.rnaCheckBox, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        return jPanel2;
    }

    private JPanel createLabelPanel() {
        this.locusTagShowCheckBox = new JCheckBox("Show");
        JLabel jLabel = new JLabel("Row count:");
        this.labelRowPanel = new SliderTextPanel(){

            public void stateChanged(ChangeEvent changeEvent) {
                super.stateChanged(changeEvent);
                GlobalAlignViewOptionPanel.this.locusTagShowCheckBox.setEnabled(this.getValue() != 0.0);
            }
        };
        this.labelRowPanel.setMinimum(0);
        this.labelRowPanel.setMaximum(5);
        this.labelRowPanel.setValue(this.globalAlignViewModel.getMaxLabelRowCount());
        this.labelRowPanel.setTextColumns(3);
        this.labelRowPanel.setPaintTicks(true);
        this.labelRowPanel.setPaintLabels(true);
        this.labelRowPanel.setLabelTable(1);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Locus tag"));
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.locusTagShowCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 10), 0, 0));
        jPanel.add((Component)this.labelRowPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 2, 2), 0, 0));
        return jPanel;
    }

    private void setEnableDisplayElementParts() {
        if (this.coreCheckBox.isSelected()) {
            this.coreLineCheckBox.setEnabled(true);
            if (this.coreLineCheckBox.isSelected()) {
                this.coreUniversalCheckBox.setEnabled(true);
                this.coreOneToOneCheckBox.setEnabled(true);
            } else {
                this.coreUniversalCheckBox.setEnabled(false);
                this.coreOneToOneCheckBox.setEnabled(false);
            }
        } else {
            this.coreLineCheckBox.setEnabled(false);
            this.coreUniversalCheckBox.setEnabled(false);
            this.coreOneToOneCheckBox.setEnabled(false);
        }
        if (this.nonCoreCheckBox.isSelected()) {
            this.nonCoreUniqueCheckBox.setEnabled(true);
            if (!this.nonCoreUniqueCheckBox.isSelected()) {
                this.nonCoreLineCheckBox.setEnabled(true);
                if (this.nonCoreLineCheckBox.isSelected()) {
                    this.nonCoreUniversalCheckBox.setEnabled(true);
                    this.nonCoreOneToOneCheckBox.setEnabled(true);
                } else {
                    this.nonCoreUniversalCheckBox.setEnabled(false);
                    this.nonCoreOneToOneCheckBox.setEnabled(false);
                }
            } else {
                this.nonCoreLineCheckBox.setEnabled(false);
                this.nonCoreUniversalCheckBox.setEnabled(false);
                this.nonCoreOneToOneCheckBox.setEnabled(false);
            }
        } else {
            this.nonCoreUniqueCheckBox.setEnabled(false);
            this.nonCoreLineCheckBox.setEnabled(false);
            this.nonCoreUniversalCheckBox.setEnabled(false);
            this.nonCoreOneToOneCheckBox.setEnabled(false);
        }
    }

    private void updateValue() {
        this.updateValue(this.globalAlignViewModel);
    }

    private void updateValue(GlobalAlignViewModel globalAlignViewModel) {
        this.coreCheckBox.setSelected(globalAlignViewModel.isShowCore());
        this.coreLineCheckBox.setSelected(globalAlignViewModel.isShowCoreLine());
        this.coreUniversalCheckBox.setSelected(globalAlignViewModel.isShowCoreUniversal());
        this.coreOneToOneCheckBox.setSelected(globalAlignViewModel.isShowCoreOneToOne());
        this.nonCoreCheckBox.setSelected(globalAlignViewModel.isShowNonCore());
        this.nonCoreLineCheckBox.setSelected(globalAlignViewModel.isShowNonCoreLine());
        this.nonCoreUniversalCheckBox.setSelected(globalAlignViewModel.isShowNonCoreUniversal());
        this.nonCoreUniqueCheckBox.setSelected(globalAlignViewModel.isShowNonCoreUnique());
        this.nonCoreOneToOneCheckBox.setSelected(globalAlignViewModel.isShowNonCoreOneToOne());
        this.rnaCheckBox.setSelected(globalAlignViewModel.isShowRna());
        OrganismViewModel organismViewModel = globalAlignViewModel.getOrganismViewModel();
        this.organismNamePanel.setOrganismNameType(organismViewModel.getOrganismNameType());
        this.organismNamePanel.setAddStrainToName(organismViewModel.isAddStrainToName());
        this.organismSelectPanel.setReferenceOrganism(globalAlignViewModel.getReferenceOrganism());
        this.locusTagShowCheckBox.setSelected(globalAlignViewModel.isShowLocusTag());
        this.labelRowPanel.setValue(globalAlignViewModel.getMaxLabelRowCount());
        this.setEnableDisplayElementParts();
    }

    protected void changeDefault() {
        GlobalAlignViewModel globalAlignViewModel = new GlobalAlignViewModel();
        this.updateValue(globalAlignViewModel);
        this.organismSelectPanel.setReferenceOrganism(this.globalAlignViewModel.getReferenceOrganism());
    }

    public boolean check() {
        if (!this.organismSelectPanel.isExistViewOrganism()) {
            MessageManager.showErrorMessage((Component)this, "Select organism");
            return false;
        }
        return true;
    }

    protected void updateParameters() {
        Organism organism = this.organismSelectPanel.getReferenceOrganism();
        this.globalAlignViewModel.setReferenceOrganism(organism);
        List list = this.organismSelectPanel.getTargetOrganismList();
        int n = this.organismNamePanel.getOrganismNameType();
        boolean bl = this.organismNamePanel.isAddStrainToName();
        OrganismViewModel organismViewModel = this.globalAlignViewModel.getOrganismViewModel();
        organismViewModel.setViewOrganismList(list);
        organismViewModel.setOrganismNameType(n);
        organismViewModel.setAddStrainToName(bl);
        System.err.println(organismViewModel.getViewOrganismNameList());
        this.globalAlignViewModel.setShowCore(this.coreCheckBox.isSelected());
        this.globalAlignViewModel.setShowCoreLine(this.coreLineCheckBox.isSelected());
        this.globalAlignViewModel.setShowCoreUniversal(this.coreUniversalCheckBox.isSelected());
        this.globalAlignViewModel.setShowCoreOneToOne(this.coreOneToOneCheckBox.isSelected());
        this.globalAlignViewModel.setShowNonCore(this.nonCoreCheckBox.isSelected());
        this.globalAlignViewModel.setShowNonCoreLine(this.nonCoreLineCheckBox.isSelected());
        this.globalAlignViewModel.setShowNonCoreUnique(this.nonCoreUniqueCheckBox.isSelected());
        this.globalAlignViewModel.setShowNonCoreUniversal(this.nonCoreUniversalCheckBox.isSelected());
        this.globalAlignViewModel.setShowNonCoreOneToOne(this.nonCoreOneToOneCheckBox.isSelected());
        this.globalAlignViewModel.setShowRna(this.rnaCheckBox.isSelected());
        this.globalAlignViewModel.setShowLocusTag(this.locusTagShowCheckBox.isSelected());
        this.globalAlignViewModel.setMaxLabelRowCount((int)this.labelRowPanel.getValue());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.coreCheckBox || actionEvent.getSource() == this.coreLineCheckBox || actionEvent.getSource() == this.nonCoreCheckBox || actionEvent.getSource() == this.nonCoreLineCheckBox || actionEvent.getSource() == this.nonCoreUniqueCheckBox) {
            this.setEnableDisplayElementParts();
        }
    }
}

