/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.bean;

import cgdp.recog.bean.ClusterHScrollBar;
import cgdp.recog.bean.ClusterMap;
import cgdp.recog.bean.ClusterScrollPane;
import cgdp.recog.bean.ClusterVScrollBar;
import cgdp.recog.bean.HeaderMap;
import cgdp.recog.bean.HeaderScrollPane;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.ppm.PPMContext;
import cgdp.recog.system.KeyBindUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ClusterArea
extends JPanel
implements MouseWheelListener {
    private MediatorImpl m_mediatorImpl;
    private JPanel m_spacePanel;
    private Action pageDownAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClusterArea.this.m_mediatorImpl.pageDownClusterMap();
        }
    };
    private Action pageUpAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClusterArea.this.m_mediatorImpl.pageUpClusterMap();
        }
    };
    private Action ctrlPageDownAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClusterArea.this.m_mediatorImpl.halfPageDownClusterMap();
        }
    };
    private Action ctrlPageUpAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClusterArea.this.m_mediatorImpl.halfPageUpClusterMap();
        }
    };
    private Action scrollDownAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClusterArea.this.m_mediatorImpl.scrollDownClusterMap();
        }
    };
    private Action scrollUpAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClusterArea.this.m_mediatorImpl.scrollUpClusterMap();
        }
    };
    private Action scrollLeftAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClusterArea.this.m_mediatorImpl.scrollLeftClusterMap();
        }
    };
    private Action scrollRightAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClusterArea.this.m_mediatorImpl.scrollRightClusterMap();
        }
    };
    private Action homeAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClusterArea.this.m_mediatorImpl.moveToHomeClusterMap();
        }
    };
    private Action endAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            ClusterArea.this.m_mediatorImpl.moveToEndClusterMap();
        }
    };

    public ClusterArea(MediatorImpl mediatorImpl) {
        this.m_mediatorImpl = mediatorImpl;
        this.m_mediatorImpl.register(this);
        this.createComponent();
    }

    private void createComponent() {
        PPMContext pPMContext = new PPMContext();
        HeaderMap headerMap = new HeaderMap(this.m_mediatorImpl, pPMContext);
        HeaderScrollPane headerScrollPane = new HeaderScrollPane(this.m_mediatorImpl, headerMap);
        ClusterMap clusterMap = new ClusterMap(this.m_mediatorImpl, pPMContext);
        ClusterScrollPane clusterScrollPane = new ClusterScrollPane(this.m_mediatorImpl, clusterMap);
        clusterScrollPane.getViewport().addMouseWheelListener(this);
        this.registerKeys(this);
        ClusterVScrollBar clusterVScrollBar = new ClusterVScrollBar(this.m_mediatorImpl);
        ClusterHScrollBar clusterHScrollBar = new ClusterHScrollBar(this.m_mediatorImpl);
        Dimension dimension = clusterHScrollBar.getPreferredSize();
        this.m_spacePanel = new JPanel();
        this.m_spacePanel.setPreferredSize(new Dimension(dimension.height, dimension.height));
        this.m_spacePanel.setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)clusterScrollPane, "Center");
        jPanel.add((Component)clusterVScrollBar, "East");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        jPanel2.add((Component)clusterHScrollBar, "Center");
        jPanel2.add((Component)this.m_spacePanel, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)headerScrollPane, "North");
        this.add((Component)jPanel, "Center");
        this.setFocusable(true);
        clusterScrollPane.setFocusable(false);
        clusterVScrollBar.setFocusable(false);
        clusterHScrollBar.setFocusable(false);
    }

    public void setSpace(boolean bl) {
        this.m_spacePanel.setVisible(bl);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollType() == 0) {
            if (KeyBindUtil.isKeyPressedForVerticalWheelZoom(mouseWheelEvent)) {
                this.m_mediatorImpl.verticalZoomClusterMap(mouseWheelEvent.getUnitsToScroll());
            } else if (KeyBindUtil.isKeyPressedForHorizontalWheelZoom(mouseWheelEvent)) {
                this.m_mediatorImpl.horizontalZoomClusterMap(mouseWheelEvent.getUnitsToScroll());
            } else {
                this.m_mediatorImpl.scrollClusterMap(mouseWheelEvent.getUnitsToScroll());
            }
        }
    }

    private void registerKeys(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(KeyBindUtil.getPageDownKey(), 0, false);
        inputMap.put(keyStroke, "PAGE_DOWN");
        actionMap.put("PAGE_DOWN", this.pageDownAction);
        keyStroke = KeyStroke.getKeyStroke(KeyBindUtil.getPageUpKey(), 0, false);
        inputMap.put(keyStroke, "PAGE_UP");
        actionMap.put("PAGE_UP", this.pageUpAction);
        keyStroke = KeyStroke.getKeyStroke(KeyBindUtil.getPageDownKey(), KeyBindUtil.getCtrlMetaMask(), true);
        inputMap.put(keyStroke, "CTRL_PAGE_DOWN");
        actionMap.put("CTRL_PAGE_DOWN", this.ctrlPageDownAction);
        keyStroke = KeyStroke.getKeyStroke(KeyBindUtil.getPageUpKey(), KeyBindUtil.getCtrlMetaMask(), true);
        inputMap.put(keyStroke, "CTRL_PAGE_UP");
        actionMap.put("CTRL_PAGE_UP", this.ctrlPageUpAction);
        keyStroke = KeyStroke.getKeyStroke(KeyBindUtil.getScrollLeftKey(), 0, false);
        inputMap.put(keyStroke, "LEFT");
        actionMap.put("LEFT", this.scrollLeftAction);
        keyStroke = KeyStroke.getKeyStroke(KeyBindUtil.getScrollRightKey(), 0, false);
        inputMap.put(keyStroke, "RIGHT");
        actionMap.put("RIGHT", this.scrollRightAction);
        keyStroke = KeyStroke.getKeyStroke(KeyBindUtil.getScrollDownKey(), 0, false);
        inputMap.put(keyStroke, "DOWN");
        actionMap.put("DOWN", this.scrollDownAction);
        keyStroke = KeyStroke.getKeyStroke(KeyBindUtil.getScrollUpKey(), 0, false);
        inputMap.put(keyStroke, "UP");
        actionMap.put("UP", this.scrollUpAction);
        keyStroke = KeyStroke.getKeyStroke(KeyBindUtil.getHomeKey(), 0, false);
        inputMap.put(keyStroke, "HOME");
        actionMap.put("HOME", this.homeAction);
        keyStroke = KeyStroke.getKeyStroke(KeyBindUtil.getEndKey(), 0, false);
        inputMap.put(keyStroke, "END");
        actionMap.put("END", this.endAction);
    }
}

