/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.bean;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.StringTool;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class LabelTransferHandler
extends TransferHandler {
    private static final ApplicationLogger logger = new ApplicationLogger(LabelTransferHandler.class);
    private MediatorImpl m_mediatorImpl;

    public LabelTransferHandler(MediatorImpl mediatorImpl) {
        this.m_mediatorImpl = mediatorImpl;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!DataFlavor.stringFlavor.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        String string = "";
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            if (string.startsWith("<<FILTER>>")) {
                return this.removeFilterCondition(string);
            }
            if (string.startsWith("<<FILTER_SP>>")) {
                return this.removeSpFromCondition(string);
            }
            if (string.startsWith("<<SPGROUP>>")) {
                return this.removeSpGroup(string);
            }
            if (string.startsWith("<<SPGROUP_SP>>")) {
                return this.removeSpFromSpGroup(string);
            }
            return true;
        }
        catch (Exception exception) {
            logger.warn("Fail to remove." + string, exception);
            return false;
        }
    }

    private boolean removeFilterCondition(String string) throws Exception {
        HashSet<Long> hashSet = new HashSet<Long>();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while ((string = bufferedReader.readLine()) != null) {
            hashSet.add(new Long(string.substring("<<FILTER>>".length())));
        }
        bufferedReader.close();
        this.m_mediatorImpl.removeFilterConditions(hashSet);
        return true;
    }

    private boolean removeSpFromCondition(String string) throws Exception {
        HashMap<Long, HashSet<String>> hashMap = new HashMap<Long, HashSet<String>>();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while ((string = bufferedReader.readLine()) != null) {
            Vector vector = StringTool.splitString(string = string.substring("<<FILTER_SP>>".length()), ";;");
            Long l = new Long(String.valueOf(vector.get(0)));
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(l);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put(l, hashSet);
            }
            hashSet.add(String.valueOf(vector.get(1)));
        }
        bufferedReader.close();
        this.m_mediatorImpl.removeSpFromCondition(hashMap);
        return true;
    }

    private boolean removeSpGroup(String string) throws Exception {
        HashSet<Long> hashSet = new HashSet<Long>();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while ((string = bufferedReader.readLine()) != null) {
            hashSet.add(new Long(string.substring("<<SPGROUP>>".length())));
        }
        bufferedReader.close();
        this.m_mediatorImpl.removeSpGroups(hashSet);
        return true;
    }

    private boolean removeSpFromSpGroup(String string) throws Exception {
        HashMap<Long, HashSet<String>> hashMap = new HashMap<Long, HashSet<String>>();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while ((string = bufferedReader.readLine()) != null) {
            Vector vector = StringTool.splitString(string = string.substring("<<SPGROUP_SP>>".length()), ";;");
            Long l = new Long(String.valueOf(vector.get(0)));
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(l);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put(l, hashSet);
            }
            hashSet.add(String.valueOf(vector.get(1)));
        }
        bufferedReader.close();
        this.m_mediatorImpl.removeSpFromSpGroup(hashMap);
        return true;
    }
}

