/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.calc;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.calc.CoefCondition;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoCategory;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoCalcCondition;
import cgdp.recog.info.cluster.ClusterInfoCalculator;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoType;
import cgdp.recog.info.cluster.ClusterInfoUtil;
import cgdp.recog.pattern.Pattern;
import cgdp.recog.pattern.PatternFactory;
import cgdp.recog.ppm.PPMLabelConditionFactory;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.sort.GeneInfoSortConditionGroup;
import cgdp.recog.sort.SortConditionFactory;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoefCalcExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(CoefCalcExecuter.class);
    private Component parent;
    private MediatorImpl mediator;
    private List clusterList = new ArrayList();
    private CoefCondition coefCondition;

    public CoefCalcExecuter(Component component, MediatorImpl mediatorImpl, List list, CoefCondition coefCondition) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.clusterList = list;
        this.coefCondition = coefCondition;
    }

    public void execute(ProgressImpl progressImpl) {
        try {
            Object object;
            Object object2;
            Object object3;
            progressImpl.setTotal(this.getPrograssTotal());
            if (this.coefCondition.isGeneProperty()) {
                object3 = this.coefCondition.getPattern().getOrganismCodeListWithoutIgnore();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    if (progressImpl.isCanceled()) {
                        this.setCancel(true);
                        return;
                    }
                    progressImpl.increment();
                    object = (String)object2.next();
                    this.coefCondition.loadInfo((String)object, this.clusterList);
                }
            }
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.increment();
            if (this.coefCondition.isNeedCalcPatternForProperty()) {
                object3 = this.coefCondition.getPattern();
                object2 = this.coefCondition.getBaseCluster();
                PatternFactory.updateBasePatternForProperty((Pattern)object3, this.coefCondition.getOrganismCodeList(), (Cluster)object2, this.coefCondition);
            }
            object3 = this.coefCondition.createClusterInfoTitle();
            object2 = new ClusterInfoCalcCondition();
            ((ClusterInfoCalcCondition)object2).setOrganismCodeList(this.coefCondition.getOrganismCodeList());
            ((ClusterInfoCalcCondition)object2).setCoefCondition(this.coefCondition);
            ((ClusterInfoCalcCondition)object2).setDomClustId(this.coefCondition.getDomClustId());
            object = CoefCalcExecuter.calcCoefMap(this.clusterList, (ClusterInfoTitle)object3, (ClusterInfoCalcCondition)object2);
            progressImpl.increment();
            Map map = ClusterInfoUtil.convertClusterInfoKeyMap((Map)object, this.coefCondition.getClusterInfoType());
            if (this.coefCondition.isSave()) {
                ClusterInfoFacade.saveClusterInfo((ClusterInfoTitle)object3, map, this.coefCondition.getDomClustId(), this.coefCondition.getClusterInfoType());
            }
            progressImpl.increment();
            ClusterInfoFacade.addClusterInfo(map, (ClusterInfoTitle)object3, ((AbstractInfoTitle)object3).getInfoType());
            progressImpl.increment();
        }
        catch (Exception exception) {
            String string = "Fail to calculate pattern correlation.";
            this.setError(true);
            this.setErrorMessage(string);
            logger.warn(string, exception);
        }
    }

    private static Map calcCoefMap(List list, ClusterInfoTitle clusterInfoTitle, ClusterInfoCalcCondition clusterInfoCalcCondition) {
        HashMap hashMap = new HashMap();
        if (ClusterInfoType.isCluster(clusterInfoTitle.getInfoType())) {
            List list2 = ClusterTbl.createSuperClusterListByCluster(list);
            CoefCalcExecuter.calcCoefCore(list2, clusterInfoTitle, clusterInfoCalcCondition, hashMap);
        } else if (ClusterInfoType.isSubCluster(clusterInfoTitle.getInfoType())) {
            CoefCalcExecuter.calcCoefCore(list, clusterInfoTitle, clusterInfoCalcCondition, hashMap);
        }
        return hashMap;
    }

    private static void calcCoefCore(List list, ClusterInfoTitle clusterInfoTitle, ClusterInfoCalcCondition clusterInfoCalcCondition, Map map) {
        for (Cluster cluster : list) {
            Object object;
            if (InfoCategory.isPatternCoef(clusterInfoTitle.getCategory())) {
                object = CoefCalcExecuter.getPatternCoefValue(cluster, clusterInfoCalcCondition);
            } else {
                if (!InfoCategory.isNumCoef(clusterInfoTitle.getCategory())) continue;
                object = CoefCalcExecuter.getNumCoefValue(cluster, clusterInfoCalcCondition);
            }
            ClusterInfo clusterInfo = new ClusterInfo();
            clusterInfo.putInfo(clusterInfoTitle, object);
            ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
            if (cluster instanceof SuperCluster) {
                arrayList.addAll(((SuperCluster)cluster).getSubClusterList());
            } else {
                arrayList.add(cluster);
            }
            for (Cluster cluster2 : arrayList) {
                ClusterInfo clusterInfo2 = (ClusterInfo)map.get(cluster2);
                if (clusterInfo2 == null) {
                    clusterInfo2 = new ClusterInfo();
                    map.put(cluster2, clusterInfo2);
                }
                clusterInfo2.putAllInfo(clusterInfo);
            }
        }
    }

    private static Object getPatternCoefValue(Cluster cluster, ClusterInfoCalcCondition clusterInfoCalcCondition) {
        return new Float(ClusterInfoCalculator.getPatternCoef(cluster, clusterInfoCalcCondition));
    }

    private static Object getNumCoefValue(Cluster cluster, ClusterInfoCalcCondition clusterInfoCalcCondition) {
        return new Float(ClusterInfoCalculator.getNumVectCoef(cluster, clusterInfoCalcCondition));
    }

    public int getPrograssTotal() {
        return this.coefCondition.getOrganismCodeList().size() + 4;
    }

    public void done() {
        ClusterInfoTitle clusterInfoTitle;
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        if (this.coefCondition.isSave()) {
            clusterInfoTitle = this.coefCondition.createClusterInfoTitle();
            this.mediator.registerPPMLabel(PPMLabelConditionFactory.createRegClusterInfoLabelCondition(clusterInfoTitle, this.coefCondition.isOutgroup()));
        } else {
            this.mediator.registerPPMLabel(PPMLabelConditionFactory.createPatternCoefLabelCondition(this.coefCondition.isOutgroup()));
        }
        if (this.coefCondition.isSort()) {
            clusterInfoTitle = this.coefCondition.createClusterInfoTitle();
            GeneInfoSortConditionGroup geneInfoSortConditionGroup = SortConditionFactory.createInfoConditionGroup(null, clusterInfoTitle);
            this.mediator.sortClusterList(geneInfoSortConditionGroup);
        }
    }
}

