/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeAnalysis;
import cgdp.recog.coregenome.CoreGenomeDownloader;
import cgdp.recog.coregenome.CoreGenomeFacade;
import cgdp.recog.coregenome.CoreGenomeFileUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import java.awt.Component;

public class CoreGenomeDownloadExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenomeDownloadExecuter.class);
    private Component parent;
    private CoreGenomeAnalysis analysis;
    private String domClustViewId;

    public CoreGenomeDownloadExecuter(Component component, CoreGenomeAnalysis coreGenomeAnalysis, String string) {
        this.analysis = coreGenomeAnalysis;
        this.domClustViewId = string;
    }

    public void execute(ProgressImpl progressImpl) {
        try {
            CoreGenomeAnalysis coreGenomeAnalysis = this.analysis;
            CoreGenomeDownloader coreGenomeDownloader = new CoreGenomeDownloader(coreGenomeAnalysis.getDomClustId(), this.domClustViewId, coreGenomeAnalysis.getCoreGenomeId());
            coreGenomeDownloader.execute();
            String string = CoreGenomeFileUtil.createCoreGenomeFilepath(this.analysis.getProject(), this.analysis.getName());
            FileUtil.outputFile(coreGenomeDownloader.getContents(), string);
            CoreGenomeFacade.saveCoreGenomeAnalysis(coreGenomeAnalysis.getProject(), coreGenomeAnalysis);
        }
        catch (Exception exception) {
            String string = "Fail to download core genome alignment result.";
            logger.warn(string, exception);
        }
    }

    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        Runnable runnable = this.getAfterRunnable();
        if (runnable != null) {
            runnable.run();
        }
    }
}

