/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.data.TaxonomyTbl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismComparator;
import cgdp.recog.organism.OrganismSelectPanel;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.SliderTextPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CoreGenomeExecuteDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Core Genome Alignment";
    private static final String CHANGE_BUTTON_TEXT_SIMPLE = "<<Simple";
    private static final String CHANGE_BUTTON_TEXT_EXPERT = ">>Expert";
    private static final String LABEL_USER_SP_GROUP = "Use sp group";
    private MediatorImpl mediator;
    private List organismList;
    private String domClustId;
    private String clusterViewId;
    private String domClustName;
    private Container panelContainer;
    private JPanel simplePanel;
    private JPanel expertPanel;
    private JComboBox referenceOrganismComboBox;
    private SliderTextPanel ratioConservedPanel;
    private SliderTextPanel simpleWindowSizePanel;
    private JCheckBox simpleSpGroupCheckBox;
    private OrganismSelectPanel organismSelectPanel;
    private SliderTextPanel orthologPanel;
    private SliderTextPanel connectionPanel;
    private SliderTextPanel expertWindowSizePanel;
    private JCheckBox expertSpGroupCheckBox;
    private SliderTextPanel expertMinClustSizPanel;
    private SliderTextPanel expertMinSpCovPanel;
    private SliderTextPanel expertSpCovRegCutPanel;
    private SliderTextPanel expertSpCovSpRatioPanel;
    private FocusTextField otherOptionTextField;
    private JButton changeButton;
    private boolean simpleFlag;

    public CoreGenomeExecuteDialog(Frame frame, MediatorImpl mediatorImpl, List list, String string, String string2, String string3) {
        super(frame);
        this.mediator = mediatorImpl;
        this.organismList = list;
        this.domClustId = string;
        this.clusterViewId = string2;
        this.domClustName = string3;
        this.createComponents();
    }

    protected void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.changeButton = new JButton(CHANGE_BUTTON_TEXT_EXPERT);
        this.changeButton.addActionListener(this);
        this.simplePanel = this.createSimplePanel();
        this.expertPanel = this.createExpertPanel();
        this.panelContainer = new JPanel();
        this.panelContainer.add(this.simplePanel);
        this.simpleFlag = true;
        this.setApplyButtonName("Run");
        this.setCloseButtonName("Cancel");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.changeButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        jPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.panelContainer, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.updateValue();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateValue() {
        OptionTbl optionTbl = OptionTbl.getInstance();
        CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = optionTbl.getOptionValues().getCoreGenomeAlignmentCondition();
        this.ratioConservedPanel.setValue((int)(coreGenomeAlignmentCondition.getOrthologRate() * 100.0));
        this.orthologPanel.setValue((int)(coreGenomeAlignmentCondition.getOrthologRate() * 100.0));
        this.connectionPanel.setValue((int)(coreGenomeAlignmentCondition.getConnectionRate() * 100.0));
        this.simpleSpGroupCheckBox.setSelected(coreGenomeAlignmentCondition.isUseSpGroup());
        this.expertSpGroupCheckBox.setSelected(coreGenomeAlignmentCondition.isUseSpGroup());
        this.expertMinSpCovPanel.setValue((int)(coreGenomeAlignmentCondition.getMinSpCov() * 100.0));
        this.expertSpCovRegCutPanel.setValue((int)coreGenomeAlignmentCondition.getSpCovRegCut());
        this.expertSpCovSpRatioPanel.setValue((int)(coreGenomeAlignmentCondition.getSpCovSpRatio() * 100.0));
        this.expertMinClustSizPanel.setValue(coreGenomeAlignmentCondition.getMinClustSiz());
        this.otherOptionTextField.setText(coreGenomeAlignmentCondition.getOtherOptions());
        this.simpleWindowSizePanel.setValue(coreGenomeAlignmentCondition.getWindowSize());
        this.expertWindowSizePanel.setValue(coreGenomeAlignmentCondition.getWindowSize());
    }

    private JPanel createSimplePanel() {
        Object object;
        JLabel jLabel = new JLabel("Reference Genome:");
        List list = this.getTargetOrganismList();
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object = (Organism)list.get(i);
            stringArray[i] = ((Organism)object).getAbbrev() + " " + ((Organism)object).getStrain();
        }
        this.referenceOrganismComboBox = new JComboBox<String>(stringArray);
        JLabel jLabel2 = new JLabel("Cutoff ratio of conserved genes and connections (%):");
        this.ratioConservedPanel = new SliderTextPanel();
        this.ratioConservedPanel.setMinimum(0);
        this.ratioConservedPanel.setMaximum(100);
        this.ratioConservedPanel.setValue(50.0);
        this.ratioConservedPanel.setTextColumns(3);
        this.ratioConservedPanel.setPaintTicks(true);
        this.ratioConservedPanel.setPaintLabels(true);
        this.ratioConservedPanel.setLabelTable(20);
        object = new JLabel("Window Size:");
        this.simpleWindowSizePanel = new SliderTextPanel();
        this.simpleWindowSizePanel.setMinimum(5);
        this.simpleWindowSizePanel.setMaximum(80);
        this.simpleWindowSizePanel.setValue(20.0);
        this.simpleWindowSizePanel.setTextColumns(3);
        this.simpleWindowSizePanel.setPaintTicks(true);
        this.simpleWindowSizePanel.setPaintLabels(true);
        this.simpleWindowSizePanel.setLabelTable(15);
        this.simpleSpGroupCheckBox = new JCheckBox(LABEL_USER_SP_GROUP);
        this.simpleSpGroupCheckBox.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.referenceOrganismComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.ratioConservedPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)object, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.simpleWindowSizePanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.simpleSpGroupCheckBox, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createExpertPanel() {
        this.organismSelectPanel = new OrganismSelectPanel(this.organismList, this.getTargetOrganismList(), (Organism)this.organismList.get(0));
        JLabel jLabel = new JLabel("Cutoff ratio of conserved genes (%):");
        this.orthologPanel = new SliderTextPanel();
        this.orthologPanel.setMinimum(0);
        this.orthologPanel.setMaximum(100);
        this.orthologPanel.setValue(50.0);
        this.orthologPanel.setTextColumns(3);
        this.orthologPanel.setPaintTicks(true);
        this.orthologPanel.setPaintLabels(true);
        this.orthologPanel.setLabelTable(20);
        JLabel jLabel2 = new JLabel("Cutoff ratio of conserved connections (%):");
        this.connectionPanel = new SliderTextPanel();
        this.connectionPanel.setMinimum(0);
        this.connectionPanel.setMaximum(100);
        this.connectionPanel.setValue(50.0);
        this.connectionPanel.setTextColumns(3);
        this.connectionPanel.setPaintTicks(true);
        this.connectionPanel.setPaintLabels(true);
        this.connectionPanel.setLabelTable(20);
        JLabel jLabel3 = new JLabel("Window Size:");
        this.expertWindowSizePanel = new SliderTextPanel();
        this.expertWindowSizePanel.setMinimum(5);
        this.expertWindowSizePanel.setMaximum(80);
        this.expertWindowSizePanel.setValue(20.0);
        this.expertWindowSizePanel.setTextColumns(3);
        this.expertWindowSizePanel.setPaintTicks(true);
        this.expertWindowSizePanel.setPaintLabels(true);
        this.expertWindowSizePanel.setLabelTable(15);
        this.expertSpGroupCheckBox = new JCheckBox(LABEL_USER_SP_GROUP);
        this.expertSpGroupCheckBox.setSelected(true);
        JLabel jLabel4 = new JLabel("Minimum number of ortholog groups in each cluster");
        this.expertMinClustSizPanel = new SliderTextPanel();
        this.expertMinClustSizPanel.setMinimum(5);
        this.expertMinClustSizPanel.setMaximum(50);
        this.expertMinClustSizPanel.setValue(10.0);
        this.expertMinClustSizPanel.setTextColumns(3);
        this.expertMinClustSizPanel.setPaintTicks(true);
        this.expertMinClustSizPanel.setPaintLabels(true);
        this.expertMinClustSizPanel.setLabelTable(15);
        JLabel jLabel5 = new JLabel("Required coverage of each genome for each cluster (%)");
        this.expertMinSpCovPanel = SliderTextPanel.createRatioSliderTextPanel();
        JLabel jLabel6 = new JLabel("Cutoff of deletion score for removing local regions");
        this.expertSpCovRegCutPanel = new SliderTextPanel();
        this.expertSpCovRegCutPanel.setMinimum(0);
        this.expertSpCovRegCutPanel.setMaximum(50);
        this.expertSpCovRegCutPanel.setValue(20.0);
        this.expertSpCovRegCutPanel.setTextColumns(3);
        this.expertSpCovRegCutPanel.setPaintTicks(true);
        this.expertSpCovRegCutPanel.setPaintLabels(true);
        this.expertSpCovRegCutPanel.setLabelTable(10);
        JLabel jLabel7 = new JLabel("Cutoff ratio of species allowed to be deleted in a cluster (%)");
        this.expertSpCovSpRatioPanel = SliderTextPanel.createRatioSliderTextPanel();
        JLabel jLabel8 = new JLabel("Other Options");
        this.otherOptionTextField = new FocusTextField();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.organismSelectPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.orthologPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.connectionPanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.expertWindowSizePanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.expertMinSpCovPanel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel6, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.expertSpCovRegCutPanel, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel7, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.expertSpCovSpRatioPanel, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.expertMinClustSizPanel, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel8, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.otherOptionTextField, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.expertSpGroupCheckBox, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        return jPanel;
    }

    private List getTargetOrganismList() {
        ArrayList arrayList = new ArrayList(this.organismList);
        TaxonomyTbl taxonomyTbl = new TaxonomyTbl();
        taxonomyTbl.read();
        Collections.sort(arrayList, new OrganismComparator(taxonomyTbl.getGenomeOrganismCodeIndexMap()));
        return arrayList;
    }

    protected boolean check() {
        if (!this.simpleFlag && this.organismSelectPanel.getTargetOrganismList().isEmpty()) {
            MessageManager.showErrorMessage((Component)this, "Select displayed organisms.");
            return false;
        }
        return true;
    }

    protected boolean apply() {
        String string;
        int n;
        double d;
        double d2;
        double d3;
        boolean bl;
        int n2;
        double d4;
        double d5;
        List list;
        Organism organism;
        OptionTbl optionTbl = OptionTbl.getInstance();
        if (this.simpleFlag) {
            int n3 = this.referenceOrganismComboBox.getSelectedIndex();
            organism = (Organism)this.organismList.get(n3);
            list = this.getTargetOrganismList();
            d5 = this.ratioConservedPanel.getValue() / 100.0;
            d4 = this.ratioConservedPanel.getValue() / 100.0;
            n2 = (int)this.simpleWindowSizePanel.getValue();
            bl = this.simpleSpGroupCheckBox.isSelected();
            d3 = optionTbl.getOptionValues().getCoreGenomeAlignmentCondition().getMinSpCov();
            d2 = optionTbl.getOptionValues().getCoreGenomeAlignmentCondition().getSpCovRegCut();
            d = optionTbl.getOptionValues().getCoreGenomeAlignmentCondition().getSpCovSpRatio();
            n = optionTbl.getOptionValues().getCoreGenomeAlignmentCondition().getMinClustSiz();
            string = optionTbl.getOptionValues().getCoreGenomeAlignmentCondition().getOtherOptions();
        } else {
            organism = this.organismSelectPanel.getReferenceOrganism();
            list = this.organismSelectPanel.getTargetOrganismList();
            d5 = this.orthologPanel.getValue() / 100.0;
            d4 = this.connectionPanel.getValue() / 100.0;
            n2 = (int)this.expertWindowSizePanel.getValue();
            bl = this.expertSpGroupCheckBox.isSelected();
            d3 = this.expertMinSpCovPanel.getValue() / 100.0;
            d2 = this.expertSpCovRegCutPanel.getValue();
            d = this.expertSpCovSpRatioPanel.getValue() / 100.0;
            n = (int)this.expertMinClustSizPanel.getValue();
            string = this.otherOptionTextField.getText();
        }
        CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = new CoreGenomeAlignmentCondition();
        coreGenomeAlignmentCondition.setDomClustName(this.domClustName);
        coreGenomeAlignmentCondition.setDomClustId(this.domClustId);
        coreGenomeAlignmentCondition.setClusterViewId(this.clusterViewId);
        coreGenomeAlignmentCondition.setReferenceOrganism(organism);
        coreGenomeAlignmentCondition.setOrganismList(this.organismList);
        coreGenomeAlignmentCondition.setViewOrganismList(list);
        coreGenomeAlignmentCondition.setOrthologRate(d5);
        coreGenomeAlignmentCondition.setConnectionRate(d4);
        coreGenomeAlignmentCondition.setWindowSize(n2);
        coreGenomeAlignmentCondition.setMinSpCov(d3);
        coreGenomeAlignmentCondition.setSpCovRegCut(d2);
        coreGenomeAlignmentCondition.setSpCovSpRatio(d);
        coreGenomeAlignmentCondition.setMinClustSiz(n);
        coreGenomeAlignmentCondition.setOtherOptions(string);
        coreGenomeAlignmentCondition.setUseSpGroup(bl);
        this.setVisible(false);
        this.mediator.alignCoreGenome(coreGenomeAlignmentCondition);
        optionTbl.getOptionValues().setCoreGenomeAlignmentCondition(coreGenomeAlignmentCondition);
        return true;
    }

    private void copySimple2Expert() {
        int n = this.referenceOrganismComboBox.getSelectedIndex();
        Organism organism = (Organism)this.organismList.get(n);
        this.organismSelectPanel.setReferenceOrganism(organism);
        this.expertWindowSizePanel.setValue(this.simpleWindowSizePanel.getValue());
        this.expertSpGroupCheckBox.setSelected(this.simpleSpGroupCheckBox.isSelected());
    }

    private void copyExpert2Simple() {
        Organism organism = this.organismSelectPanel.getReferenceOrganism();
        this.referenceOrganismComboBox.setSelectedItem(organism.getName());
        this.simpleWindowSizePanel.setValue(this.expertWindowSizePanel.getValue());
        this.simpleSpGroupCheckBox.setSelected(this.expertSpGroupCheckBox.isSelected());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.changeButton) {
            if (this.simpleFlag) {
                this.panelContainer.removeAll();
                this.panelContainer.add(this.expertPanel);
                this.simpleFlag = false;
                this.copySimple2Expert();
                this.changeButton.setText(CHANGE_BUTTON_TEXT_SIMPLE);
                this.pack();
            } else {
                this.panelContainer.removeAll();
                this.panelContainer.add(this.simplePanel);
                this.simpleFlag = true;
                this.copyExpert2Simple();
                this.changeButton.setText(CHANGE_BUTTON_TEXT_EXPERT);
                this.pack();
            }
        }
    }
}

