/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeFilenameFilter;
import cgdp.recog.coregenome.CoreGenomeImporter;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CoreGenomeFileUtil {
    private static final ApplicationLogger logger = new ApplicationLogger(CoreGenomeFileUtil.class);

    public static String getCoreGenomeFilepath(String string, String string2, List list) {
        String string3 = CoreGenomeFileUtil.getOriginalCoreGenomeFilepath(string, list);
        if (!StringTool.isNull(string3)) {
            return string3;
        }
        return CoreGenomeFileUtil.createCoreGenomeFilepathWithoutDuplicate(string2);
    }

    private static String createCoreGenomeFilepathWithoutDuplicate(String string) {
        Set set = CoreGenomeFileUtil.getCoreGenomeFilenameSet();
        String string2 = "";
        String string3 = "";
        int n = 0;
        while (true) {
            string2 = string;
            if (!string3.equals("")) {
                string2 = string2 + "_" + string3;
            }
            if (!set.contains(string2)) break;
            string3 = String.valueOf(++n);
        }
        return CoreGenomeFileUtil.createCoreGenomeFilepath(string2);
    }

    public static String createCoreGenomeFilepath(String string) {
        return CoreGenomeFileUtil.createCoreGenomeFilepath(ProjectAccesser.getSelectedProject(), string);
    }

    public static String createCoreGenomeFilepath(Project project, String string) {
        String string2 = project.getDirectoryPath();
        return string2 + File.separator + string + ".coaln";
    }

    private static Set getCoreGenomeFilenameSet() {
        File file = ProjectAccesser.getProjectDir();
        File[] fileArray = file.listFiles(new CoreGenomeFilenameFilter());
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            hashSet.add(FileUtil.removeExtension(fileArray[i].getName()));
        }
        return hashSet;
    }

    private static String getOriginalCoreGenomeFilepath(String string, List list) {
        File file = ProjectAccesser.getProjectDir();
        File[] fileArray = file.listFiles(new CoreGenomeFilenameFilter());
        if (fileArray == null) {
            return null;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = new CoreGenomeAlignmentCondition();
                coreGenomeAlignmentCondition.setOrganismList(list);
                CoreGenomeImporter coreGenomeImporter = new CoreGenomeImporter(fileArray[i].getAbsolutePath());
                coreGenomeImporter.setCondition(coreGenomeAlignmentCondition);
                coreGenomeImporter.setParameterOnly(true);
                coreGenomeImporter.execute();
                String string2 = coreGenomeImporter.getGenomeAlign().getCoreGenomeId();
                if (StringTool.isNull(string2) || !string2.equals(string) || coreGenomeAlignmentCondition.isForViewFlag()) continue;
                return fileArray[i].getAbsolutePath();
            }
            catch (IOException iOException) {
                logger.warn("Fail to read core genome file. " + fileArray[i].getAbsolutePath(), iOException);
            }
        }
        return null;
    }

    public static void deleteFilesByClustId(Project project, String string) {
        File file = new File(project.getDirectoryPath());
        File[] fileArray = file.listFiles(FileFilterFactory.createCoreGenomeIOFileFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                if (string != null && !CoreGenomeFileUtil.hasDomClustId(fileArray[i].getAbsolutePath(), string)) continue;
                if (!fileArray[i].delete()) {
                    logger.warn("Failed to delete a coaln file " + fileArray[i].getAbsolutePath());
                    continue;
                }
                logger.info("A coaln file is deleted. " + fileArray[i].getAbsolutePath());
                continue;
            }
            catch (Exception exception) {
                logger.fatal("Failed to load core genome alignment file " + fileArray[i].getAbsolutePath(), exception);
            }
        }
    }

    public static void deleteFilesByViewId(Project project, String string, String string2) {
        File file = new File(project.getDirectoryPath());
        File[] fileArray = file.listFiles(FileFilterFactory.createCoreGenomeIOFileFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                if (!CoreGenomeFileUtil.hasDomClustViewId(fileArray[i].getAbsolutePath(), string, string2)) continue;
                if (!fileArray[i].delete()) {
                    logger.warn("Failed to delete a coaln file " + fileArray[i].getAbsolutePath());
                    continue;
                }
                logger.info("A coaln file is deleted. " + fileArray[i].getAbsolutePath());
                continue;
            }
            catch (Exception exception) {
                logger.fatal("Failed to load core genome alignment file " + fileArray[i].getAbsolutePath(), exception);
            }
        }
    }

    public static boolean hasDomClustId(String string, String string2) throws IOException {
        CoreGenomeImporter coreGenomeImporter = new CoreGenomeImporter(string);
        coreGenomeImporter.setParameterOnly(true);
        coreGenomeImporter.execute();
        GenomeAlign genomeAlign = coreGenomeImporter.getGenomeAlign();
        String string3 = genomeAlign.getDomClustId();
        return string3 != null && string3.compareTo(string2) == 0;
    }

    public static boolean hasDomClustViewId(String string, String string2, String string3) throws IOException {
        CoreGenomeImporter coreGenomeImporter = new CoreGenomeImporter(string);
        coreGenomeImporter.setParameterOnly(true);
        coreGenomeImporter.execute();
        GenomeAlign genomeAlign = coreGenomeImporter.getGenomeAlign();
        String string4 = genomeAlign.getDomClustId();
        if (string4 == null || string4.compareTo(string2) != 0) {
            return false;
        }
        string4 = genomeAlign.getClusterViewId();
        return string4 != null && string4.compareTo(string3) == 0;
    }
}

