/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.align.CoreGeneAddPropertyItem;
import cgdp.recog.align.CoreGeneAddSetItem;
import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreCommonParamDTO;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeLeftButton;
import cgdp.recog.coregenome.CoreGenomeMainPanel;
import cgdp.recog.coregenome.CoreGenomeOverviewPanel;
import cgdp.recog.coregenome.CoreGenomePreviewItem;
import cgdp.recog.coregenome.CoreGenomePrintItem;
import cgdp.recog.coregenome.CoreGenomeRightButton;
import cgdp.recog.coregenome.CoreGenomeSaveItem;
import cgdp.recog.coregenome.CoreGenomeSaveServerItem;
import cgdp.recog.coregenome.CoreGenomeSaveTool;
import cgdp.recog.coregenome.CoreGenomeSearchPanel;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.CoreGenomeViewModelUpdateEvent;
import cgdp.recog.coregenome.CoreGenomeViewUpdateItem;
import cgdp.recog.coregenome.CoreGenomeZoomEvent;
import cgdp.recog.coregenome.CoreGenomeZoomItem;
import cgdp.recog.coregenome.CoreGenomeZoominTool;
import cgdp.recog.coregenome.CoreGenomeZoomoutTool;
import cgdp.recog.coregenome.GlobalAlignShowItem;
import cgdp.recog.observer.ApplicationObservable;
import cgdp.recog.observer.ApplicationObserver;
import cgdp.recog.observer.ApplicationObserverEvent;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.util.ApplicationFrame;
import cgdp.recog.util.JLicenserTool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class CoreGenomeFrame
extends ApplicationFrame
implements ActionListener,
ComponentListener,
PropertyChangeListener {
    private static final int DEFAULT_DIVIDER_LOCATION = 80;
    private static final double MAX_DIALOG_HEIGHT_RATIO = 0.8;
    private static final String TITLE = "Core Genome Alignment";
    static final int WIDTH = 700;
    private static final int MAIN_PANEL_MARGIN_BOTTOM = 10;
    private ApplicationObservable observable;
    private Frame parent;
    private MediatorImpl mediator;
    private CoreGenomeSearchPanel coreGenomeSearchPanel;
    private CoreGenomeViewModel coreGenomeViewModel;
    private CoreGenomeOverviewPanel coreGenomeOverviewPanel;
    private CoreGenomeMainPanel coreGenomeMainPanel;
    private JScrollPane mainScrollPane;
    private JSplitPane splitPane;
    private JToolBar toolBar;
    private CoreGenomeZoominTool coreGenomeZoominTool;
    private CoreGenomeZoomoutTool coreGenomeZoomoutTool;
    private List zoomMenuList = new ArrayList();
    private CoreGenomeLeftButton leftButton;
    private CoreGenomeRightButton rightButton;

    public CoreGenomeFrame(Frame frame, MediatorImpl mediatorImpl, CoreGenomeViewModel coreGenomeViewModel) {
        super(TITLE);
        this.parent = frame;
        this.mediator = mediatorImpl;
        this.mediator.register(this);
        this.observable = new ApplicationObservable();
        this.setCoreGenomeViewModel(coreGenomeViewModel);
        this.addComponentListener(this);
        this.init();
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CoreGenomeFrame.this.exit();
            }

            public void windowActivated(WindowEvent windowEvent) {
                CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = CoreGenomeFrame.this.coreGenomeViewModel.createCoreGenomeAlignmentCondition();
                if (coreGenomeAlignmentCondition.updateByCoreCommonParamDTO(CoreGenomeFrame.this.coreGenomeViewModel.getCoreCommonParamDTO())) {
                    CoreGenomeFrame.this.mediator.updateCoreGenomeMap(CoreGenomeFrame.this.coreGenomeViewModel, coreGenomeAlignmentCondition, false);
                    CoreGenomeFrame.this.coreGenomeViewModel.clearCoreCommonParamDTO();
                }
            }
        });
        this.setJMenuBar(this.createMenuBar());
        this.toolBar = this.createToolBar();
        this.getContentPane().add((Component)this.toolBar, "North");
        this.coreGenomeOverviewPanel = new CoreGenomeOverviewPanel(this.coreGenomeViewModel);
        this.coreGenomeMainPanel = new CoreGenomeMainPanel(this.mediator, this.coreGenomeViewModel);
        this.mainScrollPane = new JScrollPane(this.coreGenomeMainPanel, 20, 31);
        this.coreGenomeMainPanel.setMainScrollPane(this.mainScrollPane);
        this.coreGenomeMainPanel.updatePreferredSize();
        this.splitPane = new JSplitPane(0, this.coreGenomeOverviewPanel, this.mainScrollPane);
        this.splitPane.addPropertyChangeListener(this);
        this.splitPane.setDividerLocation(80);
        this.addObserver(this.coreGenomeMainPanel);
        this.addObserver(this.coreGenomeOverviewPanel);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.pack();
        Dimension dimension = this.calcSize();
        this.setSize(dimension);
        this.setSizeToPanel(dimension);
        int n = this.coreGenomeMainPanel.getViewOrthologGroupCount();
        this.coreGenomeViewModel.setViewOrthologGroupCountOnMain(n);
        this.setLocationRelativeTo(this.parent);
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.add(new CoreGenomeSaveItem(this, this.mediator, this.coreGenomeViewModel));
        jMenu.add(new CoreGenomeSaveServerItem(this, this.mediator, this, this.coreGenomeViewModel));
        jMenu.addSeparator();
        jMenu.add(new CoreGenomePreviewItem(this, this.mediator, this, this.coreGenomeViewModel));
        jMenu.add(new CoreGenomePrintItem(this, this.mediator, this.coreGenomeViewModel));
        JMenu jMenu2 = new JMenu("View");
        jMenuBar.add(jMenu2);
        jMenu2.add(new CoreGenomeViewUpdateItem(this, this.mediator, this, this.coreGenomeViewModel));
        JMenu jMenu3 = new JMenu("Zoom");
        try {
            jMenu3.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/zoomIn.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        jMenu2.add(jMenu3);
        ButtonGroup buttonGroup = new ButtonGroup();
        List list = this.coreGenomeViewModel.getZoomScaleList();
        Object object = list.iterator();
        while (object.hasNext()) {
            double d = (Double)object.next();
            String string = String.valueOf((int)(d * 100.0));
            CoreGenomeZoomItem coreGenomeZoomItem = new CoreGenomeZoomItem(this, this.mediator, string + "%", this.coreGenomeViewModel, d);
            this.zoomMenuList.add(coreGenomeZoomItem);
            jMenu3.add(coreGenomeZoomItem);
            buttonGroup.add(coreGenomeZoomItem);
            if (d != 1.0) continue;
            coreGenomeZoomItem.setSelected(true);
        }
        jMenu2.addSeparator();
        object = new GlobalAlignShowItem(this, this.mediator, this.coreGenomeViewModel);
        jMenu2.add((JMenuItem)object);
        JMenu jMenu4 = new JMenu("Property");
        jMenuBar.add(jMenu4);
        jMenu4.add(new CoreGeneAddPropertyItem((ActionListener)this, (Component)this, this.mediator, this.coreGenomeViewModel.getGenomeAlign().getOrganismList(), this.coreGenomeViewModel.getGenomeAlign()));
        jMenu4.add(new CoreGeneAddSetItem((ActionListener)this, (Component)this, this.mediator, this.coreGenomeViewModel.getGenomeAlign().getOrganismList(), this.coreGenomeViewModel.getGenomeAlign()));
        return jMenuBar;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        this.coreGenomeZoominTool = new CoreGenomeZoominTool(this, this.mediator, this.coreGenomeViewModel);
        this.coreGenomeZoomoutTool = new CoreGenomeZoomoutTool(this, this.mediator, this.coreGenomeViewModel);
        this.leftButton = new CoreGenomeLeftButton(this, this.coreGenomeViewModel);
        this.rightButton = new CoreGenomeRightButton(this, this.coreGenomeViewModel);
        this.coreGenomeSearchPanel = new CoreGenomeSearchPanel(this.coreGenomeViewModel);
        jToolBar.add(new CoreGenomeSaveTool(this, this.mediator, this.coreGenomeViewModel));
        jToolBar.addSeparator();
        jToolBar.add(this.leftButton);
        jToolBar.add(this.rightButton);
        jToolBar.addSeparator();
        jToolBar.add(this.coreGenomeZoominTool);
        jToolBar.add(this.coreGenomeZoomoutTool);
        jToolBar.addSeparator();
        jToolBar.add(this.coreGenomeSearchPanel);
        return jToolBar;
    }

    private Dimension calcSize() {
        double d;
        double d2 = this.splitPane.getDividerLocation();
        int n = (int)(d2 + (d = this.coreGenomeMainPanel.calcHeight())) + this.splitPane.getDividerSize() + this.getInsets().bottom + this.getInsets().top + this.getJMenuBar().getSize().height + this.toolBar.getHeight() + 10;
        if ((double)n > (double)this.getToolkit().getScreenSize().height * 0.8) {
            n = (int)((double)this.getToolkit().getScreenSize().height * 0.8);
        }
        int n2 = 700 + this.getInsets().left + this.getInsets().right;
        return new Dimension(n2, n);
    }

    public CoreGenomeViewModel getCoreGenomeViewModel() {
        return this.coreGenomeViewModel;
    }

    private void setCoreGenomeViewModel(CoreGenomeViewModel coreGenomeViewModel) {
        this.coreGenomeViewModel = coreGenomeViewModel;
        this.coreGenomeViewModel.setObservable(this.observable);
    }

    public void fireUpadteCoreGenomeViewModel(CoreGenomeViewModel coreGenomeViewModel) {
        this.coreGenomeViewModel.copy(coreGenomeViewModel);
        this.fireUpadteCoreGenomeViewModel();
    }

    public void fireUpadteCoreGenomeViewModel() {
        this.updateComponentSize();
        this.coreGenomeMainPanel.updatePreferredSize();
        this.coreGenomeMainPanel.revalidate();
        CoreGenomeViewModelUpdateEvent coreGenomeViewModelUpdateEvent = new CoreGenomeViewModelUpdateEvent(this);
        this.nodifyObservers(coreGenomeViewModelUpdateEvent);
    }

    private void updateComponentSize() {
        Dimension dimension = this.getSize();
        this.setSizeToPanel(dimension);
        int n = this.coreGenomeMainPanel.getViewOrthologGroupCount();
        this.coreGenomeViewModel.setViewOrthologGroupCountOnMain(n);
    }

    public void zoom(double d) {
        this.coreGenomeViewModel.setZoomScale(d);
        this.updateComponentSize();
        CoreGenomeZoomEvent coreGenomeZoomEvent = new CoreGenomeZoomEvent(this, d);
        this.coreGenomeViewModel.nodifyObservers(coreGenomeZoomEvent);
        this.repaint();
        this.setSelectedZoomMenu(d);
        this.setEnabledZoomTool(d);
    }

    public void selectOrthologGroup(String string) {
        this.coreGenomeMainPanel.selectOrthologGroup(string);
    }

    public void selectOrthologGroupSet(Set set) {
        this.coreGenomeMainPanel.selectOrthologGroup(set);
    }

    public void selectOrthologGroup(List list) {
        this.coreGenomeMainPanel.selectOrthologGroup(list);
    }

    public void changeCentralPosition(String string) {
        this.coreGenomeMainPanel.changeCentralPosition(string);
    }

    public void setCoreParam(CoreCommonParamDTO coreCommonParamDTO) {
        this.coreGenomeViewModel.setCoreCommonParamDTO(coreCommonParamDTO);
    }

    public void changeOrthologGroupLabel(int n) {
        this.coreGenomeMainPanel.changeOrthologGroupLabel(n);
    }

    private void setEnabledZoomTool(double d) {
        this.coreGenomeZoominTool.setEnabled(this.coreGenomeViewModel.canZoomin());
        this.coreGenomeZoomoutTool.setEnabled(this.coreGenomeViewModel.canZoomout());
    }

    private void setSelectedZoomMenu(double d) {
        for (CoreGenomeZoomItem coreGenomeZoomItem : this.zoomMenuList) {
            if (!coreGenomeZoomItem.equalsScale(d)) continue;
            coreGenomeZoomItem.setSelected(true);
        }
    }

    private void exit() {
        this.mediator.closeCoreGenomeFrame();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((CommandImpl)actionEvent.getSource()).execute();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.updateComponentSize();
        this.repaint();
    }

    private void setSizeToPanel(Dimension dimension) {
        int n = dimension.width - this.getInsets().left - this.getInsets().right;
        int n2 = dimension.height - this.getInsets().top - this.getInsets().bottom - this.getJMenuBar().getSize().height - this.toolBar.getHeight();
        int n3 = this.splitPane.getDividerLocation();
        Dimension dimension2 = new Dimension(n, n3);
        Dimension dimension3 = new Dimension(n, n2);
        this.coreGenomeOverviewPanel.setViewSize(dimension2);
        this.coreGenomeMainPanel.setViewSize(dimension3);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void addObserver(ApplicationObserver applicationObserver) {
        this.observable.addObserver(applicationObserver);
    }

    public void deleteObserver(ApplicationObserver applicationObserver) {
        this.observable.deleteObserver(applicationObserver);
    }

    public void deleteObservers() {
        this.observable.deleteObservers();
    }

    public void nodifyObservers(ApplicationObserverEvent applicationObserverEvent) {
        this.observable.notifyObservers(applicationObserverEvent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("lastDividerLocation") && ((Integer)propertyChangeEvent.getNewValue()).intValue() == this.splitPane.getDividerLocation()) {
            Dimension dimension = this.getSize();
            this.setSizeToPanel(dimension);
            this.repaint();
        }
    }
}

