/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeChangeStartIndexEvent;
import cgdp.recog.coregenome.CoreGenomeContext;
import cgdp.recog.coregenome.CoreGenomeOrthologLabelChangeEvent;
import cgdp.recog.coregenome.CoreGenomeRenderer;
import cgdp.recog.coregenome.CoreGenomeSearch;
import cgdp.recog.coregenome.CoreGenomeSearchResult;
import cgdp.recog.coregenome.CoreGenomeViewChangeEvent;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.CoreGenomeViewModelUpdateEvent;
import cgdp.recog.coregenome.StartPointChangeEvent;
import cgdp.recog.observer.ApplicationObserver;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Observable;
import javax.swing.JPanel;

public class CoreGenomeOverviewPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ApplicationObserver {
    private static final Dimension DEFAULT_PANEL_SIZE = new Dimension(500, 2);
    private CoreGenomeViewModel coreGenomeViewModel;
    private CoreGenomeRenderer coreGenomeRenderer;
    private BufferedImage image;
    private Dimension panelSize = DEFAULT_PANEL_SIZE;

    public CoreGenomeOverviewPanel(CoreGenomeViewModel coreGenomeViewModel) {
        this.coreGenomeViewModel = coreGenomeViewModel;
        this.coreGenomeRenderer = new CoreGenomeRenderer();
        this.coreGenomeRenderer.setModel(coreGenomeViewModel, this.createCoreGenomeContext());
        this.setPreferredSize(this.panelSize);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private CoreGenomeContext createCoreGenomeContext() {
        CoreGenomeContext coreGenomeContext = new CoreGenomeContext();
        coreGenomeContext.setResizeFlag(true);
        coreGenomeContext.setDrawDerectionBorderFlag(false);
        coreGenomeContext.setMarginBottom(50.0);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        coreGenomeContext.setCanvasWidth(d);
        coreGenomeContext.setCanvasHeight(d2);
        this.coreGenomeViewModel.setOverviewCoreGenomeContext(coreGenomeContext);
        return coreGenomeContext;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        CoreGenomeContext coreGenomeContext = this.coreGenomeRenderer.getCoreGenomeContext();
        int n = (int)coreGenomeContext.getCanvasWidth();
        int n2 = (int)coreGenomeContext.getCanvasHeight();
        if (this.image == null) {
            this.createCacheImage(n, n2);
        }
        double d = this.calcScaleX();
        double d2 = this.calcScaleY();
        ((Graphics2D)graphics).scale(d, d2);
        graphics.drawImage(this.image, 0, 0, this);
        ((Graphics2D)graphics).scale(1.0 / d, 1.0 / d2);
        this.drawHighlight((Graphics2D)graphics);
        this.drawHitOrthologGroup((Graphics2D)graphics);
    }

    private double calcScaleX() {
        CoreGenomeContext coreGenomeContext = this.coreGenomeRenderer.getCoreGenomeContext();
        int n = (int)coreGenomeContext.getCanvasWidth();
        return this.panelSize.getWidth() / (double)n;
    }

    private double calcScaleY() {
        CoreGenomeContext coreGenomeContext = this.coreGenomeRenderer.getCoreGenomeContext();
        int n = (int)coreGenomeContext.getCanvasHeight();
        return this.panelSize.getHeight() / (double)n;
    }

    private synchronized void createCacheImage(int n, int n2) {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = new BufferedImage(n, n2, 5);
        Graphics2D graphics2D = (Graphics2D)this.image.getGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, n, n2);
        this.coreGenomeRenderer.draw(graphics2D);
    }

    private void drawHighlight(Graphics2D graphics2D) {
        int n;
        int n2;
        if (this.coreGenomeViewModel.getGenomeAlign().getOrthologGroupSize() + this.coreGenomeViewModel.getGenomeAlign().getClusterCount() <= this.coreGenomeViewModel.getViewOrthologGroupCountOnMain()) {
            n2 = 0;
            n = this.coreGenomeViewModel.getGenomeAlign().getOrthologGroupSize();
        } else {
            n2 = this.convertOrthologGroupIndex(this.coreGenomeViewModel.getViewOrthologGroupStartIndexOnMain());
            n = this.convertOrthologGroupIndex(this.coreGenomeViewModel.getViewOrthologGroupEndIndexOnMain());
        }
        double d = this.calcScaleX();
        double d2 = this.coreGenomeViewModel.calcXForOverview(n2) * d;
        double d3 = this.coreGenomeViewModel.calcXForOverview(n) * d;
        Composite composite = graphics2D.getComposite();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(Color.blue.brighter());
        if (d2 <= d3) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2, 0.0, d3 - d2, this.getSize().height);
            graphics2D.fill(double_);
        } else {
            Rectangle2D.Double double_;
            CoreGenomeContext coreGenomeContext = this.coreGenomeRenderer.getCoreGenomeContext();
            double d4 = coreGenomeContext.getDirectionStartX() * coreGenomeContext.getScaleX() * d;
            double d5 = (coreGenomeContext.getCanvasWidth() - coreGenomeContext.getMarginRight()) * d;
            if (n != 0) {
                double_ = new Rectangle2D.Double(d4, 0.0, d3 - d4, this.getSize().height);
                graphics2D.fill(double_);
            }
            double_ = new Rectangle2D.Double(d2, 0.0, d5 - d2, this.getSize().height);
            graphics2D.fill(double_);
        }
        graphics2D.setComposite(composite);
    }

    public void drawHitOrthologGroup(Graphics2D graphics2D) {
        CoreGenomeSearch coreGenomeSearch = this.coreGenomeViewModel.getCoreGenomeSearch();
        if (!coreGenomeSearch.isExistSearchResult()) {
            return;
        }
        Composite composite = graphics2D.getComposite();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(Color.red);
        double d = this.calcScaleX();
        double d2 = this.calcScaleY();
        CoreGenomeContext coreGenomeContext = this.coreGenomeRenderer.getCoreGenomeContext();
        for (CoreGenomeSearchResult coreGenomeSearchResult : coreGenomeSearch.getCoreGenomeSearchResultList()) {
            int n = coreGenomeSearchResult.getOrthologGroupIndex();
            Rectangle rectangle = coreGenomeContext.getOrthologGroupRect(n, this.coreGenomeRenderer.getGenomeAlign());
            double d3 = ((RectangularShape)rectangle).getWidth() * d;
            if (d3 < 1.0) {
                d3 = 1.0;
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(((RectangularShape)rectangle).getX() * d, ((RectangularShape)rectangle).getY() * d2, d3, ((RectangularShape)rectangle).getHeight() * d2);
            graphics2D.fill(double_);
        }
        graphics2D.setComposite(composite);
    }

    private int convertOrthologGroupIndex(int n) {
        int n2;
        for (n2 = n - this.coreGenomeRenderer.getCoreGenomeContext().getOrthologGroupStartIndex(); n2 < 0; n2 += this.coreGenomeViewModel.getGenomeAlign().getOrthologGroupSize()) {
        }
        return n2;
    }

    public void setViewSize(Dimension dimension) {
        this.panelSize = new Dimension(dimension);
    }

    private void updateViewOrthologGroupStartIndex(int n) {
        CoreGenomeContext coreGenomeContext = this.coreGenomeRenderer.getCoreGenomeContext();
        int n2 = coreGenomeContext.getOrhologGroupIndex(n, this.coreGenomeViewModel.getGenomeAlign());
        int n3 = n2 - this.coreGenomeViewModel.getViewOrthologGroupCountOnMain() / 2 + 1;
        if (n3 < 0) {
            n3 += this.coreGenomeViewModel.getGenomeAlign().getOrthologGroupSize();
        }
        this.coreGenomeViewModel.setViewOrthologGroupStartIndexOnMain(n3);
    }

    private synchronized void clearCacheImage() {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
    }

    private int convertX(int n) {
        return (int)((double)n / this.calcScaleX());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.convertX(point.x);
        this.updateViewOrthologGroupStartIndex(n);
        CoreGenomeChangeStartIndexEvent coreGenomeChangeStartIndexEvent = new CoreGenomeChangeStartIndexEvent(this, this.coreGenomeViewModel.getViewOrthologGroupStartIndexOnMain());
        this.coreGenomeViewModel.nodifyObservers(coreGenomeChangeStartIndexEvent);
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.convertX(point.x);
        this.updateViewOrthologGroupStartIndex(n);
        CoreGenomeChangeStartIndexEvent coreGenomeChangeStartIndexEvent = new CoreGenomeChangeStartIndexEvent(this, this.coreGenomeViewModel.getViewOrthologGroupStartIndexOnMain());
        this.coreGenomeViewModel.nodifyObservers(coreGenomeChangeStartIndexEvent);
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void update(Observable observable, Object object) {
        if (object instanceof CoreGenomeChangeStartIndexEvent) {
            this.repaint();
        } else if (object instanceof CoreGenomeViewModelUpdateEvent) {
            this.clearCacheImage();
            this.coreGenomeRenderer.clearCache();
            this.repaint();
        } else if (object instanceof CoreGenomeViewChangeEvent) {
            this.repaint();
        } else if (object instanceof StartPointChangeEvent) {
            StartPointChangeEvent startPointChangeEvent = (StartPointChangeEvent)object;
            this.coreGenomeRenderer.getCoreGenomeContext().setOrthologGroupStartIndex(startPointChangeEvent.getStartOrthologGroupIndex());
            this.clearCacheImage();
            this.coreGenomeRenderer.clearCache();
            this.repaint();
        } else if (object instanceof CoreGenomeOrthologLabelChangeEvent) {
            this.clearCacheImage();
            this.coreGenomeRenderer.clearCache();
            this.repaint();
        }
    }
}

