/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomePreviewPanel;
import cgdp.recog.coregenome.CoreGenomePrintOptionDialog;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.PreviewUpdateListener;
import cgdp.recog.util.JLicenserTool;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CoreGenomePreviewDialog
extends JDialog
implements ActionListener,
PreviewUpdateListener {
    private static final String TITLE = "Core Genome Alignment Preview";
    private CoreGenomeViewModel coreGenomeViewModel;
    private MediatorImpl mediator;
    private CoreGenomePreviewPanel coreGenomePreviewPanel;
    private JButton printButton;
    private JButton optionButton;
    private JButton prevButton;
    private JButton nextButton;
    private JLabel pageLabel;

    public CoreGenomePreviewDialog(Frame frame, MediatorImpl mediatorImpl, PageFormat pageFormat, CoreGenomeViewModel coreGenomeViewModel) {
        super(frame);
        this.mediator = mediatorImpl;
        this.coreGenomeViewModel = coreGenomeViewModel;
        this.init();
    }

    private void init() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.addWindowFocusListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                CoreGenomePreviewDialog.this.exit();
            }
        });
        this.coreGenomePreviewPanel = new CoreGenomePreviewPanel(this.mediator, this.coreGenomeViewModel);
        JScrollPane jScrollPane = new JScrollPane(this.coreGenomePreviewPanel, 20, 30);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createControlPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createControlPanel() {
        this.printButton = new JButton("Print");
        this.printButton.addActionListener(this);
        this.optionButton = new JButton("Option");
        this.optionButton.addActionListener(this);
        this.prevButton = new JButton();
        this.prevButton.addActionListener(this);
        this.prevButton.setMargin(new Insets(0, 0, 0, 0));
        try {
            this.prevButton.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/prev2.png")));
        }
        catch (Exception exception) {
            this.prevButton.setText("<-");
        }
        this.nextButton = new JButton();
        this.nextButton.addActionListener(this);
        this.nextButton.setMargin(new Insets(0, 0, 0, 0));
        try {
            this.nextButton.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/next2.png")));
        }
        catch (Exception exception) {
            this.nextButton.setText("->");
        }
        this.pageLabel = new JLabel();
        this.updateForPageChange();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.printButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        jPanel.add((Component)this.optionButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        jPanel.add((Component)this.prevButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
        jPanel.add((Component)this.nextButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        jPanel.add((Component)this.pageLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        return jPanel;
    }

    private void updateForPageChange() {
        this.prevButton.setEnabled(!this.coreGenomePreviewPanel.isFirstPage());
        this.nextButton.setEnabled(!this.coreGenomePreviewPanel.isLastPage());
        this.pageLabel.setText(this.createPageLabelString());
    }

    private String createPageLabelString() {
        int n = this.coreGenomePreviewPanel.getTotalPageCount();
        int n2 = this.coreGenomePreviewPanel.getPageIndex() + 1;
        return n2 + "/" + n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.printButton) {
            this.print();
        } else if (actionEvent.getSource() == this.optionButton) {
            this.showOptionDialog();
        } else if (actionEvent.getSource() == this.prevButton) {
            this.prev();
        } else if (actionEvent.getSource() == this.nextButton) {
            this.next();
        }
    }

    private void print() {
        this.mediator.printCoreGenomeAlignment(this.coreGenomeViewModel);
        this.exit();
    }

    private void showOptionDialog() {
        CoreGenomePrintOptionDialog coreGenomePrintOptionDialog = new CoreGenomePrintOptionDialog((Dialog)this, this.mediator, this.coreGenomeViewModel);
        coreGenomePrintOptionDialog.addPreviewUpdateListener(this);
        coreGenomePrintOptionDialog.setVisible(true);
        coreGenomePrintOptionDialog.dispose();
        this.updatePreview();
    }

    public void updatePreview() {
        this.coreGenomePreviewPanel.updateFoldCoreGenomeRenderer();
        this.updateForPageChange();
        this.validateTree();
        this.pack();
    }

    public void updateLightPreview() {
        this.coreGenomePreviewPanel.updateFoldCoreGenomeRenderer();
        this.updateForPageChange();
    }

    private void prev() {
        this.coreGenomePreviewPanel.prev();
        this.updateForPageChange();
    }

    private void next() {
        this.coreGenomePreviewPanel.next();
        this.updateForPageChange();
    }

    private void exit() {
        this.setVisible(false);
        this.dispose();
    }
}

