/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomePrintDriver;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.coregenome.FoldCoreGenomeRenderer;
import cgdp.recog.util.AbstractPrintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;

public class CoreGenomePrintable
extends AbstractPrintable {
    private CoreGenomeViewModel coreGenomeViewModel;
    private FoldCoreGenomeRenderer coreGenomeRenderer;

    public CoreGenomePrintable(PageFormat pageFormat, CoreGenomeViewModel coreGenomeViewModel) {
        this.coreGenomeViewModel = coreGenomeViewModel;
        this.setPageFormat(pageFormat);
        this.init();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(this.coreGenomeRenderer.getCoreGenomeContext().createFont());
        this.coreGenomeRenderer.getFoldCoreGenomeContext().setPageIndex(n);
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.coreGenomeRenderer.draw(graphics2D);
        if (n >= this.getPageCount()) {
            return 1;
        }
        return 0;
    }

    private void init() {
        CoreGenomePrintDriver coreGenomePrintDriver = new CoreGenomePrintDriver(this.getPageFormat(), this.coreGenomeViewModel);
        this.coreGenomeRenderer = coreGenomePrintDriver.createCoreGenomeRenderer(this.getRowCountParPage(coreGenomePrintDriver));
        this.setPageCount(this.coreGenomeRenderer.getFoldCoreGenomeContext().getPageCount());
    }

    private int getRowCountParPage(CoreGenomePrintDriver coreGenomePrintDriver) {
        if (this.coreGenomeViewModel.isOnePagePrintFlag()) {
            return coreGenomePrintDriver.calcRowCountForOnePage();
        }
        return this.coreGenomeViewModel.getRowCountParPage();
    }
}

