/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeViewModel;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismNamePanel;
import cgdp.recog.organism.OrganismSelectPanel;
import cgdp.recog.ppm.PPMLabelType;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.SliderTextPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CoreGenomeUpdateDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Core Genome Alignment";
    private MediatorImpl mediator;
    private CoreGenomeViewModel coreGenomeViewModel;
    private OrganismSelectPanel organismSelectPanel;
    private OrganismNamePanel organismNamePanel;
    private SliderTextPanel windowSizePanel;
    private JRadioButton clusterIdButton;
    private JRadioButton representativeGeneNameButton;
    private JRadioButton refGeneNameButton;

    public CoreGenomeUpdateDialog(Frame frame, MediatorImpl mediatorImpl, CoreGenomeViewModel coreGenomeViewModel) {
        super(frame);
        this.mediator = mediatorImpl;
        this.coreGenomeViewModel = coreGenomeViewModel;
        this.createComponent(coreGenomeViewModel);
    }

    private void createComponent(CoreGenomeViewModel coreGenomeViewModel) {
        this.setTitle(TITLE);
        this.setModal(true);
        ArrayList arrayList = new ArrayList(coreGenomeViewModel.getOrganismList());
        arrayList.removeAll(coreGenomeViewModel.getViewOrganismList());
        this.organismSelectPanel = new OrganismSelectPanel(arrayList, coreGenomeViewModel.getViewOrganismList(), null, true);
        this.organismNamePanel = new OrganismNamePanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.organismSelectPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createWindowSizePanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.organismNamePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.createOrthologGroupLabelPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 0, 5, 0), 0, 0));
        this.updateValue();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createWindowSizePanel() {
        this.windowSizePanel = new SliderTextPanel();
        this.windowSizePanel.setMinimum(10);
        this.windowSizePanel.setMaximum(30);
        this.windowSizePanel.setValue(this.coreGenomeViewModel.getWindowSize());
        this.windowSizePanel.setTextColumns(3);
        this.windowSizePanel.setPaintTicks(true);
        this.windowSizePanel.setPaintLabels(true);
        this.windowSizePanel.setLabelTable(10);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Window size"));
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.windowSizePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
        return jPanel;
    }

    private JPanel createOrthologGroupLabelPanel() {
        this.clusterIdButton = new JRadioButton("Cluster ID");
        this.representativeGeneNameButton = new JRadioButton("Representative gene name of the cluster");
        this.refGeneNameButton = new JRadioButton("Gene name of the reference genome");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.clusterIdButton);
        buttonGroup.add(this.representativeGeneNameButton);
        buttonGroup.add(this.refGeneNameButton);
        this.refGeneNameButton.setSelected(true);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Label"));
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.clusterIdButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.representativeGeneNameButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.refGeneNameButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        return jPanel;
    }

    private void updateValue() {
        this.organismNamePanel.setOrganismNameType(this.coreGenomeViewModel.getOrganismNameType());
        this.organismNamePanel.setAddStrainToName(this.coreGenomeViewModel.isAddStrainToName());
        this.organismSelectPanel.setReferenceOrganism(this.coreGenomeViewModel.getReferenceOrganism());
        this.setOrthologGroupLabelType(this.coreGenomeViewModel.getOrthologGroupLabelType());
    }

    private void setOrthologGroupLabelType(int n) {
        if (PPMLabelType.isClusterId(n)) {
            this.clusterIdButton.setSelected(true);
        } else if (PPMLabelType.isClusterGeneName(n)) {
            this.representativeGeneNameButton.setSelected(true);
        } else if (PPMLabelType.isRefGeneName(n)) {
            this.refGeneNameButton.setSelected(true);
        }
    }

    private int getOrthologGroupLabelType() {
        int n = 3;
        if (this.clusterIdButton.isSelected()) {
            n = 1;
        } else if (this.representativeGeneNameButton.isSelected()) {
            n = 2;
        } else if (this.refGeneNameButton.isSelected()) {
            n = 3;
        }
        return n;
    }

    protected boolean check() {
        if (!this.organismSelectPanel.isExistViewOrganism()) {
            MessageManager.showErrorMessage((Component)this, "Select organism.");
            return false;
        }
        return true;
    }

    private int getOrganisnNameType() {
        return this.organismNamePanel.getOrganismNameType();
    }

    protected boolean apply() {
        this.setVisible(false);
        Organism organism = this.organismSelectPanel.getReferenceOrganism();
        List list = this.organismSelectPanel.getTargetOrganismList();
        int n = (int)this.windowSizePanel.getValue();
        int n2 = this.getOrganisnNameType();
        boolean bl = this.organismNamePanel.isAddStrainToName();
        CoreGenomeAlignmentCondition coreGenomeAlignmentCondition = this.coreGenomeViewModel.createCoreGenomeAlignmentCondition();
        coreGenomeAlignmentCondition.setReferenceOrganism(organism);
        coreGenomeAlignmentCondition.setViewOrganismList(list);
        coreGenomeAlignmentCondition.setWindowSize(n);
        coreGenomeAlignmentCondition.setOrganismNameType(n2);
        coreGenomeAlignmentCondition.setAddStrainToName(bl);
        coreGenomeAlignmentCondition.setOrthologGroupLabelType(this.getOrthologGroupLabelType());
        this.mediator.updateCoreGenomeMap(this.coreGenomeViewModel, coreGenomeAlignmentCondition, true);
        return true;
    }
}

