/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneDomain;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.funccat.FunctionCategoryType;
import cgdp.recog.info.ElementInfo;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.GeneInfoUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Cluster
implements ElementInfo {
    public static final String PREFIX_DISPLAY_CLUSTER_ID = "O";
    public static final String PREFIX_DISPLAY_MERGE_CLUSTER_ID = "M";
    public static final String PREFIX_DISPLAY_SPLIT_CLUSTER_ID = "S";
    public static final String DELIMITER_KEY = ".";
    private static final double NO_VALUE = -1.7976931348623157E308;
    public static final int NO_VALUE_INT = Integer.MAX_VALUE;
    protected static final int TYPE_CLUSTER = 1;
    protected static final int TYPE_MERGE_CLUSTER = 2;
    protected static final int TYPE_SUPER_CLUSTER = 3;
    protected static final int TYPE_SPLIT_CLUSTER = 4;
    private int index;
    private ClusterInfo homClusterInfo = new ClusterInfo();
    private ClusterInfo clusterInfo = new ClusterInfo();
    private ClusterInfo subClusterInfo = new ClusterInfo();
    private Map geneInfoMap = new HashMap();
    private int clusterType = 1;

    public Cluster() {
        this.setClusterType(1);
    }

    protected void setClusterType(int n) {
        this.clusterType = n;
    }

    public int getClusterType() {
        return this.clusterType;
    }

    public boolean isTypeCluster() {
        return this.getClusterType() == 1;
    }

    public boolean isTypeMergeCluster() {
        return this.getClusterType() == 2;
    }

    public boolean isTypeSplitCluster() {
        return this.getClusterType() == 4;
    }

    public boolean isTypeSuperCluster() {
        return this.getClusterType() == 3;
    }

    public void setHomClusterInfo(ClusterInfo clusterInfo) {
        this.homClusterInfo = clusterInfo;
    }

    public ClusterInfo getHomClusterInfo() {
        return this.homClusterInfo;
    }

    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.clusterInfo = clusterInfo;
    }

    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public void setSubClusterInfo(ClusterInfo clusterInfo) {
        this.subClusterInfo = clusterInfo;
    }

    public ClusterInfo getSubClusterInfo() {
        return this.subClusterInfo;
    }

    private Object getHomClusterInfo(String string) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle(string);
        return this.getHomClusterInfo(clusterInfoTitle);
    }

    private Object getHomClusterInfo(ClusterInfoTitle clusterInfoTitle) {
        return this.homClusterInfo.getInfo(clusterInfoTitle);
    }

    private String getHomClusterInfoString(String string) {
        String string2 = (String)this.getHomClusterInfo(string);
        if (StringTool.isNull(string2)) {
            string2 = "";
        }
        return string2;
    }

    private double getHomClusterInfoDouble(String string) {
        Number number = (Number)this.getHomClusterInfo(string);
        double d = -1.7976931348623157E308;
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    private int getHomClusterInfoInt(String string) {
        Number number = (Number)this.getHomClusterInfo(string);
        return Cluster.getIntValue(number);
    }

    private Object getClusterInfo(String string) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle(string);
        return this.getClusterInfo(clusterInfoTitle);
    }

    private Object getClusterInfo(ClusterInfoTitle clusterInfoTitle) {
        return this.clusterInfo.getInfo(clusterInfoTitle);
    }

    private String getClusterInfoString(String string) {
        String string2 = (String)this.getClusterInfo(string);
        if (StringTool.isNull(string2)) {
            string2 = "";
        }
        return string2;
    }

    private int getClusterInfoInt(String string) {
        Number number = (Number)this.getClusterInfo(string);
        return Cluster.getIntValue(number);
    }

    private static int getIntValue(Number number) {
        int n = Integer.MAX_VALUE;
        if (number != null) {
            n = (int)number.doubleValue();
        }
        return n;
    }

    private double getClusterInfoDouble(String string) {
        Number number = (Number)this.getClusterInfo(string);
        double d = -1.7976931348623157E308;
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    private Object getSubClusterInfo(String string) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle(string);
        return this.getSubClusterInfo(clusterInfoTitle);
    }

    private Object getSubClusterInfo(ClusterInfoTitle clusterInfoTitle) {
        return this.subClusterInfo.getInfo(clusterInfoTitle);
    }

    private String getSubClusterInfoString(String string) {
        String string2 = (String)this.getSubClusterInfo(string);
        if (StringTool.isNull(string2)) {
            string2 = "";
        }
        return string2;
    }

    private double getSubClusterInfoDouble(String string) {
        Number number = (Number)this.getSubClusterInfo(string);
        double d = -1.7976931348623157E308;
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    private int getSubClusterInfoInt(String string) {
        Number number = (Number)this.getSubClusterInfo(string);
        return Cluster.getIntValue(number);
    }

    private void setHomClusterInfo(String string, Object object) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle(string);
        this.homClusterInfo.putInfo(clusterInfoTitle, object);
    }

    private void setClusterInfo(String string, Object object) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle(string);
        this.clusterInfo.putInfo(clusterInfoTitle, object);
    }

    private void setSubClusterInfo(String string, Object object) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle(string);
        this.subClusterInfo.putInfo(clusterInfoTitle, object);
    }

    public Object getValue(String string) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle(string);
        return this.getValue(clusterInfoTitle);
    }

    public Object getValue(ClusterInfoTitle clusterInfoTitle) {
        if (clusterInfoTitle.isInfoTypeHomCluster()) {
            return this.getHomClusterInfo(clusterInfoTitle);
        }
        if (clusterInfoTitle.isInfoTypeCluster()) {
            return this.getClusterInfo(clusterInfoTitle);
        }
        if (clusterInfoTitle.isInfoTypeSubCluster()) {
            return this.getSubClusterInfo(clusterInfoTitle);
        }
        return null;
    }

    public ClusterInfo getInfo(ClusterInfoTitle clusterInfoTitle) {
        if (clusterInfoTitle.isInfoTypeHomCluster()) {
            return this.getHomClusterInfo();
        }
        if (clusterInfoTitle.isInfoTypeCluster()) {
            return this.getClusterInfo();
        }
        if (clusterInfoTitle.isInfoTypeSubCluster()) {
            return this.getSubClusterInfo();
        }
        return null;
    }

    private boolean containsHomClusterInfo(ClusterInfoTitle clusterInfoTitle) {
        return this.getHomClusterInfo().containsTitle(clusterInfoTitle);
    }

    private boolean containsClusterInfo(ClusterInfoTitle clusterInfoTitle) {
        return this.getClusterInfo().containsTitle(clusterInfoTitle);
    }

    private boolean containsSubClusterInfo(ClusterInfoTitle clusterInfoTitle) {
        return this.getSubClusterInfo().containsTitle(clusterInfoTitle);
    }

    public boolean containsInfo(ClusterInfoTitle clusterInfoTitle) {
        if (clusterInfoTitle.isInfoTypeHomCluster()) {
            return this.containsHomClusterInfo(clusterInfoTitle);
        }
        if (clusterInfoTitle.isInfoTypeCluster()) {
            return this.containsClusterInfo(clusterInfoTitle);
        }
        if (clusterInfoTitle.isInfoTypeSubCluster()) {
            return this.containsSubClusterInfo(clusterInfoTitle);
        }
        return false;
    }

    public boolean containsSp(String string) {
        return this.geneInfoMap.containsKey(string);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void setClusterId(int n) {
        this.setClusterInfo("clusterid", new Float(n));
    }

    public void setGeneName(String string) {
        this.setClusterInfo("CGene", string);
    }

    public void setFunctionCategoryMBGD(String string) {
        this.setClusterInfo("CFuncMbgd", string);
    }

    public void setFunctionCategoryKEGG(String string) {
        this.setClusterInfo("CFuncKegg", string);
    }

    public void setFunctionCategoryCOG(String string) {
        this.setClusterInfo("CFuncCog", string);
    }

    public void setFunctionCategoryTIGR(String string) {
        this.setClusterInfo("CFuncKegg", string);
    }

    public void setFunctionCategory(String string, String string2) {
        if (FunctionCategoryType.isMBGD(string)) {
            this.setFunctionCategoryMBGD(string2);
        } else if (FunctionCategoryType.isCOG(string)) {
            this.setFunctionCategoryCOG(string2);
        } else if (FunctionCategoryType.isKEGG(string)) {
            this.setFunctionCategoryKEGG(string2);
        } else if (FunctionCategoryType.isTIGR(string)) {
            this.setFunctionCategoryTIGR(string2);
        } else {
            this.setFunctionCategoryMBGD(string2);
        }
    }

    public void setSubClusterId(int n) {
        this.setSubClusterInfo("subclusterid", new Float(n));
    }

    public void setSubGeneName(String string) {
        this.setSubClusterInfo("SCGene", string);
    }

    public void setSubFunctionCategoryMBGD(String string) {
        this.setSubClusterInfo("SCFuncMbgd", string);
    }

    public void setSubFunctionCategoryKEGG(String string) {
        this.setSubClusterInfo("SCFuncKegg", string);
    }

    public void setSubFunctionCategoryCOG(String string) {
        this.setSubClusterInfo("SCFuncCog", string);
    }

    public void setSubFunctionCategoryTIGR(String string) {
        this.setSubClusterInfo("SCFuncTigr", string);
    }

    public void setSubFunctionCategory(String string, String string2) {
        if (FunctionCategoryType.isMBGD(string)) {
            this.setSubFunctionCategoryMBGD(string2);
        } else if (FunctionCategoryType.isCOG(string)) {
            this.setSubFunctionCategoryCOG(string2);
        } else if (FunctionCategoryType.isKEGG(string)) {
            this.setSubFunctionCategoryKEGG(string2);
        } else if (FunctionCategoryType.isTIGR(string)) {
            this.setSubFunctionCategoryTIGR(string2);
        } else {
            this.setSubFunctionCategoryMBGD(string2);
        }
    }

    public void setDescription(String string) {
        this.setClusterInfo("CDescr", string);
    }

    public void setSubDescription(String string) {
        this.setSubClusterInfo("SCDescr", string);
    }

    protected void setGeneInfoMap(Map map) {
        this.geneInfoMap = map;
    }

    public void addLocusTagMap(String string, Collection collection) {
        ArrayList<GeneInformation> arrayList = (ArrayList<GeneInformation>)this.geneInfoMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<GeneInformation>();
            this.geneInfoMap.put(string, arrayList);
        }
        for (String string2 : collection) {
            GeneInformation geneInformation = new GeneInformation();
            geneInformation.setLocusTag(string2);
            if (GeneUtil.isDomain(string2)) {
                geneInformation.setDomainNo(GeneUtil.getDomainNo(string2));
            }
            arrayList.add(geneInformation);
        }
    }

    public void addLocusTag(String string, String string2) {
        ArrayList<GeneInformation> arrayList = (ArrayList<GeneInformation>)this.geneInfoMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<GeneInformation>();
            this.geneInfoMap.put(string, arrayList);
        }
        GeneInformation geneInformation = new GeneInformation();
        geneInformation.setLocusTag(string2);
        if (GeneUtil.isDomain(string2)) {
            int n = GeneUtil.getDomainNo(string2);
            geneInformation.setDomainNo(n);
        }
        arrayList.add(geneInformation);
    }

    public void addGeneInfo(String string, String string2, int n, int n2, int n3, boolean bl, boolean bl2) {
        ArrayList<GeneInformation> arrayList = (ArrayList<GeneInformation>)this.geneInfoMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<GeneInformation>();
            this.geneInfoMap.put(string, arrayList);
        }
        GeneInformation geneInformation = new GeneInformation();
        geneInformation.setLocusTag(string2);
        geneInformation.setDomainNo(n);
        geneInformation.setFrom(n2);
        geneInformation.setTo(n3);
        geneInformation.setOutgroupIngroup(bl);
        geneInformation.setOutergroup(bl2);
        arrayList.add(geneInformation);
    }

    public boolean addGeneInfo(String string, GeneInformation geneInformation) {
        ArrayList<GeneInformation> arrayList = (ArrayList<GeneInformation>)this.geneInfoMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<GeneInformation>();
            this.geneInfoMap.put(string, arrayList);
        }
        if (this.containsGeneInfo(string, geneInformation)) {
            return false;
        }
        arrayList.add(geneInformation);
        return true;
    }

    public boolean addGeneInfo(String string, Collection collection) {
        boolean bl = false;
        for (GeneInformation geneInformation : collection) {
            bl |= this.addGeneInfo(string, geneInformation);
        }
        return bl;
    }

    private boolean containsGeneInfo(String string, GeneInformation geneInformation) {
        List list = (List)this.geneInfoMap.get(string);
        if (list == null) {
            return false;
        }
        for (GeneInformation geneInformation2 : list) {
            if (!geneInformation.equalsGeneInfo(geneInformation2)) continue;
            return true;
        }
        return false;
    }

    public int getClusterId() {
        return this.getClusterInfoInt("clusterid");
    }

    public String getDisplayClusterId() {
        if (this.isTypeMergeCluster()) {
            return PREFIX_DISPLAY_MERGE_CLUSTER_ID + this.getCombinedClusterIdRegardSubCluster();
        }
        if (this.isTypeSplitCluster()) {
            return PREFIX_DISPLAY_SPLIT_CLUSTER_ID + this.getCombinedClusterIdRegardSubCluster();
        }
        return PREFIX_DISPLAY_CLUSTER_ID + this.getCombinedClusterIdRegardSubCluster();
    }

    public static boolean isMergeCluster(String string) {
        return string.equals(PREFIX_DISPLAY_MERGE_CLUSTER_ID);
    }

    public static boolean isSplitCluster(String string) {
        return string.equals(PREFIX_DISPLAY_SPLIT_CLUSTER_ID);
    }

    public String getCombinedClusterIdRegardSubCluster() {
        String string = this.isExistOutgourp() ? Cluster.conbineClusterId(this.getClusterId(), this.getSubClusterId()) : String.valueOf(this.getClusterId());
        return string;
    }

    public String getConbinedClusterId() {
        return this.getConbinedClusterId(DELIMITER_KEY);
    }

    public String getConbinedClusterId(String string) {
        int n = this.isExistOutgourp() ? this.getSubClusterId() : 1;
        return Cluster.conbineClusterId(this.getClusterId(), n, string);
    }

    public static String conbineClusterId(int n, int n2) {
        return Cluster.conbineClusterId(n, n2, DELIMITER_KEY);
    }

    public static String conbineClusterId(int n, int n2, String string) {
        return n + string + n2;
    }

    private boolean isExistOutgourp() {
        return !this.isNoValueInt(this.getSubClusterId());
    }

    private boolean isNoValueInt(int n) {
        return n == Integer.MAX_VALUE;
    }

    public boolean isExistOrganism(String string) {
        return this.getLocusTagList(string) != null;
    }

    public String getGeneName() {
        return this.getClusterInfoString("CGene");
    }

    public String getFunctionCategory() {
        FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
        String string = funcCatTbl.getFunctionCategoryType();
        if (FunctionCategoryType.isMBGD(string)) {
            return this.getFunctionCategoryMBGD();
        }
        if (FunctionCategoryType.isCOG(string)) {
            return this.getFunctionCategoryCOG();
        }
        if (FunctionCategoryType.isKEGG(string)) {
            return this.getFunctionCategoryKEGG();
        }
        if (FunctionCategoryType.isTIGR(string)) {
            return this.getFunctionCategoryTIGR();
        }
        return null;
    }

    public String getFunctionCategoryMBGD() {
        return this.getClusterInfoString("CFuncMbgd");
    }

    public String getFunctionCategoryKEGG() {
        return this.getClusterInfoString("CFuncKegg");
    }

    public String getFunctionCategoryCOG() {
        return this.getClusterInfoString("CFuncCog");
    }

    public String getFunctionCategoryTIGR() {
        return this.getClusterInfoString("CFuncTigr");
    }

    public int getSubClusterId() {
        return this.getSubClusterInfoInt("subclusterid");
    }

    public String getSubGeneName() {
        return this.getSubClusterInfoString("SCGene");
    }

    public String getSubFunctionCategory() {
        FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
        String string = funcCatTbl.getFunctionCategoryType();
        if (FunctionCategoryType.isMBGD(string)) {
            return this.getSubFunctionCategoryMBGD();
        }
        if (FunctionCategoryType.isCOG(string)) {
            return this.getSubFunctionCategoryCOG();
        }
        if (FunctionCategoryType.isKEGG(string)) {
            return this.getSubFunctionCategoryKEGG();
        }
        if (FunctionCategoryType.isTIGR(string)) {
            return this.getSubFunctionCategoryTIGR();
        }
        return null;
    }

    public String getSubFunctionCategoryMBGD() {
        return this.getSubClusterInfoString("SCFuncMbgd");
    }

    public String getSubFunctionCategoryKEGG() {
        return this.getSubClusterInfoString("SCFuncKegg");
    }

    public String getSubFunctionCategoryCOG() {
        return this.getSubClusterInfoString("SCFuncCog");
    }

    public String getSubFunctionCategoryTIGR() {
        return this.getSubClusterInfoString("SCFuncTigr");
    }

    private Map getLocusTagMap() {
        return this.geneInfoMap;
    }

    public String getDescription() {
        return this.getClusterInfoString("CDescr");
    }

    public String getSubDescription() {
        return this.getSubClusterInfoString("SCDescr");
    }

    public Set getOrgasnismLocusTagKeySet(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        List list = this.getLocusTagList(string);
        if (list == null) {
            return hashSet;
        }
        for (String string2 : list) {
            String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
            hashSet.add(string3);
        }
        return hashSet;
    }

    public Set getOrganismCodeLocusTagKeySet() {
        HashSet hashSet = new HashSet();
        for (String string : this.getSpSet()) {
            hashSet.addAll(this.getOrgasnismLocusTagKeySet(string));
        }
        return hashSet;
    }

    public List getLocusTagList(String string) {
        List list = (List)this.geneInfoMap.get(string);
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GeneInformation geneInformation : list) {
            arrayList.add(geneInformation.getLocusTag());
        }
        return arrayList;
    }

    public Set getLocusTagWithoutDomainSet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (List list : this.getLocusTagMap().values()) {
            for (GeneInformation geneInformation : list) {
                hashSet.add(geneInformation.getLocusTagWithoutDomain());
            }
        }
        return hashSet;
    }

    public List getLocusTagWithoutDomainList(String string) {
        List list = (List)this.geneInfoMap.get(string);
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GeneInformation geneInformation : list) {
            String string2 = GeneUtil.removeDomainNo(geneInformation.getLocusTag());
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public List getGeneInformationList(String string) {
        return (List)this.geneInfoMap.get(string);
    }

    public List getGeneInfoListWithoutDomainNo() {
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.getSpSet()) {
            List list = this.getGeneInformationList(string);
            for (GeneInformation geneInformation : list) {
                GeneInfo geneInfo = geneInformation.createGeneInfoWithoutDomainNo(string);
                String string2 = geneInfo.getKey();
                if (hashSet.contains(string2)) continue;
                arrayList.add(geneInfo);
                hashSet.add(string2);
            }
        }
        return arrayList;
    }

    public Set getSpSet() {
        return this.geneInfoMap.keySet();
    }

    public int getSpCount() {
        return this.getSpSet().size();
    }

    public int getGeneCount() {
        int n = 0;
        for (List list : this.getLocusTagMap().values()) {
            if (list == null) continue;
            n += list.size();
        }
        return n;
    }

    public boolean equalsHomClusterId(Cluster cluster) {
        if (cluster == null) {
            return false;
        }
        if (Cluster.isNoValue(this.getHomClusterId()) || Cluster.isNoValue(cluster.getHomClusterId())) {
            return false;
        }
        return this.getHomClusterId() == cluster.getHomClusterId();
    }

    public boolean equalsClusterId(Cluster cluster) {
        if (cluster == null) {
            return false;
        }
        return this.equalsClusterId(cluster.getClusterId());
    }

    public boolean equalsClusterId(int n) {
        if (Cluster.isNoValue(n)) {
            return false;
        }
        return this.getClusterId() == n;
    }

    public boolean equalsCluster(Cluster cluster) {
        if (cluster == null) {
            return false;
        }
        return this.equalsCluster(cluster.getClusterId(), cluster.getSubClusterId());
    }

    public boolean equalsCluster(int n) {
        if (Cluster.isNoValue(n)) {
            return false;
        }
        return n == this.getClusterId();
    }

    public boolean equalsCluster(int n, int n2) {
        if (Cluster.isNoValue(n) || Cluster.isNoValue(n2)) {
            return false;
        }
        return n == this.getClusterId() && n2 == this.getSubClusterId();
    }

    public boolean containsKeywordInGeneName(String string) {
        return !StringTool.isNull(this.getGeneName()) && this.getGeneName().indexOf(string) != -1 || !StringTool.isNull(this.getSubGeneName()) && this.getSubGeneName().indexOf(string) != -1;
    }

    public boolean containsKeywordInDescription(String string) {
        String string2 = string.toLowerCase();
        return !StringTool.isNull(this.getDescription()) && this.getDescription().toLowerCase().indexOf(string2) != -1 || !StringTool.isNull(this.getSubDescription()) && this.getSubDescription().toLowerCase().indexOf(string2) != -1;
    }

    public boolean containsKeywordInFunctionCategory(String string) {
        return !StringTool.isNull(this.getFunctionCategory()) && this.getFunctionCategory().indexOf(string) != -1 || !StringTool.isNull(this.getSubFunctionCategory()) && this.getSubFunctionCategory().indexOf(string) != -1;
    }

    public Map getPatternMap() {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.getSpSet().iterator();
        while (iterator.hasNext()) {
            hashMap.put(iterator.next(), "OK");
        }
        return hashMap;
    }

    public void addGeneInfo(String string, GeneTbl geneTbl) {
        List list = (List)this.geneInfoMap.get(string);
        if (list == null) {
            return;
        }
        for (GeneInformation geneInformation : list) {
            Gene gene = (Gene)geneTbl.get(GeneUtil.removeDomainNo(geneInformation.getLocusTag()));
            geneInformation.setGeneName(gene.getGeneName());
        }
    }

    public Map createGeneDomainMap() {
        HashMap<String, GeneDomain> hashMap = new HashMap<String, GeneDomain>();
        for (String string : this.getSpSet()) {
            List list = (List)this.geneInfoMap.get(string);
            for (GeneInformation geneInformation : list) {
                GeneDomain geneDomain = new GeneDomain();
                geneDomain.setOrganismCode(string);
                geneDomain.setClusterId(this.getClusterId());
                geneDomain.setSubClusterId(this.getSubClusterId());
                geneDomain.setGeneInformation(geneInformation);
                String string2 = GeneUtil.createOrganismLocusTagKey(string, geneDomain.getLocusTag());
                hashMap.put(string2, geneDomain);
            }
        }
        return hashMap;
    }

    public Set createGeneInfoSet() {
        HashSet<GeneInfo> hashSet = new HashSet<GeneInfo>();
        for (String string : this.getSpSet()) {
            List list = (List)this.geneInfoMap.get(string);
            for (GeneInformation geneInformation : list) {
                GeneInfo geneInfo = new GeneInfo();
                geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string);
                geneInfo.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, geneInformation.getLocusTag());
                geneInfo.putInfo(GeneInfoTitle.TITLE_START_ON_GENE, new Float(geneInformation.getFrom()));
                geneInfo.putInfo(GeneInfoTitle.TITLE_END_ON_GENE, new Float(geneInformation.getTo()));
                hashSet.add(geneInfo);
            }
        }
        return hashSet;
    }

    public Set createOrganismLocusTagSet() {
        Set set = GeneInfoUtil.createOrganismCodeLocusTagSet(this.createGeneInfoSet());
        return GeneUtil.removeDomainNo(set);
    }

    public GeneInformation getGeneInformation(String string, String string2) {
        List list = this.getGeneInformationList(string);
        if (list == null) {
            return null;
        }
        for (GeneInformation geneInformation : list) {
            if (!geneInformation.getLocusTag().equals(string2)) continue;
            return geneInformation;
        }
        return null;
    }

    public List getGeneInformationList(String string, List list) {
        ArrayList<GeneInformation> arrayList = new ArrayList<GeneInformation>();
        for (String string2 : list) {
            GeneInformation geneInformation = this.getGeneInformation(string, string2);
            if (geneInformation == null) continue;
            arrayList.add(geneInformation);
        }
        return arrayList;
    }

    public GeneInformation getGeneInformationWithoutDomain(String string, String string2) {
        List list = this.getGeneInformationList(string);
        if (list == null) {
            return null;
        }
        for (GeneInformation geneInformation : list) {
            if (!geneInformation.getLocusTagWithoutDomain().equals(GeneUtil.removeDomainNo(string2))) continue;
            return geneInformation;
        }
        return null;
    }

    private int getOutgroupIngroupGeneCount(String string) {
        int n = 0;
        List list = this.getGeneInformationList(string);
        if (list == null) {
            return 0;
        }
        for (GeneInformation geneInformation : list) {
            if (!geneInformation.isOutgroupIngroup()) continue;
            ++n;
        }
        return n;
    }

    private int[] getOutgroupGeneClassCount(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[]{0, 0, 0};
        List list = this.getGeneInformationList(string);
        if (list != null) {
            for (GeneInformation geneInformation : list) {
                if (geneInformation.isOutgroupIngroup()) {
                    ++n;
                    continue;
                }
                if (geneInformation.isOutergroup()) {
                    ++n2;
                    continue;
                }
                ++n3;
            }
            nArray[0] = n3;
            nArray[1] = n2;
            nArray[2] = n;
        }
        return nArray;
    }

    public int getGeneCount(String string) {
        List list = this.getGeneInformationList(string);
        if (list == null) {
            return -1;
        }
        return list.size();
    }

    public double getRatioOutgroupIngroup(String string) {
        return (double)this.getOutgroupIngroupGeneCount(string) / (double)this.getGeneCount(string);
    }

    public double[] getOutgroupGeneClassRatio(String string) {
        double[] dArray = new double[3];
        int[] nArray = this.getOutgroupGeneClassCount(string);
        for (int i = 0; i < 3; ++i) {
            dArray[i] = (double)nArray[i] / (double)this.getGeneCount(string);
        }
        return dArray;
    }

    public boolean containsGeneInfo(String string, String string2) {
        return this.getGeneInformation(string, string2) != null;
    }

    public boolean containsGeneInfoWithountDomain(String string, String string2) {
        return this.getGeneInformationWithoutDomain(string, string2) != null;
    }

    public List[] getOutgroupClassLocusTagLists(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        List[] listArray = new List[]{arrayList2, arrayList2, arrayList};
        List list = this.getGeneInformationList(string);
        if (list == null) {
            return listArray;
        }
        for (GeneInformation geneInformation : list) {
            if (geneInformation.isOutgroupIngroup()) {
                arrayList.add(geneInformation.getLocusTag());
                continue;
            }
            if (geneInformation.isOutergroup()) {
                arrayList3.add(geneInformation.getLocusTag());
                continue;
            }
            arrayList2.add(geneInformation.getLocusTag());
        }
        return listArray;
    }

    public List getOutgroupAsOutgroupLocusTagList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getGeneInformationList(string);
        if (list == null) {
            return arrayList;
        }
        for (GeneInformation geneInformation : list) {
            if (geneInformation.isOutgroupIngroup() || geneInformation.isOutergroup()) continue;
            arrayList.add(geneInformation.getLocusTag());
        }
        return arrayList;
    }

    public List getOutergroupLocusTagList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getGeneInformationList(string);
        if (list == null) {
            return arrayList;
        }
        for (GeneInformation geneInformation : list) {
            if (geneInformation.isOutgroupIngroup() || !geneInformation.isOutergroup()) continue;
            arrayList.add(geneInformation.getLocusTag());
        }
        return arrayList;
    }

    public List getOutgroupAsIngroupLocusTagList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getGeneInformationList(string);
        if (list == null) {
            return arrayList;
        }
        for (GeneInformation geneInformation : list) {
            if (!geneInformation.isOutgroupIngroup()) continue;
            arrayList.add(geneInformation.getLocusTag());
        }
        return arrayList;
    }

    public int getHomClusterId() {
        return this.getHomClusterInfoInt("homclusterid");
    }

    public void setHomClusterId(int n) {
        this.setHomClusterInfo("homclusterid", new Float(n));
    }

    public double getHomScore() {
        return this.getHomClusterInfoDouble("HCScore");
    }

    public void setHomScore(double d) {
        this.setHomClusterInfo("HCScore", new Float(d));
    }

    public double getHomDist() {
        return this.getHomClusterInfoDouble("HCDist");
    }

    public void setHomDist(double d) {
        this.setHomClusterInfo("HCScore", new Float(d));
    }

    public double getScore() {
        return this.getClusterInfoDouble("CScore");
    }

    public void setScore(double d) {
        this.setClusterInfo("CScore", new Float(d));
    }

    public double getDist() {
        return this.getClusterInfoDouble("CDist");
    }

    public void setDist(double d) {
        this.setClusterInfo("CScore", new Float(d));
    }

    public double getSubScore() {
        return this.getSubClusterInfoDouble("SCScore");
    }

    public void setSubScore(double d) {
        this.setSubClusterInfo("SCScore", new Float(d));
    }

    public double getSubDist() {
        return this.getSubClusterInfoDouble("SCDist");
    }

    public void setSubDist(double d) {
        this.setSubClusterInfo("SCScore", new Float(d));
    }

    public static boolean isNoValue(double d) {
        return Math.abs(-1.7976931348623157E308 - d) <= 1.0E-6;
    }

    public static boolean isNoValue(int n) {
        return n == Integer.MAX_VALUE;
    }

    public String getKey() {
        return this.getConbinedClusterId();
    }

    public static boolean isSubClusterKey(String string) {
        return string.indexOf(DELIMITER_KEY) != -1;
    }

    public void removeOrganism(String string) {
        this.geneInfoMap.remove(string);
    }

    public void removeAllOrganism(Collection collection) {
        for (String string : collection) {
            this.removeOrganism(string);
        }
    }
}

