/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.data.MultiCluster;
import cgdp.recog.data.SplitCluster;
import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ClusterUtil {
    private ClusterUtil() {
    }

    public static String getGeneName(Cluster cluster, boolean bl) {
        String string = bl ? cluster.getSubGeneName() : cluster.getGeneName();
        return string;
    }

    public static String getFunctionCategoryNo(Cluster cluster, boolean bl) {
        String string = null;
        if (cluster == null) {
            return string;
        }
        string = bl ? cluster.getSubFunctionCategory() : cluster.getFunctionCategory();
        return string;
    }

    public static String getFunctionCategoryName(Cluster cluster, boolean bl) {
        String string = ClusterUtil.getFunctionCategoryNo(cluster, bl);
        FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
        FuncCat funcCat = (FuncCat)funcCatTbl.get(string);
        if (funcCat != null) {
            return funcCat.getName();
        }
        return "";
    }

    public static String getDescription(Cluster cluster, boolean bl) {
        String string = bl ? cluster.getSubDescription() : cluster.getDescription();
        return string;
    }

    public static int getClusterComparatorType(boolean bl) {
        if (bl) {
            return 4;
        }
        return 3;
    }

    public static int getGeneCount(List list) {
        int n = 0;
        for (Cluster cluster : list) {
            n += cluster.getGeneCount();
        }
        return n;
    }

    public static int getClusterCount(List list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = 0;
        for (Cluster cluster : list) {
            if (hashSet.contains(new Integer(cluster.getClusterId()))) continue;
            ++n;
            hashSet.add(new Integer(cluster.getClusterId()));
        }
        return n;
    }

    public static Set getClusterIdSet(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Cluster cluster : collection) {
            hashSet.add(cluster.getKey());
        }
        return hashSet;
    }

    public static Map createClusterIdMap(Collection collection) {
        HashMap<String, Cluster> hashMap = new HashMap<String, Cluster>();
        for (Cluster cluster : collection) {
            String string = cluster.getKey();
            hashMap.put(string, cluster);
        }
        return hashMap;
    }

    public static List getClusterIdList(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Cluster cluster : collection) {
            arrayList.add(cluster.getConbinedClusterId());
        }
        return arrayList;
    }

    public static List getGeneInfoList(List list) {
        return ClusterUtil.getGeneInfoList(list, null);
    }

    public static List getGeneInfoList(List list, Collection collection) {
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Cluster cluster : list) {
            List list2 = ClusterUtil.getGeneInfoList(cluster);
            for (GeneInfo geneInfo : list2) {
                String string;
                String string2 = (String)geneInfo.getInfo(GeneInfoTitle.TITLE_ORGANISM_CODE);
                if (!CollectionUtil.isNull(collection) && !collection.contains(string2) || hashSet.contains(string = geneInfo.getKey())) continue;
                arrayList.add(geneInfo);
                hashSet.add(string);
            }
        }
        return arrayList;
    }

    public static Set getOrganismCodeLocusTagSet(Cluster cluster) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : cluster.getSpSet()) {
            List list = cluster.getGeneInformationList(string);
            if (CollectionUtil.isNull(list)) continue;
            for (GeneInformation geneInformation : list) {
                String string2 = geneInformation.getLocusTagWithoutDomain();
                String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
                hashSet.add(string3);
            }
        }
        return hashSet;
    }

    private static List getGeneInfoList(Cluster cluster) {
        ArrayList<GeneInfo> arrayList = new ArrayList<GeneInfo>();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : cluster.getSpSet()) {
            List list = cluster.getGeneInformationList(string);
            if (CollectionUtil.isNull(list)) continue;
            for (GeneInformation geneInformation : list) {
                String string2 = geneInformation.getLocusTagWithoutDomain();
                String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
                if (hashSet.contains(string3)) continue;
                GeneInfo geneInfo = new GeneInfo(string, string2);
                arrayList.add(geneInfo);
                hashSet.add(string3);
            }
        }
        return arrayList;
    }

    public static Set getPatternMapSet(Collection collection) {
        HashSet<Map> hashSet = new HashSet<Map>();
        for (Cluster cluster : collection) {
            hashSet.add(cluster.getPatternMap());
        }
        return hashSet;
    }

    public static Map getPatternMap(Collection collection) {
        HashMap<Map, ArrayList<Cluster>> hashMap = new HashMap<Map, ArrayList<Cluster>>();
        for (Cluster cluster : collection) {
            Map map = cluster.getPatternMap();
            ArrayList<Cluster> arrayList = (ArrayList<Cluster>)hashMap.get(map);
            if (arrayList == null) {
                arrayList = new ArrayList<Cluster>();
                hashMap.put(map, arrayList);
            }
            arrayList.add(cluster);
        }
        return hashMap;
    }

    public static List findCluster(int n, List list) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : list) {
            if (cluster.getClusterId() != n) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    public static List findCluster(Map map, List list) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : list) {
            if (!cluster.getPatternMap().equals(map)) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    public static List findCluster(String string, String string2, Collection collection) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : collection) {
            if (!cluster.containsGeneInfoWithountDomain(string, string2)) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    public static List extractMergeCluster(Collection collection) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : collection) {
            if (!cluster.isTypeMergeCluster()) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    public static List getEnableMergeClusterList(Collection collection) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : collection) {
            if (cluster.isTypeSplitCluster()) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    public static Set getSplitBaseClusterList(Collection collection) {
        HashSet<Cluster> hashSet = new HashSet<Cluster>();
        for (Cluster cluster : collection) {
            if (!cluster.isTypeSplitCluster()) continue;
            SplitCluster splitCluster = (SplitCluster)cluster;
            hashSet.add(splitCluster.getCluster());
        }
        return hashSet;
    }

    public static List extractSplitCluster(Collection collection) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : collection) {
            if (!cluster.isTypeSplitCluster()) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    public static List convertClusterOnlyList(Collection collection) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : collection) {
            if (cluster.isTypeMergeCluster()) {
                List list = ((MultiCluster)cluster).getSubClusterList();
                arrayList.addAll(list);
                continue;
            }
            arrayList.add(cluster);
        }
        return arrayList;
    }

    public static int getMaxClusterId(Collection collection) {
        int n = 0;
        for (Cluster cluster : collection) {
            n = Math.max(n, cluster.getClusterId());
        }
        return n;
    }

    public static int[] splitCombinedClusterId(String string) {
        Vector vector = StringTool.splitString(string, ".");
        if (vector.size() != 2) {
            return null;
        }
        int[] nArray = new int[]{Integer.parseInt((String)vector.get(0)), Integer.parseInt((String)vector.get(1))};
        return nArray;
    }

    public static Map createSplitClusterMap(Collection collection) {
        HashMap<Cluster, ArrayList<SplitCluster>> hashMap = new HashMap<Cluster, ArrayList<SplitCluster>>();
        for (SplitCluster splitCluster : collection) {
            Cluster cluster = splitCluster.getCluster();
            ArrayList<SplitCluster> arrayList = (ArrayList<SplitCluster>)hashMap.get(cluster);
            if (arrayList == null) {
                arrayList = new ArrayList<SplitCluster>();
                hashMap.put(cluster, arrayList);
            }
            arrayList.add(splitCluster);
        }
        return hashMap;
    }
}

