/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.domclust.DomClustAnalysis;
import cgdp.recog.domclust.DomClustDeleteRequester;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DomClustDeleteRequestExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustDeleteRequestExecuter.class);
    private Component parent;
    private Collection domClustAnalysisC = new HashSet();
    private Set unableDeleteAnalysisSet = new HashSet();

    public DomClustDeleteRequestExecuter(Component component, DomClustAnalysis domClustAnalysis) {
        this.parent = component;
        HashSet<DomClustAnalysis> hashSet = new HashSet<DomClustAnalysis>();
        hashSet.add(domClustAnalysis);
        this.domClustAnalysisC = hashSet;
    }

    public DomClustDeleteRequestExecuter(Component component, Collection collection) {
        this.parent = component;
        this.domClustAnalysisC = collection;
    }

    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(this.domClustAnalysisC.size());
        Iterator iterator = this.domClustAnalysisC.iterator();
        while (iterator.hasNext()) {
            if (progressImpl.isCanceled()) {
                this.setCancel(true);
                return;
            }
            progressImpl.increment();
            DomClustAnalysis domClustAnalysis = (DomClustAnalysis)iterator.next();
            try {
                DomClustDeleteRequester domClustDeleteRequester = new DomClustDeleteRequester(domClustAnalysis.getProject(), domClustAnalysis.getDomClustId(), domClustAnalysis.getName());
                domClustDeleteRequester.execute();
                if (!domClustDeleteRequester.isError()) continue;
                logger.warn(domClustDeleteRequester.getMessage());
                this.unableDeleteAnalysisSet.add(domClustAnalysis);
            }
            catch (Exception exception) {
                String string = "Fail to delte domclust result on server. " + domClustAnalysis.getName();
                logger.warn(string, exception);
                this.unableDeleteAnalysisSet.add(domClustAnalysis);
            }
        }
    }

    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        Runnable runnable = this.getAfterRunnable();
        if (runnable != null) {
            runnable.run();
        }
    }
}

