/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.data.Cluster;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.CluserInfoAdjuster;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.regex.Pattern;

public class DomClustImporter
extends AbstractDomClustImporter {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustImporter.class);
    protected static final String COLUMN_CID = "CID";
    protected static final String COLUMN_CID_2 = "Cluster ID";
    protected static final String COLUMN_CGENE = "CGene";
    protected static final String COLUMN_CGENE_2 = "Gene Name";
    protected static final String COLUMN_CFUNC_MBGD = "CFuncMbgd";
    protected static final String COLUMN_CFUNC_MBGD_2 = "Function Category(MBGD)";
    protected static final String COLUMN_CFUNC = "CFunc";
    protected static final String COLUMN_CFUNC_COG = "CFuncCog";
    protected static final String COLUMN_CFUNC_COG_2 = "Function Category(COG)";
    protected static final String COLUMN_CFUNC_KEGG = "CFuncKegg";
    protected static final String COLUMN_CFUNC_KEGG_2 = "Function Category(KEGG)";
    protected static final String COLUMN_CFUNC_TIGR = "CFuncTigr";
    protected static final String COLUMN_CFUNC_TIGR_2 = "Function Category(TIGR)";
    protected static final String COLUMN_CDESCR = "CDescr";
    protected static final String COLUMN_CDESCR_2 = "Description";
    protected static final String COLUMN_SCID = "SCID";
    protected static final String COLUMN_SCID_2 = "SubCluster ID";
    protected static final String COLUMN_SCGENE = "SCGene";
    protected static final String COLUMN_SCFUNC_MBGD = "SCFuncMbgd";
    protected static final String COLUMN_SCFUNC = "SCFunc";
    protected static final String COLUMN_SCFUNC_COG = "SCFuncCog";
    protected static final String COLUMN_SCFUNC_KEGG = "SCFuncKegg";
    protected static final String COLUMN_SCFUNC_TIGR = "SCFuncTigr";
    protected static final String COLUMN_SCDESCR = "SCDescr";

    public DomClustImporter(String string) {
        this.filepath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileInputStream = new FileInputStream(this.filepath);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            int n = 0;
            boolean bl = false;
            Pattern pattern = Pattern.compile("^\\s*$");
            while ((string = bufferedReader.readLine()) != null && !this.progressImpl.isCanceled()) {
                if (this.setParameter(string)) continue;
                if (!pattern.matcher(string).matches() && !bl) {
                    this.createColumnNameList(string);
                    bl = true;
                    this.progressImpl.setTotal((int)((double)this.getNClusters() * 1.2));
                    this.progressImpl.setCount(0);
                    continue;
                }
                if (this.parameterOnly) {
                    return;
                }
                Cluster cluster = this.parseDataLine(string);
                cluster.setIndex(n);
                this.clusterList.add(cluster);
                this.progressImpl.increment();
                ++n;
            }
            this.progressImpl.increment();
            CluserInfoAdjuster.addDomainInfo(this.clusterList);
            this.progressImpl.setCount((int)((double)this.nClusters * 1.2) - 1);
            this.progressImpl.increment();
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void createColumnNameList(String string) {
        Vector vector = StringTool.splitString(string, "\t");
        for (int i = 0; i < vector.size(); ++i) {
            this.columnNameList.add((String)vector.get(i));
        }
    }

    private Cluster parseDataLine(String string) {
        Vector vector = StringTool.splitString(string, "\t");
        Cluster cluster = new Cluster();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)this.columnNameList.get(i);
            String string3 = (String)vector.get(i);
            if (this.isOutgroup()) {
                this.setClusterFieldBoth(string2, string3, cluster);
                continue;
            }
            this.setClusterFieldForIngroupOnly(string2, string3, cluster);
        }
        return cluster;
    }

    protected void setClusterFieldBoth(String string, String string2, Cluster cluster) {
        if (string.equals(COLUMN_SCID)) {
            cluster.setClusterId(Integer.parseInt(string2));
        } else if (string.equals(COLUMN_SCGENE)) {
            cluster.setGeneName(string2);
        } else if (string.equals(COLUMN_SCDESCR)) {
            cluster.setDescription(string2);
        } else if (string.equals(COLUMN_SCFUNC_COG)) {
            cluster.setFunctionCategoryCOG(string2);
        } else if (string.equals(COLUMN_SCFUNC_KEGG)) {
            cluster.setFunctionCategoryKEGG(string2);
        } else if (string.equals(COLUMN_SCFUNC_MBGD) || string.equals(COLUMN_SCFUNC)) {
            cluster.setFunctionCategoryMBGD(string2);
        } else if (string.equals(COLUMN_SCFUNC_TIGR)) {
            cluster.setFunctionCategoryTIGR(string2);
        } else if (string.equals(COLUMN_CID)) {
            cluster.setSubClusterId(Integer.parseInt(string2));
        } else if (string.equals(COLUMN_CGENE)) {
            cluster.setSubGeneName(string2);
        } else if (string.equals(COLUMN_CDESCR)) {
            cluster.setSubDescription(string2);
        } else if (string.equals(COLUMN_CFUNC_COG)) {
            cluster.setSubFunctionCategoryCOG(string2);
        } else if (string.equals(COLUMN_CFUNC_KEGG)) {
            cluster.setSubFunctionCategoryKEGG(string2);
        } else if (string.equals(COLUMN_CFUNC_MBGD) || string.equals(COLUMN_CFUNC)) {
            cluster.setSubFunctionCategoryMBGD(string2);
        } else if (string.equals(COLUMN_CFUNC_TIGR)) {
            cluster.setSubFunctionCategoryTIGR(string2);
        } else if (this.containsOrganism(string)) {
            this.parseLocusTag(string, string2, cluster);
        }
    }

    protected void setClusterFieldForIngroupOnly(String string, String string2, Cluster cluster) {
        if (string.equals(COLUMN_CID) || string.equals(COLUMN_CID_2)) {
            cluster.setClusterId(Integer.parseInt(string2));
        } else if (string.equals(COLUMN_CGENE) || string.equals(COLUMN_CGENE_2)) {
            cluster.setGeneName(string2);
        } else if (string.equals(COLUMN_CDESCR) || string.equals(COLUMN_CDESCR_2)) {
            cluster.setDescription(string2);
        } else if (string.equals(COLUMN_CFUNC_COG) || string.equals(COLUMN_CFUNC_COG_2)) {
            cluster.setFunctionCategoryCOG(string2);
        } else if (string.equals(COLUMN_CFUNC_KEGG) || string.equals(COLUMN_CFUNC_KEGG_2)) {
            cluster.setFunctionCategoryKEGG(string2);
        } else if (string.equals(COLUMN_CFUNC_MBGD) || string.equals(COLUMN_CFUNC_MBGD_2) || string.equals(COLUMN_CFUNC)) {
            cluster.setFunctionCategoryMBGD(string2);
        } else if (string.equals(COLUMN_CFUNC_TIGR) || string.equals(COLUMN_CFUNC_TIGR_2)) {
            cluster.setFunctionCategoryTIGR(string2);
        } else if (this.containsOrganism(string)) {
            this.parseLocusTag(string, string2, cluster);
        }
    }

    private void parseLocusTag(String string, String string2, Cluster cluster) {
        if (StringTool.isNull(string2)) {
            return;
        }
        Vector vector = StringTool.splitString(string2, " ");
        cluster.addLocusTagMap(string, vector);
    }
}

