/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.error;

import cgdp.recog.bean.Const;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.error.LogFileImporter;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.property.PropertyMapCreater;
import cgdp.recog.server.AccessServer;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.SimpleServerConnection;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Stack;

public class ErrorInfoUploader
extends SimpleServerConnection {
    private static final ApplicationLogger logger = new ApplicationLogger(ErrorInfoUploader.class);
    private static final String OPTION_MESSAGE1 = "message1";
    private static final String LOG_FILE_NAME = "recog.log";
    private static final String TITLE_PREFIX = "=== ";
    private static final String TITLE_CLIENT_STACKTRACE = "=== RECOG Client Stacktrace";
    private static final String TITLE_CLIENT_PROPERTY = "=== RECOG Client Properties";
    private static final String TITLE_CLIENT_LOG = "=== RECOG Client LOG";
    private static final String TITLE_SERVER_LOG = "=== RECOG Server LOG";
    private ClusterTbl clusterTbl;
    private Exception exception;

    public ErrorInfoUploader(ClusterTbl clusterTbl, Exception exception) {
        this.clusterTbl = clusterTbl;
        this.exception = exception;
        this.setDisplayLogOption(false);
    }

    protected String createUrl() {
        String string = OptionTbl.getInstance().getOptionValues().getErrorUploadURL();
        return string;
    }

    public String getOptions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("message1=");
        stringBuffer.append(this.getClientStackTrace());
        stringBuffer.append(this.getClientProperty());
        int n = 500;
        stringBuffer.append(this.getClientLog(n));
        stringBuffer.append(this.getServerLog());
        return stringBuffer.toString();
    }

    public void parseOutputString(int n, String string) {
    }

    private String getClientStackTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TITLE_CLIENT_STACKTRACE);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        if (this.exception == null) {
            stringBuffer.append("NONE");
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.exception.printStackTrace(printWriter);
            stringBuffer.append(stringWriter.toString());
        }
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        return stringBuffer.toString();
    }

    private String getClientProperty() {
        PropertyMapCreater propertyMapCreater = new PropertyMapCreater(this.clusterTbl);
        Map map = propertyMapCreater.createPropertyMap();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TITLE_CLIENT_PROPERTY);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (String string : map.keySet()) {
            stringBuffer.append(string);
            stringBuffer.append("\t");
            stringBuffer.append(map.get(string));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        return stringBuffer.toString();
    }

    private String getClientLog(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TITLE_CLIENT_LOG);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        try {
            int n2 = 0;
            Stack<String> stack = new Stack<String>();
            block2: while (stack.size() <= n) {
                String string = Const.LOG_DIR + LOG_FILE_NAME;
                if (n2 != 0) {
                    string = string + "." + n2;
                }
                LogFileImporter logFileImporter = new LogFileImporter(string);
                logFileImporter.execute();
                Stack stack2 = logFileImporter.getLogStack();
                while (!stack2.isEmpty()) {
                    String string2 = (String)stack2.pop();
                    stack.push(string2);
                    if (stack.size() < n) continue;
                    continue block2;
                }
            }
        }
        catch (IOException iOException) {
            logger.warn("Fail to upload client log.", iOException);
        }
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        return stringBuffer.toString();
    }

    private String getServerLog() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TITLE_SERVER_LOG);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        AccessServer accessServer = AccessServer.getInstance();
        ServerLogDownloader serverLogDownloader = new ServerLogDownloader();
        try {
            serverLogDownloader.execute();
        }
        catch (Exception exception) {
            logger.warn("Fail to download server log.", exception);
        }
        stringBuffer.append(serverLogDownloader.getServerLog());
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Exception exception = new Exception("Exception text");
        try {
            ErrorInfoUploader errorInfoUploader = new ErrorInfoUploader(null, exception);
            System.out.println(errorInfoUploader.getOptions());
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
        }
    }

    private class ServerLogDownloader
    extends SimpleServerConnection {
        private StringBuffer serverLog = new StringBuffer();

        ServerLogDownloader() {
            this.setContextPath(OptionTbl.getInstance().getOptionValues().getServerLogDownloadURL());
        }

        public void parseOutputString(int n, String string) {
            this.serverLog.append(string);
            this.serverLog.append(FileUtil.LINE_SEPARETOR);
        }

        public String getServerLog() {
            return this.serverLog.toString();
        }
    }
}

