/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.filter.CountFilterCondition;
import cgdp.recog.filter.GeneCountFilterCondition;
import cgdp.recog.filter.OrganismCountFilterCondition;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.SliderTextPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CountFilterDialog
extends AbstractApplyDialog {
    private static CountFilterDialog COUNT_FILTER_DIALOG;
    private static final String TITLE = "Gene/Organism Count Filter";
    private JCheckBox organismCountLessCheckBox;
    private JCheckBox organismCountMoreCheckBox;
    private JCheckBox geneCountLessCheckBox;
    private JCheckBox geneCountMoreCheckBox;
    private SliderTextPanel organismLessCountSliderTextPanel;
    private SliderTextPanel organismMoreCountSliderTextPanel;
    private SliderTextPanel geneLessCountSliderTextPanel;
    private SliderTextPanel geneMoreCountSliderTextPanel;

    private CountFilterDialog(Frame frame) {
        super(frame);
        this.createComponents();
    }

    public static void creasteInstance(Frame frame) {
        COUNT_FILTER_DIALOG = new CountFilterDialog(frame);
    }

    public static CountFilterDialog getInstance() {
        return COUNT_FILTER_DIALOG;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createCountPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createCountPanel() {
        JLabel jLabel = new JLabel("Organism");
        this.organismCountLessCheckBox = new JCheckBox("# or less");
        this.organismCountLessCheckBox.addActionListener(this);
        this.organismCountMoreCheckBox = new JCheckBox("# or more");
        this.organismCountMoreCheckBox.addActionListener(this);
        this.organismLessCountSliderTextPanel = new SliderTextPanel();
        this.organismLessCountSliderTextPanel.setPaintLabels(true);
        this.organismLessCountSliderTextPanel.setSnapToTicks(true);
        this.organismMoreCountSliderTextPanel = new SliderTextPanel();
        this.organismMoreCountSliderTextPanel.setPaintLabels(true);
        this.organismMoreCountSliderTextPanel.setSnapToTicks(true);
        JLabel jLabel2 = new JLabel("Gene");
        this.geneCountLessCheckBox = new JCheckBox("# or less");
        this.geneCountLessCheckBox.addActionListener(this);
        this.geneCountMoreCheckBox = new JCheckBox("# or more");
        this.geneCountMoreCheckBox.addActionListener(this);
        this.geneLessCountSliderTextPanel = new SliderTextPanel();
        this.geneLessCountSliderTextPanel.setPaintLabels(true);
        this.geneLessCountSliderTextPanel.setSnapToTicks(true);
        this.geneMoreCountSliderTextPanel = new SliderTextPanel();
        this.geneMoreCountSliderTextPanel.setPaintLabels(true);
        this.geneMoreCountSliderTextPanel.setSnapToTicks(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.organismCountLessCheckBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.organismCountMoreCheckBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.organismLessCountSliderTextPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.organismMoreCountSliderTextPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.geneCountLessCheckBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.geneCountMoreCheckBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.geneLessCountSliderTextPanel, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.geneMoreCountSliderTextPanel, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public void updateValue(int n, int n2, CountFilterCondition countFilterCondition, CountFilterCondition countFilterCondition2) {
        this.organismLessCountSliderTextPanel.setMinimum(0);
        this.organismLessCountSliderTextPanel.setMaximum(n2);
        this.organismLessCountSliderTextPanel.setAutoLabelTable();
        this.organismMoreCountSliderTextPanel.setMinimum(0);
        this.organismMoreCountSliderTextPanel.setMaximum(n2);
        this.organismMoreCountSliderTextPanel.setAutoLabelTable();
        this.geneLessCountSliderTextPanel.setMinimum(0);
        this.geneLessCountSliderTextPanel.setMaximum(n);
        this.geneLessCountSliderTextPanel.setAutoLabelTable();
        this.geneMoreCountSliderTextPanel.setMinimum(0);
        this.geneMoreCountSliderTextPanel.setMaximum(n);
        this.geneMoreCountSliderTextPanel.setAutoLabelTable();
        int n3 = String.valueOf(n).length();
        int n4 = String.valueOf(n2).length();
        int n5 = Math.max(n3, n4);
        this.organismLessCountSliderTextPanel.setTextColumns(n5);
        this.organismMoreCountSliderTextPanel.setTextColumns(n5);
        this.geneLessCountSliderTextPanel.setTextColumns(n5);
        this.geneMoreCountSliderTextPanel.setTextColumns(n5);
        if (countFilterCondition2 != null) {
            this.organismCountLessCheckBox.setSelected(countFilterCondition2.isLessFilter());
            this.organismCountMoreCheckBox.setSelected(countFilterCondition2.isMoreFilter());
            this.organismLessCountSliderTextPanel.setValue(countFilterCondition2.getLessThreshold());
            this.organismMoreCountSliderTextPanel.setValue(countFilterCondition2.getMoreThreshold());
        }
        if (countFilterCondition != null) {
            this.geneCountLessCheckBox.setSelected(countFilterCondition.isLessFilter());
            this.geneCountMoreCheckBox.setSelected(countFilterCondition.isMoreFilter());
            this.geneLessCountSliderTextPanel.setValue(countFilterCondition.getLessThreshold());
            this.geneMoreCountSliderTextPanel.setValue(countFilterCondition.getMoreThreshold());
        }
        this.setEnableSliderTextPanel();
        this.pack();
    }

    private void setEnableSliderTextPanel(SliderTextPanel sliderTextPanel, boolean bl) {
        sliderTextPanel.setEnabledComponents(bl);
    }

    private void setEnableSliderTextPanel() {
        this.setEnableSliderTextPanel(this.organismLessCountSliderTextPanel, this.organismCountLessCheckBox.isSelected());
        this.setEnableSliderTextPanel(this.organismMoreCountSliderTextPanel, this.organismCountMoreCheckBox.isSelected());
        this.setEnableSliderTextPanel(this.geneLessCountSliderTextPanel, this.geneCountLessCheckBox.isSelected());
        this.setEnableSliderTextPanel(this.geneMoreCountSliderTextPanel, this.geneCountMoreCheckBox.isSelected());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.organismCountLessCheckBox) {
            this.setEnableSliderTextPanel(this.organismLessCountSliderTextPanel, this.organismCountLessCheckBox.isSelected());
        } else if (actionEvent.getSource() == this.organismCountMoreCheckBox) {
            this.setEnableSliderTextPanel(this.organismMoreCountSliderTextPanel, this.organismCountMoreCheckBox.isSelected());
        } else if (actionEvent.getSource() == this.geneCountLessCheckBox) {
            this.setEnableSliderTextPanel(this.geneLessCountSliderTextPanel, this.geneCountLessCheckBox.isSelected());
        } else if (actionEvent.getSource() == this.geneCountMoreCheckBox) {
            this.setEnableSliderTextPanel(this.geneMoreCountSliderTextPanel, this.geneCountMoreCheckBox.isSelected());
        }
    }

    protected boolean apply() {
        return true;
    }

    private boolean isOrganismCountLessFilter() {
        return this.organismCountLessCheckBox.isSelected();
    }

    private boolean isOrganismCountMoreFilter() {
        return this.organismCountMoreCheckBox.isSelected();
    }

    private boolean isGeneCountLessFilter() {
        return this.geneCountLessCheckBox.isSelected();
    }

    private boolean isGeneCountMoreFilter() {
        return this.geneCountMoreCheckBox.isSelected();
    }

    private int getOrganismCountLessThreshold() {
        return (int)this.organismLessCountSliderTextPanel.getValue();
    }

    private int getOrganismCountMoreThreshold() {
        return (int)this.organismMoreCountSliderTextPanel.getValue();
    }

    private int getGeneCountLessThreshold() {
        return (int)this.geneLessCountSliderTextPanel.getValue();
    }

    private int getGeneCountMoreThreshold() {
        return (int)this.geneMoreCountSliderTextPanel.getValue();
    }

    public CountFilterCondition createOrganismCondition() {
        OrganismCountFilterCondition organismCountFilterCondition = new OrganismCountFilterCondition();
        organismCountFilterCondition.setLessFilter(this.isOrganismCountLessFilter());
        organismCountFilterCondition.setMoreFilter(this.isOrganismCountMoreFilter());
        organismCountFilterCondition.setLessThreshold(this.getOrganismCountLessThreshold());
        organismCountFilterCondition.setMoreThreshold(this.getOrganismCountMoreThreshold());
        organismCountFilterCondition.setFilterActive(true);
        return organismCountFilterCondition;
    }

    public CountFilterCondition createGeneCondition() {
        GeneCountFilterCondition geneCountFilterCondition = new GeneCountFilterCondition();
        geneCountFilterCondition.setLessFilter(this.isGeneCountLessFilter());
        geneCountFilterCondition.setMoreFilter(this.isGeneCountMoreFilter());
        geneCountFilterCondition.setLessThreshold(this.getGeneCountLessThreshold());
        geneCountFilterCondition.setMoreThreshold(this.getGeneCountMoreThreshold());
        geneCountFilterCondition.setFilterActive(true);
        return geneCountFilterCondition;
    }
}

