/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.filter.TaxFilterCondition;
import java.util.HashSet;
import java.util.Set;

public class FilterConditionLabel {
    private static final String NODE_LABEL_PREFIX_ALL = "All";
    private static final String NODE_LABEL_PREFIX_NONE = "None";
    private static final String NODE_LABEL_PREFIX_ANY = "Any";

    private FilterConditionLabel() {
    }

    public static String getNodeLabel(TaxFilterCondition taxFilterCondition, ClusterTbl clusterTbl) {
        String string = "";
        if (taxFilterCondition.isAll()) {
            string = "All(" + taxFilterCondition.getSpSize() + ")";
        } else if (taxFilterCondition.isNone()) {
            string = "None(" + taxFilterCondition.getSpSize() + ")";
        } else if (taxFilterCondition.isAny()) {
            String string2 = taxFilterCondition.getTaxUnit();
            if (string2 == null) {
                string2 = "";
            }
            string = "Any " + taxFilterCondition.getName() + " [" + string2 + FilterConditionLabel.createThresholdString(taxFilterCondition, clusterTbl) + "] (" + taxFilterCondition.getSpSize() + ")";
        }
        return string;
    }

    private static Set getExcludeOrganismSet(ClusterTbl clusterTbl) {
        if (clusterTbl == null) {
            return new HashSet();
        }
        return clusterTbl.getExcludeOrganismSet();
    }

    private static String createThresholdString(TaxFilterCondition taxFilterCondition, ClusterTbl clusterTbl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (taxFilterCondition.isCountFlag()) {
            if (taxFilterCondition.isLessCount() && taxFilterCondition.isMoreCount()) {
                Set set = FilterConditionLabel.getExcludeOrganismSet(clusterTbl);
                if (taxFilterCondition.isAnyConditionConbinedAnd(set)) {
                    stringBuffer.append(taxFilterCondition.getMoreThresholdCount());
                    stringBuffer.append("<=x<=");
                    stringBuffer.append(taxFilterCondition.getLessThresholdCount());
                } else {
                    stringBuffer.append("<=");
                    stringBuffer.append(taxFilterCondition.getLessThresholdCount());
                    stringBuffer.append(",>=");
                    stringBuffer.append(taxFilterCondition.getMoreThresholdCount());
                }
            } else if (taxFilterCondition.isLessCount()) {
                stringBuffer.append("<=");
                stringBuffer.append(taxFilterCondition.getLessThresholdCount());
            } else if (taxFilterCondition.isMoreCount()) {
                stringBuffer.append(">=");
                stringBuffer.append(taxFilterCondition.getMoreThresholdCount());
            }
        } else if (taxFilterCondition.isLessPercent() && taxFilterCondition.isMorePercent()) {
            Set set = FilterConditionLabel.getExcludeOrganismSet(clusterTbl);
            if (taxFilterCondition.isAnyConditionConbinedAnd(set)) {
                stringBuffer.append(taxFilterCondition.getMoreThresholdPercent() * 100.0);
                stringBuffer.append("%<=x<=");
                stringBuffer.append(taxFilterCondition.getLessThresholdPercent() * 100.0);
                stringBuffer.append("%");
            } else {
                stringBuffer.append("<=");
                stringBuffer.append(taxFilterCondition.getLessThresholdPercent() * 100.0);
                stringBuffer.append("%,>=");
                stringBuffer.append(taxFilterCondition.getMoreThresholdPercent() * 100.0);
                stringBuffer.append("%");
            }
        } else if (taxFilterCondition.isLessPercent()) {
            stringBuffer.append("<=");
            stringBuffer.append(taxFilterCondition.getLessThresholdPercent() * 100.0);
            stringBuffer.append("%");
        } else if (taxFilterCondition.isMorePercent()) {
            stringBuffer.append(">=");
            stringBuffer.append(taxFilterCondition.getMoreThresholdPercent() * 100.0);
            stringBuffer.append("%");
        }
        return stringBuffer.toString();
    }
}

