/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.data.GenomeTbl;
import cgdp.recog.filter.TaxFilterCondition;
import cgdp.recog.filter.TaxFilterConditionGroup;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.util.StringTool;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

public class FilterConditionParser {
    private static final String CONDITION_DELIMIETER = ";";
    private static final String ELEMENT_DELIMIETER = ":";
    private static final String SP_DELIMIETER = ",";

    private FilterConditionParser() {
    }

    public static void str2Condition(TaxFilterConditionGroup taxFilterConditionGroup, String string) {
        GenomeTbl genomeTbl = new GenomeTbl();
        genomeTbl.read();
        if (StringTool.isNull(string)) {
            return;
        }
        Vector vector = StringTool.splitString(string, CONDITION_DELIMIETER);
        for (String string2 : vector) {
            Vector vector2 = StringTool.splitString(string2, ELEMENT_DELIMIETER);
            String string3 = (String)vector2.get(0);
            int n = Integer.parseInt((String)vector2.get(1));
            HashSet hashSet = new HashSet(StringTool.splitString((String)vector2.get(2), SP_DELIMIETER));
            int n2 = Integer.parseInt((String)vector2.get(3));
            int n3 = Integer.parseInt((String)vector2.get(4));
            double d = Double.parseDouble((String)vector2.get(5));
            double d2 = Double.parseDouble((String)vector2.get(6));
            boolean bl = new Boolean((String)vector2.get(7));
            boolean bl2 = new Boolean((String)vector2.get(8));
            boolean bl3 = new Boolean((String)vector2.get(9));
            boolean bl4 = new Boolean((String)vector2.get(10));
            boolean bl5 = new Boolean((String)vector2.get(11));
            boolean bl6 = new Boolean((String)vector2.get(12));
            Map map = OrganismUtil.createOrganismNameMap(hashSet);
            String string4 = null;
            if (vector2.size() >= 14) {
                string4 = (String)vector2.get(13);
            }
            taxFilterConditionGroup.setFilterCondition(-1L, string3, n, map, n2, n3, d, d2, bl, bl2, bl3, bl4, bl5, string4);
            TaxFilterCondition taxFilterCondition = taxFilterConditionGroup.getMaxIdFilterCondition();
            if (taxFilterCondition == null) continue;
            taxFilterCondition.setFilterActive(bl6);
        }
    }

    public static String condition2Str(TaxFilterConditionGroup taxFilterConditionGroup) {
        StringBuffer stringBuffer = new StringBuffer();
        TaxFilterCondition taxFilterCondition = taxFilterConditionGroup.getAllCondition();
        if (taxFilterCondition != null) {
            stringBuffer.append(FilterConditionParser.getFilterConditionString(taxFilterCondition));
        }
        for (TaxFilterCondition taxFilterCondition2 : taxFilterConditionGroup.getAnyConditionList()) {
            if (stringBuffer.length() != 0 && !stringBuffer.toString().endsWith(CONDITION_DELIMIETER)) {
                stringBuffer.append(CONDITION_DELIMIETER);
            }
            stringBuffer.append(FilterConditionParser.getFilterConditionString(taxFilterCondition2));
        }
        TaxFilterCondition taxFilterCondition3 = taxFilterConditionGroup.getNoneCondition();
        if (taxFilterCondition3 != null) {
            if (stringBuffer.length() != 0 && !stringBuffer.toString().endsWith(CONDITION_DELIMIETER)) {
                stringBuffer.append(CONDITION_DELIMIETER);
            }
            stringBuffer.append(FilterConditionParser.getFilterConditionString(taxFilterCondition3));
        }
        return stringBuffer.toString();
    }

    private static String getFilterConditionString(TaxFilterCondition taxFilterCondition) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(taxFilterCondition.getName());
        stringBuffer.append(ELEMENT_DELIMIETER);
        stringBuffer.append(taxFilterCondition.getCondition());
        stringBuffer.append(ELEMENT_DELIMIETER);
        int n = 0;
        for (String string : taxFilterCondition.getSpSet()) {
            stringBuffer.append(string);
            if (n != taxFilterCondition.getSpSize() - 1) {
                stringBuffer.append(SP_DELIMIETER);
            }
            ++n;
        }
        stringBuffer.append(ELEMENT_DELIMIETER);
        stringBuffer.append(taxFilterCondition.getLessThresholdCount());
        stringBuffer.append(ELEMENT_DELIMIETER);
        stringBuffer.append(taxFilterCondition.getMoreThresholdCount());
        stringBuffer.append(ELEMENT_DELIMIETER);
        stringBuffer.append(taxFilterCondition.getLessThresholdPercent());
        stringBuffer.append(ELEMENT_DELIMIETER);
        stringBuffer.append(taxFilterCondition.getMoreThresholdPercent());
        stringBuffer.append(ELEMENT_DELIMIETER);
        stringBuffer.append(taxFilterCondition.isCountFlag());
        stringBuffer.append(ELEMENT_DELIMIETER);
        stringBuffer.append(taxFilterCondition.isLessCount());
        stringBuffer.append(ELEMENT_DELIMIETER);
        stringBuffer.append(taxFilterCondition.isMoreCount());
        stringBuffer.append(ELEMENT_DELIMIETER);
        stringBuffer.append(taxFilterCondition.isLessPercent());
        stringBuffer.append(ELEMENT_DELIMIETER);
        stringBuffer.append(taxFilterCondition.isMorePercent());
        stringBuffer.append(ELEMENT_DELIMIETER);
        stringBuffer.append(taxFilterCondition.isFilterActive());
        stringBuffer.append(ELEMENT_DELIMIETER);
        stringBuffer.append(taxFilterCondition.getTaxUnit());
        return stringBuffer.toString();
    }
}

