/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.gmap;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.gmap.GenomeMapFrame;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.system.OS;
import cgdp.recog.util.JLicenserTool;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Timer;

class MovePrevTool
extends JButton
implements CommandImpl,
MouseListener {
    private MediatorImpl mediator;
    private Timer timer;
    private GenomeMapFrame genomeMapFrame;

    MovePrevTool(ActionListener actionListener, MediatorImpl mediatorImpl, GenomeMapFrame genomeMapFrame) {
        this.setToolTipText("Previous");
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setFont(new Font("Monospaced", 0, 10));
        try {
            this.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/prev2.png")));
        }
        catch (Exception exception) {
            this.setText("0");
        }
        this.clear();
        this.addActionListener(actionListener);
        this.addMouseListener(this);
        this.mediator = mediatorImpl;
        this.genomeMapFrame = genomeMapFrame;
    }

    private void clear() {
        this.timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MovePrevTool.this.execute();
            }
        });
        this.timer.setInitialDelay(400);
    }

    private void showPopup(int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        String[] stringArray = new String[]{"1", "1/2", "1/4"};
        for (int i = 0; i < stringArray.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionTbl.getInstance().getOptionValues().setMovePrev(actionEvent.getActionCommand());
                }
            });
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(this, n, n2);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        String string = OptionTbl.getInstance().getOptionValues().getMovePrev();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.getSize().width - fontMetrics.stringWidth(string) - 2;
        int n2 = this.getSize().height - 2;
        graphics.setColor(Color.black);
        graphics.drawString(string, n, n2);
    }

    public void execute() {
        this.genomeMapFrame.movePrev();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX(), this.getSize().height);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.timer.start();
        if (!OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.timer.stop();
        if (OS.isWindows() && mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

