/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.hcluster.ClusterNode;
import cgdp.recog.hcluster.ExecClustering;
import cgdp.recog.hcluster.PairDist;
import cgdp.recog.propvect.EquivMap;
import java.text.DecimalFormat;
import java.util.LinkedList;

public class ClusterTree {
    static StringBuffer head;
    static int format;
    static final int NORMAL = 0;
    static final int TREE = 1;
    static final int NEWICK = 2;
    static final int NEWICKDIST = 3;

    static void equivTreeMap(EquivMap equivMap) {
        for (int i = 0; i < ClusterNode.leafNum(); ++i) {
            ClusterNode clusterNode;
            Object object;
            ClusterNode clusterNode2;
            String string;
            ClusterNode clusterNode3 = ClusterNode.get(i);
            LinkedList linkedList = equivMap.get(clusterNode3.name);
            if (linkedList == null || linkedList.isEmpty()) continue;
            LinkedList<ClusterNode> linkedList2 = new LinkedList<ClusterNode>();
            ClusterNode clusterNode4 = new ClusterNode(clusterNode3.name);
            int n = 1;
            while (!linkedList.isEmpty() && (string = (String)linkedList.removeFirst()) != null) {
                if (string == clusterNode3.name) continue;
                if (n % 2 == 1) {
                    clusterNode2 = new ClusterNode(string);
                    object = PairDist.newInstance(clusterNode4, clusterNode2, 0.0);
                    clusterNode = new ClusterNode((PairDist)object);
                    linkedList2.add(clusterNode);
                } else {
                    clusterNode4 = new ClusterNode(string);
                }
                ++n;
            }
            while (!linkedList2.isEmpty()) {
                object = (ClusterNode)linkedList2.removeFirst();
                if (n % 2 == 1) {
                    clusterNode2 = object;
                    PairDist pairDist = PairDist.newInstance(clusterNode4, clusterNode2, 0.0);
                    clusterNode = new ClusterNode(pairDist);
                    linkedList2.add(clusterNode);
                } else {
                    clusterNode4 = object;
                }
                ++n;
            }
            if (clusterNode3.parent == null) continue;
            clusterNode4.replaceNode(clusterNode3);
        }
    }

    public static void outputCluster(int n) {
        ClusterTree clusterTree = new ClusterTree();
        int n2 = 0;
        format = n;
        for (int i = ClusterNode.totalNum() - 1; i >= 0; --i) {
            ClusterNode clusterNode = ClusterNode.get(i);
            if (!clusterNode.isRoot()) continue;
            System.out.println("Cluster " + ++n2);
            if (format == 0) {
                ClusterTree.outputCluster_sub(clusterNode);
            } else if (format == 1) {
                head = new StringBuffer();
                ClusterTree.outputTree_sub(clusterNode, 0, 1);
            } else if (format == 2 || format == 3) {
                ClusterTree.outputNewick_sub(clusterNode, -1.0);
            }
            System.out.println("");
        }
    }

    static void outputCluster_sub(ClusterNode clusterNode) {
        if (clusterNode.child == null) {
            System.out.println(clusterNode.name);
        } else {
            ClusterTree.outputCluster_sub(clusterNode.child.node1);
            ClusterTree.outputCluster_sub(clusterNode.child.node2);
        }
    }

    static void outputTree_sub(ClusterNode clusterNode, int n, int n2) {
        if (clusterNode.child == null) {
            System.out.println(head + "+- " + clusterNode.name);
        } else {
            head.setLength(n * 2);
            head.append(n > 0 && n2 == -1 ? "| " : "  ");
            ClusterTree.outputTree_sub(clusterNode.child.node1, n + 1, 1);
            head.setLength(n * 2);
            DecimalFormat decimalFormat = new DecimalFormat(ClusterTree.formatString());
            System.out.println(head + "+-| " + decimalFormat.format(clusterNode.child.dist));
            head.append(n > 0 && n2 == 1 ? "| " : "  ");
            ClusterTree.outputTree_sub(clusterNode.child.node2, n + 1, -1);
        }
    }

    static void outputNewick_sub(ClusterNode clusterNode, double d) {
        if (clusterNode.child == null) {
            System.out.print(clusterNode.name);
            if (format == 3 && d >= 0.0) {
                DecimalFormat decimalFormat = new DecimalFormat(ClusterTree.formatString());
                System.out.print(":" + decimalFormat.format(d));
            }
        } else {
            double d2 = clusterNode.child.dist / 2.0f;
            System.out.print("(");
            ClusterTree.outputNewick_sub(clusterNode.child.node1, d2);
            System.out.print(",");
            ClusterTree.outputNewick_sub(clusterNode.child.node2, d2);
            System.out.print(")");
            if (format == 3 && d >= 0.0) {
                double d3 = d - d2;
                DecimalFormat decimalFormat = new DecimalFormat(ClusterTree.formatString());
                System.out.print(":" + decimalFormat.format(d3));
            }
        }
    }

    static String formatString() {
        String string = "#####0.";
        int n = 1;
        if (ExecClustering.scale > 10) {
            n = (int)Math.round(Math.log(ExecClustering.scale) / Math.log(10.0));
        }
        for (int i = 0; i < n; ++i) {
            string = string + "0";
        }
        return string;
    }
}

